/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.toolbar.setting;

import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.tizen.dynamicanalyzer.common.DAState;
import org.tizen.dynamicanalyzer.handlers.CommonAction;
import org.tizen.dynamicanalyzer.nl.PreferencesDialogLabels;
import org.tizen.dynamicanalyzer.nl.WidgetLabels;
import org.tizen.dynamicanalyzer.resources.ColorResources;
import org.tizen.dynamicanalyzer.resources.FontResources;
import org.tizen.dynamicanalyzer.resources.ImageResources;
import org.tizen.dynamicanalyzer.setting.FlatPreferences;
import org.tizen.dynamicanalyzer.setting.SettingDataManager;
import org.tizen.dynamicanalyzer.shortcut.ShortCutManager;
import org.tizen.dynamicanalyzer.ui.page.MenuBar;
import org.tizen.dynamicanalyzer.widgets.button.DACustomButton;
import org.tizen.dynamicanalyzer.widgets.button.DACustomButtonClickEventListener;
import org.tizen.dynamicanalyzer.widgets.button.toggle.DACustomExtendButton;
import org.tizen.dynamicanalyzer.widgets.button.toggle.DACustomToggleButton;
import org.tizen.dynamicanalyzer.widgets.combo.DACustomCombo;
import org.tizen.dynamicanalyzer.widgets.combo.DACustomComboSelectionListener;
import org.tizen.dynamicanalyzer.widgets.da.base.DAMessageBox;

public class PreferencesDialog
extends DAMessageBox {
    private static boolean opened = false;
    private ScrolledComposite scrolledComp = null;
    private Composite buttonContentsComp = null;
    private final int DIALOG_HEIGT = 435;
    private final int DIALOG_WIDTH = 430;
    private final int SCROLL_COMP_LEFT_MARGIN = 20;
    private final int LABLE_LEFT_MARGIN = 45;
    private final int LABLE_HEIGTH = 28;
    private final int TEXTBOX_HEIGTH = 24;
    private final int LABLE_INTERVAL = 21;
    private int TEXTBOX_WIDTH = 77;
    private int UNIT_LEFT_MARGIN = 5;
    private int TEXTBOX_TOP_MARGIN = 2;
    private DACustomToggleButton sourceviewtoggle = null;
    private DACustomToggleButton periodicallytoggle = null;
    private DACustomCombo systemRateCombo = null;
    private DACustomCombo functionRateCombo = null;
    private DACustomCombo screenshotRateCombo = null;
    private DACustomButtonClickEventListener infoButtonListener = new DACustomButtonClickEventListener(){

        public void handleClickEvent(DACustomButton button) {
        }
    };

    public PreferencesDialog(Shell parentShell) {
        super(parentShell);
    }

    protected boolean run() {
        if (opened) {
            return false;
        }
        int dialogLocationX = this.shell.getParent().getLocation().x + (this.shell.getParent().getSize().x - 430) / 2;
        int dialogLocationY = this.shell.getParent().getLocation().y + (this.shell.getParent().getSize().y - 435) / 2;
        this.shell.setLocation(dialogLocationX, dialogLocationY);
        this.shell.setSize(430, 435);
        this.shell.setLayout((Layout)new FormLayout());
        this.shell.setText(PreferencesDialogLabels.TITLE);
        this.shell.setBackground(ColorResources.DIALOG_CONTENT_BACKGROUND);
        this.shell.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent arg0) {
                opened = false;
                ShortCutManager.getInstance().setEnabled(!opened);
            }
        });
        Composite marginTop = new Composite((Composite)this.shell, 0);
        this.scrolledComp = new ScrolledComposite((Composite)this.shell, 512);
        Composite marginMiddle = new Composite((Composite)this.shell, 0);
        this.buttonContentsComp = new Composite((Composite)this.shell, 0);
        marginTop.setLayout((Layout)new FormLayout());
        FormData marginCompData = new FormData();
        marginCompData.top = new FormAttachment(0, 0);
        marginCompData.left = new FormAttachment(0, 0);
        marginCompData.right = new FormAttachment(100, 0);
        marginCompData.bottom = new FormAttachment(0, 1);
        marginTop.setLayoutData((Object)marginCompData);
        marginTop.setBackground(ColorResources.DIALOG_TOP_LINE_COLOR);
        this.scrolledComp.setLayout((Layout)new FormLayout());
        FormData scrollCompData = new FormData();
        scrollCompData.top = new FormAttachment((Control)marginTop, 0);
        scrollCompData.left = new FormAttachment(0, 0);
        scrollCompData.right = new FormAttachment(100, 0);
        scrollCompData.bottom = new FormAttachment(100, -61);
        this.scrolledComp.setLayoutData((Object)scrollCompData);
        this.scrolledComp.setExpandVertical(true);
        this.scrolledComp.setExpandHorizontal(true);
        this.scrolledComp.setBackground(ColorResources.DIALOG_CONTENT_BACKGROUND);
        this.scrolledComp.getVerticalBar().setIncrement(12);
        this.scrolledComp.setFocus();
        marginMiddle.setLayout((Layout)new FormLayout());
        marginCompData = new FormData();
        marginCompData.top = new FormAttachment((Control)this.scrolledComp, 0);
        marginCompData.left = new FormAttachment(0, 0);
        marginCompData.right = new FormAttachment(100, 0);
        marginCompData.bottom = new FormAttachment(100, -60);
        marginMiddle.setLayoutData((Object)marginCompData);
        marginMiddle.setBackground(ColorResources.DIALOG_MIDDLE_LINE_COLOR);
        this.buttonContentsComp.setLayout((Layout)new FormLayout());
        FormData compData = new FormData();
        compData.top = new FormAttachment((Control)marginMiddle, 0);
        compData.left = new FormAttachment(0, 0);
        compData.right = new FormAttachment(100, 0);
        compData.bottom = new FormAttachment(100, 0);
        this.buttonContentsComp.setLayoutData((Object)compData);
        this.buttonContentsComp.setBackground(ColorResources.WHITE);
        this.drawPreferenceCom();
        this.initComboBoxes();
        this.drawButtonCom();
        this.setSelectedOptions();
        opened = true;
        ShortCutManager.getInstance().setEnabled(!opened);
        this.shell.open();
        return true;
    }

    private void drawPreferenceCom() {
        final Composite baseCom = new Composite((Composite)this.scrolledComp, 0);
        baseCom.setBackground(ColorResources.DIALOG_CONTENT_BACKGROUND);
        baseCom.setLayout((Layout)new RowLayout(512));
        Composite marginview_one = new Composite(baseCom, 0);
        marginview_one.setLayoutData((Object)new RowData(-1, 26));
        marginview_one.setLayout((Layout)new FillLayout());
        int generalviewHeight = 126;
        int screenshotviewHeight = 37;
        DACustomExtendButton generalExtend = this.createFoldingButton(baseCom, PreferencesDialogLabels.GENERAL);
        final Composite generalview = new Composite(baseCom, 0);
        final RowData generalviewdata = new RowData(-1, generalviewHeight);
        generalview.setLayoutData((Object)generalviewdata);
        generalview.setBackground(ColorResources.DIALOG_CONTENT_BACKGROUND);
        generalview.setLayout((Layout)new FormLayout());
        RowLayout layout = new RowLayout(512);
        layout.justify = true;
        layout.fill = true;
        Composite generallabel = new Composite(generalview, 0);
        FormData form = new FormData();
        form.top = new FormAttachment(0, 0);
        form.left = new FormAttachment(0, 45);
        form.bottom = new FormAttachment(100, 0);
        form.width = 180;
        generallabel.setLayoutData((Object)form);
        generallabel.setLayout((Layout)layout);
        generallabel.setBackground(ColorResources.DIALOG_CONTENT_BACKGROUND);
        this.createLabel(generallabel, PreferencesDialogLabels.SOURCE_VIEW);
        this.createLabel(generallabel, PreferencesDialogLabels.SYSTEM_SAMPLIING_RATE);
        this.createLabel(generallabel, PreferencesDialogLabels.FUNCION_SAMPLIING_RATE);
        Composite generalvalues = new Composite(generalview, 0);
        form = new FormData();
        form.top = new FormAttachment(0, 0);
        form.left = new FormAttachment((Control)generallabel, 70);
        form.right = new FormAttachment(100, 0);
        form.bottom = new FormAttachment(100, 0);
        generalvalues.setLayoutData((Object)form);
        generalvalues.setLayout((Layout)layout);
        generalvalues.setBackground(ColorResources.DIALOG_CONTENT_BACKGROUND);
        this.sourceviewtoggle = this.createToggleButton(generalvalues);
        this.sourceviewtoggle.addClickListener(new DACustomButtonClickEventListener(){

            public void handleClickEvent(DACustomButton button) {
                MenuBar.getInstance().setSourceView(PreferencesDialog.this.sourceviewtoggle.isToggled());
            }
        });
        this.systemRateCombo = this.makeDACustomCombo(generalvalues, "ms");
        this.functionRateCombo = this.makeDACustomCombo(generalvalues, "ms");
        Composite marginview_two = new Composite(baseCom, 0);
        marginview_two.setLayoutData((Object)new RowData(-1, 31));
        marginview_two.setLayout((Layout)new FillLayout());
        DACustomExtendButton screenshotExtend = this.createFoldingButton(baseCom, PreferencesDialogLabels.SCREENSHOT);
        final Composite screenshotlview = new Composite(baseCom, 0);
        final RowData screenshotlviewdata = new RowData(-1, screenshotviewHeight);
        screenshotlview.setLayoutData((Object)screenshotlviewdata);
        screenshotlview.setBackground(ColorResources.DIALOG_CONTENT_BACKGROUND);
        screenshotlview.setLayout((Layout)new FormLayout());
        Composite screenshotlabel = new Composite(screenshotlview, 0);
        form = new FormData();
        form.top = new FormAttachment(0, 0);
        form.left = new FormAttachment(0, 45);
        form.bottom = new FormAttachment(100, 0);
        form.width = 110;
        screenshotlabel.setLayoutData((Object)form);
        screenshotlabel.setLayout((Layout)layout);
        screenshotlabel.setBackground(ColorResources.DIALOG_CONTENT_BACKGROUND);
        this.createLabel(screenshotlabel, PreferencesDialogLabels.PERIODICALLY);
        Composite screenshottoggel = new Composite(screenshotlview, 0);
        form = new FormData();
        form.top = new FormAttachment(0, 0);
        form.left = new FormAttachment((Control)screenshotlabel, 50);
        form.width = 80;
        form.bottom = new FormAttachment(100, 0);
        screenshottoggel.setLayoutData((Object)form);
        screenshottoggel.setLayout((Layout)layout);
        screenshottoggel.setBackground(ColorResources.DIALOG_CONTENT_BACKGROUND);
        this.periodicallytoggle = this.createToggleButton(screenshottoggel);
        Composite screenshotperiod = new Composite(screenshotlview, 0);
        form = new FormData();
        form.top = new FormAttachment(0, this.TEXTBOX_TOP_MARGIN);
        form.left = new FormAttachment((Control)screenshottoggel, 10);
        form.right = new FormAttachment(100, 0);
        form.bottom = new FormAttachment(100, 0);
        screenshotperiod.setLayoutData((Object)form);
        screenshotperiod.setLayout((Layout)layout);
        screenshotperiod.setBackground(ColorResources.DIALOG_CONTENT_BACKGROUND);
        this.screenshotRateCombo = this.makeDACustomCombo(screenshotperiod, "s");
        this.screenshotRateCombo.setEnabled(false);
        this.scrolledComp.setContent((Control)baseCom);
        this.scrolledComp.setMinSize(baseCom.computeSize(-1, -1));
        generalExtend.addClickListener(new DACustomButtonClickEventListener(){

            public void handleClickEvent(DACustomButton button) {
                generalviewdata.exclude = !generalviewdata.exclude;
                generalview.setVisible(!generalviewdata.exclude);
                generalview.getParent().pack(true);
                PreferencesDialog.this.scrolledComp.setContent((Control)baseCom);
                PreferencesDialog.this.scrolledComp.setMinSize(baseCom.computeSize(-1, -1));
            }
        });
        screenshotExtend.addClickListener(new DACustomButtonClickEventListener(){

            public void handleClickEvent(DACustomButton button) {
                screenshotlviewdata.exclude = !screenshotlviewdata.exclude;
                screenshotlview.setVisible(!screenshotlviewdata.exclude);
                screenshotlview.getParent().pack(true);
                PreferencesDialog.this.scrolledComp.setContent((Control)baseCom);
                PreferencesDialog.this.scrolledComp.setMinSize(baseCom.computeSize(-1, -1));
            }
        });
        this.periodicallytoggle.addClickListener(new DACustomButtonClickEventListener(){

            public void handleClickEvent(DACustomButton button) {
                PreferencesDialog.this.screenshotRateCombo.setEnabled(PreferencesDialog.this.periodicallytoggle.isToggled());
            }
        });
    }

    private void drawButtonCom() {
        Button okButton = new Button(this.buttonContentsComp, 0);
        FormData buttonData = new FormData();
        buttonData.top = new FormAttachment(0, 15);
        buttonData.right = new FormAttachment(100, -15);
        buttonData.width = 100;
        buttonData.height = 30;
        okButton.setLayoutData((Object)buttonData);
        okButton.setFont(FontResources.DIALOG_BUTTON_FONT);
        okButton.setText(WidgetLabels.OK);
        okButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }

            public void widgetSelected(SelectionEvent arg0) {
                PreferencesDialog.this.applyPreferenceData();
                if (DAState.isStartable()) {
                    CommonAction.configure();
                }
                SettingDataManager.INSTANCE.applySettingData();
                PreferencesDialog.this.shell.dispose();
            }
        });
        Button cancelButton = new Button(this.buttonContentsComp, 0);
        buttonData = new FormData();
        buttonData.top = new FormAttachment(0, 15);
        buttonData.right = new FormAttachment((Control)okButton, -8);
        buttonData.width = 100;
        buttonData.height = 30;
        cancelButton.setLayoutData((Object)buttonData);
        cancelButton.setFont(FontResources.DIALOG_BUTTON_FONT);
        cancelButton.setText(WidgetLabels.CANCEL);
        cancelButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }

            public void widgetSelected(SelectionEvent arg0) {
                PreferencesDialog.this.shell.dispose();
            }
        });
        Button setAsDefaultButton = new Button(this.buttonContentsComp, 0);
        buttonData = new FormData();
        buttonData.top = new FormAttachment(0, 15);
        buttonData.right = new FormAttachment((Control)cancelButton, -8);
        buttonData.width = 100;
        buttonData.height = 30;
        setAsDefaultButton.setLayoutData((Object)buttonData);
        setAsDefaultButton.setFont(FontResources.DIALOG_BUTTON_FONT);
        setAsDefaultButton.setText(PreferencesDialogLabels.SET_AS_DEFAULT);
        setAsDefaultButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }

            public void widgetSelected(SelectionEvent arg0) {
                PreferencesDialog.this.setToDefault();
                PreferencesDialog.this.scrolledComp.setFocus();
            }
        });
    }

    private void setSelectedOptions() {
        int value = SettingDataManager.INSTANCE.getOptionsPreferencesValue(FlatPreferences.SOURCE_VIEW);
        if (value == 1) {
            this.sourceviewtoggle.setToggled(true);
            MenuBar.getInstance().setSourceView(true);
        } else {
            this.sourceviewtoggle.setToggled(false);
            MenuBar.getInstance().setSourceView(false);
        }
        value = SettingDataManager.INSTANCE.getOptionsPreferencesValue(FlatPreferences.SYSTEM_SAMPLING_RATE);
        this.systemRateCombo.setText(String.valueOf(value));
        value = SettingDataManager.INSTANCE.getOptionsPreferencesValue(FlatPreferences.FUNCTION_SAMPLING_RATE);
        this.functionRateCombo.setText(String.valueOf(value));
        value = SettingDataManager.INSTANCE.getOptionsPreferencesValue(FlatPreferences.SCREENSHOT_PERIODICALLY);
        if (value != 0) {
            this.periodicallytoggle.setToggled(true);
            this.screenshotRateCombo.setEnabled(true);
            this.screenshotRateCombo.setText(String.valueOf(value));
        } else {
            this.periodicallytoggle.setToggled(false);
            this.screenshotRateCombo.setEnabled(false);
        }
    }

    private void setToDefault() {
        int value = FlatPreferences.SOURCE_VIEW.getDefaultValue();
        if (value == 1) {
            this.sourceviewtoggle.setToggled(true);
        } else {
            this.sourceviewtoggle.setToggled(false);
        }
        value = FlatPreferences.SYSTEM_SAMPLING_RATE.getDefaultValue();
        this.systemRateCombo.setText(String.valueOf(value));
        value = FlatPreferences.FUNCTION_SAMPLING_RATE.getDefaultValue();
        this.functionRateCombo.setText(String.valueOf(value));
        value = FlatPreferences.SCREENSHOT_PERIODICALLY.getDefaultValue();
        if (value != 0) {
            this.periodicallytoggle.setToggled(true);
            this.screenshotRateCombo.setEnabled(true);
            this.screenshotRateCombo.setText(String.valueOf(value));
        } else {
            this.periodicallytoggle.setToggled(false);
            this.screenshotRateCombo.select(0);
            this.screenshotRateCombo.setEnabled(false);
        }
    }

    private DACustomExtendButton createFoldingButton(Composite parent, String text) {
        Composite toggleposition = new Composite(parent, 0);
        toggleposition.setLayoutData((Object)new RowData(-1, 28));
        toggleposition.setBackground(ColorResources.DIALOG_CONTENT_BACKGROUND);
        toggleposition.setLayout((Layout)new FormLayout());
        DACustomExtendButton foldingbutton = new DACustomExtendButton(toggleposition, ImageResources.DROP_ARROW_DOWN_NOR, ImageResources.DROP_ARROW_DOWN_NOR, ImageResources.DROP_ARROW_DOWN_NOR, ImageResources.DROP_ARROW_DOWN_NOR, ImageResources.DROP_ARROW_UP_NORL, ImageResources.DROP_ARROW_UP_NORL);
        foldingbutton.setButtonImagePoint(new Point(0, 5));
        foldingbutton.setText(text);
        foldingbutton.setFontPoint(new Point(19, 0));
        foldingbutton.setBackground(ColorResources.DIALOG_CONTENT_BACKGROUND);
        foldingbutton.setButtonFont(FontResources.DIALOG_CONTENTS_BOLD_FONT);
        FormData buttonData = new FormData();
        buttonData.top = new FormAttachment(0, 0);
        buttonData.left = new FormAttachment(0, 20);
        buttonData.width = 120;
        buttonData.height = 28;
        foldingbutton.setLayoutData((Object)buttonData);
        return foldingbutton;
    }

    private DACustomToggleButton createToggleButton(Composite parent) {
        Composite comp = new Composite(parent, 0);
        comp.setBackground(ColorResources.DIALOG_CONTENT_BACKGROUND);
        comp.setLayout((Layout)new FormLayout());
        DACustomToggleButton toggle = new DACustomToggleButton(comp, ImageResources.TOGGLE_OFF, ImageResources.TOGGLE_OFF, ImageResources.TOGGLE_OFF, ImageResources.TOGGLE_OFF, ImageResources.TOGGLE_ON, ImageResources.TOGGLE_ON);
        Point imagePoint = new Point(0, 0);
        toggle.setButtonImagePoint(imagePoint);
        FormData toggleform = new FormData();
        toggleform.top = new FormAttachment(0, 0);
        toggleform.left = new FormAttachment(0, 0);
        toggleform.width = 78;
        toggleform.height = 28;
        toggle.setLayoutData((Object)toggleform);
        return toggle;
    }

    private Label createLabel(Composite parent, String text) {
        Label label = new Label(parent, 16384);
        label.setBackground(ColorResources.DIALOG_CONTENT_BACKGROUND);
        label.setFont(FontResources.DIALOG_CONTENTS_NORMAL_FONT);
        label.setText(text);
        return label;
    }

    private void applyPreferenceData() {
        int rate;
        if (this.sourceviewtoggle.isToggled()) {
            SettingDataManager.INSTANCE.addOptionsSelectedPreference(FlatPreferences.SOURCE_VIEW, 1);
        } else {
            SettingDataManager.INSTANCE.addOptionsSelectedPreference(FlatPreferences.SOURCE_VIEW, 0);
        }
        String ratestring = this.systemRateCombo.getText();
        try {
            rate = Integer.parseInt(ratestring);
            SettingDataManager.INSTANCE.addOptionsSelectedPreference(FlatPreferences.SYSTEM_SAMPLING_RATE, rate);
        }
        catch (Exception exception) {
            return;
        }
        ratestring = this.functionRateCombo.getText();
        try {
            rate = Integer.parseInt(ratestring);
            SettingDataManager.INSTANCE.addOptionsSelectedPreference(FlatPreferences.FUNCTION_SAMPLING_RATE, rate);
        }
        catch (Exception exception) {
            return;
        }
        if (this.periodicallytoggle.isToggled()) {
            rate = 1;
            ratestring = this.screenshotRateCombo.getText();
            try {
                rate = Integer.parseInt(ratestring);
            }
            catch (Exception exception) {
                return;
            }
            SettingDataManager.INSTANCE.addOptionsSelectedPreference(FlatPreferences.SCREENSHOT_PERIODICALLY, rate);
        } else {
            SettingDataManager.INSTANCE.addOptionsSelectedPreference(FlatPreferences.SCREENSHOT_PERIODICALLY, 0);
        }
    }

    private DACustomCombo makeDACustomCombo(Composite parent, String unit) {
        Composite comp = new Composite(parent, 0);
        comp.setBackground(ColorResources.DIALOG_CONTENT_BACKGROUND);
        comp.setLayout((Layout)new FormLayout());
        DACustomCombo returnCombo = new DACustomCombo(comp, 0);
        returnCombo.setComboGradation(ColorResources.WHITE, ColorResources.WHITE, ColorResources.WHITE, ColorResources.WHITE, ColorResources.WHITE, ColorResources.WHITE, ColorResources.WHITE, ColorResources.WHITE);
        returnCombo.setOutlineColors(ColorResources.GRAY_130, ColorResources.GRAY_130, ColorResources.GRAY_130, ColorResources.GRAY_130);
        returnCombo.setComboImages(ImageResources.DROP_ARROW_DOWN_NOR, ImageResources.DROP_ARROW_DOWN_SEL, ImageResources.DROP_ARROW_DOWN_HOVER, ImageResources.DROP_ARROW_DOWN_DIM);
        returnCombo.setComboImagePoint(new Point(this.TEXTBOX_WIDTH - 15, 9));
        returnCombo.setComboButtonColor(ColorResources.WHITE, ColorResources.WHITE, ColorResources.WHITE, ColorResources.WHITE);
        returnCombo.setArrowOutlineColors(ColorResources.GRAY_220, ColorResources.GRAY_220, ColorResources.GRAY_220, ColorResources.GRAY_220);
        returnCombo.setButtonImages(ImageResources.COMBO_DROPDOWN_UP, ImageResources.COMBO_DROPDOWN_DOWN);
        returnCombo.setFontPoint(new Point(5, 5));
        returnCombo.setEnabled(true);
        returnCombo.setComboFont(FontResources.COMBO);
        returnCombo.setItemFont(FontResources.DROPDOWN);
        returnCombo.setFontColors(ColorResources.BLACK, ColorResources.BLACK, ColorResources.BLACK, ColorResources.GRAY_170);
        FormData data = new FormData();
        data.top = new FormAttachment(0, 0);
        data.left = new FormAttachment(0, 0);
        data.width = this.TEXTBOX_WIDTH;
        data.height = 24;
        returnCombo.setLayoutData((Object)data);
        Label unitlabel = new Label(comp, 16384);
        FormData labelform = new FormData();
        labelform.top = new FormAttachment(0, 6);
        labelform.left = new FormAttachment(0, this.TEXTBOX_WIDTH + this.UNIT_LEFT_MARGIN);
        labelform.width = 20;
        labelform.height = 24;
        unitlabel.setLayoutData((Object)labelform);
        unitlabel.setText(unit);
        unitlabel.setBackground(ColorResources.DIALOG_CONTENT_BACKGROUND);
        unitlabel.setFont(FontResources.DIALOG_CONTENTS_NORMAL_FONT);
        return returnCombo;
    }

    private void initComboBoxes() {
        if (this.systemRateCombo != null) {
            this.systemRateCombo.initCombo();
            this.systemRateCombo.add("100");
            this.systemRateCombo.add("200");
            this.systemRateCombo.add("500");
            this.systemRateCombo.add("1000");
            this.systemRateCombo.select(3);
            this.systemRateCombo.addSelectionListener(new DACustomComboSelectionListener(){

                public void selectionEvent(DACustomCombo combo) {
                }
            });
        }
        if (this.functionRateCombo != null) {
            this.functionRateCombo.initCombo();
            this.functionRateCombo.add("10");
            this.functionRateCombo.add("50");
            this.functionRateCombo.add("100");
            this.functionRateCombo.add("200");
            this.functionRateCombo.select(0);
            this.functionRateCombo.addSelectionListener(new DACustomComboSelectionListener(){

                public void selectionEvent(DACustomCombo combo) {
                }
            });
        }
        if (this.screenshotRateCombo != null) {
            this.screenshotRateCombo.initCombo();
            this.screenshotRateCombo.add("1");
            this.screenshotRateCombo.add("2");
            this.screenshotRateCombo.add("5");
            this.screenshotRateCombo.add("10");
            this.screenshotRateCombo.select(0);
            this.screenshotRateCombo.addSelectionListener(new DACustomComboSelectionListener(){

                public void selectionEvent(DACustomCombo combo) {
                }
            });
        }
    }
}

