/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.toolbar.setting;

import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.tizen.dynamicanalyzer.common.AnalyzerManager;
import org.tizen.dynamicanalyzer.common.DAState;
import org.tizen.dynamicanalyzer.communicator.IDECommunicator;
import org.tizen.dynamicanalyzer.handlers.CommonAction;
import org.tizen.dynamicanalyzer.handlers.UIActionHolder;
import org.tizen.dynamicanalyzer.nl.AnalyzerLabels;
import org.tizen.dynamicanalyzer.nl.ConfigureLabels;
import org.tizen.dynamicanalyzer.nl.WidgetLabels;
import org.tizen.dynamicanalyzer.resources.ColorResources;
import org.tizen.dynamicanalyzer.resources.FontResources;
import org.tizen.dynamicanalyzer.setting.SettingDataManager;
import org.tizen.dynamicanalyzer.shortcut.ShortCutManager;
import org.tizen.dynamicanalyzer.ui.toolbar.setting.SettingDialogBinarySettingsPage;
import org.tizen.dynamicanalyzer.ui.toolbar.setting.SettingDialogOptionPage;
import org.tizen.dynamicanalyzer.ui.toolbar.setting.SettingDialogTemplatePage;
import org.tizen.dynamicanalyzer.util.Logger;
import org.tizen.dynamicanalyzer.widgets.button.DACustomButton;
import org.tizen.dynamicanalyzer.widgets.button.DACustomButtonClickEventListener;
import org.tizen.dynamicanalyzer.widgets.da.base.DAButton;
import org.tizen.dynamicanalyzer.widgets.da.base.DAMessageBox;
import org.tizen.dynamicanalyzer.widgets.da.view.DABaseComposite;
import org.tizen.dynamicanalyzer.widgets.da.view.DATabComposite;

public class SettingDialog
extends DAMessageBox {
    private static boolean opened = false;
    private DACustomButton okButton = null;
    private DACustomButton cancelButton = null;
    private boolean isApply = false;
    private SettingDialogTemplatePage templatesPage = null;
    private SettingDialogOptionPage optionPage = null;
    private DATabComposite tabView = null;
    private Composite buttonContentsComp = null;
    private DACustomButtonClickEventListener okButtonListener = new DACustomButtonClickEventListener(){

        public void handleClickEvent(DACustomButton button) {
            if (SettingDialog.this.optionPage.isValidInputValue()) {
                SettingDialog.this.isApply = true;
                SettingDialog.this.doApply();
                SettingDialog.this.doRun();
                SettingDialog.this.shell.close();
            } else {
                SettingDialog.this.doWarningMessage();
            }
        }
    };
    private DACustomButtonClickEventListener cancelButtonListener = new DACustomButtonClickEventListener(){

        public void handleClickEvent(DACustomButton button) {
            SettingDialog.this.isApply = true;
            SettingDialog.this.doRevert();
            SettingDialog.this.doRun();
            SettingDialog.this.shell.close();
        }
    };
    private ShellListener shellListener = new ShellListener(){

        public void shellActivated(ShellEvent e) {
        }

        public void shellClosed(ShellEvent e) {
            if (!SettingDialog.this.isApply) {
                SettingDialog.this.doRevert();
                SettingDialog.this.doRun();
            }
            SettingDialog.this.notifyAutoRun();
        }

        public void shellDeactivated(ShellEvent e) {
        }

        public void shellDeiconified(ShellEvent e) {
        }

        public void shellIconified(ShellEvent e) {
        }
    };

    public SettingDialog(Shell parentShell) {
        super(parentShell);
    }

    private void doApply() {
        DABaseComposite selectedComposite = this.tabView.getTopComposite();
        if (!(selectedComposite instanceof SettingDialogBinarySettingsPage)) {
            if (DAState.isStartable()) {
                UIActionHolder.getUIAction().setUIElementsBySetting();
                SettingDataManager.INSTANCE.applySettingData();
            }
        } else {
            SettingDialogBinarySettingsPage page = (SettingDialogBinarySettingsPage)selectedComposite;
            page.doApply();
        }
    }

    private void doRevert() {
        SettingDataManager.INSTANCE.revertSettingData();
    }

    private void doRun() {
        DABaseComposite selectedComposite = this.tabView.getTopComposite();
        if (!(selectedComposite instanceof SettingDialogBinarySettingsPage) && DAState.isStartable()) {
            CommonAction.configure();
        }
    }

    private void doWarningMessage() {
        UIActionHolder.getUIAction().showWarning(ConfigureLabels.SETTING_WARNING_MESSAGE_SETTING_INVALID_INPUT_VALUE, 550, 153);
    }

    protected boolean run() {
        if (opened) {
            return false;
        }
        IDECommunicator.setOpenWelcomeDlg(true);
        this.shell.setSize(631, 550);
        this.shell.setLayout((Layout)new FormLayout());
        this.shell.setText(AnalyzerLabels.SETTING_TITLE);
        this.shell.setBackground(ColorResources.CONFIGURATION_TABLE_COVER_BACKGROUND_COLOR);
        Composite contentsComp = new Composite((Composite)this.shell, 0);
        FormLayout compLayout = new FormLayout();
        contentsComp.setLayout((Layout)compLayout);
        contentsComp.setBackground(ColorResources.CONFIGURATION_TABLE_COVER_BACKGROUND_COLOR);
        FormData compData = new FormData();
        compData.top = new FormAttachment(0, 0);
        compData.left = new FormAttachment(0, 0);
        compData.right = new FormAttachment(100, 0);
        compData.bottom = new FormAttachment(100, -49);
        contentsComp.setLayoutData((Object)compData);
        if (!SettingDataManager.INSTANCE.isParsingSuccess()) {
            Label label = new Label(contentsComp, 0);
            label.setForeground(ColorResources.DEFAULT_FONT_COLOR);
            label.setBackground(ColorResources.CONFIGURATION_TABLE_COVER_BACKGROUND_COLOR);
            label.setFont(FontResources.SETTING_TITLE_FONT);
            label.setText(ConfigureLabels.SETTING_WARNING_MESSAGE_FILE_NOT_FOUND);
            this.shell.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    opened = false;
                    ShortCutManager.getInstance().setEnabled(!opened);
                }
            });
            opened = true;
            ShortCutManager.getInstance().setEnabled(!opened);
            this.shell.open();
            return true;
        }
        this.tabView = new DATabComposite(contentsComp, 0x20000000);
        this.tabView.setBackground(ColorResources.CONFIGURATION_TABLE_COVER_BACKGROUND_COLOR);
        this.tabView.setTabWidth(120);
        compData = new FormData();
        compData.top = new FormAttachment(0, 0);
        compData.left = new FormAttachment(0, 0);
        compData.right = new FormAttachment(100, 0);
        compData.bottom = new FormAttachment(100, 0);
        this.tabView.setLayoutData((Object)compData);
        this.templatesPage = new SettingDialogTemplatePage(this.tabView.getContentComposite(), 0);
        this.tabView.addView((DABaseComposite)this.templatesPage, false);
        this.optionPage = new SettingDialogOptionPage(this.tabView.getContentComposite(), 0);
        this.tabView.addView((DABaseComposite)this.optionPage, false);
        if (AnalyzerManager.isPlatformSDK()) {
            this.createBinarySettingPage();
        }
        this.buttonContentsComp = new Composite((Composite)this.shell, 0);
        compLayout = new FormLayout();
        this.buttonContentsComp.setLayout((Layout)compLayout);
        this.buttonContentsComp.setBackground(ColorResources.CONFIGURATION_BUTTON_COVER_BACKGROUND_COLOR);
        compData = new FormData();
        compData.top = new FormAttachment((Control)contentsComp, 0);
        compData.left = new FormAttachment(0, 0);
        compData.right = new FormAttachment(100, 0);
        compData.bottom = new FormAttachment(100, 0);
        this.buttonContentsComp.setLayoutData((Object)compData);
        this.buttonContentsComp.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                Composite comp = (Composite)e.widget;
                Rectangle rect = comp.getClientArea();
                e.gc.setForeground(ColorResources.SETTING_SUNKEN_LINE_1);
                e.gc.drawLine(0, 0, rect.width - 1, 0);
                e.gc.setForeground(ColorResources.SETTING_SUNKEN_LINE_2);
                e.gc.drawLine(0, 1, rect.width - 1, 1);
            }
        });
        this.optionPage.addListener(23, new Listener(){

            public void handleEvent(Event event) {
                Logger.debug((Object)"options page hide");
                if (!SettingDialog.this.optionPage.isValidInputValue()) {
                    SettingDialog.this.doWarningMessage();
                    SettingDialog.this.optionPage.revertInputValue();
                }
                SettingDialog.this.templatesPage.updateTotalOverheadRange();
            }
        });
        this.cancelButton = new DAButton(this.buttonContentsComp, 0);
        this.cancelButton.addClickListener(this.cancelButtonListener);
        this.cancelButton.setText(WidgetLabels.CANCEL);
        this.cancelButton.setButtonFont(FontResources.DIALOG_BUTTON_FONT);
        FormData buttonData = new FormData();
        buttonData.right = new FormAttachment(100, -9);
        buttonData.top = new FormAttachment(0, 11);
        buttonData.width = 100;
        buttonData.height = 28;
        this.cancelButton.setLayoutData((Object)buttonData);
        this.okButton = new DAButton(this.buttonContentsComp, 0);
        this.okButton.addClickListener(this.okButtonListener);
        this.okButton.setText(WidgetLabels.OK);
        this.okButton.setButtonFont(FontResources.DIALOG_BUTTON_FONT);
        buttonData = new FormData();
        buttonData.right = new FormAttachment((Control)this.cancelButton, -8);
        buttonData.top = new FormAttachment(0, 11);
        buttonData.width = 100;
        buttonData.height = 28;
        this.okButton.setLayoutData((Object)buttonData);
        this.shell.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                opened = false;
                ShortCutManager.getInstance().setEnabled(!opened);
            }
        });
        opened = true;
        ShortCutManager.getInstance().setEnabled(!opened);
        this.shell.addShellListener(this.shellListener);
        this.shell.open();
        return true;
    }

    private void createBinarySettingPage() {
        SettingDialogBinarySettingsPage binarySettings = new SettingDialogBinarySettingsPage(this.tabView.getContentComposite(), 0);
        this.tabView.addView((DABaseComposite)binarySettings, false);
        binarySettings.addListener(22, new Listener(){

            public void handleEvent(Event event) {
                Logger.debug((Object)"binary settings show");
                SettingDialog.this.cancelButton.setText(WidgetLabels.CLOSE);
                FormData data = (FormData)SettingDialog.this.okButton.getLayoutData();
                data.width = 0;
                SettingDialog.this.buttonContentsComp.layout();
            }
        });
        binarySettings.addListener(23, new Listener(){

            public void handleEvent(Event event) {
                Logger.debug((Object)"binary settings hide");
                SettingDialog.this.cancelButton.setText(WidgetLabels.CANCEL);
                FormData data = (FormData)SettingDialog.this.okButton.getLayoutData();
                data.width = 100;
                SettingDialog.this.buttonContentsComp.layout();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyAutoRun() {
        Object object = IDECommunicator.getWaitingWelcomeDlg();
        synchronized (object) {
            IDECommunicator.setOpenWelcomeDlg(false);
            IDECommunicator.getWaitingWelcomeDlg().notifyAll();
        }
    }
}

