/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.userinterface.control;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.nebula.widgets.grid.GridCellRenderer;
import org.eclipse.nebula.widgets.grid.GridColumn;
import org.eclipse.nebula.widgets.grid.GridHeaderRenderer;
import org.eclipse.nebula.widgets.grid.GridItem;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.tizen.dynamicanalyzer.common.AnalyzerManager;
import org.tizen.dynamicanalyzer.common.DASelectionData;
import org.tizen.dynamicanalyzer.common.Global;
import org.tizen.dynamicanalyzer.model.TreeInput;
import org.tizen.dynamicanalyzer.project.ImageInfo;
import org.tizen.dynamicanalyzer.swap.model.data.ControlData;
import org.tizen.dynamicanalyzer.swap.model.data.LogData;
import org.tizen.dynamicanalyzer.ui.summary.profiling.ProfilingData;
import org.tizen.dynamicanalyzer.ui.toolbar.Toolbar;
import org.tizen.dynamicanalyzer.ui.userinterface.UIDataManager;
import org.tizen.dynamicanalyzer.ui.userinterface.UIPage;
import org.tizen.dynamicanalyzer.ui.userinterface.control.UIControlListData;
import org.tizen.dynamicanalyzer.ui.widgets.table.DATableCellRenderer;
import org.tizen.dynamicanalyzer.ui.widgets.table.DATableDataFormat;
import org.tizen.dynamicanalyzer.ui.widgets.table.DATableHeaderRenderer;
import org.tizen.dynamicanalyzer.ui.widgets.table.DATreeComposite;
import org.tizen.dynamicanalyzer.widgets.da.view.DAViewData;

public class UIControlListTable
extends DATreeComposite {
    public boolean selfUpdate = false;

    public UIControlListTable(Composite parent, int compStyle, int tableStyle) {
        super(parent, compStyle, tableStyle);
        this.table.addListener(17, new Listener(){

            public void handleEvent(Event event) {
                GridItem item = (GridItem)event.item;
                UIControlListTable.this.setExpand(item, true);
            }
        });
        this.table.addListener(18, new Listener(){

            public void handleEvent(Event event) {
                GridItem item = (GridItem)event.item;
                UIControlListTable.this.setExpand(item, false);
            }
        });
        this.table.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                GridItem[] items = UIControlListTable.this.table.getSelection();
                if (items.length <= 0) {
                    return;
                }
                DATableDataFormat dataFormat = (DATableDataFormat)items[0].getData();
                ControlData data = (ControlData)dataFormat.getLogData();
                String className = UIDataManager.getInstance().getControlDataChecker().getClassName(data);
                UIDataManager.getInstance().setTableSeleteClassName(className);
                long time = UIControlListTable.this.getSnapsotForScene(className, data.getTime());
                DASelectionData selData = new DASelectionData(UIPage.controlListViewID, time, 0L, items, (Control)UIControlListTable.this.table);
                AnalyzerManager.getCurrentPage().updateView((DAViewData)selData);
                UIControlListTable.this.setSelfUpdate(true);
                UIControlListTable.this.updateTree();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.table.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseDoubleClick(MouseEvent e) {
                GridItem[] items = UIControlListTable.this.table.getSelection();
                if (items == null || items.length == 0) {
                    return;
                }
                GridItem item = items[0];
                if (item.isExpanded()) {
                    UIControlListTable.this.setExpand(item, false);
                } else {
                    UIControlListTable.this.setExpand(item, true);
                }
                UIControlListTable.this.setSelfUpdate(true);
                UIControlListTable.this.updateTree();
            }
        });
    }

    private long getSnapsotForScene(String className, long strTime) {
        ImageInfo lastimg;
        Long time = UIDataManager.getInstance().getFindScreenshotViewHashMap().get(className);
        if (time == null) {
            return strTime;
        }
        if (time == -1L) {
            time = strTime;
        }
        if ((lastimg = Global.getLeastImageInfoByTime(strTime)) == null) {
            return strTime;
        }
        return lastimg.getTime();
    }

    @Override
    public void setColumns(String[] columnNames) {
        int size = columnNames.length;
        int i = 0;
        while (i < size) {
            GridColumn column = new GridColumn(this.table, 0);
            column.setText(columnNames[i]);
            if (this.isTree && i == 0) {
                column.setTree(true);
            }
            column.setCellRenderer((GridCellRenderer)new DATableCellRenderer());
            column.setHeaderRenderer((GridHeaderRenderer)new DATableHeaderRenderer());
            if (this.columnAlignment != null && this.columnAlignment.length > i) {
                column.setAlignment(this.columnAlignment[i]);
            }
            column.pack();
            if (this.comparator != null && this.sortTypes != null) {
                final int type = this.sortTypes[i];
                final int columnIndex = i;
                column.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent event) {
                        UIControlListTable.this.comparator.setType(type);
                        UIControlListTable.this.comparator.setColumn(columnIndex);
                        UIControlListTable.this.comparator.reverseDirection();
                        UIControlListTable.this.updateTree();
                    }
                });
            }
            ++i;
        }
    }

    public List<ProfilingData> difference(ArrayList<ProfilingData> base, ArrayList<ProfilingData> target) {
        ArrayList result = (ArrayList)base.clone();
        result.removeAll(target);
        return result;
    }

    private TreeInput makeInput(UIControlListData input) {
        DATableDataFormat tableData = new DATableDataFormat(input.getSequence());
        LogData inputData = input.getData();
        tableData.setLogData(inputData);
        tableData.setObject(input.getChildClassName());
        ArrayList<String> text = new ArrayList<String>();
        text.add(input.getChildClassName());
        text.add(input.getInitializeTime());
        text.add(input.getTerminateTime());
        text.add(input.getControlType());
        text.add(input.getPID());
        TreeInput output = new TreeInput();
        output.setText(text);
        output.setData(tableData);
        output.setParent(Long.toString(input.getParentPointer()));
        output.setChild(Long.toString(input.getChildPointer()));
        String strSelectedClassname = UIDataManager.getInstance().getTableSeleteClassName();
        boolean isUpdate = true;
        if (this.isSelfUpdate() && !input.getControlType().trim().equals("Frame") && !input.getControlType().trim().equals("Form") && !input.getControlType().trim().equals("Panel")) {
            isUpdate = false;
        }
        if (strSelectedClassname.equals(input.getCalssKeyName()) && isUpdate) {
            output.setSecondSelection(true);
        }
        return output;
    }

    public boolean makeChildTree(TreeInput nodeParent, TreeInput currentNode, int nNodeDepth) {
        if (nodeParent.getChild().trim().equals(currentNode.getParent().trim())) {
            nodeParent.getChildren().add(currentNode);
            return true;
        }
        int i = 0;
        while (i < nodeParent.getChildren().size()) {
            if (this.makeChildTree(nodeParent.getChildren().get(i), currentNode, nNodeDepth++)) break;
            ++i;
        }
        return false;
    }

    @Override
    public List<TreeInput> makeTreeInput() {
        List<UIControlListData> controlList = UIDataManager.getInstance().getControlDataChecker().getDataList();
        ArrayList<TreeInput> output = new ArrayList<TreeInput>();
        int size = controlList.size();
        int nNodeDepth = 0;
        int i = 0;
        while (i < size) {
            String pid;
            int selectedPid = Toolbar.INSTANCE.getSelectedPid();
            if (selectedPid == 0 || (pid = controlList.get(i).getPID().trim()).equals(Integer.toString(selectedPid))) {
                TreeInput currentNode = this.makeInput(controlList.get(i));
                if (this.isRootNode(controlList, i)) {
                    output.add(currentNode);
                } else {
                    int j = 0;
                    while (j < output.size()) {
                        if (this.makeChildTree((TreeInput)output.get(j), currentNode, nNodeDepth++)) break;
                        ++j;
                    }
                }
            }
            ++i;
        }
        return output;
    }

    public boolean isRootNode(List<UIControlListData> controlList, int index) {
        boolean isRootNode = true;
        if (!controlList.get(index).getChildName().trim().equals("Frame") && !controlList.get(index).getChildName().trim().equals("Form")) {
            return false;
        }
        int i = 0;
        while (i < index) {
            if (controlList.get(i).getChildPointer() == controlList.get(index).getParentPointer()) {
                isRootNode = false;
                break;
            }
            ++i;
        }
        return isRootNode;
    }

    public boolean isSelfUpdate() {
        return this.selfUpdate;
    }

    public void setSelfUpdate(boolean update) {
        this.selfUpdate = update;
    }
}

