/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.widgets.da.view;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.tizen.dynamicanalyzer.widgets.chartBoard.DAChartBoardItem;
import org.tizen.dynamicanalyzer.widgets.da.view.DABaseComposite;
import org.tizen.dynamicanalyzer.widgets.da.view.DAViewData;

public abstract class DAPageComposite
extends DABaseComposite {
    public static final String KEY_TOOLTIP = "tooltip";
    protected HashMap<String, DABaseComposite> childMap = null;
    private DAViewData selection = null;
    private boolean isToplevel = true;

    public DAPageComposite(Composite parent, int style) {
        super(parent, style);
        this.construct();
    }

    public DAPageComposite(Composite parent, int style, boolean istoplevel) {
        super(parent, style);
        this.isToplevel = istoplevel;
        this.construct();
    }

    private void construct() {
        this.childMap = new HashMap();
        this.addControlListener(new ControlListener(){

            public void controlResized(ControlEvent e) {
                Composite composite = (Composite)e.widget;
                Rectangle rect = composite.getBounds();
                DAPageComposite.this.onResized(rect.width, rect.height);
            }

            public void controlMoved(ControlEvent e) {
            }
        });
    }

    public boolean addView(DABaseComposite view) {
        return this.addView(view.getID(), view);
    }

    public boolean addView(String viewId, DABaseComposite view) {
        if (viewId == null || viewId.isEmpty()) {
            viewId = ((Object)((Object)view)).getClass().getName();
        }
        view.setID(viewId);
        if (this.childMap.get(viewId) != null) {
            return false;
        }
        this.childMap.put(viewId, view);
        return true;
    }

    @Override
    public DABaseComposite getView(String viewId) {
        DABaseComposite view = this.childMap.get(viewId);
        if (view == null) {
            for (Map.Entry<String, DABaseComposite> entry : this.childMap.entrySet()) {
                DABaseComposite entryComp = entry.getValue();
                if (entryComp.isContainer() && (view = entryComp.getView(viewId)) != null) break;
            }
        }
        return view;
    }

    public void setSelection(DAViewData sel) {
        this.selection = sel;
    }

    public DAViewData getSelection() {
        return this.selection;
    }

    public boolean isToplevel() {
        return this.isToplevel;
    }

    public Composite getTopTable() {
        return null;
    }

    @Override
    public void updateView() {
        for (Map.Entry<String, DABaseComposite> entry : this.childMap.entrySet()) {
            entry.getValue().updateView();
        }
    }

    @Override
    public void updateView(DAViewData data) {
        String viewid = data.getViewID();
        for (Map.Entry<String, DABaseComposite> entry : this.childMap.entrySet()) {
            if (entry.getKey().equals(viewid)) continue;
            entry.getValue().updateView(data);
        }
    }

    @Override
    public void callUpdatePage(DAChartBoardItem selectedItem) {
        for (Map.Entry<String, DABaseComposite> entry : this.childMap.entrySet()) {
            entry.getValue().callUpdatePage(selectedItem);
        }
    }

    @Override
    public void clear() {
        for (Map.Entry<String, DABaseComposite> entry : this.childMap.entrySet()) {
            entry.getValue().clear();
        }
    }

    protected void onResized(int width, int height) {
    }

    @Override
    protected boolean isContainer() {
        return true;
    }
}

