/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.sdblib.app;

import java.util.HashSet;
import org.tizen.sdblib.IDevice;
import org.tizen.sdblib.app.IApplication;
import org.tizen.sdblib.app.IApplicationListener;
import org.tizen.sdblib.app.IApplicationType;
import org.tizen.sdblib.util.CollectionUtil;

public class Application
implements IApplication {
    private IDevice device;
    private String name;
    private String packageId;
    private String appId;
    private HashSet<IApplicationListener> listeners = new HashSet();
    private boolean isRunning = false;
    private IApplicationType type;

    public int hashCode() {
        Object[] hashArray = new Object[]{this.name, this.packageId, this.appId, this.type, this.device};
        return CollectionUtil.hashCode(hashArray);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Application)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        Application app = (Application)obj;
        Object[][] compareArray = new Object[][]{{app.getName(), app.getPackageId(), app.getType(), app.getDevice()}, {this.name, this.packageId, this.appId, this.type, this.device}};
        return CollectionUtil.equals(compareArray);
    }

    public String toString() {
        String deviceStr = "";
        if (this.device != null) {
            deviceStr = this.device.toString();
        }
        String str = "id[" + this.packageId + "]" + ", name[" + this.name + "]" + ", target[" + deviceStr + "]";
        return str;
    }

    public Application(IDevice device, String name, String packageId, IApplicationType type) {
        this(device, name, packageId, packageId, type);
    }

    public Application(IDevice device, String name, String packageId, String appId, IApplicationType type) {
        this.device = device;
        this.name = name;
        this.packageId = packageId;
        this.appId = appId;
        this.type = type;
    }

    @Override
    public IDevice getDevice() {
        return this.device;
    }

    @Override
    public String getPackageId() {
        return this.packageId;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void addListener(IApplicationListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeListener(IApplicationListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public IApplicationListener[] getListeners() {
        return this.listeners.toArray(new IApplicationListener[0]);
    }

    @Override
    public boolean isRunning() {
        return this.isRunning;
    }

    @Override
    public void setRunning(boolean isRunning) {
        this.isRunning = isRunning;
    }

    @Override
    public IApplicationType getType() {
        return this.type;
    }

    @Override
    public String getAppId() {
        return this.appId;
    }
}

