/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.widgets.button;

import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.tizen.dynamicanalyzer.widgets.button.DACustomButtonAttribute;
import org.tizen.dynamicanalyzer.widgets.button.DACustomButtonClickEventListener;
import org.tizen.dynamicanalyzer.widgets.button.DACustomButtonRenderer;
import org.tizen.dynamicanalyzer.widgets.button.IDACustomButtonRenderer;
import org.tizen.dynamicanalyzer.widgets.helper.ColorResources;

public class DACustomButton
extends Canvas {
    public static final int STATE_NORMAL = 0;
    public static final int STATE_PUSH = 1;
    public static final int STATE_HOVER = 2;
    public static final int STATE_DISABLE = 3;
    public static final int TYPE_IMAGE = 0;
    public static final int TYPE_COLOR = 1;
    public static final int TYPE_GRADATION = 2;
    protected int state = 0;
    protected DACustomButtonAttribute attr;
    protected IDACustomButtonRenderer buttonRenderer = null;
    private boolean isTapbutton = false;
    protected Listener buttonMouseListener = new Listener(){

        public void handleEvent(Event event) {
            if (DACustomButton.this.state == 3) {
                return;
            }
            if (event.type == 6 && !DACustomButton.this.isTapbutton) {
                DACustomButton.this.changeButtonState(2);
            }
            if (event.type == 7 && !DACustomButton.this.isTapbutton) {
                DACustomButton.this.changeButtonState(0);
            }
            if (event.type == 3) {
                DACustomButton.this.changeButtonState(1);
            }
            if (event.type == 4) {
                DACustomButton.this.changeButtonState(2);
            }
        }
    };
    protected PaintListener buttonPaintListener = new PaintListener(){

        public void paintControl(PaintEvent e) {
            DACustomButton.this.buttonRenderer.draw(e.gc, (Canvas)e.widget, DACustomButton.this.state, DACustomButton.this.attr);
        }
    };

    public DACustomButton(Composite parent, int style) {
        super(parent, style);
        this.setForeground(ColorResources.WHITE);
        this.addPaintListener(this.buttonPaintListener);
        this.addListeners();
        this.buttonRenderer = new DACustomButtonRenderer();
        this.attr = new DACustomButtonAttribute();
        this.setDefaultColors();
        this.addListener(4, new Listener(){

            public void handleEvent(Event event) {
                DACustomButton button = (DACustomButton)event.widget;
                if (button != null) {
                    Rectangle rectangle = button.getBounds();
                    int x = event.x;
                    int y = event.y;
                    if (x < 0 || x > rectangle.width || y < 0 || y > rectangle.height) {
                        return;
                    }
                } else {
                    return;
                }
                button.setFocus();
            }
        });
    }

    public DACustomButton(Composite parent, String titleText) {
        this(parent, 0);
        this.attr.setText(titleText);
    }

    public DACustomButton(Composite parent, Image normal, Image mouseDown, Image hover, Image disable) {
        this(parent, 0x40000000);
        this.setImages(normal, mouseDown, hover, disable);
        this.attr.setDrawType(0);
    }

    public DACustomButton(Composite parent, Color normalStart, Color normalEnd, Color pushStart, Color pushEnd, Color hoverStart, Color hoverEnd, Color disableStart, Color disableEnd) {
        this(parent, 0);
        this.attr.setColor(0, normalStart);
        this.attr.setColor(1, normalEnd);
        this.attr.setColor(2, pushStart);
        this.attr.setColor(3, pushEnd);
        this.attr.setColor(4, hoverStart);
        this.attr.setColor(5, hoverEnd);
        this.attr.setColor(6, disableStart);
        this.attr.setColor(7, disableEnd);
        this.attr.setDrawType(2);
    }

    public DACustomButton(Composite parent, Color normalStart, Color normalEnd, Color pushStart, Color pushEnd, Color hoverStart, Color hoverEnd, Color disableStart, Color disableEnd, boolean istapbutton) {
        this(parent, 0);
        this.attr.setColor(0, normalStart);
        this.attr.setColor(1, normalEnd);
        this.attr.setColor(2, pushStart);
        this.attr.setColor(3, pushEnd);
        this.attr.setColor(4, hoverStart);
        this.attr.setColor(5, hoverEnd);
        this.attr.setColor(6, disableStart);
        this.attr.setColor(7, disableEnd);
        this.attr.setDrawType(2);
        this.isTapbutton = istapbutton;
    }

    protected void addListeners() {
        this.addListener(6, this.buttonMouseListener);
        this.addListener(7, this.buttonMouseListener);
        this.addListener(3, this.buttonMouseListener);
        this.addListener(4, this.buttonMouseListener);
    }

    protected void changeButtonState(int state) {
        this.state = state;
        this.redraw();
    }

    private void setDefaultColors() {
        this.attr.setColor(3, ColorResources.BUTTON_STATE_DISABLE);
        this.attr.setColor(1, ColorResources.BUTTON_STATE_PUSH);
        this.attr.setColor(2, ColorResources.BUTTON_STATE_HOVER);
        this.attr.setColor(0, ColorResources.BUTTON_STATE_NORMAL);
    }

    public void setTitle(String newTitle) {
        this.attr.setText(newTitle);
    }

    public void setText(String newTitle) {
        this.attr.setText(newTitle);
        this.redraw();
    }

    public String getText() {
        return this.attr.getText();
    }

    public void setButtonImage(int state, Image image) {
        this.attr.setButtonImage(state, image);
    }

    public void setButtonImagePoint(Point point) {
        this.attr.setButtonImagePoint(point);
    }

    public void setRenderer(IDACustomButtonRenderer newRenderer) {
        this.buttonRenderer = newRenderer;
    }

    public void setButtonEnabled(boolean enabled) {
        if (enabled) {
            this.changeButtonState(0);
        } else {
            this.changeButtonState(3);
        }
    }

    public boolean isButtonEnabled() {
        return this.state != 3;
    }

    public void setImage(int state, Image image) {
        this.attr.setImage(state, image);
    }

    public Image getImage(int state) {
        return this.attr.getImage(state);
    }

    public void setColor(int state, Color color) {
        this.attr.setColor(state, color);
    }

    public void setButtonFont(Font font) {
        this.attr.setFont(font);
    }

    public void setFontPoint(Point point) {
        this.attr.setFontPoint(point);
    }

    public void setColors(Color normal, Color push, Color hover, Color disable) {
        this.attr.setColor(0, normal);
        this.attr.setColor(1, push);
        this.attr.setColor(2, hover);
        this.attr.setColor(3, disable);
        this.attr.setDrawType(1);
    }

    public void setImages(Image normal, Image push, Image hover, Image disable) {
        this.attr.setImage(0, normal);
        this.attr.setImage(1, push);
        this.attr.setImage(2, hover);
        this.attr.setImage(3, disable);
        this.attr.setDrawType(0);
    }

    public void setButtonImages(Image normal, Image push, Image hover, Image disable) {
        this.attr.setButtonImage(0, normal);
        this.attr.setButtonImage(1, push);
        this.attr.setButtonImage(2, hover);
        this.attr.setButtonImage(3, disable);
    }

    public void setOutlineColors(Color normal, Color push, Color hover, Color disable) {
        this.attr.setOutlineColor(0, normal);
        this.attr.setOutlineColor(1, push);
        this.attr.setOutlineColor(2, hover);
        this.attr.setOutlineColor(3, disable);
    }

    public void setOutlineInColors(Color normal, Color push, Color hover, Color disable) {
        this.attr.setOutlineInColor(0, normal);
        this.attr.setOutlineInColor(1, push);
        this.attr.setOutlineInColor(2, hover);
        this.attr.setOutlineInColor(3, disable);
    }

    public void setGradationColor(int state, Color start, Color end) {
        this.attr.setColor(state * 2, start);
        this.attr.setColor(state * 2 + 1, end);
    }

    public void setGradation(Color normalStart, Color normalEnd, Color pushStart, Color pushEnd, Color hoverStart, Color hoverEnd, Color disableStart, Color disableEnd) {
        this.attr.setColor(0, normalStart);
        this.attr.setColor(1, normalEnd);
        this.attr.setColor(2, pushStart);
        this.attr.setColor(3, pushEnd);
        this.attr.setColor(4, hoverStart);
        this.attr.setColor(5, hoverEnd);
        this.attr.setColor(6, disableStart);
        this.attr.setColor(7, disableEnd);
        this.attr.setDrawType(2);
    }

    public void addClickListener(DACustomButtonClickEventListener listener) {
        this.addListener(4, listener);
    }

    public int getState() {
        return this.state;
    }

    public void setFontColors(Color normal, Color push, Color hover, Color disable) {
        this.attr.setFontColor(0, normal);
        this.attr.setFontColor(1, push);
        this.attr.setFontColor(2, hover);
        this.attr.setFontColor(3, disable);
    }

    public void setFontColor(int state, Color color) {
        this.attr.setFontColor(state, color);
    }

    public void setIcon(Image icon) {
        this.attr.setIcon(icon);
    }

    public void setAlign(int align) {
        this.attr.setAlign(align);
    }

    public void setDrawType(int style) {
        this.attr.setDrawType(style);
    }
}

