/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.widgets.button.radio;

import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.tizen.dynamicanalyzer.widgets.button.radio.DARadioGroup;
import org.tizen.dynamicanalyzer.widgets.button.radio.DARadioSelectionListener;
import org.tizen.dynamicanalyzer.widgets.helper.ColorResources;
import org.tizen.dynamicanalyzer.widgets.helper.ImageResources;

public class DARadioButton
extends Canvas {
    private static int radioSeq = 0;
    public static final int RADIO_UNSELECTED = 0;
    public static final int RADIO_SELECTED = 1;
    public static final int RADIO_UNSELECTED_HOVER = 2;
    private DARadioGroup parent = null;
    private String text = null;
    private int state = 0;
    private Color bgColor = null;
    private Color fgColor = null;
    private int id = 0;
    private PaintListener radioPaintListener = new PaintListener(){

        public void paintControl(PaintEvent e) {
            DARadioButton me = (DARadioButton)e.widget;
            Rectangle rect = me.getClientArea();
            Image img = null;
            if (DARadioButton.this.state == 1) {
                img = ImageResources.RADIO_SELECTED;
            } else if (DARadioButton.this.state == 2) {
                img = ImageResources.RADIO_UNSELECTED_HOVER;
            } else if (DARadioButton.this.state == 0) {
                img = ImageResources.RADIO_UNSELECTED;
            } else {
                return;
            }
            Rectangle imgRect = img.getBounds();
            int x = 0;
            int y = (rect.height - imgRect.height) / 2;
            if (DARadioButton.this.bgColor != null) {
                e.gc.setBackground(DARadioButton.this.bgColor);
            }
            e.gc.fillRectangle(rect);
            e.gc.drawImage(img, x, y);
            if (DARadioButton.this.isEnabled()) {
                if (DARadioButton.this.fgColor != null) {
                    e.gc.setForeground(DARadioButton.this.fgColor);
                }
            } else {
                e.gc.setForeground(ColorResources.BAR_GRAY1);
            }
            int fontHeight = e.gc.getFontMetrics().getHeight();
            x = imgRect.width + 4;
            y = (rect.height - fontHeight) / 2;
            e.gc.drawText(DARadioButton.this.text, x, y);
        }
    };
    protected Listener mouseListener = new Listener(){

        public void handleEvent(Event event) {
            DARadioButton radio = (DARadioButton)event.widget;
            if (event.type == 6 && DARadioButton.this.state != 1) {
                DARadioButton.this.state = 2;
            }
            if (event.type == 7 && DARadioButton.this.state != 1) {
                DARadioButton.this.state = 0;
            }
            if (event.type == 32 && DARadioButton.this.state != 1) {
                DARadioButton.this.state = 2;
            }
            if (event.type == 4) {
                DARadioButton.this.parent.setSelection(radio);
                DARadioButton.this.state = 1;
            }
            DARadioButton.this.redraw();
        }
    };

    public DARadioButton(Composite parent, int style) {
        super(parent, style);
        this.addPaintListener(this.radioPaintListener);
        this.addListener(6, this.mouseListener);
        this.addListener(7, this.mouseListener);
        this.addListener(4, this.mouseListener);
        this.text = "";
        this.id = radioSeq++;
    }

    public DARadioButton(Composite parent, int style, int radioID) {
        this(parent, style);
        this.addPaintListener(this.radioPaintListener);
        this.addListener(6, this.mouseListener);
        this.addListener(7, this.mouseListener);
        this.addListener(4, this.mouseListener);
        this.text = "";
        this.id = radioID;
    }

    public void setForeground(Color color) {
        super.setForeground(color);
        this.fgColor = color;
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        this.bgColor = color;
    }

    public void setText(String text) {
        this.text = text;
    }

    public String getText() {
        return this.text;
    }

    public void setGroup(DARadioGroup parent) {
        this.parent = parent;
    }

    public void setSelection(boolean selected) {
        this.state = selected ? 1 : 0;
    }

    public void addSelectionListener(DARadioSelectionListener listener) {
        this.addListener(4, listener);
    }

    public boolean isSelected() {
        return this.state == 1;
    }

    public int getRadioId() {
        return this.id;
    }

    public String getGroup() {
        return this.parent.getGroupID();
    }
}

