/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.widgets.helper;

import java.text.DecimalFormat;
import org.tizen.dynamicanalyzer.util.Logger;

public class Formatter {
    public static String toHexString(String decimal) {
        block4: {
            if (decimal == null || decimal.isEmpty()) {
                return null;
            }
            try {
                if (!decimal.isEmpty()) break block4;
                return null;
            }
            catch (NumberFormatException e) {
                Logger.exception((Throwable)e);
                return decimal;
            }
        }
        long data = 0L;
        data = Long.parseLong(decimal);
        return String.format("0x%08X", data);
    }

    public static String toDoubleFormat1(String value) {
        if (value == null || value.isEmpty()) {
            return null;
        }
        try {
            double data = Double.parseDouble(value);
            return String.format("%.1f", data);
        }
        catch (NumberFormatException e) {
            Logger.exception((Throwable)e);
            return value;
        }
    }

    public static String toByteNumberFormat(String value) {
        if (value == null || value.isEmpty()) {
            return null;
        }
        try {
            long num = Long.parseLong(value);
            String str = "";
            while (num > 0L) {
                long n = num % 1000L;
                if (str.isEmpty()) {
                    str = String.valueOf(str) + Long.toString(n);
                } else {
                    String zero = "";
                    if (str.length() == 1) {
                        zero = String.valueOf(zero) + "00";
                    } else if (str.length() == 2) {
                        zero = String.valueOf(zero) + "0";
                    }
                    str = String.valueOf(zero) + Long.toString(n) + "," + str;
                }
                num /= 1000L;
            }
            if (str.isEmpty()) {
                str = String.valueOf(str) + "0";
            }
            return str;
        }
        catch (NumberFormatException e) {
            Logger.exception((Throwable)e);
            return "0";
        }
    }

    public static String toByteToMbNumberFormat2(String value) {
        if (value == null || value.isEmpty()) {
            return null;
        }
        try {
            long num = Long.parseLong(value);
            double kb = (double)(num /= 1024L) / 1024.0;
            String str = Formatter.toDoubleFormat2(Double.toString(kb));
            return str;
        }
        catch (NumberFormatException e) {
            Logger.exception((Throwable)e);
            return "0";
        }
    }

    public static String toDoubleFormat2(String value) {
        if (value == null || value.isEmpty()) {
            return null;
        }
        try {
            double data = Double.parseDouble(value);
            return String.format("%.2f", data);
        }
        catch (NumberFormatException e) {
            Logger.exception((Throwable)e);
            return value;
        }
    }

    public static String toTimeFormat(long time) {
        String strMs;
        String strSecond;
        long ms = (time /= 1000L) % 1000L;
        long second = (time /= 1000L) % 60L;
        long minute = (time /= 60L) % 60L;
        String strMinute = Long.toString(minute);
        if (strMinute.length() < 2) {
            strMinute = "0" + strMinute;
        }
        if ((strSecond = Long.toString(second)).length() < 2) {
            strSecond = "0" + strSecond;
        }
        if ((strMs = Long.toString(ms)).length() == 2) {
            strMs = "0" + strMs;
        } else if (strMs.length() == 1) {
            strMs = "00" + strMs;
        }
        String output = String.valueOf(strMinute) + ":" + strSecond + ":" + strMs;
        return output;
    }

    public static String toTimeFormat(String time) {
        long longTime = Long.parseLong(time);
        return Formatter.toTimeFormat(longTime);
    }

    public static String toTimeFormat2(String msTime) {
        String strMs;
        long longTime = Long.parseLong(msTime);
        long ms = longTime % 1000L;
        long second = (longTime /= 1000L) % 60L;
        String strSecond = Long.toString(second);
        if (strSecond.length() < 2) {
            strSecond = "0" + strSecond;
        }
        if ((strMs = Long.toString(ms)).length() == 2) {
            strMs = "0" + strMs;
        } else if (strMs.length() == 1) {
            strMs = "00" + strMs;
        }
        String output = String.valueOf(strSecond) + ":" + strMs;
        return output;
    }

    public static String toTimelineFormat(int totalSecond) {
        String output;
        int second = totalSecond % 60;
        int minute = totalSecond / 60;
        if (minute > 60) {
            int hours = minute / 60;
            output = String.format("%d:%02d:%02d", hours, minute % 60, second);
        } else {
            output = String.format("%02d:%02d", minute, second);
        }
        return output;
    }

    public static String toPercentageFormat(Double input) {
        String ret = String.format("%.2f", input);
        ret = String.valueOf(ret) + " %";
        return ret;
    }

    public static String toNumberFormat(long input) {
        String value;
        int reminder = 0;
        long quotient = input;
        String output = "";
        while (true) {
            reminder = (int)(quotient % 1000L);
            value = Integer.toString(reminder);
            if ((quotient /= 1000L) <= 0L) break;
            if (value.length() < 2) {
                value = "00" + value;
            } else if (value.length() < 3) {
                value = "0" + value;
            }
            output = String.valueOf(value) + output;
            output = "," + output;
        }
        output = String.valueOf(value) + output;
        return output;
    }

    public static String toNumberFormat(double input) {
        return Formatter.toNumberFormat((long)input);
    }

    public static String toByteFormat(long input) {
        int reminder = 0;
        long quotient = input;
        int count = 0;
        String value = "";
        while (quotient >= 1024L) {
            reminder = (int)(quotient % 1024L);
            quotient /= 1024L;
            ++count;
        }
        value = Long.toString(quotient);
        String remStr = Integer.toString(reminder);
        if (count > 0) {
            value = remStr.length() < 3 ? String.valueOf(value) + ".0" : String.valueOf(value) + "." + remStr.substring(0, 1);
        }
        value = String.valueOf(value) + " " + Formatter.getMeasure(count);
        return value;
    }

    public static String toByteFormat(double input) {
        return Formatter.toByteFormat((long)input);
    }

    public static String toBpsFormat(long nByte, long startTime, long endTime) {
        String value = "";
        DecimalFormat df1 = new DecimalFormat("#,##0.00");
        double Bps = nByte;
        if (endTime - startTime >= 1000000L) {
            Bps = (double)nByte * (1000000.0 / (double)(endTime - startTime));
        }
        value = String.valueOf(value) + df1.format(Bps) + " Bps";
        return value;
    }

    public static String toBpsFormat(double nByte, long startTime, long endTime) {
        return Formatter.toBpsFormat((long)nByte, startTime, endTime);
    }

    private static String getMeasure(int count) {
        if (count == 4) {
            return "TB";
        }
        if (count == 3) {
            return "GB";
        }
        if (count == 2) {
            return "MB";
        }
        if (count == 1) {
            return "KB";
        }
        return "Byte";
    }

    public static String toByteFormatValue(long input) {
        int reminder = 0;
        long quotient = input;
        int count = 0;
        String value = "";
        while (quotient >= 1024L) {
            reminder = (int)(quotient % 1024L);
            quotient /= 1024L;
            ++count;
        }
        value = Long.toString(quotient);
        String remStr = Integer.toString(reminder);
        if (count > 0) {
            value = remStr.length() < 3 ? String.valueOf(value) + ".0" : String.valueOf(value) + "." + remStr.substring(0, 1);
        }
        return value;
    }

    public static String toByteFormatMeasure(long input) {
        long quotient = input;
        int count = 0;
        String value = null;
        while (quotient >= 1024L) {
            quotient /= 1024L;
            ++count;
        }
        value = Formatter.getMeasure(count);
        return value;
    }

    public static String convertDecimalPrefix(double input) {
        String ret;
        String[] units = new String[]{"K", "M", "G", "T"};
        long k = 1000L;
        String unit = "";
        long quotient = (long)input;
        long remainder = (long)(input * (double)k) % k;
        long n = k;
        int i = 0;
        while (i < units.length) {
            if (input < (double)n) break;
            remainder = quotient % k;
            quotient /= k;
            unit = units[i];
            n *= k;
            ++i;
        }
        if (0L == remainder || unit.equals("")) {
            ret = String.format("%d", quotient);
        } else {
            float fValue = remainder /= 100L;
            remainder = Math.round(fValue);
            ret = String.format("%d.%d%s", quotient, remainder, unit);
        }
        return ret;
    }

    public static String convertMicroDecimalPrefix(double input) {
        String ret;
        String[] units = new String[]{"m", "", "K", "M", "G", "T"};
        long k = 1000L;
        String unit = "\u00b5";
        long quotient = (long)input;
        long remainder = (long)(input * (double)k) % k;
        long n = k;
        int i = 0;
        while (i < units.length) {
            if (input < (double)n) break;
            remainder = quotient % k;
            quotient /= k;
            unit = units[i];
            n *= k;
            ++i;
        }
        if (0L == remainder) {
            ret = String.format("%d%s", quotient, unit);
        } else {
            float fValue = remainder /= 100L;
            remainder = Math.round(fValue);
            ret = String.format("%d.%d%s", quotient, remainder, unit);
        }
        return ret;
    }

    public static String convertBinaryPrefix(double input) {
        String ret;
        String[] units = new String[]{"Ki", "Mi", "Gi", "Ti"};
        long k = 1024L;
        String unit = "";
        long quotient = (long)input;
        long remainder = (long)(input * (double)k) % k;
        long n = k;
        int i = 0;
        while (i < units.length) {
            if (input < (double)n) break;
            remainder = quotient % k;
            quotient /= k;
            unit = units[i];
            n *= k;
            ++i;
        }
        if (0L == remainder || unit.equals("")) {
            ret = String.format("%d", quotient);
        } else {
            remainder /= 100L;
            remainder = Math.round(remainder);
            ret = String.format("%d.%d%s", quotient, remainder, unit);
            ret = String.format("%d.%d%s", quotient, remainder, unit);
        }
        return ret;
    }
}

