/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.widgets.progress;

import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.tizen.dynamicanalyzer.widgets.helper.ColorResources;

public class Progress
extends Canvas {
    private Color barStartBgColor = ColorResources.GRAY_245;
    private Color barEndBgColor = ColorResources.GRAY_245;
    private Color barStartColor = ColorResources.POINT;
    private Color barEndColor = ColorResources.POINT;
    private Color barOutlineColor = ColorResources.POINT;
    private int maxSize = 100;
    private int value = 0;
    private Font percentageFont = null;
    private Color fontColor = null;
    private PaintListener progressPaintListener = new PaintListener(){

        public void paintControl(PaintEvent e) {
            Canvas canvas = (Canvas)e.widget;
            Rectangle rect = canvas.getBounds();
            e.gc.setForeground(Progress.this.barStartBgColor);
            e.gc.setBackground(Progress.this.barEndBgColor);
            e.gc.fillGradientRectangle(0, 0, rect.width, rect.height, true);
            int width = Progress.this.value * rect.width / 100;
            e.gc.setForeground(Progress.this.barStartColor);
            e.gc.setBackground(Progress.this.barEndColor);
            e.gc.fillGradientRectangle(0, 0, width, rect.height, true);
            e.gc.setForeground(Progress.this.barOutlineColor);
            e.gc.drawRectangle(new Rectangle(0, 0, rect.width - 1, rect.height - 1));
            Point widgetSize = Progress.this.getSize();
            String text = String.valueOf(Progress.this.value) + "%";
            if (Progress.this.percentageFont != null) {
                e.gc.setFont(Progress.this.percentageFont);
            }
            if (Progress.this.fontColor != null) {
                e.gc.setForeground(Progress.this.fontColor);
            }
            Point textSize = e.gc.stringExtent(text);
            e.gc.drawString(text, (widgetSize.x - textSize.x) / 2, (widgetSize.y - textSize.y) / 2 + 1, true);
        }
    };

    public Progress(Composite parent, int style) {
        super(parent, style);
        this.addPaintListener(this.progressPaintListener);
    }

    public void setBarStartBackgroundColor(Color color) {
        this.barStartBgColor = color;
    }

    public void setBarEndBackgroundColor(Color color) {
        this.barEndBgColor = color;
    }

    public void setBarStartColor(Color color) {
        this.barStartColor = color;
    }

    public void setBarEndColor(Color color) {
        this.barEndColor = color;
    }

    public void setBarOutlineColor(Color color) {
        this.barOutlineColor = color;
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public void setMaxSize(int maxSize) {
        this.maxSize = maxSize;
    }

    public int getValue() {
        return this.value;
    }

    public void setValue(int value) {
        this.value = value;
        this.redraw();
        this.update();
    }

    public void errorOccured() {
        this.barStartColor = ColorResources.RED;
        this.barEndColor = ColorResources.WHITE;
    }

    public void setPercentageFont(Font font) {
        this.percentageFont = font;
    }

    public void setFontColor(Color color) {
        this.fontColor = color;
    }
}

