/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.swap.logparser;

import java.io.File;
import org.tizen.dynamicanalyzer.common.DAResult;
import org.tizen.dynamicanalyzer.common.Global;
import org.tizen.dynamicanalyzer.communicator.DACommunicator;
import org.tizen.dynamicanalyzer.swap.logparser.LogParser;
import org.tizen.dynamicanalyzer.util.Logger;
import org.tizen.dynamicanalyzer.utils.ImageUtil;
import org.tizen.dynamicanalyzer.utils.ImageUtilSWT;

public class ImageProcessingThread
implements Runnable {
    private static final int GET_IMAGE_TRY_COUNT = 5;
    private static final int GET_IMAGE_TRY_INTERVAL = 1000;
    private static final int SMALL_IMG_WIDTH = 40;
    private static final int SMALL_IMG_HEIGHT = 66;
    private static final int DEFAULT_IMG_WIDTH = 480;
    private static final int DEFAULT_IMG_HEIGHT = 800;
    private String sourcePath = null;
    private int angle = 0;
    private boolean isECS = false;
    private LogParser parent = null;

    public ImageProcessingThread(LogParser parent, String srcPath, int angle, boolean isECS) {
        this.parent = parent;
        this.sourcePath = srcPath;
        this.angle = angle;
        this.isECS = isECS;
    }

    @Override
    public void run() {
        if (this.isECS) {
            if (this.getImageFromECS(this.sourcePath)) {
                this.resizeImageFromECS(this.sourcePath, this.angle);
            }
        } else {
            String fileName = this.getImageName(this.sourcePath);
            String to = String.valueOf(Global.getProject().getSavePath()) + File.separator + "img" + File.separator + fileName;
            this.getImage(this.sourcePath, to);
        }
        this.parent.setImageThreadFinished(Thread.currentThread());
    }

    private boolean getImageFromECS(String path) {
        boolean ret = false;
        for (int count = 0; count < 5; ++count) {
            File file = new File(path);
            if (file.exists()) {
                ret = true;
                break;
            }
            Logger.debug((Object)("Failed to get '" + path + "' file"));
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException e) {
                Logger.exception((Throwable)e);
                break;
            }
        }
        return ret;
    }

    private boolean getImage(String from, String to) {
        boolean ret = false;
        for (int count = 0; count < 5; ++count) {
            DAResult res = DACommunicator.pull(from, to);
            if (res.isSuccess()) {
                DACommunicator.removeFile(from);
                ret = true;
                break;
            }
            Logger.debug((Object)("Failed to get '" + from + "' file"));
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException e) {
                Logger.exception((Throwable)e);
                break;
            }
        }
        return ret;
    }

    private void resizeImageFromECS(String path, int angle) {
        String fileName = this.getImageName(path);
        String smallImagePath = String.valueOf(Global.getProject().getSavePath()) + File.separator + "img" + File.separator + "small" + File.separator + fileName;
        ImageUtilSWT.transform(path, path, 480, 800, angle);
        if (angle == 90 || angle == 270) {
            ImageUtilSWT.resize(path, smallImagePath, 66, 40);
        } else {
            ImageUtilSWT.resize(path, smallImagePath, 40, 66);
        }
    }

    private void resizeImage(String fileName, String to, int angle) {
        String smallImagePath = String.valueOf(Global.getProject().getSavePath()) + File.separator + "img" + File.separator + "small" + File.separator + fileName;
        ImageUtil.transform(to, to, 480, 800, angle);
        if (angle == 90 || angle == 270) {
            ImageUtil.resize(to, smallImagePath, 66, 40);
        } else {
            ImageUtil.resize(to, smallImagePath, 40, 66);
        }
    }

    private String getImageName(String fullPath) {
        String name = null;
        name = fullPath.substring(fullPath.lastIndexOf("/") + 1);
        return name;
    }
}

