/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.common;

import java.util.Collections;
import org.tizen.dynamicanalyzer.ui.common.PopupRangeAnalysisMenuItemListener;
import org.tizen.dynamicanalyzer.ui.range.RangeDataManager;
import org.tizen.dynamicanalyzer.util.Logger;
import org.tizen.dynamicanalyzer.utils.AnalyzerUtil;
import org.tizen.dynamicanalyzer.widgets.chart.DAChart;
import org.tizen.dynamicanalyzer.widgets.chart.DAChartPlotIntervalMarker;
import org.tizen.dynamicanalyzer.widgets.chart.DAChartPlotMarker;
import org.tizen.dynamicanalyzer.widgets.chartBoard.DAChartBoard;
import org.tizen.dynamicanalyzer.widgets.popupMenu.DAPopupMenuItem;

public class PopupRangeAnalysisMenuItemOnChartListener
extends PopupRangeAnalysisMenuItemListener {
    DAChart chart;

    public PopupRangeAnalysisMenuItemOnChartListener(DAPopupMenuItem menuItem, DAChartBoard chartBoard, DAChart chart) {
        super(menuItem, chartBoard);
        this.chart = chart;
    }

    @Override
    public void widgetSelected(DAPopupMenuItem menuItem) {
        double time = menuItem.getDoubleData();
        Collections.sort(RangeDataManager.getInstance().getMarerTimeList());
        RangeDataManager.getInstance().setRangeFromMarkerList((long)(time * 1000000.0));
        DAChartPlotMarker marker = (DAChartPlotMarker)this.chart.getPlot().getMarkers().get(0);
        if (marker instanceof DAChartPlotIntervalMarker) {
            DAChartPlotIntervalMarker intervalMarker = (DAChartPlotIntervalMarker)marker;
            double startVal = RangeDataManager.getInstance().getMarkerStartTime();
            double endVal = RangeDataManager.getInstance().getMarkerEndTime();
            intervalMarker.setInterval(startVal / 1000000.0, endVal / 1000000.0);
            AnalyzerUtil.getMainTab().getTopComposite().callUpdatePage(this.chartBoard.getSelectItem());
        } else {
            Logger.error((Object)("Chart plot marker is not of type DAChartPlotIntervalMarker but " + marker.getClass().getName()));
        }
    }
}

