/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.file.manager;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.tizen.dynamicanalyzer.common.DALimit;
import org.tizen.dynamicanalyzer.common.Global;
import org.tizen.dynamicanalyzer.communicator.UnsupportedProtocolException;
import org.tizen.dynamicanalyzer.nl.FilePageLabels;
import org.tizen.dynamicanalyzer.setting.Feature;
import org.tizen.dynamicanalyzer.setting.SettingDataManager;
import org.tizen.dynamicanalyzer.setting.TargetData;
import org.tizen.dynamicanalyzer.swap.logparser.LogPackage;
import org.tizen.dynamicanalyzer.swap.logparser.Logs;
import org.tizen.dynamicanalyzer.swap.model.data.FileData;
import org.tizen.dynamicanalyzer.swap.model.data.FileSyscallData;
import org.tizen.dynamicanalyzer.swap.model.data.LogData;
import org.tizen.dynamicanalyzer.swap.model.data.ProfileData;
import org.tizen.dynamicanalyzer.ui.file.manager.FileDataManager;
import org.tizen.dynamicanalyzer.ui.file.model.FileAccess;
import org.tizen.dynamicanalyzer.ui.file.model.FileAccessor;
import org.tizen.dynamicanalyzer.ui.file.model.FileEvent;
import org.tizen.dynamicanalyzer.ui.file.model.FileStatus;
import org.tizen.dynamicanalyzer.ui.summary.SummaryDataManager;
import org.tizen.dynamicanalyzer.ui.summary.warning.WarningCase;
import org.tizen.dynamicanalyzer.util.Logger;

public class FileDataMaker {
    private List<FileStatus> fileStatusList = new ArrayList<FileStatus>();
    private List<FileAccess> fileAccessList = new ArrayList<FileAccess>();
    private List<FileEvent> fileApiList = new ArrayList<FileEvent>();
    private List<FileAccessor> fileAccessorList = Collections.synchronizedList(new ArrayList());
    private Map<Long, FileEvent> entryMap = new HashMap<Long, FileEvent>();
    private Map<String, List<Object>> fileAccessorMap = new LinkedHashMap<String, List<Object>>();
    private Map<String, List<Object>> filePathMap = new HashMap<String, List<Object>>();
    private Map<List<Integer>, List<Integer>> accessorHasLockMap = new HashMap<List<Integer>, List<Integer>>();
    private Map<String, Integer> concurrentAccessNumMap = new HashMap<String, Integer>();
    AtomicInteger idGenerator = new AtomicInteger();
    private boolean isInculdeInsideCall = false;

    public void clear() {
        this.fileStatusList.clear();
        this.fileAccessList.clear();
        this.fileApiList.clear();
        this.fileAccessorList.clear();
        this.fileAccessorMap.clear();
        this.filePathMap.clear();
        this.accessorHasLockMap.clear();
        this.concurrentAccessNumMap.clear();
        this.entryMap.clear();
    }

    public void makeData(LogPackage pack) {
        TargetData target = SettingDataManager.INSTANCE.getConnectedTarget();
        if (target.isSelectedFeature(Feature.INTERNAL_PROBE_FILE)) {
            this.isInculdeInsideCall = true;
        }
        ArrayList<FileEvent> fileEventList = new ArrayList<FileEvent>();
        new ArrayList();
        new ArrayList();
        Logs probeLogs = pack.getLogs(260);
        this.processProbeData(probeLogs, fileEventList);
        Logs sysLogs = pack.getLogs(2304);
        this.processSysData(sysLogs, fileEventList);
    }

    public void processOpenFileList(Logs openFileLogs, List<FileEvent> fileEventList) {
        if (openFileLogs != null && openFileLogs.getRawLogs().size() != 0) {
            openFileLogs.getLogs();
        }
    }

    public void processProbeData(Logs probeLogs, List<FileEvent> fileEventList) {
        if (probeLogs != null && probeLogs.getRawLogs().size() != 0) {
            List<LogData> inputs = probeLogs.getLogs();
            FileEvent event = null;
            int i = 0;
            while (i < inputs.size()) {
                FileData input = (FileData)inputs.get(i);
                if (!(!this.isInculdeInsideCall && input.isInternal() || this.checkInvalidApiName(input) || this.isOpenMainLog(input))) {
                    if (input.getErrno() != 0L) {
                        SummaryDataManager.getInstance().getFailedApiDataMaker().makeData(input);
                    }
                    Logger.debug((Object)(">>probe pid:" + input.getPid() + ", tid:" + input.getTid() + ", fd:" + input.getFdValue() + ", type:" + input.getFdApiType() + ", filePath:" + input.getFilePath() + ", err:" + input.getErrno() + ", arg" + input.getArgs()));
                    event = new FileEvent(input.getSeq(), input.getFilePath(), input.getPid(), input.getTid(), input.getFdValue(), input.getFdApiType(), input.getApiId(), input.getTime(), input.getFileSize(), input.getSize(), input.getArgs(), input.getReturn(), input.getErrno(), true);
                    this.addFileEvent(fileEventList, event, input);
                }
                ++i;
            }
            this.saveFileAccessors(fileEventList);
        }
    }

    public void processSysData(Logs sysLogs, List<FileEvent> fileEventList) {
        if (sysLogs != null) {
            ProfileData profileData = null;
            FileSyscallData fileSyscallData = null;
            FileEvent event = null;
            FileEvent fakeOpenEvent = null;
            String filePath = null;
            int pid = 0;
            int tid = 0;
            int fd = 0;
            int eventType = 0;
            long seq = 0L;
            long time = 0L;
            int msgID = -1;
            List<LogData> inputs = sysLogs.getLogs();
            int i = 0;
            while (i < inputs.size()) {
                LogData fileLog = inputs.get(i);
                if (fileLog instanceof ProfileData) {
                    profileData = (ProfileData)fileLog;
                    seq = profileData.getSeq();
                    time = profileData.getTime();
                    msgID = profileData.getMsgID();
                    pid = profileData.getPid();
                    tid = profileData.getTid();
                } else {
                    fileSyscallData = (FileSyscallData)fileLog;
                    seq = fileSyscallData.getSeq();
                    time = fileSyscallData.getTime();
                    msgID = fileSyscallData.getMsgID();
                    pid = fileSyscallData.getPid();
                    tid = fileSyscallData.getTid();
                }
                block1 : switch (msgID) {
                    case 8: 
                    case 12: {
                        if (profileData != null) {
                            String args = profileData.getArgs();
                            String[] splitPath = args.split(",\\s+");
                            fd = Integer.parseInt(splitPath[1]);
                            filePath = splitPath[0];
                            try {
                                eventType = profileData.getProbeSubType();
                            }
                            catch (UnsupportedProtocolException unsupportedProtocolException) {
                                Logger.error((Object)"Never goes here!");
                            }
                        } else {
                            fd = fileSyscallData.getFd();
                            eventType = fileSyscallData.getEventType();
                            filePath = fileSyscallData.getFilePath();
                        }
                        event = new FileEvent(seq, pid, tid, fd, filePath, eventType, time, 0L, false);
                        fakeOpenEvent = new FileEvent(0L, pid, tid, fd, filePath, 0, time, 0L, false);
                        if (!this.fileAccessorMap.containsKey(filePath)) break;
                        Logger.debug((Object)(">> syscall:seq:" + seq + ", pid:" + pid + ", tid:" + tid + ", type:" + eventType));
                        event = new FileEvent(seq, pid, tid, fd, filePath, eventType, time, 0L, false);
                        if (fd == -1) {
                            event.setErrNo(-1L);
                        }
                        String key = this.createKey(pid, tid, fd);
                        switch (eventType) {
                            case 0: {
                                this.addFilePathInfo(key, filePath, -1, -1);
                                this.addFileEvent(fileEventList, event, null);
                                break block1;
                            }
                            case 1: {
                                if (!this.filePathMap.containsKey(key)) break block1;
                                this.addFileEvent(fileEventList, event, null);
                                this.removeFilePathInfo(key);
                                break block1;
                            }
                            case 14: {
                                if (!this.filePathMap.containsKey(key)) {
                                    this.addFileEvent(fileEventList, fakeOpenEvent, null);
                                    this.addFilePathInfo(key, filePath, -1, -1);
                                }
                                this.entryMap.put(seq, event);
                                this.addFileEvent(fileEventList, event, null);
                                break block1;
                            }
                            case 16: {
                                if (this.filePathMap.containsKey(key)) break block1;
                                this.addFileEvent(fileEventList, fakeOpenEvent, null);
                                this.addFilePathInfo(key, filePath, -1, -1);
                                break block1;
                            }
                            case 2: 
                            case 4: {
                                if (!this.filePathMap.containsKey(key)) {
                                    this.addFileEvent(fileEventList, fakeOpenEvent, null);
                                    this.addFilePathInfo(key, filePath, -1, -1);
                                }
                                this.entryMap.put(seq, event);
                                this.addFileEvent(fileEventList, event, null);
                                break block1;
                            }
                        }
                        break;
                    }
                    case 9: 
                    case 13: {
                        long entrySeq = -1L;
                        String ret = "";
                        if (profileData != null) {
                            entrySeq = profileData.getEntrySeq();
                            ret = profileData.getReturn();
                        } else {
                            entrySeq = fileSyscallData.getEntrySeq();
                            ret = fileSyscallData.getReturn();
                        }
                        if (!this.entryMap.containsKey(entrySeq)) break;
                        event = this.entryMap.get(entrySeq);
                        if (Long.parseLong(ret) < 0L) {
                            event.setErrNo(-1L);
                        }
                        switch (event.getFdApiType()) {
                            case 2: {
                                event.setFdApiType(3);
                                event.setTime(time);
                                this.addFileEvent(fileEventList, event, null);
                                break block1;
                            }
                            case 4: {
                                event.setFdApiType(5);
                                event.setTime(time);
                                this.addFileEvent(fileEventList, event, null);
                                break block1;
                            }
                            case 14: {
                                event.setFdApiType(15);
                                event.setTime(time);
                                this.addFileEvent(fileEventList, event, null);
                                break block1;
                            }
                            case 16: {
                                event.setFdApiType(16);
                                event.setTime(time);
                                this.addFileEvent(fileEventList, event, null);
                                break block1;
                            }
                        }
                    }
                }
                ++i;
            }
            this.saveFileAccessors(fileEventList);
        }
    }

    public void saveFileAccessors(List<FileEvent> fileEventList) {
        ArrayList<List<Object>> fileApiList = new ArrayList<List<Object>>();
        if (fileEventList.size() > 0) {
            for (FileEvent data : fileEventList) {
                fileApiList.add(data.getDBData());
            }
            FileDataManager.getInstance().getApiDB().insert(fileApiList);
        }
        this.fileAccessorList.clear();
        for (String key : this.fileAccessorMap.keySet()) {
            List<Object> values = this.fileAccessorMap.get(key);
            Object[] list = values.toArray();
            this.fileAccessorList.addAll((ArrayList)list[1]);
        }
    }

    public void addFileEvent(List<FileEvent> fileEventList, FileEvent event, FileData logData) {
        Object[] fileInfo;
        this.checkFileAnalysisLimit();
        int pid = event.getPid();
        int tid = event.getTid();
        long fd = event.getFdValue();
        String filePath = event.getFilePath();
        int apiType = event.getFdApiType();
        long eventTime = event.getTime();
        boolean isTarget = event.isTarget();
        long size = event.getSize();
        long errNo = event.getErrno();
        String key = null;
        if (isTarget) {
            key = this.createKey(pid, tid, fd);
            if (fd == -1L) {
                filePath = FilePageLabels.FILE_CHART_UNKNOWN_FILE;
                fileInfo = this.addFileAccessor(filePath, pid, tid, isTarget);
                event.setFileId(fileInfo[0]);
                event.setAccessorId(fileInfo[1]);
                event.setFilePath(filePath);
            } else if (filePath == null || filePath.equals("")) {
                fileInfo = this.getFilePathInfo(key);
                if (fileInfo == null) {
                    return;
                }
                filePath = (String)fileInfo[0];
                event.setFilePath(filePath);
                event.setFileId(fileInfo[1]);
                event.setAccessorId(fileInfo[2]);
            }
        } else {
            fileInfo = this.addFileAccessor(filePath, pid, tid, isTarget);
            event.setFileId(fileInfo[0]);
            event.setAccessorId(fileInfo[1]);
        }
        switch (apiType) {
            case 0: {
                if (isTarget) {
                    fileInfo = this.addFileAccessor(filePath, pid, tid, isTarget);
                    event.setFileId(fileInfo[0]);
                    event.setAccessorId(fileInfo[1]);
                    this.addFilePathInfo(key, filePath, fileInfo[0], fileInfo[1]);
                }
                if (errNo != 0L) break;
                this.addStatusData(new FileStatus(event.getFileId(), apiType, eventTime));
                break;
            }
            case 1: {
                if (errNo != 0L) break;
                if (isTarget) {
                    this.removeFilePathInfo(key);
                }
                this.addStatusData(new FileStatus(event.getFileId(), apiType, eventTime));
                List<Integer> accessorIds = this.getTidsHasLock(event.getFileId(), pid);
                if (accessorIds == null) break;
                for (Integer accessor : accessorIds) {
                    FileAccess access = new FileAccess((int)accessor, 17, eventTime, eventTime, FilePageLabels.FILE_CHART_TOOLTIP_LOCK_AUTORELEASE);
                    this.addAccessData(access);
                }
                this.removeTidsHasLock(event.getFileId(), pid);
                break;
            }
            case 2: {
                FileAccess readAccess = new FileAccess(event.getAccessorId(), fd, apiType, eventTime, FilePageLabels.FILE_CHART_TOOLTIP_READ);
                if (this.checkConcurrentAccess(filePath)) {
                    readAccess.setWarning();
                    readAccess.setTooltip(FilePageLabels.FILE_CHART_TOOLTIP_CONCURRENT_READ);
                    if (logData != null) {
                        SummaryDataManager.getInstance().getWarningDataMaker().add(logData, String.valueOf(FilePageLabels.FILE_CAHRT_PROCESS_ID) + pid + ", " + FilePageLabels.FILE_CAHRT_THREAD_ID + tid, WarningCase.CONCURRENT_ACCESS.getType());
                    }
                }
                this.addStartAccessData(readAccess);
                break;
            }
            case 3: {
                this.addEndAccessData(event.getAccessorId(), fd, eventTime, size, 2, errNo);
                this.removeConcurrentAccess(filePath);
                break;
            }
            case 4: {
                FileAccess writeAccess = new FileAccess(event.getAccessorId(), fd, apiType, eventTime, FilePageLabels.FILE_CHART_TOOLTIP_WRITE);
                if (this.checkConcurrentAccess(filePath)) {
                    writeAccess.setWarning();
                    writeAccess.setTooltip(FilePageLabels.FILE_CHART_TOOLTIP_CONCURRENT_WRITE);
                    if (logData != null) {
                        SummaryDataManager.getInstance().getWarningDataMaker().add(logData, String.valueOf(FilePageLabels.FILE_CAHRT_PROCESS_ID) + pid + ", " + FilePageLabels.FILE_CAHRT_THREAD_ID + tid, WarningCase.CONCURRENT_ACCESS.getType());
                    }
                }
                this.addStartAccessData(writeAccess);
                break;
            }
            case 5: {
                this.addEndAccessData(event.getAccessorId(), fd, eventTime, size, 4, errNo);
                this.removeConcurrentAccess(filePath);
                break;
            }
            case 14: {
                this.addStartAccessData(new FileAccess(event.getAccessorId(), fd, apiType, eventTime, FilePageLabels.FILE_CHART_TOOLTIP_LOCK));
                break;
            }
            case 15: {
                this.addEndAccessData(event.getAccessorId(), fd, eventTime, size, 14, errNo);
                this.addFileLock(event.getFileId(), pid, event.getAccessorId());
                break;
            }
            case 16: {
                this.addAccessData(new FileAccess(event.getAccessorId(), apiType, eventTime, eventTime, FilePageLabels.FILE_CHART_TOOLTIP_UNLOCK));
                break;
            }
        }
        if (errNo != 0L) {
            String tooltip = String.valueOf(FilePageLabels.FILE_CHART_TOOLTIP_FAIL) + " " + Global.getFunctionName(event.getApiId());
            FileAccess accessFail = new FileAccess(event.getAccessorId(), 18, eventTime, eventTime, tooltip);
            this.addAccessData(accessFail);
        }
        if (event.isTarget()) {
            fileEventList.add(event);
        }
        Logger.debug((Object)("file:" + filePath + "pid:" + pid + " tid:" + tid + " apiType:" + apiType));
    }

    public void addStatusData(FileStatus data) {
        this.fileStatusList.add(data);
        ArrayList<List<Object>> insertDataList = new ArrayList<List<Object>>();
        insertDataList.add(data.getDBData());
        FileDataManager.getInstance().getSatatusDBInserter().pushData(insertDataList);
    }

    public void addStartAccessData(FileAccess data) {
        this.fileAccessList.add(data);
    }

    public void addAccessData(FileAccess data) {
        this.fileAccessList.add(data);
        ArrayList<List<Object>> insertDataList = new ArrayList<List<Object>>();
        insertDataList.add(data.getDBData());
        FileDataManager.getInstance().getAccessDBInserter().pushData(insertDataList);
    }

    public void addEndAccessData(int accessorId, long fd, long endTime, long ioSize, int apiType, long errNo) {
        int i = 0;
        while (i < this.fileAccessList.size()) {
            FileAccess data = this.fileAccessList.get(i);
            if (data.getAccessorId() == accessorId && data.getFd() == fd && data.getApiType() == apiType && data.getEndTime() <= 0L) {
                if (errNo != 0L) {
                    this.fileAccessList.remove(i);
                    break;
                }
                data.setEndTime(endTime);
                if (apiType == 4 || apiType == 2) {
                    String tooltip = String.valueOf(data.getTooltip()) + " , " + String.valueOf(ioSize);
                    data.setTooltip(tooltip);
                }
                ArrayList<List<Object>> insertDataList = new ArrayList<List<Object>>();
                insertDataList.add(data.getDBData());
                FileDataManager.getInstance().getAccessDBInserter().pushData(insertDataList);
                break;
            }
            ++i;
        }
    }

    private String createKey(int pid, int tid, long fd) {
        StringBuffer key = new StringBuffer();
        key.append(pid);
        key.append(":");
        key.append(tid);
        if (fd != -1L) {
            key.append(":");
            key.append(fd);
        }
        return key.toString();
    }

    private boolean checkConcurrentAccess(String concurrentKey) {
        int num = 0;
        if (this.concurrentAccessNumMap.containsKey(concurrentKey)) {
            num = this.concurrentAccessNumMap.get(concurrentKey);
        } else {
            this.concurrentAccessNumMap.put(concurrentKey, 1);
        }
        return num > 0;
    }

    private void removeConcurrentAccess(String concurrentKey) {
        if (this.concurrentAccessNumMap.containsKey(concurrentKey)) {
            int num = this.concurrentAccessNumMap.get(concurrentKey);
            if (num != 0) {
                this.concurrentAccessNumMap.put(concurrentKey, num - 1);
            }
        } else {
            Logger.debug((Object)("Couldn't get concurrent access!, key :" + concurrentKey));
        }
    }

    private int[] addFileAccessor(String filePath, int pid, int tid, boolean isTarget) {
        int fileId = -1;
        int accessorId = -1;
        if (this.fileAccessorMap.containsKey(filePath)) {
            List<Object> set = this.fileAccessorMap.get(filePath);
            Object[] list = set.toArray();
            fileId = (Integer)list[0];
            ArrayList accessorList = (ArrayList)list[1];
            boolean isExistAccessor = false;
            for (FileAccessor accessor : accessorList) {
                if (pid != accessor.getPid() || tid != accessor.getTid()) continue;
                accessorId = accessor.getAccessorId();
                isExistAccessor = true;
                break;
            }
            if (!isExistAccessor) {
                accessorId = this.idGenerator.incrementAndGet();
                FileAccessor newAccessor = new FileAccessor(accessorId, fileId, filePath, pid, tid, isTarget);
                accessorList.add(newAccessor);
                set.add(fileId);
                set.add(accessorList);
                this.fileAccessorMap.put(filePath, set);
                FileDataManager.getInstance().getAccessorDB().insert(newAccessor);
            }
        } else {
            fileId = this.fileAccessorMap.size() + 1;
            accessorId = this.idGenerator.incrementAndGet();
            ArrayList<FileAccessor> accessorList = new ArrayList<FileAccessor>();
            FileAccessor newAccessor = new FileAccessor(accessorId, fileId, filePath, pid, tid, isTarget);
            accessorList.add(newAccessor);
            ArrayList<Serializable> set = new ArrayList<Serializable>();
            set.add(Integer.valueOf(fileId));
            set.add(accessorList);
            this.fileAccessorMap.put(filePath, set);
            FileDataManager.getInstance().getAccessorDB().insert(newAccessor);
        }
        return new int[]{fileId, accessorId};
    }

    private Object[] getFilePathInfo(String key) {
        Object[] list = null;
        if (this.filePathMap.containsKey(key)) {
            List<Object> set = this.filePathMap.get(key);
            list = set.toArray();
        } else {
            Logger.debug((Object)("The key is not exist : " + key));
        }
        return list;
    }

    private void addFilePathInfo(String key, String filePath, int fileId, int accessorId) {
        if (!this.filePathMap.containsKey(key)) {
            ArrayList<Object> set = new ArrayList<Object>();
            set.add(filePath);
            set.add(fileId);
            set.add(accessorId);
            this.filePathMap.put(key, set);
        }
    }

    private void removeFilePathInfo(String key) {
        if (this.filePathMap.containsKey(key)) {
            this.filePathMap.remove(key);
        }
    }

    private void addFileLock(int fileId, int pid, int accessorId) {
        List<Integer> key = Arrays.asList(fileId, pid);
        List<Object> tids = new ArrayList<Integer>();
        if (this.accessorHasLockMap.containsKey(key)) {
            tids = this.accessorHasLockMap.get(key);
            if (!tids.contains(accessorId)) {
                tids.add(accessorId);
                this.accessorHasLockMap.put(key, tids);
            }
        } else {
            tids.add(accessorId);
            this.accessorHasLockMap.put(key, tids);
        }
    }

    private List<Integer> getTidsHasLock(int fileId, int pid) {
        List<Integer> tids = null;
        List<Integer> key = Arrays.asList(fileId, pid);
        if (this.accessorHasLockMap.containsKey(key)) {
            tids = this.accessorHasLockMap.get(key);
        }
        return tids;
    }

    private void removeTidsHasLock(int fileId, int pid) {
        List<Integer> key = Arrays.asList(fileId, pid);
        if (this.accessorHasLockMap.containsKey(key)) {
            this.accessorHasLockMap.remove(key);
        }
    }

    private void checkFileAnalysisLimit() {
        if (this.fileAccessList.size() > DALimit.MAX_FILE_ACCESS_COUNT || this.fileStatusList.size() > DALimit.MAX_FILE_STATUS_COUNT) {
            DALimit.stopTraceAndOpenWarningDialog();
        }
    }

    private boolean checkInvalidApiName(FileData input) {
        String apiName = input.getApiName();
        return apiName.contains("print") || apiName.contains("printf") || apiName.contains("fdopen") || apiName.contains("putchar") || apiName.contains("getchar") || apiName.contains("putchar") || apiName.contains("scanf") || apiName.contains("gets") || apiName.contains("puts");
    }

    private boolean isOpenMainLog(FileData input) {
        String filePath = input.getFilePath();
        if (filePath.contains("/")) {
            String[] splitApiFilePath = filePath.split("/");
            String strApiFilePath = new String(splitApiFilePath[splitApiFilePath.length - 1].trim());
            if (Global.getProject().getPackageID().equals(strApiFilePath)) {
                return true;
            }
        }
        return false;
    }

    public List<FileAccess> getFileAccessList() {
        return this.fileAccessList;
    }

    public List<FileStatus> getFileStatusList() {
        return this.fileStatusList;
    }

    public List<FileEvent> getFileApiList() {
        return this.fileApiList;
    }

    public List<FileAccessor> getFileAccessorList() {
        return this.fileAccessorList;
    }

    public void setFileAccessList(List<FileAccess> fileAccessList) {
        this.fileAccessList = fileAccessList;
    }

    public void setFileStatusList(List<FileStatus> fileStatusList) {
        this.fileStatusList = fileStatusList;
    }

    public void setFileApiList(List<FileEvent> fileApiList) {
        this.fileApiList = fileApiList;
    }

    public void setFileAccessorList(List<FileAccessor> fileAccessorList) {
        this.fileAccessorList = fileAccessorList;
    }
}

