/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.info.callstack;

import java.util.List;
import org.eclipse.nebula.widgets.grid.Grid;
import org.eclipse.nebula.widgets.grid.GridItem;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.tizen.dynamicanalyzer.common.AnalyzerManager;
import org.tizen.dynamicanalyzer.common.DASelectionData;
import org.tizen.dynamicanalyzer.nl.InformationViewLabels;
import org.tizen.dynamicanalyzer.resources.ColorResources;
import org.tizen.dynamicanalyzer.swap.model.data.LogData;
import org.tizen.dynamicanalyzer.ui.info.callstack.CallStackInserter;
import org.tizen.dynamicanalyzer.ui.info.callstack.CallstackTable;
import org.tizen.dynamicanalyzer.ui.timeline.calltrace.FunctionEntryDBTable;
import org.tizen.dynamicanalyzer.ui.widgets.table.DATableComposite;
import org.tizen.dynamicanalyzer.ui.widgets.table.DATableDataFormat;
import org.tizen.dynamicanalyzer.ui.widgets.table.DATreeComposite;
import org.tizen.dynamicanalyzer.ui.widgets.table.DAWindowingTableComposite;
import org.tizen.dynamicanalyzer.ui.widgets.table.TableColumnSizePackListener;
import org.tizen.dynamicanalyzer.widgets.da.view.DAViewComposite;
import org.tizen.dynamicanalyzer.widgets.da.view.DAViewData;

public class CallstackView
extends DAViewComposite {
    private DATableComposite callstackTableComp = null;
    private String[] columnNames = new String[]{InformationViewLabels.CALLSTACK_VIEW_FUNCTION, InformationViewLabels.CALLSTACK_VIEW_ADDRESS, InformationViewLabels.CALLSTACK_VIEW_BINARY_PATH};
    private int[] columnSizes = new int[]{120, 70, 400};
    private boolean[] columnVisibility = new boolean[]{true, true, true};
    private String[] observingViews = null;
    Composite contents = null;
    private static CallStackInserter inserter = CallStackInserter.getInstance();

    public CallstackView(Composite parent, int style) {
        super(parent, style, false);
        this.setLayout((Layout)new FillLayout());
        this.setTitle(InformationViewLabels.CALLSTACK_VIEW_TITLE);
        this.contents = this.getContentArea();
        this.contents.setBackground(ColorResources.WINDOW_BG_COLOR);
        this.contents.setLayout((Layout)new FillLayout());
        this.callstackTableComp = new CallstackTable(this.contents, 0, 2820);
        this.callstackTableComp.setTableName("Callstack");
        this.callstackTableComp.setColumns(this.columnNames);
        this.callstackTableComp.setColumnSize(this.columnSizes);
        this.callstackTableComp.setColumnVisibility(this.columnVisibility);
        this.contents.addControlListener((ControlListener)new TableColumnSizePackListener(this.callstackTableComp, this.columnSizes));
    }

    public void setObservingViews(String[] viewIds) {
        this.observingViews = viewIds;
    }

    public String[] getObservingViews() {
        return this.observingViews;
    }

    public void updateView() {
        if (this.observingViews == null) {
            return;
        }
        int size = this.observingViews.length;
        int i = 0;
        while (i < size) {
            block12: {
                block16: {
                    long startTime;
                    GridItem[] selection;
                    Grid table;
                    block18: {
                        DATableDataFormat tableData;
                        block20: {
                            block19: {
                                block17: {
                                    block14: {
                                        Control control;
                                        block15: {
                                            block13: {
                                                DAViewComposite view = (DAViewComposite)AnalyzerManager.getCurrentPage().getView(this.observingViews[i]);
                                                if (view == null) break block12;
                                                control = view.getControl();
                                                table = null;
                                                if (!(control instanceof DATableComposite)) break block13;
                                                table = ((DATableComposite)control).getTable();
                                                break block14;
                                            }
                                            if (!(control instanceof DAWindowingTableComposite)) break block15;
                                            table = ((DAWindowingTableComposite)control).getTable();
                                            break block14;
                                        }
                                        if (!(control instanceof DATreeComposite)) break block12;
                                        table = ((DATreeComposite)control).getTable();
                                    }
                                    if (table.getSelectionCount() <= 0) break block16;
                                    selection = table.getSelection();
                                    startTime = -1L;
                                    tableData = (DATableDataFormat)selection[0].getData();
                                    if (tableData.getType() != 2) break block17;
                                    List<Object> failedData = tableData.getData();
                                    startTime = (Long)failedData.get(1);
                                    break block18;
                                }
                                if (tableData.getType() != 4) break block19;
                                List<Object> leakData = tableData.getData();
                                startTime = (Long)leakData.get(4);
                                break block18;
                            }
                            if (tableData.getType() != 32) break block20;
                            List<Object> calltraceData = tableData.getData();
                            startTime = (Long)calltraceData.get(FunctionEntryDBTable.COLUMN.START_TIME.index);
                            break block18;
                        }
                        if (tableData.getType() == 1024) break block12;
                        LogData startData = ((DATableDataFormat)selection[0].getData()).getLogData();
                        startTime = startData.getTime();
                    }
                    long endTime = startTime;
                    if (selection[selection.length - 1].getData() != null) {
                        DATableDataFormat lastTableData = (DATableDataFormat)selection[selection.length - 1].getData();
                        if (lastTableData.getType() == 2) {
                            List<Object> failedData = lastTableData.getData();
                            endTime = (Long)failedData.get(1);
                        } else if (lastTableData.getType() == 4) {
                            List<Object> leakData = lastTableData.getData();
                            endTime = (Long)leakData.get(4);
                        } else if (lastTableData.getType() == 32) {
                            List<Object> calltraceData = lastTableData.getData();
                            endTime = (Long)calltraceData.get(FunctionEntryDBTable.COLUMN.START_TIME.index);
                        } else {
                            LogData endData = lastTableData.getLogData();
                            endTime = endData.getTime();
                        }
                    }
                    DASelectionData data = new DASelectionData(this.observingViews[i], startTime, endTime, selection, (Control)table);
                    this.updateView(data);
                }
                return;
            }
            ++i;
        }
        this.clear();
    }

    public void updateView(DAViewData data) {
        if (!(data instanceof DASelectionData)) {
            return;
        }
        DASelectionData seldata = (DASelectionData)data;
        if (seldata.isLogData()) {
            this.updateView();
        } else {
            ((CallstackTable)this.callstackTableComp).updateCallstackTable(seldata);
        }
    }

    public void clear() {
        this.callstackTableComp.clear();
    }

    public Control getControl() {
        return this.callstackTableComp;
    }
}

