/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.opengl.data.DB;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.tizen.dynamicanalyzer.database.DBColumn;
import org.tizen.dynamicanalyzer.database.DBTable;
import org.tizen.dynamicanalyzer.database.SqlConnectionManager;
import org.tizen.dynamicanalyzer.ui.opengl.data.type.GLContextNameEnum;
import org.tizen.dynamicanalyzer.util.Logger;

public class GLCommonStateDBTableManager
extends DBTable {
    private static final String TABLENAME = "GL_CONTEXT";
    private final String[] columnName;
    private int rid = 0;
    public static final int TABLE_CONTEXT_ID_INDEX = 1;
    private static final String SELECT_CONTEXT_TABLE__QUERY = "select RID, SEQUENCE_NUMBER, CONTEXT_ID, VIEWPORT, BLEND_ENABLED, BLEND_COLOR, BLEND_DEST_RGB, BLEND_DEST_ALPHA, BLEND_EQUATION_RGB, BLEND_EQUATION_ALPHA, BLEND_SRC_RGB, BLEND_SRC_ALPHA, CULLING_ENABLED, CULLING_ORIENTATION, CULLING_MODE, DEPTH_ENABLED, DEPTH_FUNC, DEPTH_RANGE_N, DEPTH_RANGE_F, DITHER_ENABLED, FRAME_BUFFER_BINDING, LINE_WIDTH, POLY_ENABLED, POLY_FACTOR, POLY_UNITS, SCISSOR_ENABLED, SCISSOR, STENCIL_ENABLED, STENCIL_FRONT_FUNC, STENCIL_FRONT_REF, STENCIL_FRONT_MASK, STENCIL_FRONT_S_FAIL, STENCIL_FRONT_D_FAIL, STENCIL_FRONT_D_PASS, STENCIL_BACK_FUNC, STENCIL_BACK_REF, STENCIL_BACK_MASK, STENCIL_BACK_S_FAIL, STENCIL_BACK_D_FAIL, STENCIL_BACK_D_PASS, PACK_ALIGN, UNPACK_ALIGN, GVA_ENABLED, GVA_SIZE, GVA_TYPE, GVA_NORMAL, GVA_STRIDE, GVA_POINTER, GVA_V0, GVA_V1, GVA_V2, GVA_V3, VBO_ARRAY_BINDING, VBO_ARRAY_ID, VBO_ARRAY_SIZE, VBO_ARRAY_DATA, VBO_ARRAY_USAGE, VBO_ELEMENT_BINDING, VBO_ELEMENT_ID, VBO_ELEMENT_SIZE, VBO_ELEMENT_DATA, VBO_ELEMENT_USAGE, TEXTURE_ACTIVE from GL_CONTEXT where SEQUENCE_NUMBER <= '%s' and CONTEXT_ID = '%S' order by rid desc";

    @Override
    public String getTableName() {
        return TABLENAME;
    }

    public GLCommonStateDBTableManager() {
        GLContextNameEnum[] glContextDBEnum = GLContextNameEnum.values();
        int length = glContextDBEnum.length;
        this.columnName = new String[length + 1];
        String[] options = new String[length + 1];
        String[] types = new String[length + 1];
        int i = 0;
        while (i < length) {
            this.columnName[i] = glContextDBEnum[i].getcolumnName();
            options[i] = "";
            if (this.isIntegerType(i)) {
                types[i] = "INTEGER";
            } else if (this.isLongType(i)) {
                types[i] = "BIGINT";
            } else if (this.isBooleans(i)) {
                types[i] = "BOOLEAN";
            } else if (this.isStringType(i)) {
                types[i] = "VARCHAR(24)";
            } else if (i == GLContextNameEnum.GVA_ENABLED.ordinal()) {
                types[i] = "BOOLEAN ARRAY";
            } else if (this.isIntegerArray(i)) {
                types[i] = "INTEGER ARRAY";
            } else if (this.isLongArray(i)) {
                types[i] = "BIGINT ARRAY";
            } else {
                Logger.error((Object)("undefine column : " + i));
            }
            ++i;
        }
        i = 0;
        while (i < length) {
            this.addColumn(new DBColumn(this.columnName[i], options[i], types[i]));
            ++i;
        }
        this.setIndexColumn(1);
    }

    public String[] getColumnName() {
        return this.columnName;
    }

    public void insertContextData(List<Object> insertData) {
        ArrayList<List<Object>> insertList = new ArrayList<List<Object>>();
        ArrayList<Object> objextList = new ArrayList<Object>();
        int i = 0;
        while (i < insertData.size()) {
            if (i == GLContextNameEnum.RID.ordinal()) {
                objextList.add(this.rid++);
            } else if (this.isBooleanArray(i)) {
                objextList.addAll(this.makeArray(i, insertData, new Boolean(true)));
            } else if (this.isIntegerArray(i)) {
                objextList.addAll(this.makeArray(i, insertData, new Integer(0)));
            } else if (this.isLongArray(i)) {
                objextList.addAll(this.makeArray(i, insertData, new Long(0L)));
            } else {
                objextList.add(insertData.get(i));
            }
            ++i;
        }
        insertList.add(objextList);
        this.insertData(insertList);
    }

    private <T> List<Object> makeArray(int index, List<Object> insertData, T type) {
        ArrayList<Object> returnObjectList = new ArrayList<Object>();
        if (insertData.get(index) == null) {
            returnObjectList.add(null);
            return returnObjectList;
        }
        List objectArray = (List)insertData.get(index);
        ArrayList insertArray = new ArrayList();
        int j = 0;
        while (j < objectArray.size()) {
            if (objectArray.get(j) != null) {
                insertArray.add(objectArray.get(j));
            }
            ++j;
        }
        returnObjectList.add(insertArray);
        return returnObjectList;
    }

    public List<Object> getContextData(String seq, long contextID) {
        String query = String.format(SELECT_CONTEXT_TABLE__QUERY, seq, contextID);
        List<List<Object>> result = SqlConnectionManager.executeQuery(query);
        if (result == null || result.size() == 0 || result.get(0).size() == 0) {
            return null;
        }
        return result.get(0);
    }

    public boolean isStringType(int index) {
        return index == GLContextNameEnum.VIEWPORT.ordinal() || index == GLContextNameEnum.BLEND_COLOR.ordinal() || index == GLContextNameEnum.SCISSOR.ordinal();
    }

    public boolean isIntegerType(int index) {
        return index == GLContextNameEnum.RID.ordinal() || index == GLContextNameEnum.BLEND_EQUATION_RGB.ordinal() || index == GLContextNameEnum.BLEND_EQUATION_ALPHA.ordinal() || index == GLContextNameEnum.BLEND_SRC_RGB.ordinal() || index == GLContextNameEnum.BLEND_SRC_ALPHA.ordinal() || index == GLContextNameEnum.BLEND_DEST_RGB.ordinal() || index == GLContextNameEnum.BLEND_DEST_ALPHA.ordinal() || index == GLContextNameEnum.CULLING_ORIENTATION.ordinal() || index == GLContextNameEnum.CULLING_MODE.ordinal() || index == GLContextNameEnum.DEPTH_RANGE_N.ordinal() || index == GLContextNameEnum.DEPTH_RANGE_F.ordinal() || index == GLContextNameEnum.DEPTH_FUNC.ordinal() || index == GLContextNameEnum.LINE_WIDTH.ordinal() || index == GLContextNameEnum.POLY_FACTOR.ordinal() || index == GLContextNameEnum.POLY_UNITS.ordinal() || index == GLContextNameEnum.STENCIL_FRONT_FUNC.ordinal() || index == GLContextNameEnum.STENCIL_FRONT_REF.ordinal() || index == GLContextNameEnum.STENCIL_FRONT_MASK.ordinal() || index == GLContextNameEnum.STENCIL_FRONT_S_FAIL.ordinal() || index == GLContextNameEnum.STENCIL_FRONT_D_FAIL.ordinal() || index == GLContextNameEnum.STENCIL_FRONT_D_PASS.ordinal() || index == GLContextNameEnum.STENCIL_BACK_FUNC.ordinal() || index == GLContextNameEnum.STENCIL_BACK_REF.ordinal() || index == GLContextNameEnum.STENCIL_BACK_MASK.ordinal() || index == GLContextNameEnum.STENCIL_BACK_S_FAIL.ordinal() || index == GLContextNameEnum.STENCIL_BACK_D_FAIL.ordinal() || index == GLContextNameEnum.STENCIL_BACK_D_PASS.ordinal() || index == GLContextNameEnum.PACK_ALIGN.ordinal() || index == GLContextNameEnum.UNPACK_ALIGN.ordinal() || index == GLContextNameEnum.TEXTURE_ACTIVE.ordinal() || index == GLContextNameEnum.FRAME_BUFFER_BINDING.ordinal() || index == GLContextNameEnum.VBO_ARRAY_BINDING.ordinal() || index == GLContextNameEnum.VBO_ARRAY_SIZE.ordinal() || index == GLContextNameEnum.VBO_ARRAY_ID.ordinal() || index == GLContextNameEnum.VBO_ARRAY_USAGE.ordinal() || index == GLContextNameEnum.VBO_ELEMENT_BINDING.ordinal() || index == GLContextNameEnum.VBO_ELEMENT_SIZE.ordinal() || index == GLContextNameEnum.VBO_ELEMENT_ID.ordinal() || index == GLContextNameEnum.VBO_ELEMENT_USAGE.ordinal();
    }

    public boolean isLongType(int index) {
        return index == GLContextNameEnum.SEQ.ordinal() || index == GLContextNameEnum.CONTEXT_ID.ordinal() || index == GLContextNameEnum.VBO_ARRAY_DATA.ordinal() || index == GLContextNameEnum.VBO_ELEMENT_DATA.ordinal();
    }

    public boolean isBooleans(int index) {
        return index == GLContextNameEnum.BLEND_ENABLED.ordinal() || index == GLContextNameEnum.CULLING_ENABLED.ordinal() || index == GLContextNameEnum.DEPTH_ENABLED.ordinal() || index == GLContextNameEnum.DITHER_ENABLED.ordinal() || index == GLContextNameEnum.SCISSOR_ENABLED.ordinal() || index == GLContextNameEnum.STENCIL_ENABLED.ordinal() || index == GLContextNameEnum.POLY_ENABLED.ordinal();
    }

    public boolean isBooleanArray(int index) {
        return index == GLContextNameEnum.GVA_ENABLED.ordinal();
    }

    public boolean isIntegerArray(int index) {
        return index == GLContextNameEnum.GVA_SIZE.ordinal() || index == GLContextNameEnum.GVA_NORMAL.ordinal() || index == GLContextNameEnum.GVA_STRIDE.ordinal() || index == GLContextNameEnum.GVA_TYPE.ordinal() || index == GLContextNameEnum.GVA_V0.ordinal() || index == GLContextNameEnum.GVA_V1.ordinal() || index == GLContextNameEnum.GVA_V2.ordinal() || index == GLContextNameEnum.GVA_V3.ordinal();
    }

    public boolean isLongArray(int index) {
        return index == GLContextNameEnum.GVA_POINTER.ordinal();
    }

    @Override
    public boolean prepare(PreparedStatement prep, List<Object> rowData) {
        boolean isPrepared = true;
        int columnsize = this.getColumnSize();
        if (columnsize != rowData.size()) {
            isPrepared = false;
        } else {
            int index = 0;
            while (index < columnsize) {
                try {
                    if (this.isBooleanArray(index)) {
                        this.setArrayToPreparedStatement(index, "BOOLEAN", prep, rowData);
                    } else if (this.isIntegerArray(index)) {
                        this.setArrayToPreparedStatement(index, "INTEGER", prep, rowData);
                    } else if (this.isLongArray(index)) {
                        this.setArrayToPreparedStatement(index, "BIGINT", prep, rowData);
                    } else if (this.isIntegerType(index)) {
                        prep.setInt(index + 1, (Integer)rowData.get(index));
                    } else if (this.isLongType(index)) {
                        prep.setLong(index + 1, (Long)rowData.get(index));
                    } else if (this.isBooleans(index)) {
                        prep.setBoolean(index + 1, (Boolean)rowData.get(index));
                    } else if (this.isStringType(index)) {
                        prep.setString(index + 1, (String)rowData.get(index));
                    } else {
                        Logger.error((Object)("undefine column : " + index));
                    }
                }
                catch (SQLException e) {
                    Logger.exception((Throwable)e);
                    isPrepared = false;
                }
                ++index;
            }
        }
        return isPrepared;
    }
}

