/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.range;

import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.tizen.dynamicanalyzer.nl.AnalyzerLabels;
import org.tizen.dynamicanalyzer.resources.ColorResources;
import org.tizen.dynamicanalyzer.shortcut.ShortCutManager;
import org.tizen.dynamicanalyzer.ui.range.RangeFailedApiListView;
import org.tizen.dynamicanalyzer.ui.range.RangeLeakView;
import org.tizen.dynamicanalyzer.ui.range.RangeProfilingView;
import org.tizen.dynamicanalyzer.ui.range.RangeWarningDetailView;
import org.tizen.dynamicanalyzer.ui.range.RangeWarningListView;
import org.tizen.dynamicanalyzer.ui.timeline.common.TimelineTableView;
import org.tizen.dynamicanalyzer.ui.widgets.table.DATableComposite;
import org.tizen.dynamicanalyzer.widgets.da.view.DABaseComposite;
import org.tizen.dynamicanalyzer.widgets.da.view.DAPageComposite;

public class RangePage
extends DAPageComposite {
    public static final String pageID = RangePage.class.getName();
    public static final String failedListViewID = RangeFailedApiListView.class.getName();
    public static final String leakViewID = RangeLeakView.class.getName();
    public static final String profilingViewID = RangeProfilingView.class.getName();
    public static final String warningListViewID = RangeWarningListView.class.getName();
    public static final String warningDerailViewID = RangeWarningDetailView.class.getName();
    SashForm upperForm;
    SashForm bottomForm;
    SashForm baseForm;
    SashForm warningForm;

    public RangePage(Composite parent, int style) {
        super(parent, style);
        this.setTitle(AnalyzerLabels.COOLBAR_AREA_RANGE);
        this.setData("tooltip", ShortCutManager.COOLBAR_AREA_RANGE_TOOLTIP);
        this.setBackground(ColorResources.CONFIGURATION_TABLE_COVER_BACKGROUND_COLOR);
        this.setLayout((Layout)new FillLayout());
        this.baseForm = new SashForm((Composite)this, 512);
        this.baseForm.setLayout((Layout)new FillLayout());
        this.baseForm.setForeground(ColorResources.TAB_SELECTED_COLOR_START);
        ((FillLayout)this.getLayout()).marginHeight = 15;
        ((FillLayout)this.getLayout()).marginWidth = 5;
        this.upperForm = new SashForm((Composite)this.baseForm, 256);
        RangeFailedApiListView failedApiListView = new RangeFailedApiListView((Composite)this.upperForm, 0);
        ((DATableComposite)failedApiListView.getControl()).getTable().setSelectionEnabled(true);
        this.addView((DABaseComposite)failedApiListView);
        RangeLeakView leakView = new RangeLeakView((Composite)this.upperForm, 0);
        this.addView((DABaseComposite)leakView);
        TimelineTableView tabView = new TimelineTableView((Composite)this.upperForm, 0);
        this.addView((DABaseComposite)tabView);
        this.upperForm.setWeights(new int[]{37, 40, 23});
        this.bottomForm = new SashForm((Composite)this.baseForm, 256);
        RangeProfilingView userFunctionProfilingView = new RangeProfilingView((Composite)this.bottomForm, 0);
        this.addView((DABaseComposite)userFunctionProfilingView);
        this.warningForm = new SashForm((Composite)this.bottomForm, 512);
        this.bottomForm.setWeights(new int[]{70, 30});
        RangeWarningListView warningListView = new RangeWarningListView((Composite)this.warningForm, 0);
        this.addView((DABaseComposite)warningListView);
        RangeWarningDetailView warningDetailView = new RangeWarningDetailView((Composite)this.warningForm, 0);
        this.addView((DABaseComposite)warningDetailView);
        this.warningForm.setWeights(new int[]{70, 30});
    }

    protected void onResized(int width, int height) {
        int wrate = (int)(25000.0 / (double)width);
        int hrate = (int)(23500.0 / (double)height);
        wrate = wrate > 100 ? 100 : wrate;
        int n = hrate = hrate > 100 ? 100 : hrate;
        if (wrate > 63 || hrate > 100) {
            return;
        }
        this.upperForm.setWeights(new int[]{37, 63 - wrate, wrate});
        this.baseForm.setWeights(new int[]{hrate, 100 - hrate});
    }
}

