/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.timeline;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.tizen.dynamicanalyzer.database.DBColumn;
import org.tizen.dynamicanalyzer.database.DBTable;
import org.tizen.dynamicanalyzer.util.Logger;

public class UIEventDBTable
extends DBTable {
    public static final String TABLENAME = "TIMELINE_UIEVENT";
    private static final int MAX_INFO_LEN = 64;
    public static final String EVENT_TIME = "EVENT_TIME";
    public static final String EVENT_TYPE = "EVENT_TYPE";
    public static final String DETAIL_TYPE = "DETAIL_TYPE";
    public static final String POINT_X = "POINT_X";
    public static final String POINT_Y = "POINT_Y";
    public static final String INFO_STRING = "INFO_STRING";
    public static final String INFO_INTEGER = "INFO_INTEGER";

    @Override
    public String getTableName() {
        return TABLENAME;
    }

    public UIEventDBTable() {
        this.addColumn(new DBColumn(EVENT_TIME, "NOT NULL", "BIGINT"));
        this.addColumn(new DBColumn(EVENT_TYPE, "NOT NULL", "INTEGER"));
        this.addColumn(new DBColumn(DETAIL_TYPE, "NOT NULL", "INTEGER"));
        this.addColumn(new DBColumn(POINT_X, "NOT NULL", "INTEGER"));
        this.addColumn(new DBColumn(POINT_Y, "NOT NULL", "INTEGER"));
        this.addColumn(new DBColumn(INFO_STRING, "NOT NULL", "VARCHAR", 64));
        this.addColumn(new DBColumn(INFO_INTEGER, "NOT NULL", "INTEGER"));
        this.setIndexColumn(COLUMN.EVENT_TIME.ordinal());
    }

    @Override
    public boolean prepare(PreparedStatement prep, List<Object> rowData) {
        boolean isPrepared = true;
        int columnsize = this.getColumnSize();
        if (columnsize != rowData.size()) {
            isPrepared = false;
        } else {
            try {
                prep.setLong(1, (Long)rowData.get(COLUMN.EVENT_TIME.ordinal()));
                prep.setInt(2, (Integer)rowData.get(COLUMN.EVENT_TYPE.ordinal()));
                prep.setInt(3, (Integer)rowData.get(COLUMN.DETAIL_TYPE.ordinal()));
                prep.setInt(4, (Integer)rowData.get(COLUMN.POINT_X.ordinal()));
                prep.setInt(5, (Integer)rowData.get(COLUMN.POINT_Y.ordinal()));
                String info = (String)rowData.get(COLUMN.INFO_STRING.ordinal());
                if (info != null && info.length() > 64) {
                    Logger.error((Object)("Overflow occurs INFO_STRING in UIEventDBTable : " + info));
                    info = info.substring(0, 64);
                }
                prep.setString(6, info);
                prep.setInt(7, (Integer)rowData.get(COLUMN.INFO_INTEGER.ordinal()));
            }
            catch (SQLException e) {
                Logger.exception((Throwable)e);
                isPrepared = false;
            }
        }
        return isPrepared;
    }

    @Override
    public List<Object> extractDataFromResultSet(ResultSet rs) {
        ArrayList<Object> row = new ArrayList<Object>();
        try {
            row.add(rs.getLong(1));
            row.add(rs.getInt(2));
            row.add(rs.getInt(3));
            row.add(rs.getInt(4));
            row.add(rs.getInt(5));
            row.add(rs.getString(6));
            row.add(rs.getInt(7));
        }
        catch (SQLException e) {
            Logger.exception((Throwable)e);
            return null;
        }
        return row;
    }

    public static enum COLUMN {
        EVENT_TIME,
        EVENT_TYPE,
        DETAIL_TYPE,
        POINT_X,
        POINT_Y,
        INFO_STRING,
        INFO_INTEGER;

    }
}

