/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.toolbar.replayEditor;

import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.tizen.dynamicanalyzer.nl.AnalyzerLabels;
import org.tizen.dynamicanalyzer.nl.ReplayEditLabels;
import org.tizen.dynamicanalyzer.resources.ColorResources;
import org.tizen.dynamicanalyzer.resources.FontResources;
import org.tizen.dynamicanalyzer.resources.ImageResources;
import org.tizen.dynamicanalyzer.shortcut.ShortCutManager;
import org.tizen.dynamicanalyzer.ui.toolbar.replayEditor.ReplayEditTableView;
import org.tizen.dynamicanalyzer.ui.toolbar.replayEditor.data.ReplayEditSaveDataMaker;
import org.tizen.dynamicanalyzer.ui.toolbar.replayEditor.data.ReplayEditTableDataMaker;
import org.tizen.dynamicanalyzer.ui.widgets.table.DATableComposite;
import org.tizen.dynamicanalyzer.util.Logger;
import org.tizen.dynamicanalyzer.widgets.button.DACustomButton;
import org.tizen.dynamicanalyzer.widgets.button.DACustomButtonClickEventListener;
import org.tizen.dynamicanalyzer.widgets.da.base.DAButton;
import org.tizen.dynamicanalyzer.widgets.da.base.DAMessageBox;

public class ReplayEditDialog
extends DAMessageBox {
    private static boolean opened = false;
    private DACustomButton cancelButton = null;
    private DATableComposite replayTable;
    private DACustomButtonClickEventListener okButtonListener = new DACustomButtonClickEventListener(){

        public void handleClickEvent(DACustomButton button) {
            ReplayEditSaveDataMaker.getInstance().setTableItemsList(ReplayEditDialog.this.replayTable);
            ReplayEditSaveDataMaker.getInstance().insertDB();
            ReplayEditDialog.this.shell.dispose();
        }
    };
    private DACustomButtonClickEventListener cancelButtonListener = new DACustomButtonClickEventListener(){

        public void handleClickEvent(DACustomButton button) {
            ReplayEditDialog.this.shell.dispose();
        }
    };

    public ReplayEditDialog(Shell parent) {
        super(parent);
    }

    protected boolean run() {
        if (opened) {
            return false;
        }
        ReplayEditTableDataMaker.getInstance().clean();
        this.shell.setSize(608, 480);
        this.shell.setLayout((Layout)new FormLayout());
        this.shell.setText(AnalyzerLabels.REPLAYEDIT);
        this.shell.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                Logger.debug((Object)"shell disposed!");
                opened = false;
                ShortCutManager.getInstance().setEnabled(!opened);
            }
        });
        Label banner = new Label((Composite)this.shell, 0x40000000);
        banner.setBackground(ColorResources.WINDOW_BG_COLOR);
        banner.setImage(ImageResources.REPLAY_EDIT_BANNER_IMAGE);
        FormData labelData = new FormData();
        labelData.top = new FormAttachment(0, 0);
        labelData.left = new FormAttachment(0, 0);
        labelData.right = new FormAttachment(100, 0);
        labelData.height = 80;
        banner.setLayoutData((Object)labelData);
        Composite tabContentsComp = new Composite((Composite)this.shell, 0);
        FormLayout compLayout = new FormLayout();
        tabContentsComp.setLayout((Layout)compLayout);
        tabContentsComp.setBackground(ColorResources.CONFIGURATION_TABLE_COVER_BACKGROUND_COLOR);
        FormData compData = new FormData();
        compData = new FormData();
        compData.top = new FormAttachment((Control)banner, 0);
        compData.left = new FormAttachment(0, 0);
        compData.right = new FormAttachment(100, 0);
        compData.bottom = new FormAttachment(100, -50);
        tabContentsComp.setLayoutData((Object)compData);
        ReplayEditTableView featuresPage = new ReplayEditTableView(tabContentsComp, 0);
        compData = new FormData();
        compData = new FormData();
        compData.top = new FormAttachment(0, 0);
        compData.left = new FormAttachment(0, 0);
        compData.right = new FormAttachment(100, 0);
        compData.bottom = new FormAttachment(100, 0);
        featuresPage.setLayoutData(compData);
        this.replayTable = featuresPage.getReplayTable();
        Composite buttonContentsComp = new Composite((Composite)this.shell, 0);
        buttonContentsComp.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                Composite composite = (Composite)e.widget;
                Rectangle rect = composite.getClientArea();
                e.gc.setForeground(ColorResources.CONFIGURATION_SUNKEN_LINE_UP_COLOR);
                e.gc.drawLine(0, 0, rect.x + rect.width, 0);
            }
        });
        compLayout = new FormLayout();
        buttonContentsComp.setLayout((Layout)compLayout);
        buttonContentsComp.setBackground(ColorResources.CONFIGURATION_BUTTON_COVER_BACKGROUND_COLOR);
        compData = new FormData();
        compData.top = new FormAttachment((Control)tabContentsComp, 0);
        compData.left = new FormAttachment(0, 0);
        compData.right = new FormAttachment(100, 0);
        compData.bottom = new FormAttachment(100, 0);
        buttonContentsComp.setLayoutData((Object)compData);
        this.cancelButton = new DAButton(buttonContentsComp, 0);
        this.cancelButton.addClickListener(this.cancelButtonListener);
        this.cancelButton.setText(ReplayEditLabels.CANCEL);
        this.cancelButton.setFont(FontResources.DIALOG_BUTTON_FONT);
        FormData buttonData = new FormData();
        buttonData.right = new FormAttachment(100, -9);
        buttonData.top = new FormAttachment(0, 11);
        buttonData.width = 100;
        buttonData.height = 28;
        this.cancelButton.setLayoutData((Object)buttonData);
        ReplayEditTableDataMaker.getInstance().setOkButton((DACustomButton)new DAButton(buttonContentsComp, 0));
        ReplayEditTableDataMaker.getInstance().getOkButton().addClickListener(this.okButtonListener);
        ReplayEditTableDataMaker.getInstance().getOkButton().setText(ReplayEditLabels.OK);
        ReplayEditTableDataMaker.getInstance().getOkButton().setFont(FontResources.DIALOG_BUTTON_FONT);
        buttonData = new FormData();
        buttonData.right = new FormAttachment((Control)this.cancelButton, -8);
        buttonData.top = new FormAttachment(0, 11);
        buttonData.width = 100;
        buttonData.height = 28;
        ReplayEditTableDataMaker.getInstance().getOkButton().setLayoutData((Object)buttonData);
        opened = true;
        ShortCutManager.getInstance().setEnabled(!opened);
        return true;
    }
}

