/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.toolbar.setting;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.nebula.widgets.grid.GridCellRenderer;
import org.eclipse.nebula.widgets.grid.GridColumn;
import org.eclipse.nebula.widgets.grid.GridHeaderRenderer;
import org.eclipse.nebula.widgets.grid.GridItem;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.tizen.dynamicanalyzer.common.DAState;
import org.tizen.dynamicanalyzer.model.TreeInput;
import org.tizen.dynamicanalyzer.nl.ConfigureLabels;
import org.tizen.dynamicanalyzer.resources.ColorResources;
import org.tizen.dynamicanalyzer.resources.ImageResources;
import org.tizen.dynamicanalyzer.setting.Feature;
import org.tizen.dynamicanalyzer.setting.FeatureData;
import org.tizen.dynamicanalyzer.setting.SettingDataManager;
import org.tizen.dynamicanalyzer.setting.TargetData;
import org.tizen.dynamicanalyzer.ui.toolbar.setting.FeatureDialogFeaturesTreeTableCellRenderer;
import org.tizen.dynamicanalyzer.ui.widgets.table.DATableDataFormat;
import org.tizen.dynamicanalyzer.ui.widgets.table.DATableHeaderRenderer;
import org.tizen.dynamicanalyzer.ui.widgets.table.DATreeComposite;
import org.tizen.dynamicanalyzer.util.Logger;
import org.tizen.dynamicanalyzer.widgets.tooltip.DACustomTooltip;

public class FeatureDialogFeaturesTable
extends DATreeComposite {
    private static final int tableTextOptionColumnIndex = 1;
    public static final String ITEM_PARENT_FEATURE_NAME_ITEM = ", parent_feature_name_";
    public static final String ITEM_ALL_CHECKED = ", item_all_checked ";
    public static final String ITEM_PART_CHECKED = ", item_part_checked ";
    public static final String FEATURE_OPTION_VALUE = ", feature_option_value ";
    public static final String FEATURE_INVALID_VALUE = ", feature_invalid_value ";
    private DACustomTooltip tooltip = new DACustomTooltip(){

        public void setTooltipMessage() {
            this.tooltipMessage.clear();
            FeatureData feature = Feature.getFeature(this.getSelectedItem()).getData();
            String message = feature.getOverheadRankingMessage();
            if (message != null && !message.isEmpty()) {
                this.tooltipMessage.add(message);
                this.setFontColor(feature.getOverheadRankingFontColor());
            }
        }

        public void setTooltipMessage(String name) {
        }
    };
    private Listener tableTooltipListener = new Listener(){

        public void handleEvent(Event event) {
            if (event.type == 6 || event.type == 5) {
                GridItem item = FeatureDialogFeaturesTable.this.table.getItem(new Point(event.x, event.y));
                if (item == null) {
                    return;
                }
                if (DAState.isStartable()) {
                    if (FeatureDialogFeaturesTable.this.isClickCheckBox(item, event)) {
                        FeatureDialogFeaturesTable.this.tooltip.setSeletedItem(item.getText());
                        FeatureDialogFeaturesTable.this.tooltip.openAndMove(FeatureDialogFeaturesTable.this.table.getShell());
                    } else {
                        FeatureDialogFeaturesTable.this.tooltip.setSeletedItem(null);
                        FeatureDialogFeaturesTable.this.tooltip.close();
                    }
                }
            }
            if (event.type == 7) {
                FeatureDialogFeaturesTable.this.tooltip.close();
            }
        }
    };
    private Listener tableMouseListener = new Listener(){

        public void handleEvent(Event event) {
            GridItem item = FeatureDialogFeaturesTable.this.table.getItem(new Point(event.x, event.y));
            if (item == null) {
                return;
            }
            block0 : switch (event.type) {
                case 12: {
                    break;
                }
                case 6: {
                    break;
                }
                case 7: {
                    break;
                }
                case 5: {
                    break;
                }
                case 8: {
                    break;
                }
                case 32: {
                    break;
                }
                case 4: {
                    break;
                }
                case 3: {
                    switch (event.button) {
                        case 1: {
                            if (!DAState.isStartable() || !FeatureDialogFeaturesTable.this.isClickCheckBox(item, event)) break block0;
                            FeatureDialogFeaturesTable.this.updateCheckBox(item, event);
                            FeatureDialogFeaturesTable.this.updateChildCheckBoxByParent(item, event);
                            FeatureDialogFeaturesTable.this.updateParentCheckBoxByChild(item, event);
                            if (!item.hasChildren() || !FeatureDialogFeaturesTable.this.isCheckStatus(item)) break block0;
                            item.setExpanded(true);
                            break block0;
                        }
                        case 3: {
                            break block0;
                        }
                    }
                    break;
                }
            }
        }
    };

    public FeatureDialogFeaturesTable(Composite parent, int style) {
        super(parent, style);
        this.table.setLinesVisible(false);
        this.table.addListener(12, this.tableMouseListener);
        this.table.addListener(6, this.tableMouseListener);
        this.table.addListener(7, this.tableMouseListener);
        this.table.addListener(5, this.tableMouseListener);
        this.table.addListener(32, this.tableMouseListener);
        this.table.addListener(4, this.tableMouseListener);
        this.table.addListener(3, this.tableMouseListener);
        this.table.addListener(8, this.tableMouseListener);
        this.setTableToolTipListener();
    }

    private void setTableToolTipListener() {
        this.table.addListener(6, this.tableTooltipListener);
        this.table.addListener(7, this.tableTooltipListener);
        this.table.addListener(5, this.tableTooltipListener);
    }

    @Override
    public void setColumns(String[] columnNames) {
        int size = columnNames.length;
        int i = 0;
        while (i < size) {
            GridColumn column = new GridColumn(this.table, 0);
            column.setText(columnNames[i]);
            column.setCellRenderer((GridCellRenderer)new FeatureDialogFeaturesTreeTableCellRenderer(this.table));
            DATableHeaderRenderer header = new DATableHeaderRenderer(16384);
            header.setBgColor(ColorResources.SETTING_TABLE_HEADER_BG);
            header.setFontColor(ColorResources.SETTING_TABLE_HEADER_FONT_COLOR);
            column.setHeaderRenderer((GridHeaderRenderer)header);
            if (i == 0) {
                column.setTree(true);
            }
            column.pack();
            ++i;
        }
    }

    private TreeInput makeInput(FeatureData feature) {
        String optionText;
        DATableDataFormat tableData = new DATableDataFormat(0L);
        ArrayList<String> text = new ArrayList<String>();
        String featureName = feature.getFeatureName();
        text.add(featureName);
        TargetData target = SettingDataManager.INSTANCE.getTarget(null);
        StringBuffer optionColumn = new StringBuffer();
        if (target.isSelectedFeature(feature.getKey())) {
            optionColumn.append(ITEM_ALL_CHECKED);
        } else {
            optionColumn.append("");
        }
        if (feature.getParentIndex() > 0) {
            String parentFeatureName = Feature.getFeature(feature.getParentIndex()).getName();
            optionColumn.append(ITEM_PARENT_FEATURE_NAME_ITEM + parentFeatureName);
        }
        if (feature.getFeatureType() == 2 && (optionText = this.getDetailFeatureOptionText(featureName)) != null) {
            optionColumn.append(FEATURE_OPTION_VALUE + optionText);
        }
        text.add(optionColumn.toString());
        TreeInput outPut = new TreeInput();
        outPut.setText(text);
        outPut.setData(tableData);
        return outPut;
    }

    @Override
    public List<TreeInput> makeTreeInput() {
        ArrayList<TreeInput> output = new ArrayList<TreeInput>();
        TargetData target = SettingDataManager.INSTANCE.getTarget(null);
        List<Feature> featureList = target.getAvailableFeatureList();
        int i = 0;
        while (i < featureList.size()) {
            FeatureData feature = featureList.get(i).getData();
            if (!this.existTreeInput(output, feature.getFeatureName())) {
                TreeInput currentNode = this.makeInput(feature);
                if (feature.getParentIndex() <= 0) {
                    output.add(currentNode);
                } else {
                    String parentFeatureName = Feature.getFeature(feature.getParentIndex()).getName();
                    if (!this.existTreeInput(output, parentFeatureName)) {
                        TreeInput parentNode = this.makeInput(Feature.getFeature(feature.getParentIndex()).getData());
                        output.add(parentNode);
                        parentNode.getChildren().add(currentNode);
                    } else {
                        TreeInput parentTreeInput = this.getTreeInput(output, parentFeatureName);
                        if (parentTreeInput != null) {
                            parentTreeInput.getChildren().add(currentNode);
                        }
                    }
                }
            }
            ++i;
        }
        this.updateParentFeatureCheckStatus(output);
        return output;
    }

    private boolean existTreeInput(List<TreeInput> list, String featureName) {
        int j = 0;
        while (j < list.size()) {
            String name = list.get(j).getText().get(0);
            if (name.equals(featureName)) {
                return true;
            }
            ++j;
        }
        return false;
    }

    private TreeInput getTreeInput(List<TreeInput> list, String featureName) {
        int j = 0;
        while (j < list.size()) {
            String name = list.get(j).getText().get(0);
            if (name.equals(featureName)) {
                return list.get(j);
            }
            ++j;
        }
        return null;
    }

    private String getDetailFeatureOptionText(String featureName) {
        if (featureName.equals(ConfigureLabels.FEATURE_DETAIL_VALUE_SYSTEM_SAMPLING_RATE) || featureName.equals(ConfigureLabels.FEATURE_DETAIL_VALUE_FUNCTION_SAMPLING_RATE)) {
            return this.getSystemOptionText(featureName);
        }
        Logger.debug((Object)("the feature is not an option. " + featureName));
        return null;
    }

    private String getSystemOptionText(String featureName) {
        StringBuffer optionValue = new StringBuffer();
        TargetData target = SettingDataManager.INSTANCE.getTarget(null);
        FeatureData feature = Feature.getFeature(featureName).getData();
        int selectedValue = target.getSelectedFeatureValue(feature.getKey());
        int defaultValue = feature.getDefaultValue();
        if (selectedValue > 0) {
            optionValue.append(String.valueOf(ConfigureLabels.SAMPLING) + Integer.toString(selectedValue));
        } else {
            optionValue.append(String.valueOf(ConfigureLabels.SAMPLING) + Integer.toString(defaultValue));
        }
        return optionValue.toString();
    }

    private void updateParentFeatureCheckStatus(List<TreeInput> output) {
        int i = 0;
        while (i < output.size()) {
            TreeInput treeData = output.get(i);
            if (treeData.getChildren().size() > 0) {
                int childCheckedCount = 0;
                int childUnCheckedCount = 0;
                int j = 0;
                while (j < treeData.getChildren().size()) {
                    if (treeData.getChildren().get(j).getText().get(1).contains(ITEM_ALL_CHECKED)) {
                        ++childCheckedCount;
                    } else {
                        ++childUnCheckedCount;
                    }
                    ++j;
                }
                if (childCheckedCount > 0 && childUnCheckedCount == 0) {
                    this.setCheckStatus(treeData, ITEM_ALL_CHECKED);
                } else if (childCheckedCount > 0 && childUnCheckedCount > 0) {
                    this.setCheckStatus(treeData, ITEM_PART_CHECKED);
                } else if (childCheckedCount == 0 && childUnCheckedCount > 0) {
                    this.setCheckStatus(treeData, "");
                }
            }
            ++i;
        }
    }

    private boolean isClickCheckBox(GridItem item, Event event) {
        String optionText = item.getText(1);
        int checkImgX = 0;
        checkImgX = !optionText.contains(ITEM_PARENT_FEATURE_NAME_ITEM) ? 20 : 40;
        int checkImgWidth = ImageResources.CHECKBOX_SELECTED.getBounds().width;
        return checkImgX <= event.x && event.x <= checkImgX + checkImgWidth + 10;
    }

    private void updateCheckBox(GridItem item, Event event) {
        String optionText = item.getText(1);
        if (optionText.contains(ITEM_PART_CHECKED)) {
            optionText = item.getText(1).replace(ITEM_PART_CHECKED, "");
        }
        optionText = optionText.contains(ITEM_ALL_CHECKED) ? item.getText(1).replace(ITEM_ALL_CHECKED, "") : String.valueOf(optionText) + ITEM_ALL_CHECKED;
        item.setText(1, optionText);
    }

    private void updateChildCheckBoxByParent(GridItem item, Event event) {
        String featureName = item.getText(0);
        String optionText = item.getText(1);
        if (!optionText.contains(ITEM_PARENT_FEATURE_NAME_ITEM)) {
            int i = 0;
            while (i < this.table.getItemCount()) {
                String parentFeatureName;
                FeatureData feature = Feature.getFeature(this.table.getItem(i).getText(0)).getData();
                Feature parentFeature = Feature.getFeature(feature.getParentIndex());
                if (parentFeature != null && featureName.equals(parentFeatureName = parentFeature.getName())) {
                    if (optionText.contains(ITEM_ALL_CHECKED)) {
                        this.setCheckStatus(this.table.getItem(i), ITEM_ALL_CHECKED);
                    } else {
                        this.setCheckStatus(this.table.getItem(i), "");
                    }
                }
                ++i;
            }
        }
    }

    private void updateParentCheckBoxByChild(GridItem item, Event event) {
        String featureName = item.getText(0);
        FeatureData feature = Feature.getFeature(item.getText(0)).getData();
        Feature parentFeature = Feature.getFeature(feature.getParentIndex());
        if (parentFeature != null) {
            String parentFeatureName = parentFeature.getName();
            int parentIndex = -1;
            int childCheckedCount = 0;
            int childUnCheckedCount = 0;
            int i = 0;
            while (i < this.table.getItemCount()) {
                FeatureData tableFeature;
                featureName = this.table.getItem(i).getText(0);
                if (featureName.equals(parentFeatureName)) {
                    parentIndex = i;
                } else if (parentIndex > -1 && (tableFeature = Feature.getFeature(featureName).getData()).getParentIndex() == feature.getParentIndex()) {
                    if (this.table.getItem(i).getText(1).contains(ITEM_ALL_CHECKED)) {
                        ++childCheckedCount;
                    } else {
                        ++childUnCheckedCount;
                    }
                }
                ++i;
            }
            if (childCheckedCount > 0 && childUnCheckedCount == 0) {
                this.setCheckStatus(this.table.getItem(parentIndex), ITEM_ALL_CHECKED);
            } else if (childCheckedCount > 0 && childUnCheckedCount > 0) {
                this.setCheckStatus(this.table.getItem(parentIndex), ITEM_PART_CHECKED);
            } else if (childCheckedCount == 0 && childUnCheckedCount > 0) {
                this.setCheckStatus(this.table.getItem(parentIndex), "");
            }
        }
    }

    private void setCheckStatus(TreeInput item, String status) {
        String optionText = item.getText().get(1);
        if (optionText.contains(ITEM_ALL_CHECKED)) {
            optionText = item.getText().get(1).replace(ITEM_ALL_CHECKED, "");
        } else if (optionText.contains(ITEM_PART_CHECKED)) {
            optionText = item.getText().get(1).replace(ITEM_PART_CHECKED, "");
        }
        if (status.contains(ITEM_ALL_CHECKED)) {
            optionText = String.valueOf(optionText) + ITEM_ALL_CHECKED;
        } else if (status.contains(ITEM_PART_CHECKED)) {
            optionText = String.valueOf(optionText) + ITEM_PART_CHECKED;
        }
        item.getText().set(1, optionText);
    }

    private void setCheckStatus(GridItem item, String status) {
        String optionText = item.getText(1);
        if (optionText.contains(ITEM_ALL_CHECKED)) {
            optionText = item.getText(1).replace(ITEM_ALL_CHECKED, "");
        } else if (optionText.contains(ITEM_PART_CHECKED)) {
            optionText = item.getText(1).replace(ITEM_PART_CHECKED, "");
        }
        if (status.contains(ITEM_ALL_CHECKED)) {
            optionText = String.valueOf(optionText) + ITEM_ALL_CHECKED;
        } else if (status.contains(ITEM_PART_CHECKED)) {
            optionText = String.valueOf(optionText) + ITEM_PART_CHECKED;
        }
        item.setText(1, optionText);
    }

    private boolean isCheckStatus(GridItem item) {
        String optionText = item.getText(1);
        return optionText.contains(ITEM_ALL_CHECKED) || optionText.contains(ITEM_PART_CHECKED);
    }
}

