/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.toolbar.setting;

import java.util.List;
import java.util.Map;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.tizen.dynamicanalyzer.common.DAState;
import org.tizen.dynamicanalyzer.nl.AnalyzerLabels;
import org.tizen.dynamicanalyzer.nl.ConfigureLabels;
import org.tizen.dynamicanalyzer.nl.WidgetLabels;
import org.tizen.dynamicanalyzer.resources.ColorResources;
import org.tizen.dynamicanalyzer.resources.FontResources;
import org.tizen.dynamicanalyzer.resources.ImageResources;
import org.tizen.dynamicanalyzer.setting.SettingDataManager;
import org.tizen.dynamicanalyzer.setting.TargetData;
import org.tizen.dynamicanalyzer.setting.Template;
import org.tizen.dynamicanalyzer.setting.TemplateData;
import org.tizen.dynamicanalyzer.ui.toolbar.setting.FeatureDialog;
import org.tizen.dynamicanalyzer.util.CommonUtil;
import org.tizen.dynamicanalyzer.util.WorkbenchUtil;
import org.tizen.dynamicanalyzer.widgets.button.DACustomButton;
import org.tizen.dynamicanalyzer.widgets.button.DACustomButtonClickEventListener;
import org.tizen.dynamicanalyzer.widgets.button.toggle.DACustomToggleButton;
import org.tizen.dynamicanalyzer.widgets.button.toggle.DACustomToggleButtonGroup;
import org.tizen.dynamicanalyzer.widgets.da.base.DAButton;
import org.tizen.dynamicanalyzer.widgets.da.view.DAPageComposite;

public class SettingDialogTemplatePage
extends DAPageComposite {
    private Composite targetComp = null;
    private Label targetLabel = null;
    private ScrolledComposite targetScrolledComposite = null;
    private Composite targetInputComposite = null;
    private Composite templateComp = null;
    private Label templateLabel = null;
    private ScrolledComposite scrolledComposite = null;
    private Composite inputComposite = null;
    private Composite descriptionComp = null;
    private Label templateIcon = null;
    private Label templateNameLabel = null;
    private Label templateDescriptionLabel = null;
    private Label overheadLabel = null;
    private Label totalOverheadRange = null;
    private Label overheadDescriptionLabel = null;
    private DACustomButton detailButton = null;
    private DACustomButtonClickEventListener detailButtonListener = new DACustomButtonClickEventListener(){

        public void handleClickEvent(DACustomButton button) {
            Shell shell = WorkbenchUtil.getWorkbenchWindow().getShell();
            FeatureDialog dialog = new FeatureDialog(shell);
            Object result = dialog.open();
            if (result != null) {
                SettingDialogTemplatePage.this.createTemplateTitleComposite();
                SettingDialogTemplatePage.this.createTemplateDescriptionComposite();
            }
        }
    };

    public SettingDialogTemplatePage(Composite parent, int style) {
        super(parent, style);
        this.setTitle(AnalyzerLabels.COOLBAR_AREA_CONFIGURATION_FEATURES);
        this.setLayout((Layout)new FormLayout());
        this.setBackground(ColorResources.CONFIGURATION_TABLE_COVER_BACKGROUND_COLOR);
        Label title = new Label((Composite)this, 0x40000000);
        title.setText(ConfigureLabels.SETTING_DIALOG_DESCRIPTION);
        title.setBackground(ColorResources.CONFIGURATION_TABLE_COVER_BACKGROUND_COLOR);
        title.setForeground(ColorResources.DEFAULT_FONT_COLOR);
        title.setFont(FontResources.SETTING_TITLE_FONT);
        FormData data = new FormData();
        data.top = new FormAttachment(0, 14);
        data.left = new FormAttachment(0, 8);
        data.height = 18;
        title.setLayoutData((Object)data);
        this.createTargetComposite();
        this.createTemplateDescriptionComposite();
        this.createTemplateTitleComposite();
    }

    private void initTargetCompositeWidget() {
        if (this.targetLabel != null) {
            this.targetLabel.dispose();
            this.targetLabel = null;
        }
        if (this.targetScrolledComposite != null) {
            this.targetScrolledComposite.dispose();
            this.targetScrolledComposite = null;
        }
        if (this.targetInputComposite != null) {
            this.targetInputComposite.dispose();
            this.targetInputComposite = null;
        }
    }

    private void initTemplateTitleWidget() {
        if (this.templateLabel != null) {
            this.templateLabel.dispose();
            this.templateLabel = null;
        }
        if (this.scrolledComposite != null) {
            this.scrolledComposite.dispose();
            this.scrolledComposite = null;
        }
        if (this.inputComposite != null) {
            this.inputComposite.dispose();
            this.inputComposite = null;
        }
    }

    private void initTemplateDescriptionWidget() {
        if (this.templateIcon != null) {
            this.templateIcon.dispose();
            this.templateIcon = null;
        }
        if (this.templateNameLabel != null) {
            this.templateNameLabel.dispose();
            this.templateNameLabel = null;
        }
        if (this.templateDescriptionLabel != null) {
            this.templateDescriptionLabel.dispose();
            this.templateDescriptionLabel = null;
        }
        if (this.overheadLabel != null) {
            this.overheadLabel.dispose();
            this.overheadLabel = null;
        }
        if (this.totalOverheadRange != null) {
            this.totalOverheadRange.dispose();
            this.totalOverheadRange = null;
        }
        if (this.overheadDescriptionLabel != null) {
            this.overheadDescriptionLabel.dispose();
            this.overheadDescriptionLabel = null;
        }
        if (this.detailButton != null) {
            this.detailButton.dispose();
            this.detailButton = null;
        }
    }

    private DACustomToggleButton createToggleButton(Composite composit, Image image, Point imagePoint, String title, Point fontPoint, int width, int height, int topPosition, int leftPosition) {
        DACustomToggleButton toggle = new DACustomToggleButton(composit, 0);
        toggle.setColors(ColorResources.SETTING_BUTTON_NORMAL_COLOR, ColorResources.SETTING_BUTTON_PUSH_COLOR, ColorResources.SETTING_BUTTON_HOVER_COLOR, ColorResources.SETTING_BUTTON_DISABLE_COLOR, ColorResources.SETTING_BUTTON_TOGGLE_NORMAL_COLOR, ColorResources.SETTING_BUTTON_TOGGLE_HOVER_COLOR, ColorResources.SETTING_BUTTON_TOGGLE_PUSH_COLOR);
        toggle.setButtonImages(image, image, image, image, image, image, image);
        toggle.setButtonImagePoint(imagePoint);
        toggle.setTitle(title);
        toggle.setFontPoint(fontPoint);
        toggle.setFontColors(ColorResources.SETTING_COLOR, ColorResources.SETTING_COLOR, ColorResources.SETTING_COLOR, ColorResources.SETTING_COLOR);
        toggle.setButtonFont(FontResources.SETTING_BUTTON_FONT);
        FormData data = new FormData();
        data.top = new FormAttachment(0, topPosition);
        data.left = new FormAttachment(0, leftPosition);
        data.width = width;
        data.height = height;
        toggle.setLayoutData((Object)data);
        return toggle;
    }

    public void createTargetComposite() {
        this.initTargetCompositeWidget();
        if (this.targetComp == null) {
            this.targetComp = new Composite((Composite)this, 0);
            this.targetComp.setLayout((Layout)new FormLayout());
            FormData compData = new FormData();
            compData.top = new FormAttachment(0, 41);
            compData.left = new FormAttachment(0, 6);
            compData.width = 86;
            compData.height = 403;
            this.targetComp.setLayoutData((Object)compData);
            this.targetComp.setBackground(ColorResources.WHITE);
            this.targetComp.addPaintListener(new PaintListener(){

                public void paintControl(PaintEvent e) {
                    Composite comp = (Composite)e.widget;
                    Rectangle rect = comp.getClientArea();
                    Rectangle r = new Rectangle(0, 0, rect.width - 1, rect.height - 1);
                    e.gc.setForeground(ColorResources.SETTING_STROKE);
                    e.gc.drawRectangle(r);
                    e.gc.drawLine(0, 22, rect.width - 1, 22);
                    e.gc.setBackground(ColorResources.SETTING_TITLE_BACKGROUND);
                    e.gc.fillRectangle(1, 1, 84, 21);
                }
            });
        }
        this.targetLabel = new Label(this.targetComp, 0x40000000);
        FormData data = new FormData();
        data.top = new FormAttachment(0, 4);
        data.left = new FormAttachment(0, 1);
        data.height = 18;
        data.width = 84;
        this.targetLabel.setLayoutData((Object)data);
        this.targetLabel.setText(ConfigureLabels.SETTING_DIALOG_TARGET_TITLE);
        this.targetLabel.setBackground(ColorResources.SETTING_TITLE_BACKGROUND);
        this.targetLabel.setForeground(ColorResources.DEFAULT_FONT_COLOR);
        this.targetLabel.setFont(FontResources.SETTING_TITLE_FONT);
        this.targetLabel.setAlignment(0x1000000);
        this.targetScrolledComposite = new ScrolledComposite(this.targetComp, 2816);
        this.targetScrolledComposite.setLayout((Layout)new FormLayout());
        data = new FormData();
        data.top = new FormAttachment((Control)this.targetLabel, 1);
        data.left = new FormAttachment(0, 1);
        data.right = new FormAttachment(100, -1);
        data.bottom = new FormAttachment(100, -1);
        this.targetScrolledComposite.setLayoutData((Object)data);
        this.targetScrolledComposite.setExpandHorizontal(true);
        this.targetScrolledComposite.setExpandVertical(true);
        this.targetScrolledComposite.setBackground(ColorResources.WHITE);
        this.targetInputComposite = new Composite((Composite)this.targetScrolledComposite, 0);
        this.targetScrolledComposite.setContent((Control)this.targetInputComposite);
        this.targetScrolledComposite.setMinSize(this.targetInputComposite.computeSize(-1, -1));
        this.targetScrolledComposite.setShowFocusedControl(true);
        this.targetInputComposite.setLayout((Layout)new FormLayout());
        data = new FormData();
        data.top = new FormAttachment(0, 1);
        data.left = new FormAttachment(0, 1);
        data.right = new FormAttachment(100, -1);
        data.bottom = new FormAttachment(100, -1);
        this.targetInputComposite.setLayoutData((Object)data);
        this.targetInputComposite.setBackground(ColorResources.WHITE);
        Map<String, TargetData> targetList = SettingDataManager.INSTANCE.getTargetListMap();
        String selectedTarget = SettingDataManager.INSTANCE.getConnectedTarget().getTargetName();
        SettingDataManager.INSTANCE.setSelectedTarget(selectedTarget);
        DACustomToggleButtonGroup targetGroup = new DACustomToggleButtonGroup();
        Point imagePoint = new Point(18, 8);
        Point fontPoint = new Point(-1, 60);
        int topPosition = 4;
        int leftPosition = 3;
        for (Map.Entry<String, TargetData> entry : targetList.entrySet()) {
            TargetData target = entry.getValue();
            DACustomToggleButton toggle = this.createToggleButton(this.targetInputComposite, ProfileDisplayInfo.getImage(target.getTargetName()), imagePoint, target.getTargetName(), fontPoint, 76, 76, topPosition, leftPosition);
            targetGroup.addToggleButton(toggle);
            toggle.addListener(4, new Listener(){

                public void handleEvent(Event event) {
                    DACustomToggleButton toggleButton = (DACustomToggleButton)event.widget;
                    if (toggleButton.isToggled()) {
                        SettingDataManager.INSTANCE.setSelectedTarget(toggleButton.getText());
                        SettingDialogTemplatePage.this.createTemplateTitleComposite();
                        SettingDialogTemplatePage.this.createTemplateDescriptionComposite();
                    }
                }
            });
            topPosition += 80;
            if (!selectedTarget.equals(entry.getKey())) continue;
            targetGroup.setSelection(toggle);
        }
        this.targetComp.layout(true);
        this.targetInputComposite.layout();
        this.targetScrolledComposite.setMinSize(this.targetInputComposite.computeSize(-1, -1));
        if (!DAState.isStartable()) {
            this.targetComp.setEnabled(false);
        }
    }

    public void createTemplateDescriptionComposite() {
        this.initTemplateDescriptionWidget();
        if (this.descriptionComp == null) {
            this.descriptionComp = new Composite((Composite)this, 0);
            this.descriptionComp.setLayout((Layout)new FormLayout());
            FormData compData = new FormData();
            compData.top = new FormAttachment(0, 265);
            compData.left = new FormAttachment(0, 98);
            compData.width = 524;
            compData.height = 179;
            this.descriptionComp.setLayoutData((Object)compData);
            this.descriptionComp.setBackground(ColorResources.WHITE);
            this.descriptionComp.addPaintListener(new PaintListener(){

                public void paintControl(PaintEvent e) {
                    Composite comp = (Composite)e.widget;
                    Rectangle rect = comp.getClientArea();
                    Rectangle r = new Rectangle(0, 0, rect.width - 1, rect.height - 1);
                    e.gc.setForeground(ColorResources.SETTING_STROKE);
                    e.gc.drawRectangle(r);
                    e.gc.drawLine(0, 117, rect.width - 1, 117);
                    e.gc.drawImage(ImageResources.OVERHEAD_BAR_BG, 90, 130);
                    e.gc.drawImage(ImageResources.OVERHEAD_BAR, 91, 133);
                }
            });
        }
        TargetData target = SettingDataManager.INSTANCE.getTarget(null);
        TemplateData template = target.getSelectedTemplate().getData();
        this.templateIcon = new Label(this.descriptionComp, 0x40000000);
        this.templateIcon.setImage(TemplateDisplayInfo.getImage(template.getTemplateName()));
        FormData data = new FormData();
        data.left = new FormAttachment(0, 21);
        data.top = new FormAttachment(0, 16);
        data.width = 40;
        data.height = 40;
        this.templateIcon.setLayoutData((Object)data);
        this.templateIcon.setBackground(ColorResources.WHITE);
        this.templateNameLabel = new Label(this.descriptionComp, 0x40000000);
        data = new FormData();
        data.top = new FormAttachment(0, 16);
        data.left = new FormAttachment(0, 81);
        data.width = 401;
        data.height = 15;
        this.templateNameLabel.setLayoutData((Object)data);
        this.templateNameLabel.setText(template.getTemplateName());
        this.templateNameLabel.setBackground(ColorResources.WHITE);
        this.templateNameLabel.setForeground(ColorResources.DEFAULT_FONT_COLOR);
        this.templateNameLabel.setFont(FontResources.SETTING_TITLE_FONT);
        this.templateDescriptionLabel = new Label(this.descriptionComp, 72);
        data = new FormData();
        data.top = new FormAttachment(0, 40);
        data.left = new FormAttachment(0, 81);
        data.width = 401;
        data.height = 70;
        this.templateDescriptionLabel.setLayoutData((Object)data);
        this.templateDescriptionLabel.setText(template.getDescription());
        this.templateDescriptionLabel.setBackground(ColorResources.WHITE);
        this.templateDescriptionLabel.setForeground(ColorResources.SETTING_COLOR);
        this.templateDescriptionLabel.setFont(FontResources.SETTING_DESCRIPTION_FONT);
        this.overheadLabel = new Label(this.descriptionComp, 0x40000000);
        data = new FormData();
        data.top = new FormAttachment(0, 130);
        data.left = new FormAttachment(0, 9);
        data.width = 80;
        data.height = 20;
        this.overheadLabel.setLayoutData((Object)data);
        this.overheadLabel.setText(ConfigureLabels.SETTING_DIALOG_OVERHEAD);
        this.overheadLabel.setBackground(ColorResources.WHITE);
        this.overheadLabel.setForeground(ColorResources.DEFAULT_FONT_COLOR);
        this.overheadLabel.setFont(FontResources.SETTING_TITLE_FONT);
        this.updateTotalOverheadRange();
        this.overheadDescriptionLabel = new Label(this.descriptionComp, 72);
        data = new FormData();
        data.top = new FormAttachment(0, 153);
        data.left = new FormAttachment(0, 90);
        data.width = 350;
        data.height = 20;
        this.overheadDescriptionLabel.setLayoutData((Object)data);
        this.overheadDescriptionLabel.setText(ConfigureLabels.SETTING_DIALOG_OVERHEAD_DESCRIPTION);
        this.overheadDescriptionLabel.setBackground(ColorResources.WHITE);
        this.overheadDescriptionLabel.setForeground(ColorResources.SETTING_COLOR);
        this.overheadDescriptionLabel.setFont(FontResources.SETTING_DESCRIPTION_FONT);
        this.detailButton = new DAButton(this.descriptionComp, 0);
        this.detailButton.addClickListener(this.detailButtonListener);
        this.detailButton.setText(WidgetLabels.DETAIL);
        this.detailButton.setButtonFont(FontResources.DIALOG_BUTTON_FONT);
        data = new FormData();
        data.top = new FormAttachment(0, 130);
        data.right = new FormAttachment(100, -9);
        data.width = 100;
        data.height = 22;
        this.detailButton.setLayoutData((Object)data);
        this.descriptionComp.layout(true);
    }

    public void updateTotalOverheadRange() {
        SettingDataManager setting = SettingDataManager.INSTANCE;
        TargetData target = setting.getTarget(null);
        if (this.totalOverheadRange != null) {
            this.totalOverheadRange.dispose();
            this.totalOverheadRange = null;
        }
        int totalOverheadRangeCount = setting.getTotalOverheadRangeCount();
        int width = 200 / totalOverheadRangeCount;
        int totalOverheadRangeValue = setting.getSelectedOverheadLevel(target.getTargetName());
        int startPosition = 91 + width * totalOverheadRangeValue;
        this.totalOverheadRange = new Label(this.descriptionComp, 0x40000000);
        FormData data = new FormData();
        data.top = new FormAttachment(0, 133);
        data.left = new FormAttachment(0, startPosition);
        data.width = width * (totalOverheadRangeCount - totalOverheadRangeValue);
        data.height = 10;
        this.totalOverheadRange.setLayoutData((Object)data);
        this.totalOverheadRange.setBackground(ColorResources.SETTING_OVERHEAD_BACKGROUND);
        this.descriptionComp.layout(true);
    }

    public void createTemplateTitleComposite() {
        this.initTemplateTitleWidget();
        if (this.templateComp == null) {
            this.templateComp = new Composite((Composite)this, 0);
            this.templateComp.setLayout((Layout)new FormLayout());
            FormData compData = new FormData();
            compData.top = new FormAttachment(0, 41);
            compData.left = new FormAttachment(0, 98);
            compData.width = 524;
            compData.height = 218;
            this.templateComp.setLayoutData((Object)compData);
            this.templateComp.setBackground(ColorResources.WHITE);
            this.templateComp.addPaintListener(new PaintListener(){

                public void paintControl(PaintEvent e) {
                    Composite comp = (Composite)e.widget;
                    Rectangle rect = comp.getClientArea();
                    Rectangle r = new Rectangle(0, 0, rect.width - 1, rect.height - 1);
                    e.gc.setForeground(ColorResources.SETTING_STROKE);
                    e.gc.drawRectangle(r);
                    e.gc.drawLine(0, 22, rect.width - 1, 22);
                    e.gc.setBackground(ColorResources.SETTING_TITLE_BACKGROUND);
                    e.gc.fillRectangle(1, 1, 522, 21);
                }
            });
        }
        this.templateLabel = new Label(this.templateComp, 0x40000000);
        FormData data = new FormData();
        data.top = new FormAttachment(0, 4);
        data.left = new FormAttachment(0, 1);
        data.height = 18;
        data.width = 502;
        this.templateLabel.setLayoutData((Object)data);
        this.templateLabel.setText(ConfigureLabels.SETTING_DIALOG_TEMPLATE_TITLE);
        this.templateLabel.setBackground(ColorResources.SETTING_TITLE_BACKGROUND);
        this.templateLabel.setForeground(ColorResources.DEFAULT_FONT_COLOR);
        this.templateLabel.setFont(FontResources.SETTING_TITLE_FONT);
        this.templateLabel.setAlignment(0x1000000);
        this.scrolledComposite = new ScrolledComposite(this.templateComp, 2816);
        this.scrolledComposite.setLayout((Layout)new FormLayout());
        data = new FormData();
        data.top = new FormAttachment((Control)this.templateLabel, 1);
        data.left = new FormAttachment(0, 1);
        data.right = new FormAttachment(100, -1);
        data.bottom = new FormAttachment(100, -1);
        this.scrolledComposite.setLayoutData((Object)data);
        this.scrolledComposite.setExpandHorizontal(true);
        this.scrolledComposite.setExpandVertical(true);
        this.scrolledComposite.setBackground(ColorResources.WHITE);
        this.inputComposite = new Composite((Composite)this.scrolledComposite, 0);
        this.scrolledComposite.setContent((Control)this.inputComposite);
        this.scrolledComposite.setMinSize(this.inputComposite.computeSize(-1, -1));
        this.scrolledComposite.setShowFocusedControl(true);
        this.inputComposite.setLayout((Layout)new FormLayout());
        data = new FormData();
        data.top = new FormAttachment(0, 1);
        data.left = new FormAttachment(0, 1);
        data.right = new FormAttachment(100, -1);
        data.bottom = new FormAttachment(100, -1);
        this.inputComposite.setLayoutData((Object)data);
        this.inputComposite.setBackground(ColorResources.WHITE);
        String selectedTarget = SettingDataManager.INSTANCE.getSelectedTarget();
        DACustomToggleButtonGroup targetGroup = new DACustomToggleButtonGroup();
        Point imagePoint = new Point(23, 8);
        Point fontPoint = new Point(-1, 60);
        int defaultLeftPosition = 21;
        if (CommonUtil.isWin()) {
            defaultLeftPosition = 13;
        }
        int topPosition = 4;
        int leftPosition = defaultLeftPosition;
        TargetData target = SettingDataManager.INSTANCE.getTarget(selectedTarget);
        Template selectedTemplate = target.getSelectedTemplate();
        List<Template> templateList = target.getAvailableTemplateList();
        int i = 0;
        while (i < templateList.size()) {
            TemplateData template = templateList.get(i).getData();
            DACustomToggleButton toggle = this.createToggleButton(this.inputComposite, TemplateDisplayInfo.getImage(template.getTemplateName()), imagePoint, template.getTemplateName(), fontPoint, 92, 76, topPosition, leftPosition);
            targetGroup.addToggleButton(toggle);
            toggle.addListener(4, new Listener(){

                public void handleEvent(Event event) {
                    TargetData target;
                    String preSelectedTemplate;
                    DACustomToggleButton toggleButton = (DACustomToggleButton)event.widget;
                    if (toggleButton.isToggled() && !(preSelectedTemplate = (target = SettingDataManager.INSTANCE.getTarget(null)).getSelectedTemplate().getName()).equals(toggleButton.getText())) {
                        Template template = Template.getTemplate(toggleButton.getText());
                        target.setSelectedTemplate(template);
                        target.changeSelectedFeatureList(template);
                        SettingDialogTemplatePage.this.createTemplateDescriptionComposite();
                    }
                }
            });
            if (leftPosition + 96 < 480) {
                leftPosition += 96;
            } else {
                leftPosition = defaultLeftPosition;
                topPosition += 79;
            }
            if (templateList.get(i).equals(selectedTemplate)) {
                targetGroup.setSelection(toggle);
            }
            ++i;
        }
        this.templateComp.layout(true);
        this.inputComposite.layout();
        this.scrolledComposite.setMinSize(this.inputComposite.computeSize(-1, -1));
        if (!DAState.isStartable()) {
            this.templateComp.setEnabled(false);
        }
    }

    private static enum ProfileDisplayInfo {
        PROFILE_NAME_MOBILE(0, ConfigureLabels.TARGET_NAME_MOBILE, ImageResources.TARGET_NAME_MOBILE),
        PROFILE_NAME_TV(1, ConfigureLabels.TARGET_NAME_TV, ImageResources.TARGET_NAME_TV),
        PROFILE_NAME_WEARABLE(2, ConfigureLabels.TARGET_NAME_WEARABLE, ImageResources.TARGET_NAME_WEARABLE);

        private int id = -1;
        private String displayName = null;
        private Image image = null;

        private ProfileDisplayInfo(int id, String displayName, Image image) {
            this.id = id;
            this.displayName = displayName;
            this.image = image;
        }

        public static Image getImage(String displayName) {
            ProfileDisplayInfo[] profiles;
            ProfileDisplayInfo[] profileDisplayInfoArray = profiles = ProfileDisplayInfo.values();
            int n = profiles.length;
            int n2 = 0;
            while (n2 < n) {
                ProfileDisplayInfo profile = profileDisplayInfoArray[n2];
                if (profile.displayName.equals(displayName)) {
                    return profile.image;
                }
                ++n2;
            }
            return null;
        }
    }

    private static enum TemplateDisplayInfo {
        TEMPLATE_NAME_BOTTLENECK(0, ConfigureLabels.TEMPLATE_NAME_BOTTLENECK, ImageResources.TEMPLATE_BOTTLENECK_ANALYSIS),
        TEMPLATE_NAME_MEMORY_LEAKS(1, ConfigureLabels.TEMPLATE_NAME_MEMORY_LEAKS, ImageResources.TEMPLATE_MEMORY_LEAK),
        TEMPLATE_NAME_PROCESS_ACTIVITY(2, ConfigureLabels.TEMPLATE_NAME_PROCESS_ACTIVITY, ImageResources.TEMPLATE_PROCESS_ACTIVITY),
        TEMPLATE_NAME_FILE(3, ConfigureLabels.TEMPLATE_NAME_FILE, ImageResources.TEMPLATE_FILE_ANALYSIS),
        TEMPLATE_NAME_THREAD_ACTIVITY(4, ConfigureLabels.TEMPLATE_NAME_THREAD_ACTIVITY, ImageResources.TEMPLATE_THREAD_ACTIVITY_ANALYSIS),
        TEMPLATE_NAME_WAIT_STATUS(5, ConfigureLabels.TEMPLATE_NAME_WAIT_STATUS, ImageResources.TEMPLATE_WAIT_STATUS_ANALYSIS),
        TEMPLATE_NAME_NETWORK(6, ConfigureLabels.TEMPLATE_NAME_NETWORK, ImageResources.TEMPLATE_NETWORK_ANALYSIS),
        TEMPLATE_NAME_OPEN_GL(7, ConfigureLabels.TEMPLATE_NAME_OPEN_GL, ImageResources.TEMPLATE_OPEN_GL_ANALYSIS),
        TEMPLATE_NAME_ENERGY(8, ConfigureLabels.TEMPLATE_NAME_ENERGY, ImageResources.TEMPLATE_ENERGY),
        TEMPLATE_NAME_HIERARCHY_VIEWER(9, ConfigureLabels.TEMPLATE_NAME_UI_HIERARCHY, ImageResources.TEMPLATE_UI_HIERARCHY_ANALYSIS),
        TEMPLATE_NAME_CUSTOM(10, ConfigureLabels.TEMPLATE_NAME_CUSTOM, ImageResources.TEMPLATE_CUSTOM);

        private int id = -1;
        private String displayName = null;
        private Image image = null;

        private TemplateDisplayInfo(int id, String displayName, Image image) {
            this.id = id;
            this.displayName = displayName;
            this.image = image;
        }

        public static Image getImage(String displayName) {
            TemplateDisplayInfo[] templates;
            TemplateDisplayInfo[] templateDisplayInfoArray = templates = TemplateDisplayInfo.values();
            int n = templates.length;
            int n2 = 0;
            while (n2 < n) {
                TemplateDisplayInfo template = templateDisplayInfoArray[n2];
                if (template.displayName.equals(displayName)) {
                    return template.image;
                }
                ++n2;
            }
            return null;
        }
    }
}

