/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.widgets.table;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.nebula.widgets.grid.Grid;
import org.eclipse.nebula.widgets.grid.GridItem;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Shell;
import org.tizen.dynamicanalyzer.common.DAState;
import org.tizen.dynamicanalyzer.database.SqlConnectionManager;
import org.tizen.dynamicanalyzer.model.FindProperty;
import org.tizen.dynamicanalyzer.model.TableInput;
import org.tizen.dynamicanalyzer.resources.ColorResources;
import org.tizen.dynamicanalyzer.ui.toolbar.Toolbar;
import org.tizen.dynamicanalyzer.ui.widgets.DAGrid;
import org.tizen.dynamicanalyzer.ui.widgets.SearchDialog;
import org.tizen.dynamicanalyzer.ui.widgets.table.DATableComposite;
import org.tizen.dynamicanalyzer.ui.widgets.table.DATableDataFormat;
import org.tizen.dynamicanalyzer.util.CommonUtil;
import org.tizen.dynamicanalyzer.util.Logger;
import org.tizen.dynamicanalyzer.util.WorkbenchUtil;
import org.tizen.dynamicanalyzer.utils.AnalyzerUtil;

public abstract class DAWindowingTableComposite
extends DATableComposite {
    private static final String queryto_GetItemCount = "select count(*) from %s";
    private static final String queryto_GetSelectionVScrollbarIndex = "select count(*) from %s where (%s <= %s)";
    private static final String queryto_GetLimitedItem = "select limit %s %s %s from %s";
    protected Composite scrollComp;
    protected ScrollBar vScrollbar;
    protected ScrollBar hScrollbar;
    protected long selectionStartTime = -1L;
    protected long selectionEndTime = -1L;
    protected int timeColumnIndex = 0;
    private int totalItemCount = 0;
    private int previousSelectionScrollIndex = -1;
    private int previousItemCount = -1;
    private int previousTableLength = 0;
    private int tableAreaHeight = 0;
    private boolean selectSuccess = true;
    private List<List<Object>> queriedObjectData = null;

    public DAWindowingTableComposite(Composite parent, int compStyle, int tableStyle) {
        super(parent, compStyle, tableStyle);
    }

    @Override
    protected Grid createGrid(int tableStyle) {
        this.scrollComp = new Composite((Composite)this, 768);
        this.scrollComp.setBackground(ColorResources.TABLE_CONTENTS_NORMAL);
        this.scrollComp.setLayout((Layout)new FormLayout());
        this.vScrollbar = this.scrollComp.getVerticalBar();
        this.vScrollbar.setMaximum(0);
        this.vScrollbar.setMinimum(0);
        this.vScrollbar.setVisible(false);
        this.vScrollbar.addSelectionListener(new SelectionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void widgetSelected(SelectionEvent e) {
                if (DAWindowingTableComposite.this.previousSelectionScrollIndex != DAWindowingTableComposite.this.vScrollbar.getSelection()) {
                    DATableComposite dATableComposite = DAWindowingTableComposite.this.me;
                    synchronized (dATableComposite) {
                        DAWindowingTableComposite.this.updateTable();
                    }
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.hScrollbar = this.scrollComp.getHorizontalBar();
        this.hScrollbar.setMaximum(0);
        this.hScrollbar.setThumb(0);
        this.hScrollbar.setVisible(false);
        this.hScrollbar.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                int currentPosition = DAWindowingTableComposite.this.hScrollbar.getSelection();
                int xPosition = -currentPosition;
                int width = DAWindowingTableComposite.this.totalColumnSize;
                int height = DAWindowingTableComposite.this.table.getHeaderHeight() + DAWindowingTableComposite.this.getTableLength() * (DAWindowingTableComposite.this.getItemHeightSize() + 1) + 10;
                DAWindowingTableComposite.this.table.setBounds(xPosition, 0, width, height);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        return new DAGrid(this.scrollComp, tableStyle);
    }

    @Override
    protected void setTableLayout() {
        FormData data = new FormData();
        data.top = new FormAttachment(0, 0);
        data.left = new FormAttachment(0, 0);
        if (CommonUtil.isLinux()) {
            data.right = new FormAttachment(100, -2);
            data.bottom = new FormAttachment(100, -2);
        } else {
            data.right = new FormAttachment(100, 0);
            data.bottom = new FormAttachment(100, 0);
        }
        this.table.setLayoutData((Object)data);
    }

    @Override
    protected void addSelectionListener() {
        this.table.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                GridItem[] ti = ((Grid)e.widget).getSelection();
                if (ti == null || ti.length == 0 || !(ti[0].getData() instanceof DATableDataFormat)) {
                    return;
                }
                GridItem focusedItem = ((Grid)e.widget).getFocusItem();
                if (focusedItem != null) {
                    if (!(focusedItem.getData() instanceof DATableDataFormat)) {
                        return;
                    }
                    DATableDataFormat td = (DATableDataFormat)focusedItem.getData();
                    if (td == null) {
                        return;
                    }
                    DAWindowingTableComposite.this.selectionEndTime = DAWindowingTableComposite.this.selectionStartTime = ((Long)td.getData().get(DAWindowingTableComposite.this.timeColumnIndex)).longValue();
                    DAWindowingTableComposite.this.focusSeq = td.getSelectionKey();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    @Override
    protected void addKeyListener() {
        this.table.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
                if (262144 == e.keyCode) {
                    DAWindowingTableComposite.this.ctrlPressed = false;
                }
            }

            public void keyPressed(KeyEvent e) {
                if (262144 == e.keyCode) {
                    DAWindowingTableComposite.this.ctrlPressed = true;
                } else if (e.keyCode == 102) {
                    if (DAWindowingTableComposite.this.ctrlPressed) {
                        DAWindowingTableComposite.this.ctrlPressed = false;
                        if (DAWindowingTableComposite.this.findEnabled) {
                            Shell shell = WorkbenchUtil.getWorkbenchWindow().getShell();
                            SearchDialog dialog = new SearchDialog(shell, DAWindowingTableComposite.this.me);
                            dialog.open();
                        }
                    }
                } else if (e.keyCode == 0x1000001) {
                    int nowScrollBar = DAWindowingTableComposite.this.vScrollbar.getSelection();
                    int tableSelectionIndex = DAWindowingTableComposite.this.table.getSelectionIndex();
                    if (nowScrollBar > 0 && tableSelectionIndex == 0) {
                        DAWindowingTableComposite.this.vScrollbar.setSelection(nowScrollBar - 1);
                        DAWindowingTableComposite.this.setTableSeqNumber(0);
                    }
                } else if (e.keyCode == 0x1000002) {
                    int nowScrollBar = DAWindowingTableComposite.this.vScrollbar.getSelection();
                    int tableSelectionIndex = DAWindowingTableComposite.this.table.getSelectionIndex();
                    if (tableSelectionIndex >= DAWindowingTableComposite.this.getTableLength()) {
                        DAWindowingTableComposite.this.vScrollbar.setSelection(nowScrollBar + 1);
                        DAWindowingTableComposite.this.setTableSeqNumber(DAWindowingTableComposite.this.getTableLength());
                    }
                } else if (e.keyCode == 0x1000005) {
                    int nowScrollBar = DAWindowingTableComposite.this.vScrollbar.getSelection();
                    int pageChagneInde = DAWindowingTableComposite.this.getTableLength();
                    DAWindowingTableComposite.this.vScrollbar.setSelection(nowScrollBar - pageChagneInde + 1);
                    DAWindowingTableComposite.this.setTableSeqNumber(0);
                } else if (e.keyCode == 0x1000006) {
                    int nowScrollBar = DAWindowingTableComposite.this.vScrollbar.getSelection();
                    int pageChagneInde = DAWindowingTableComposite.this.getTableLength() - 1;
                    DAWindowingTableComposite.this.vScrollbar.setSelection(nowScrollBar + pageChagneInde);
                    DAWindowingTableComposite.this.setTableSeqNumber(DAWindowingTableComposite.this.getTableLength() - 1);
                }
            }
        });
    }

    private void setTableSeqNumber(int index) {
        GridItem focusedItem;
        this.selectionStartTime = 0L;
        this.selectionEndTime = 0L;
        this.focusSeq = 0L;
        this.updateTable();
        if (this.table.getItemCount() <= index) {
            index = this.table.getItemCount() - 1;
        }
        if ((focusedItem = this.table.getItem(index)) != null) {
            if (!(focusedItem.getData() instanceof DATableDataFormat)) {
                return;
            }
            DATableDataFormat td = (DATableDataFormat)focusedItem.getData();
            if (td == null) {
                return;
            }
            this.selectionEndTime = this.selectionStartTime = ((Long)td.getData().get(this.timeColumnIndex)).longValue();
            this.focusSeq = td.getSelectionKey();
        }
        this.updateTable();
    }

    public void updateTableArea(int clientAreaHeight) {
        this.tableAreaHeight = clientAreaHeight;
    }

    protected int getTableLength() {
        return (this.tableAreaHeight - this.table.getHeaderHeight()) / (this.table.getItemHeight() + 1);
    }

    public void updateHScrollBar(int tableWidth) {
        this.hScrollbar.setMaximum(this.totalColumnSize);
        this.hScrollbar.setThumb(tableWidth);
        this.hScrollbar.setVisible(true);
    }

    @Override
    public void updateTable() {
        int itemCount = this.getItemCount();
        if (itemCount <= 0) {
            return;
        }
        if ((this.selectionStartTime == this.selectionEndTime || this.selectionStartTime < 0L || this.selectionEndTime < 0L) && Toolbar.INSTANCE.getChartDragStartTime() >= 0L && Toolbar.INSTANCE.getChartDragEndTime() >= 0L) {
            this.selectionStartTime = Toolbar.INSTANCE.getChartDragStartTime();
            this.selectionEndTime = Toolbar.INSTANCE.getChartDragEndTime();
        }
        List<TableInput> output = null;
        output = this.makeTableInputFromDB(itemCount);
        if (output == null) {
            return;
        }
        this.vScrollbar.setMinimum(0);
        this.vScrollbar.setMaximum(itemCount);
        this.vScrollbar.setThumb(this.getTableLength());
        this.vScrollbar.setVisible(true);
        this.table.removeAll();
        if (this.comparator != null) {
            Collections.sort(output, this.comparator);
        }
        ArrayList<Integer> selectionList = new ArrayList<Integer>();
        boolean isSelectionItem = false;
        int focusIndex = -1;
        int size = output.size();
        int i = 0;
        while (i < size) {
            GridItem gridItem = new GridItem(this.table, 0);
            DATableDataFormat gridData = (DATableDataFormat)output.get(i).getData();
            gridItem.setData((Object)gridData);
            List<String> text = output.get(i).getText();
            int columnCount = text.size();
            int index = 0;
            while (index < columnCount) {
                String textData = text.get(index);
                if (textData != null) {
                    gridItem.setText(index, text.get(index));
                }
                ++index;
            }
            if (output.get(i).isInRange() && output.get(i).isSecondSelection()) {
                gridItem.setBackground(this.intersectColor);
            } else if (output.get(i).isSecondSelection()) {
                gridItem.setBackground(this.secondSelectionColor);
            } else if (output.get(i).isInRange()) {
                gridItem.setBackground(this.rangeColor);
            }
            if (gridData != null) {
                long seqNum = gridData.getSelectionKey();
                long time = (Long)gridData.getData().get(this.timeColumnIndex);
                if (this.selectionStartTime <= time && time <= this.selectionEndTime) {
                    isSelectionItem = true;
                    focusIndex = i;
                    selectionList.add(i);
                }
                if (-1L != this.focusSeq && seqNum == this.focusSeq) {
                    focusIndex = i;
                }
            }
            ++i;
        }
        int[] sels = new int[selectionList.size()];
        int i2 = 0;
        while (i2 < selectionList.size()) {
            sels[i2] = (Integer)selectionList.get(i2);
            ++i2;
        }
        if (isSelectionItem) {
            this.table.setSelection(sels);
            if (this.table.isFocusControl() && focusIndex > 0) {
                this.table.setFocusItem(this.table.getItem(focusIndex));
            }
        }
        this.table.update();
    }

    protected int getItemCount() {
        if (DAState.isStartable() && this.totalItemCount == 0) {
            String tablename = this.getDBTableName();
            if (tablename != null && !tablename.isEmpty()) {
                List<List<Object>> result;
                StringBuffer query = new StringBuffer();
                query.append(String.format(queryto_GetItemCount, this.getDBTableName()));
                String option = this.getSelectQueryCountOption();
                if (option != null && !option.isEmpty()) {
                    query.append(" where ").append(option);
                }
                if ((result = SqlConnectionManager.executeQuery(query.toString())) != null) {
                    Object object = result.get(0).get(0);
                    if (object instanceof Integer) {
                        this.totalItemCount = (Integer)object;
                    } else if (object instanceof Long) {
                        this.totalItemCount = ((Long)object).intValue();
                    } else {
                        Logger.error((Object)"result of item count query is not expected!!");
                        this.totalItemCount = 0;
                    }
                }
            }
        } else {
            this.totalItemCount = this.getItemCountByPid();
        }
        return this.totalItemCount;
    }

    private int getRecordCount(int itemCount) {
        int selectedEndIndex = this.getTableLength() + 1;
        int recordCount = itemCount <= selectedEndIndex ? itemCount : selectedEndIndex + 1;
        return recordCount;
    }

    private List<TableInput> makeTableInputFromDB(int itemCount) {
        int tableLen;
        int scrollSelection;
        boolean isQueryDB = false;
        if (!this.selectSuccess) {
            isQueryDB = true;
            this.selectSuccess = true;
        }
        if (this.previousSelectionScrollIndex != (scrollSelection = this.vScrollbar.getSelection())) {
            isQueryDB = true;
            this.previousSelectionScrollIndex = scrollSelection;
        }
        if (this.previousTableLength != (tableLen = this.getTableLength())) {
            isQueryDB = true;
            this.previousTableLength = tableLen;
        }
        if (this.previousItemCount != itemCount) {
            if (this.previousItemCount <= scrollSelection + tableLen + 1) {
                isQueryDB = true;
            } else if (this.previousItemCount > itemCount) {
                isQueryDB = true;
            }
            this.previousItemCount = itemCount;
        }
        if (isQueryDB) {
            this.queriedObjectData = this.getObjectDataFromDB(itemCount);
            if (this.queriedObjectData != null) {
                int selectedCount = this.queriedObjectData.size();
                if (selectedCount != this.getRecordCount(itemCount) && selectedCount != itemCount - scrollSelection) {
                    this.selectSuccess = false;
                }
            } else {
                this.selectSuccess = false;
            }
        }
        if (this.queriedObjectData == null) {
            return null;
        }
        return this.makeTableInput();
    }

    private List<List<Object>> getObjectDataFromDB(int itemCount) {
        String tableName = this.getDBTableName();
        if (tableName == null || tableName.isEmpty()) {
            return null;
        }
        int scrollSelection = this.vScrollbar.getSelection();
        if (scrollSelection > itemCount || itemCount <= this.getTableLength()) {
            scrollSelection = 0;
        }
        StringBuffer columnString = new StringBuffer();
        List<String> columnNames = this.getDBTableColumnNames();
        int columnsize = columnNames.size();
        int i = 0;
        while (i < columnsize) {
            columnString.append(columnNames.get(i));
            if (i < columnsize - 1) {
                columnString.append(", ");
            }
            ++i;
        }
        StringBuffer query = new StringBuffer();
        query.append(String.format(queryto_GetLimitedItem, scrollSelection, this.getRecordCount(itemCount), columnString.toString(), tableName));
        String option = this.getSelectQueryOption();
        if (option != null && !option.isEmpty()) {
            query.append(" where ").append(option);
        }
        return SqlConnectionManager.executeQuery(query.toString());
    }

    @Override
    public void clear() {
        super.clear();
        this.vScrollbar.setMaximum(0);
        this.vScrollbar.setMinimum(0);
        this.vScrollbar.setVisible(false);
        this.selectionStartTime = -1L;
        this.selectionEndTime = -1L;
        this.queriedObjectData = null;
        this.totalItemCount = 0;
        this.previousItemCount = -1;
    }

    @Override
    protected void actionSetStartEnd(int type) {
        GridItem item = this.table.getItem(this.mousePoint);
        if (item != null) {
            long inputTime = (Long)((DATableDataFormat)item.getData()).getData().get(this.timeColumnIndex);
            if (type == 0) {
                this.rangeDataManager.setMarkerStartTime(inputTime);
            } else if (type == 1) {
                this.rangeDataManager.setMarkerEndTime(inputTime);
            }
        }
    }

    protected List<List<Object>> getQueriedObjectData() {
        return this.queriedObjectData;
    }

    public void setSelectionByTime(long startTime, long endTime) {
        String tableName = this.getDBTableName();
        if (tableName != null && !tableName.isEmpty()) {
            List<List<Object>> resultList;
            this.selectionStartTime = startTime;
            this.selectionEndTime = endTime;
            Toolbar.INSTANCE.setChartDragStartTime(this.selectionStartTime);
            Toolbar.INSTANCE.setChartDragEndTime(this.selectionEndTime);
            AnalyzerUtil.getMainTab().getTopComposite().updateView();
            String query = String.format(queryto_GetSelectionVScrollbarIndex, tableName, this.getTimeColumnName(), Long.toString(startTime));
            if (!this.getSelectQueryCountOption().equals("")) {
                query = String.valueOf(query) + " and (" + this.getSelectQueryCountOption() + ")";
            }
            if ((resultList = SqlConnectionManager.executeQuery(query)) == null || resultList.size() == 0 || resultList.get(0).size() == 0) {
                return;
            }
            String strSelectionIndex = String.valueOf((Long)resultList.get(0).get(0));
            int intSelectionIndex = Integer.parseInt(strSelectionIndex);
            if (intSelectionIndex > 0) {
                this.vScrollbar.setSelection(intSelectionIndex - 1);
            } else {
                this.vScrollbar.setSelection(0);
            }
        }
    }

    public void setDataType(int timeColumnIndex) {
        this.timeColumnIndex = timeColumnIndex;
    }

    @Override
    public int getScrollSelectionIndex(int selection) {
        int size = this.vScrollbar.getThumb() / 2;
        int output = selection - size;
        output = output < 0 ? 0 : output;
        return output;
    }

    @Override
    public int searchString(FindProperty findProperty) {
        GridItem[] items = this.table.getItems();
        int size = items.length;
        boolean next = !findProperty.isBackward();
        int start = findProperty.getIndex();
        DAWindowingTableComposite.setFindProferty(findProperty);
        if (next) {
            int i = start;
            while (i < size) {
                if (this.checkText(findProperty, items[i])) {
                    int nowScrollBar = this.vScrollbar.getSelection();
                    this.table.setSelection(i);
                    int tableSelectionIndex = this.table.getSelectionIndex();
                    GridItem focusedItem = this.table.getFocusItem();
                    if (focusedItem != null) {
                        DATableDataFormat td = (DATableDataFormat)focusedItem.getData();
                        this.focusSeq = td.getSelectionKey();
                    }
                    if (tableSelectionIndex >= this.getTableLength()) {
                        this.vScrollbar.setSelection(nowScrollBar + 1);
                        this.setTableSeqNumber(this.getTableLength());
                    }
                    return i;
                }
                ++i;
            }
        } else {
            int i = start;
            while (i >= 0) {
                if (this.checkText(findProperty, items[i])) {
                    this.vScrollbar.setSelection(this.getScrollSelectionIndex(i));
                    this.updateTable();
                    return i;
                }
                --i;
            }
        }
        this.table.deselectAll();
        return -1;
    }

    protected abstract int getItemCountByPid();

    protected abstract List<String> getDBTableColumnNames();

    protected abstract String getDBTableName();

    protected abstract String getSelectQueryOption();

    protected abstract String getSelectQueryCountOption();

    protected abstract String getTimeColumnName();
}

