/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTTypeId;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.ITypedef;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTSimpleTypeTemplateParameter;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPScope;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateArgument;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateParameter;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateTypeParameter;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTName;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPTemplateArgument;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPTemplateParameter;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPUnknownScope;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPUnknownBinding;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPUnknownType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPVisitor;

public class CPPTemplateTypeParameter
extends CPPTemplateParameter
implements ICPPTemplateTypeParameter,
ICPPUnknownType,
ICPPUnknownBinding {
    private ICPPScope unknownScope;
    private final boolean fIsParameterPack;

    public CPPTemplateTypeParameter(IASTName name, boolean isPack) {
        super(name);
        this.fIsParameterPack = isPack;
    }

    public final boolean isParameterPack() {
        return this.fIsParameterPack;
    }

    public ICPPScope asScope() {
        if (this.unknownScope == null) {
            IASTName n = null;
            IASTName[] nodes = this.getDeclarations();
            if (nodes != null && nodes.length > 0) {
                n = nodes[0];
            }
            this.unknownScope = new CPPUnknownScope(this, n);
        }
        return this.unknownScope;
    }

    public IType getDefault() {
        IASTName[] nds = this.getDeclarations();
        if (nds == null || nds.length == 0) {
            return null;
        }
        IASTName[] iASTNameArray = nds;
        int n = nds.length;
        int n2 = 0;
        while (n2 < n) {
            ICPPASTSimpleTypeTemplateParameter simple;
            IASTTypeId typeId;
            IASTNode parent;
            IASTName nd = iASTNameArray[n2];
            if (nd != null && (parent = nd.getParent()) instanceof ICPPASTSimpleTypeTemplateParameter && (typeId = (simple = (ICPPASTSimpleTypeTemplateParameter)parent).getDefaultType()) != null) {
                return CPPVisitor.createType(typeId);
            }
            ++n2;
        }
        return null;
    }

    public ICPPTemplateArgument getDefaultValue() {
        IType t = this.getDefault();
        if (t == null) {
            return null;
        }
        return new CPPTemplateArgument(t);
    }

    public boolean isSameType(IType type) {
        if (type == this) {
            return true;
        }
        if (type instanceof ITypedef) {
            return type.isSameType(this);
        }
        if (!(type instanceof ICPPTemplateTypeParameter)) {
            return false;
        }
        return this.getParameterID() == ((ICPPTemplateParameter)((Object)type)).getParameterID();
    }

    public IASTName getUnknownName() {
        return new CPPASTName(this.getNameCharArray());
    }
}

