/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.index.composite.cpp;

import org.eclipse.cdt.core.dom.ast.EScopeKind;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPNamespace;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPNamespaceScope;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPUsingDirective;
import org.eclipse.cdt.core.index.IIndexBinding;
import org.eclipse.cdt.core.index.IIndexFileSet;
import org.eclipse.cdt.core.index.IIndexName;
import org.eclipse.cdt.internal.core.index.IIndexFragmentBinding;
import org.eclipse.cdt.internal.core.index.IIndexScope;
import org.eclipse.cdt.internal.core.index.composite.CompositeScope;
import org.eclipse.cdt.internal.core.index.composite.ICompositesFactory;

class CompositeCPPNamespaceScope
extends CompositeScope
implements ICPPNamespaceScope {
    ICPPNamespace[] namespaces;

    public CompositeCPPNamespaceScope(ICompositesFactory cf, ICPPNamespace[] namespaces) {
        super(cf, (IIndexFragmentBinding)((Object)namespaces[0]));
        this.namespaces = namespaces;
    }

    public EScopeKind getKind() {
        return EScopeKind.eNamespace;
    }

    public void addUsingDirective(ICPPUsingDirective directive) {
        this.fail();
    }

    public ICPPUsingDirective[] getUsingDirectives() {
        return new ICPPUsingDirective[0];
    }

    public IBinding getBinding(IASTName name, boolean resolve, IIndexFileSet fileSet) {
        IBinding preresult = null;
        int i = 0;
        while (preresult == null && i < this.namespaces.length) {
            preresult = this.namespaces[i].getNamespaceScope().getBinding(name, resolve, fileSet);
            ++i;
        }
        return this.processUncertainBinding(preresult);
    }

    public IBinding[] getBindings(IASTName name, boolean resolve, boolean prefixLookup, IIndexFileSet fileSet) {
        IIndexFragmentBinding[][] preresult = new IIndexFragmentBinding[this.namespaces.length][];
        int i = 0;
        while (i < this.namespaces.length) {
            IBinding[] raw = this.namespaces[i].getNamespaceScope().getBindings(name, resolve, prefixLookup, fileSet);
            preresult[i] = new IIndexFragmentBinding[raw.length];
            System.arraycopy(raw, 0, preresult[i], 0, raw.length);
            ++i;
        }
        return this.cf.getCompositeBindings(preresult);
    }

    public final IBinding[] find(String name) {
        IIndexFragmentBinding[][] preresult = new IIndexFragmentBinding[this.namespaces.length][];
        int i = 0;
        while (i < this.namespaces.length) {
            IBinding[] raw = this.namespaces[i].getNamespaceScope().find(name);
            preresult[i] = new IIndexFragmentBinding[raw.length];
            System.arraycopy(raw, 0, preresult[i], 0, raw.length);
            ++i;
        }
        return this.cf.getCompositeBindings(preresult);
    }

    public IIndexBinding getScopeBinding() {
        return this.cf.getCompositeBinding(this.rbinding);
    }

    public IIndexName getScopeName() {
        ICPPNamespace[] iCPPNamespaceArray = this.namespaces;
        int n = this.namespaces.length;
        int n2 = 0;
        while (n2 < n) {
            IIndexScope s;
            IIndexName nm;
            ICPPNamespace namespace = iCPPNamespaceArray[n2];
            if (namespace instanceof IIndexScope && (nm = (s = (IIndexScope)((Object)namespace)).getScopeName()) != null) {
                return nm;
            }
            ++n2;
        }
        return null;
    }

    public ICPPNamespaceScope[] getInlineNamespaces() {
        IIndexFragmentBinding[][] preresult = new IIndexFragmentBinding[this.namespaces.length][];
        int i = 0;
        while (i < this.namespaces.length) {
            ICPPNamespaceScope[] raw = this.namespaces[i].getNamespaceScope().getInlineNamespaces();
            preresult[i] = new IIndexFragmentBinding[raw.length];
            IIndexFragmentBinding[] arr = preresult[i];
            int j = 0;
            while (j < raw.length) {
                arr[j] = (IIndexFragmentBinding)((IIndexScope)((Object)raw[j])).getScopeBinding();
                ++j;
            }
            ++i;
        }
        IIndexBinding[] compBinding = this.cf.getCompositeBindings(preresult);
        ICPPNamespaceScope[] result = new ICPPNamespaceScope[compBinding.length];
        int i2 = 0;
        while (i2 < result.length) {
            result[i2] = ((ICPPNamespace)((Object)compBinding[i2])).getNamespaceScope();
            ++i2;
        }
        return result;
    }
}

