/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.widgets.chart;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;
import org.tizen.dynamicanalyzer.util.Logger;
import org.tizen.dynamicanalyzer.widgets.chart.DAChart;
import org.tizen.dynamicanalyzer.widgets.chart.DAChartPlot;
import org.tizen.dynamicanalyzer.widgets.chart.DAChartPlotIntervalMarker;
import org.tizen.dynamicanalyzer.widgets.chart.DAChartPlotMarker;
import org.tizen.dynamicanalyzer.widgets.chart.DAChartSeries;
import org.tizen.dynamicanalyzer.widgets.chart.DAChartSeriesItem;
import org.tizen.dynamicanalyzer.widgets.chart.DAScreenshotChartPlot;
import org.tizen.dynamicanalyzer.widgets.chart.DAUIEventChartPlot;
import org.tizen.dynamicanalyzer.widgets.helper.ColorResources;
import org.tizen.dynamicanalyzer.widgets.helper.FontResources;
import org.tizen.dynamicanalyzer.widgets.helper.Formatter;
import org.tizen.dynamicanalyzer.widgets.helper.ImageResources;

public class DAChartRenderer {
    private static final int MARGIN = 3;
    private static final int ARROW_MARGIN = 2;
    private static final int EVENT_WIDTH = 2;
    private static final double EVENT_HEIGHT_MARGIN_RATIO = 0.2;
    private static final double LOAD_HEIGHT_MARGIN_RATIO = 0.2;
    protected boolean bInitialized = false;
    protected List<DAChartSeries> seriesList = null;
    protected DAChartPlot plot = null;
    protected Rectangle r = null;
    private static final int SCREENSHOT_Y_POSITION_MINI = 4;
    private static final int SCREENSHOT_SELECTED_Y_POSITION = 4;
    private static final int SCREENSHOT_SELECTED_Y_POSITION_MINI = 1;
    private static final int SCREENSHOT_SELECTED_LINE_WIDTH = 2;
    private static final int SCREENSHOT_BORDER_LINE_WIDTH = 1;
    private static final int SCREENSHOT_DOT_WIDTH = 12;
    private static final int MULTI_CHECK_BAR_WIDTH = 2;
    private static final int AXIS_LINE_WIDTH = 6;
    private static final int AXIS_MARGIN = 2;
    private Rectangle oldStateBarRectangle = new Rectangle(0, 0, 0, 0);
    private Rectangle oldStateContinueRectangle = new Rectangle(0, 0, 0, 0);
    private Rectangle oldStateConnectionRectangle = new Rectangle(0, 0, 0, 0);

    public void draw(GC gc, DAChart chart, Image buffer) {
        if (!this.bInitialized) {
            this.initialize(gc, chart);
        }
        this.plot = chart.getPlot();
        this.r = chart.getClientArea();
        if (buffer == null) {
            Image backImage = this.plot.getBackgroundImage();
            if (backImage != null) {
                Rectangle rect = backImage.getBounds();
                gc.drawImage(backImage, rect.x, rect.y, rect.width, rect.height, this.r.x, this.r.y, this.r.width, this.r.height);
            }
        } else {
            gc.drawImage(buffer, 0, 0);
        }
        if (this.r.height > 50) {
            this.drawTooltip(gc);
        }
        this.drawEndLine(gc);
        this.drawRange(gc);
        this.drawMarker(gc);
    }

    public void drawMarker(GC gc) {
        int oldAlpha = gc.getAlpha();
        Color oldBackColor = gc.getBackground();
        Color oldForeColor = gc.getForeground();
        int oldLineWidth = gc.getLineWidth();
        int oldLineStyle = gc.getLineStyle();
        gc.setAlpha(127);
        gc.setForeground(ColorResources.POINT);
        gc.setBackground(ColorResources.POINT);
        gc.setLineWidth(2);
        gc.setLineStyle(3);
        for (double time : this.plot.getMarkerTimeList()) {
            gc.drawLine(this.plot.getXPixelFromX(time), this.r.y, this.plot.getXPixelFromX(time), this.r.height);
        }
        gc.setAlpha(oldAlpha);
        gc.setBackground(oldBackColor);
        gc.setForeground(oldForeColor);
        gc.setLineWidth(oldLineWidth);
        gc.setLineStyle(oldLineStyle);
    }

    public void drawEndLine(GC gc) {
        int oldAlpha = gc.getAlpha();
        Color oldBackColor = gc.getBackground();
        Color oldForeColor = gc.getForeground();
        int oldLineWidth = gc.getLineWidth();
        gc.setForeground(ColorResources.GRAY_170);
        gc.setBackground(ColorResources.GRAY_170);
        gc.drawLine(this.plot.getXPixelFromX(this.plot.getValidEndX()), this.r.y, this.plot.getXPixelFromX(this.plot.getValidEndX()), this.r.height);
        gc.setAlpha(oldAlpha);
        gc.setBackground(oldBackColor);
        gc.setForeground(oldForeColor);
        gc.setLineWidth(oldLineWidth);
    }

    protected boolean preDraw(GC gc, DAChart chart) {
        if (!this.bInitialized) {
            this.initialize(gc, chart);
        }
        this.plot = chart.getPlot();
        this.r = chart.getClientArea();
        gc.setForeground(ColorResources.GRAY_170);
        gc.setBackground(ColorResources.GRAY_170);
        gc.fillGradientRectangle(this.r.x, this.r.y, 1, this.r.height, false);
        if (chart.isSelected()) {
            gc.setForeground(ColorResources.WHITE);
            gc.setBackground(ColorResources.WHITE);
        } else {
            gc.setForeground(ColorResources.WHITE);
            gc.setBackground(ColorResources.WHITE);
        }
        gc.fillGradientRectangle(this.r.x + 1, this.r.y, this.r.width - 1, this.r.height, false);
        if (this.seriesList == null) {
            return false;
        }
        if (this.plot.getAutoHeightRange() == DAChartPlot.AutoRangeType.SEMI_AUTO || this.plot.getAutoHeightRange() == DAChartPlot.AutoRangeType.AUTO) {
            double maxY = 0.0;
            for (DAChartSeries series : this.seriesList) {
                double tempY = series.getMaxY();
                if (!(maxY < tempY)) continue;
                maxY = tempY;
            }
            if (maxY * 1.1 > this.plot.getVisibleEndY() * 1.1) {
                this.plot.setAxisEndY(maxY * 1.1);
            }
        }
        return true;
    }

    protected void drawAxis(GC gc) {
        if (this.plot.isShowAxis()) {
            if (this.plot.isSeriesHeightRange()) {
                int i = 0;
                while (i < this.seriesList.size()) {
                    DAChartSeries series = this.seriesList.get(i);
                    if (i == 0) {
                        this.drawAxis(gc, this.r, this.plot.getVisibleStartY(), this.plot.getVisibleEndY(), true);
                    } else {
                        if (1 != i) break;
                        this.drawAxis(gc, this.r, 0.0, series.getEndY(), false);
                    }
                    ++i;
                }
            } else {
                this.drawAxis(gc, this.r, this.plot.getVisibleStartY(), this.plot.getVisibleEndY(), true);
            }
        }
    }

    protected void drawToGc(GC gc, DAChart chart) {
        if (!this.preDraw(gc, chart)) {
            return;
        }
        this.oldStateBarRectangle.x = 0;
        this.oldStateBarRectangle.y = 0;
        this.oldStateBarRectangle.width = 0;
        this.oldStateBarRectangle.height = 0;
        this.oldStateContinueRectangle.x = 0;
        this.oldStateContinueRectangle.y = 0;
        this.oldStateContinueRectangle.width = 0;
        this.oldStateContinueRectangle.height = 0;
        this.oldStateConnectionRectangle.x = 0;
        this.oldStateConnectionRectangle.y = 0;
        this.oldStateConnectionRectangle.width = 0;
        this.oldStateConnectionRectangle.height = 0;
        int i = 0;
        while (i < this.seriesList.size()) {
            DAChartSeries series = this.seriesList.get(i);
            switch (series.getStyle()) {
                case 8: {
                    this.drawEventSeries(gc, series);
                    break;
                }
                case 9: {
                    this.drawEventAreaSeries(gc, series);
                    break;
                }
                case 2: {
                    this.drawBarSeries(gc, series);
                    break;
                }
                case 0: 
                case 1: {
                    this.drawLineSeries(gc, series, false);
                    break;
                }
                case 3: {
                    this.drawAreaSeries(gc, series, false);
                    break;
                }
                case 10: {
                    this.drawMultiCheckBarSeries(gc, series, i, this.seriesList.size());
                    break;
                }
                case 6: {
                    this.drawStepSeries(gc, series, true);
                    break;
                }
                case 7: {
                    this.drawImageSeries(gc, series);
                    break;
                }
                case 11: {
                    this.drawLoadSeries(gc, series);
                    break;
                }
                case 12: {
                    this.drawArrowSeries(gc, series);
                    break;
                }
                case 13: {
                    this.drawStateSeries(gc, series);
                    break;
                }
                case 14: {
                    this.drawStepSeries(gc, series, false);
                    break;
                }
                case 16: {
                    this.drawStateAreaSeries(gc, series, i, this.seriesList.size());
                    break;
                }
                case 17: {
                    this.drawDotSeries(gc, series);
                    break;
                }
                default: {
                    Logger.debug((Object)"Undefined series style");
                }
            }
            ++i;
        }
        this.drawAxis(gc);
        if (chart.getInformation() != null) {
            gc.setForeground(ColorResources.CHART_INFO);
            gc.setFont(FontResources.CHART_INFO_FONT);
            gc.drawImage(ImageResources.CHART_INFO, this.r.x + 5, (this.r.y + this.r.height) / 2 - 4);
            gc.drawText(chart.getInformation(), this.r.x + 18, this.r.y + this.r.height / 2 - gc.textExtent((String)chart.getInformation()).y / 2, true);
        }
    }

    public void drawBuffer(Image buffer, DAChart chart) {
        GC bufGc = new GC((Drawable)buffer);
        this.drawToGc(bufGc, chart);
        bufGc.dispose();
    }

    protected void drawAxis(GC gc, Rectangle rt, double min, double max, boolean bPosRight) {
        Color oldCol = gc.getForeground();
        gc.setForeground(ColorResources.GRAY_170);
        Font axisFont = this.plot.getAxisFont();
        String axisUnit = bPosRight ? this.plot.getAxisUnit() : this.plot.getSecondAxisUnit();
        gc.setFont(axisFont);
        String text = "";
        int x1 = 1;
        int x2 = 6;
        if (bPosRight) {
            x1 = rt.width - 1;
            x2 = rt.width - 6;
        }
        gc.drawLine(x1, 0, x1, rt.height);
        gc.drawLine(x1, rt.height - 1, x2, rt.height - 1);
        if (this.plot.getAxisUnitType() == DAChartPlot.UnitType.BINARY) {
            text = Formatter.convertBinaryPrefix(min);
        } else if (this.plot.getAxisUnitType() == DAChartPlot.UnitType.DECIMAL) {
            text = Formatter.convertDecimalPrefix(min);
        } else if (this.plot.getAxisUnitType() == DAChartPlot.UnitType.MICRO_DECIMAL) {
            text = Formatter.convertMicroDecimalPrefix(min);
        } else if (this.plot.getAxisUnitType() == DAChartPlot.UnitType.GL_MS) {
            text = min == 0.0 ? "" : "(" + Formatter.convertDecimalPrefix(1000.0 / min) + "fps)";
            text = String.valueOf(text) + Math.round(min);
        } else if (this.plot.getAxisUnitType() == DAChartPlot.UnitType.GL_FPS) {
            text = min == 0.0 ? "" : "(" + Formatter.convertDecimalPrefix(1000.0 / min) + "ms)";
            text = String.valueOf(text) + min;
        }
        if (axisUnit != null) {
            text = String.valueOf(text) + axisUnit;
        }
        int textHeight = gc.textExtent((String)text).y;
        int textX = bPosRight ? x1 - gc.textExtent((String)text).x - 2 - 6 : 8;
        gc.drawText(text, textX, rt.height - textHeight, true);
        gc.drawLine(x1, rt.height / 2, x2, rt.height / 2);
        if (this.plot.getAxisUnitType() == DAChartPlot.UnitType.BINARY) {
            text = Formatter.convertBinaryPrefix((min + max) / 2.0);
        } else if (this.plot.getAxisUnitType() == DAChartPlot.UnitType.DECIMAL) {
            text = Formatter.convertDecimalPrefix((min + max) / 2.0);
        } else if (this.plot.getAxisUnitType() == DAChartPlot.UnitType.MICRO_DECIMAL) {
            text = Formatter.convertMicroDecimalPrefix((min + max) / 2.0);
        } else if (this.plot.getAxisUnitType() == DAChartPlot.UnitType.GL_MS) {
            text = max == 0.0 ? "" : "(" + Formatter.convertDecimalPrefix(2000.0 / (min + max)) + "fps)";
            text = String.valueOf(text) + Math.round((min + max) / 2.0);
        } else if (this.plot.getAxisUnitType() == DAChartPlot.UnitType.GL_FPS) {
            text = max == 0.0 ? "" : "(" + Formatter.convertDecimalPrefix(2000.0 / (min + max)) + "ms)";
            text = String.valueOf(text) + (min + max) / 2.0;
        }
        if (axisUnit != null) {
            text = String.valueOf(text) + axisUnit;
        }
        textHeight = gc.textExtent((String)text).y;
        if (bPosRight) {
            textX = x1 - gc.textExtent((String)text).x - 2 - 6;
        }
        gc.drawText(text, textX, rt.height / 2 - textHeight / 2, true);
        gc.drawLine(x1, 0, x2, 0);
        if (this.plot.getAxisUnitType() == DAChartPlot.UnitType.BINARY) {
            text = Formatter.convertBinaryPrefix(max);
        } else if (this.plot.getAxisUnitType() == DAChartPlot.UnitType.DECIMAL) {
            text = Formatter.convertDecimalPrefix(max);
        } else if (this.plot.getAxisUnitType() == DAChartPlot.UnitType.MICRO_DECIMAL) {
            text = Formatter.convertMicroDecimalPrefix(max);
        } else if (this.plot.getAxisUnitType() == DAChartPlot.UnitType.GL_MS) {
            text = max == 0.0 ? "" : "(" + Formatter.convertDecimalPrefix(1000.0 / max) + "fps)";
            text = String.valueOf(text) + Math.round(max);
        } else if (this.plot.getAxisUnitType() == DAChartPlot.UnitType.GL_FPS) {
            text = max == 0.0 ? "" : "(" + Formatter.convertDecimalPrefix(1000.0 / max) + "ms)";
            text = String.valueOf(text) + max;
        }
        if (axisUnit != null) {
            text = String.valueOf(text) + axisUnit;
        }
        if (bPosRight) {
            textX = x1 - gc.textExtent((String)text).x - 2 - 6;
        }
        gc.drawText(text, textX, 1, true);
        gc.setForeground(oldCol);
    }

    protected void initialize(GC gc, DAChart chart) {
        this.seriesList = chart.getSeriesList();
        this.bInitialized = true;
    }

    public void drawRange(GC gc) {
        List<DAChartPlotMarker> markers = this.plot.getMarkers();
        if (markers == null) {
            return;
        }
        int oldAlpha = gc.getAlpha();
        Color oldBackColor = gc.getBackground();
        Color oldForeColor = gc.getForeground();
        int oldLineWidth = gc.getLineWidth();
        int markerSize = markers.size();
        int i = 0;
        while (i < markerSize) {
            DAChartPlotMarker marker = markers.get(i);
            gc.setForeground(ColorResources.POINT);
            gc.setBackground(ColorResources.POINT);
            gc.setAlpha(51);
            int pixelStartX = this.plot.getXPixelFromX(marker.getVal());
            int markerStyle = 1;
            if (marker instanceof DAChartPlotIntervalMarker) {
                int pixelEndX = this.plot.getXPixelFromX(((DAChartPlotIntervalMarker)marker).getEndVal());
                markerStyle = ((DAChartPlotIntervalMarker)marker).getMarkerStyle();
                if (markerStyle != 0) {
                    int width = pixelEndX - pixelStartX;
                    if (width <= 1) {
                        width = marker.getLineWidth();
                    }
                    gc.fillRectangle(pixelStartX, 0, width, this.r.height);
                }
            }
            ++i;
        }
        gc.setAlpha(oldAlpha);
        gc.setBackground(oldBackColor);
        gc.setForeground(oldForeColor);
        gc.setLineWidth(oldLineWidth);
    }

    protected int getTooltipStartX(double startVal, int width, int margin) {
        int ret = this.plot.getXPixelFromX(startVal);
        ret = ret + width > this.r.x + this.r.width ? ret - width - margin : (ret < this.r.x ? this.r.x + margin : (ret += margin));
        return ret;
    }

    protected String toTimeFormat(double sec) {
        int second = (int)sec;
        int ms = (int)(sec * 10.0) % 10;
        String ret = second > 3600 ? String.format("%d:%02d:%02d.", second / 36000, second % 3600 / 6000, second % 6000) : String.format("%02d:%02d", second / 60, second % 60);
        if (ms != 0) {
            ret = String.valueOf(ret) + "." + String.valueOf(ms);
        }
        return ret;
    }

    protected boolean checkOverlapFromPrevItem(DAChartSeries series, int index) {
        double val = series.getSeriesItemList().get(index).getX();
        if (index <= 0) {
            return false;
        }
        double prevVal = series.getSeriesItemList().get(index - 1).getX();
        int pixelStartX = this.plot.getXPixelFromX(val, this.r);
        int pixelStartPrevX = this.plot.getXPixelFromX(prevVal, this.r);
        return pixelStartPrevX + 2 >= pixelStartX;
    }

    protected double getMaxYToDraw(DAChartSeries series, int startIndex) {
        if (!this.plot.isSeriesHeightRange()) {
            return this.plot.getVisibleEndY();
        }
        double maxY = 0.0;
        DAChartPlot.AutoRangeType autoRangeType = this.plot.getAutoHeightRange();
        if (autoRangeType == DAChartPlot.AutoRangeType.MANUAL) {
            maxY = series.getEndY();
        } else if (autoRangeType == DAChartPlot.AutoRangeType.SEMI_AUTO) {
            maxY = series.getMaxY();
        } else if (autoRangeType == DAChartPlot.AutoRangeType.AUTO) {
            List<DAChartSeriesItem> seriesItemList = series.getSeriesItemList();
            int i = startIndex;
            while (i < seriesItemList.size()) {
                DAChartSeriesItem seriesItem = seriesItemList.get(i);
                if (seriesItem.getX() > this.plot.getVisibleEndX()) break;
                if (maxY < seriesItem.getY()) {
                    maxY = seriesItem.getY();
                }
                ++i;
            }
        }
        this.plot.setAxisEndY(maxY * 1.1);
        return maxY * 1.1;
    }

    /*
     * Unable to fully structure code
     */
    protected void drawTooltip(GC gc) {
        if (this.plot instanceof DAScreenshotChartPlot) {
            return;
        }
        tooltip = this.plot.getTooltip();
        if (tooltip == null || !tooltip.shouldBeDrawn() || tooltip.getStartVal() == -1.0) {
            return;
        }
        gc.setFont(tooltip.getFont());
        tooltipTexts = new ArrayList<String>();
        tooltipTimes = new ArrayList<String>();
        tooltipColor = new ArrayList<Color>();
        isMultiColumn = false;
        seriesCountPerColumn = this.findColumnSeriesCount(this.seriesList.size(), this.r.height);
        if (seriesCountPerColumn < this.seriesList.size()) {
            isMultiColumn = true;
        }
        textWidthMax = 0;
        realXVal = tooltip.getStartVal();
        tooltipSize = 0;
        i = 0;
        while (i < this.seriesList.size()) {
            block25: {
                series = this.seriesList.get(i);
                if (!(this.plot instanceof DAUIEventChartPlot)) break block25;
                i = (int)((double)this.seriesList.size() * tooltip.getYPosRatio());
                series = this.seriesList.get(i);
                ** GOTO lbl34
            }
            if (series.isDisableTooltip()) {
                tooltipTexts.add(null);
                tooltipTimes.add(null);
                tooltipColor.add(null);
            } else {
                ++tooltipSize;
lbl34:
                // 2 sources

                index = series.getPrevIndexByXvalue(realXVal);
                text = "";
                time = "";
                if (index >= 0) {
                    yVal = series.getSeriesItemList().get(index).getY();
                    xVal = series.getSeriesItemList().get(index).getX();
                    if (!(this.plot instanceof DAUIEventChartPlot)) {
                        text = String.valueOf(text) + series.getName() + ": ";
                        time = String.valueOf(time) + this.toTimeFormat(xVal);
                    }
                    text = series.isSummarizeTooltip() != false && this.checkOverlapFromPrevItem(series, index) != false ? String.valueOf(text) + series.getSummarizeString() : String.valueOf(text) + series.getSeriesItemList().get(index).getTooltipText();
                    gc.setForeground(tooltip.getLineColor());
                    gc.setLineStyle(3);
                    gc.setLineWidth(1);
                    if (series.getStyle() == 2 || series.getStyle() == 1 || series.getStyle() == 3) {
                        startIndex = series.getPrevIndexByXvalue(this.plot.getVisibleStartX());
                        if (startIndex < 0) {
                            startIndex = 0;
                        }
                        maxY = this.getMaxYToDraw(series, startIndex);
                        gc.drawLine(0, this.plot.getYPixelFromY(maxY, yVal, this.r), this.r.width, this.plot.getYPixelFromY(maxY, yVal, this.r));
                    }
                    gc.setForeground(ColorResources.CHART_TOOLTIP_TIME_NOW);
                    gc.setLineWidth(2);
                    gc.drawLine(this.plot.getXPixelFromX(xVal), 0, this.plot.getXPixelFromX(xVal), this.r.height);
                    gc.setLineStyle(6);
                    color = series.getSeriesItemList().get(index).getColor();
                } else {
                    text = series.getName();
                    color = null;
                }
                tooltipTexts.add(text);
                tooltipTimes.add(time);
                tooltipColor.add(color);
                timeMargin = 20;
                if (isMultiColumn) {
                    timeMargin = 10;
                }
                if (textWidthMax < (textWidth = gc.textExtent((String)text).x + timeMargin + gc.textExtent((String)time).x)) {
                    textWidthMax = textWidth;
                }
                if (this.plot instanceof DAUIEventChartPlot) break;
            }
            ++i;
        }
        preTextWidthMargin = 14;
        totalHeight = this.plot instanceof DAUIEventChartPlot ? (!tooltipTexts.isEmpty() ? gc.textExtent((String)((String)tooltipTexts.get((int)0))).y + 4 + 4 : 18) : seriesCountPerColumn * 10 + 4 + 5 + (seriesCountPerColumn - 1) * 8;
        if (this.plot instanceof DAUIEventChartPlot) {
            tooltipSize = this.seriesList.size();
            startY = this.r.height * (int)(tooltip.getYPosRatio() * (double)tooltipSize) / tooltipSize;
            if (this.r.height - startY - totalHeight < 0 && (startY = this.r.height - totalHeight - 1) < 0) {
                startY = 4;
            }
        } else {
            startY = this.r.y + this.r.height / 2 - totalHeight / 2;
        }
        columnCount = tooltipSize / seriesCountPerColumn;
        if (tooltipSize % seriesCountPerColumn != 0) {
            ++columnCount;
        }
        startX = this.getTooltipStartX(realXVal, (preTextWidthMargin + textWidthMax) * columnCount, 4);
        tooltipBoxWidth = (preTextWidthMargin + textWidthMax) * columnCount;
        gc.setAlpha(150);
        gc.setBackground(ColorResources.WHITE);
        gc.setForeground(ColorResources.WHITE);
        gc.fillGradientRectangle(startX, startY, tooltipBoxWidth, totalHeight, true);
        gc.setLineWidth(1);
        gc.setAlpha(255);
        gc.setForeground(ColorResources.POINT);
        gc.drawRoundRectangle(startX, startY, tooltipBoxWidth, totalHeight, 5, 5);
        gc.setFont(tooltip.getFont());
        tooltipSize = -1;
        i = 0;
        while (i < this.seriesList.size()) {
            block28: {
                block27: {
                    block26: {
                        if (!(this.plot instanceof DAUIEventChartPlot)) break block26;
                        series = this.seriesList.get((int)((double)this.seriesList.size() * tooltip.getYPosRatio()));
                        tooltipSize = 0;
                        break block27;
                    }
                    series = this.seriesList.get(i);
                    if (series.isDisableTooltip()) break block28;
                    ++tooltipSize;
                }
                y = startY + 10 * (tooltipSize % seriesCountPerColumn) + 4 + i % seriesCountPerColumn * 8;
                col = (Color)tooltipColor.get(i);
                if (col == null) {
                    gc.setBackground(series.getColor());
                } else {
                    gc.setBackground(col);
                }
                alpha = series.getAlpha() + 0.3;
                if (alpha > 1.0) {
                    alpha = 1.0;
                }
                gc.setAlpha((int)(255.0 * alpha));
                startColumnX = startX + i / seriesCountPerColumn * (preTextWidthMargin + textWidthMax);
                gc.fillRoundRectangle(startColumnX + 4, y + 5 - 3, 6, 6, 6, 6);
                gc.setBackground(tooltip.getBackgroundColor());
                gc.setAlpha(255);
                gc.setForeground(tooltip.getTextColor());
                gc.drawText((String)tooltipTexts.get(i), startColumnX + 4 + 6 + 4, y, 3);
                gc.setForeground(tooltip.getTimeColor());
                timeStr = (String)tooltipTimes.get(i);
                gc.drawText((String)tooltipTimes.get(i), startX + 4 + 6 + textWidthMax - gc.textExtent((String)timeStr).x + i / seriesCountPerColumn * (preTextWidthMargin + textWidthMax), y, 3);
                if (this.plot instanceof DAUIEventChartPlot) break;
            }
            ++i;
        }
    }

    public int findColumnSeriesCount(int tooltipSize, int maxSize) {
        int maxSeriesCount = (maxSize - 4 + 5) / 18;
        return tooltipSize > maxSeriesCount ? maxSeriesCount : tooltipSize;
    }

    private void drawBarSeries(GC gc, DAChartSeries series) {
        List<DAChartSeriesItem> seriesItems = series.getSeriesItemList();
        if (seriesItems == null) {
            return;
        }
        int seriesItemSize = seriesItems.size();
        if (seriesItemSize < 1) {
            return;
        }
        Color color = series.getColor();
        gc.setBackground(color);
        gc.setAlpha(204);
        gc.setAntialias(1);
        int barAlign = series.getBarAlign();
        int index = series.getPrevIndexByXvalue(this.plot.getVisibleStartX());
        if (index < 0) {
            index = 0;
        }
        double maxY = this.getMaxYToDraw(series, index);
        int i = index;
        while (i < seriesItemSize) {
            DAChartSeriesItem seriesItem = seriesItems.get(i);
            double barWidthTime = 0.0;
            barWidthTime = seriesItem.getBarWidth() == -1.0 ? series.getBarWidth() : seriesItem.getBarWidth();
            double currentX = seriesItem.getX();
            int pixelStartX = this.plot.getXPixelFromX(seriesItem.getX(), this.r);
            int pixelStartY = this.plot.getYPixelFromY(maxY, seriesItem.getY(), this.r);
            int barWidth = this.plot.getXPixelFromX(currentX + barWidthTime, this.r) - pixelStartX;
            if (barWidth < 1) {
                barWidth = 1;
            }
            if (barAlign == 1) {
                pixelStartX -= barWidth / 2;
            } else if (barAlign == 2) {
                pixelStartX -= barWidth;
            }
            color = seriesItem.getColor();
            if (color != null) {
                gc.setBackground(color);
                gc.fillRectangle(pixelStartX, pixelStartY, barWidth, this.r.y + this.r.height - pixelStartY);
                gc.setBackground(series.getColor());
            } else {
                DAChartPlot.BoundType boundType = this.plot.getBoundType();
                if (boundType != null) {
                    double boundValue = this.plot.getBoundValue();
                    if (boundType == DAChartPlot.BoundType.UNDER) {
                        gc.setBackground(ColorResources.DARK_YELLOW);
                    } else if (boundValue != -1.0 && seriesItem.getY() > boundValue) {
                        gc.setBackground(ColorResources.DARK_YELLOW);
                    }
                }
                gc.fillRectangle(pixelStartX, pixelStartY, barWidth, this.r.y + this.r.height - pixelStartY);
                gc.setBackground(series.getColor());
            }
            if (currentX > this.plot.getVisibleEndX()) break;
            ++i;
        }
    }

    private void drawMultiCheckBarSeries(GC gc, DAChartSeries series, int seriesIndex, int seriesSize) {
        int seriesItemSize;
        List<DAChartSeriesItem> seriesItems = series.getSeriesItemList();
        if (seriesItems == null) {
            return;
        }
        Rectangle rect = new Rectangle(this.r.x, this.r.y + this.r.height / seriesSize * seriesIndex, this.r.width, this.r.height / seriesSize);
        if (this.r.height == 79) {
            gc.setForeground(ColorResources.SERIES_NAME_ANNOTATION);
            Font oriFont = gc.getFont();
            Font nameAnnotationFont = series.getFont();
            gc.setFont(nameAnnotationFont);
            gc.drawText(series.getName(), rect.x + 3, rect.y + rect.height / 2 - gc.stringExtent((String)series.getName()).y / 2 + seriesIndex, true);
            gc.setFont(oriFont);
        }
        if (seriesIndex != 0) {
            gc.setForeground(ColorResources.CHART_SEPERATE_LINE);
            gc.drawLine(rect.x, rect.y, rect.width, rect.y);
        }
        if ((seriesItemSize = seriesItems.size()) < 1) {
            return;
        }
        Color color = series.getColor();
        gc.setBackground(color);
        gc.setAlpha(51);
        int index = series.getPrevIndexByXvalue(this.plot.getVisibleStartX());
        if (index < 0) {
            index = 0;
        }
        int highlightedIndexX = ((DAUIEventChartPlot)this.plot).getHighlightedEventIndexX();
        int highlightedIndexY = ((DAUIEventChartPlot)this.plot).getHighlightedEventIndexY();
        int i = index;
        while (i < seriesItemSize) {
            DAChartSeriesItem seriesItem = seriesItems.get(i);
            double currentX = seriesItem.getX();
            int pixelStartX = this.plot.getXPixelFromX(currentX, rect);
            int pixelStartY = rect.y + 3;
            if (highlightedIndexY == seriesIndex && highlightedIndexX == i) {
                pixelStartY -= 8;
            }
            if ((color = seriesItem.getColor()) != null) {
                gc.setBackground(color);
                gc.fillRectangle(pixelStartX, pixelStartY, 2, rect.height - 3);
                gc.setBackground(series.getColor());
            } else {
                gc.fillRectangle(pixelStartX, pixelStartY, 2, rect.height - 3);
            }
            if (currentX > this.plot.getVisibleEndX()) break;
            ++i;
        }
    }

    private void drawLineSeries(GC gc, DAChartSeries series, boolean bEndVal) {
        int endX;
        List<DAChartSeriesItem> seriesItems = series.getSeriesItemList();
        if (seriesItems == null) {
            return;
        }
        int seriesItemSize = seriesItems.size();
        if (seriesItemSize < 1) {
            return;
        }
        int index = series.getPrevIndexByXvalue(this.plot.getVisibleStartX());
        if (index < 0) {
            index = 0;
        }
        double maxY = this.getMaxYToDraw(series, index);
        DAChartSeriesItem seriesItem = seriesItems.get(0);
        int oldPixelX = this.plot.getXPixelFromX(seriesItem.getX(), this.r);
        int oldPixelY = this.plot.getYPixelFromY(maxY, seriesItem.getY(), this.r);
        if (seriesItemSize == 1) {
            if (oldPixelX < this.r.x) {
                return;
            }
            Color color = seriesItem.getColor();
            if (color == null) {
                color = series.getColor();
            }
            gc.setForeground(color);
            gc.drawPoint(oldPixelX, oldPixelY);
            return;
        }
        Color color = series.getColor();
        gc.setAlpha(204);
        gc.setForeground(color);
        gc.setLineStyle(1);
        gc.setAntialias(1);
        seriesItem = seriesItems.get(index);
        double currentX = seriesItem.getX();
        int newPixelX = this.plot.getXPixelFromX(currentX, this.r);
        int newPixelY = this.plot.getYPixelFromY(maxY, seriesItem.getY(), this.r);
        ArrayList<Integer> points = new ArrayList<Integer>();
        points.add(newPixelX);
        points.add(newPixelY);
        int i = index;
        while (i < seriesItemSize) {
            seriesItem = seriesItems.get(i);
            currentX = seriesItem.getX();
            newPixelX = this.plot.getXPixelFromX(currentX, this.r);
            newPixelY = this.plot.getYPixelFromY(maxY, seriesItem.getY(), this.r);
            points.add(newPixelX);
            points.add(newPixelY);
            if (currentX > this.plot.getVisibleEndX()) break;
            ++i;
        }
        gc.drawPolyline(this.convertArray(points));
        if (bEndVal && (endX = this.plot.getXPixelFromX(this.plot.getValidEndX(), this.r)) > newPixelX) {
            gc.drawLine(newPixelX, newPixelY, endX, newPixelY);
        }
    }

    private void drawAreaSeries(GC gc, DAChartSeries series, boolean bEndVal) {
        int endX;
        List<DAChartSeriesItem> seriesItems = series.getSeriesItemList();
        if (seriesItems == null) {
            return;
        }
        int seriesItemSize = seriesItems.size();
        if (seriesItemSize < 1) {
            return;
        }
        int index = series.getPrevIndexByXvalue(this.plot.getVisibleStartX());
        if (index < 0) {
            index = 0;
        }
        double maxY = this.getMaxYToDraw(series, index);
        DAChartSeriesItem seriesItem = seriesItems.get(0);
        int oldPixelX = this.plot.getXPixelFromX(seriesItem.getX(), this.r);
        int oldPixelY = this.plot.getYPixelFromY(maxY, seriesItem.getY(), this.r);
        int baseY = this.r.y + this.r.height;
        if (seriesItemSize == 1) {
            if (oldPixelX < this.r.x) {
                return;
            }
            Color color = seriesItem.getColor();
            if (color == null) {
                color = series.getColor();
            }
            gc.setForeground(color);
            gc.drawLine(oldPixelX, baseY, oldPixelX, oldPixelY);
            return;
        }
        Color color = series.getColor();
        double alpha = series.getAlpha();
        gc.setAntialias(1);
        gc.setAlpha((int)(255.0 * alpha));
        gc.setForeground(color);
        gc.setBackground(color);
        seriesItem = seriesItems.get(index);
        double currentX = seriesItem.getX();
        int newPixelX = this.plot.getXPixelFromX(currentX, this.r);
        int newPixelY = this.plot.getYPixelFromY(maxY, seriesItem.getY(), this.r);
        ArrayList<Integer> points = new ArrayList<Integer>();
        points.add(newPixelX);
        points.add(baseY);
        points.add(newPixelX);
        points.add(newPixelY);
        int i = index;
        while (i < seriesItemSize) {
            seriesItem = seriesItems.get(i);
            currentX = seriesItem.getX();
            newPixelX = this.plot.getXPixelFromX(currentX, this.r);
            newPixelY = this.plot.getYPixelFromY(maxY, seriesItem.getY(), this.r);
            points.add(newPixelX);
            points.add(newPixelY);
            if (i == seriesItemSize - 1 || currentX > this.plot.getVisibleEndX()) {
                points.add(newPixelX);
                points.add(baseY);
            }
            if (currentX > this.plot.getVisibleEndX()) break;
            ++i;
        }
        int[] pointArray = this.convertArray(points);
        gc.fillPolygon(pointArray);
        gc.drawPolygon(pointArray);
        if (bEndVal && (endX = this.plot.getXPixelFromX(this.plot.getValidEndX(), this.r)) > newPixelX) {
            gc.setAlpha(102);
            int[] polygon = new int[]{newPixelX, baseY, newPixelX, newPixelY, endX, newPixelY, endX, baseY};
            gc.fillPolygon(polygon);
        }
        gc.setAlpha(255);
    }

    private void drawStateAreaSeries(GC gc, DAChartSeries series, int seriesIndex, int seriesSize) {
        int oldAlpha = gc.getAlpha();
        gc.setAlpha(204);
        List<DAChartSeriesItem> seriesItems = series.getSeriesItemList();
        if (seriesItems == null) {
            return;
        }
        int seriesItemSize = seriesItems.size();
        if (seriesItemSize < 1) {
            return;
        }
        int index = series.getPrevIndexByXvalue(this.plot.getVisibleStartX());
        if (index < 0) {
            index = 0;
        }
        Color DIAGONAL_BOX_COLOR = ColorResources.WHITE;
        int margin = (int)((double)this.r.height * 0.2 / (double)(seriesSize + 1));
        int areaHeight = (this.r.height - margin * (seriesSize + 1)) / seriesSize;
        int pixelStartY = margin * (seriesIndex + 1) + areaHeight * seriesIndex;
        ArrayList<DAChartSeriesItem> barSeriesItems = new ArrayList<DAChartSeriesItem>();
        int i = 0;
        while (i < seriesItemSize) {
            DAChartSeriesItem seriesItem = seriesItems.get(i);
            DAChartSeriesItem endSeriesItem = null;
            int type = (int)seriesItem.getY();
            if (type == 0) {
                int startCount = 1;
                int ii = i + 1;
                while (ii < seriesItemSize) {
                    DAChartSeriesItem nextSeriesItem = seriesItems.get(ii);
                    int nextType = (int)nextSeriesItem.getY();
                    if (nextType == 0) {
                        ++startCount;
                    } else if (nextType == 1 && --startCount == 0) {
                        endSeriesItem = nextSeriesItem;
                        break;
                    }
                    ++ii;
                }
                Color foreGroundColor = seriesItem.getGradationForegroundColor();
                Color backGroundcolor = seriesItem.getColor();
                gc.setForeground(foreGroundColor);
                gc.setBackground(backGroundcolor);
                int pixelStartX = this.plot.getXPixelFromX(seriesItem.getX(), this.r);
                int pixelWidth = endSeriesItem != null ? this.plot.getXPixelFromX(endSeriesItem.getX(), this.r) - pixelStartX : this.plot.getXPixelFromX(this.plot.getValidEndX(), this.r) - pixelStartX;
                if (pixelWidth == 0) {
                    pixelWidth = 1;
                }
                gc.fillRectangle(pixelStartX, pixelStartY, pixelWidth, areaHeight);
                if (seriesItem.getDiagonal()) {
                    int diagonalBoxSize = areaHeight / 16;
                    gc.setForeground(DIAGONAL_BOX_COLOR);
                    gc.setBackground(DIAGONAL_BOX_COLOR);
                    int j = 0;
                    while (j < 16) {
                        int boxY = pixelStartY + diagonalBoxSize * j;
                        int k = 3 - j % 4 - j / 4;
                        while (k < pixelWidth) {
                            int boxX = diagonalBoxSize * k + pixelStartX;
                            if (pixelStartX <= boxX && boxX <= pixelWidth + pixelStartX - diagonalBoxSize) {
                                gc.fillRectangle(boxX, boxY, diagonalBoxSize, diagonalBoxSize);
                            }
                            k += 3;
                        }
                        ++j;
                    }
                }
            } else if (2 == type) {
                barSeriesItems.add(seriesItem);
            }
            ++i;
        }
        i = 0;
        while (i < barSeriesItems.size()) {
            DAChartSeriesItem barSeriesItem = (DAChartSeriesItem)barSeriesItems.get(i);
            Color foreGroundColor = barSeriesItem.getGradationForegroundColor();
            Color backGroundcolor = barSeriesItem.getColor();
            gc.setForeground(foreGroundColor);
            gc.setBackground(backGroundcolor);
            int pixelStartX = this.plot.getXPixelFromX(barSeriesItem.getX(), this.r);
            gc.fillRectangle(pixelStartX, pixelStartY, 1, areaHeight);
            ++i;
        }
        gc.setAlpha(oldAlpha);
    }

    private void drawStepSeries(GC gc, DAChartSeries series, boolean bEndVal) {
        int endX;
        List<DAChartSeriesItem> seriesItems = series.getSeriesItemList();
        if (seriesItems == null) {
            return;
        }
        int seriesItemSize = seriesItems.size();
        if (seriesItemSize < 1) {
            return;
        }
        int index = series.getPrevIndexByXvalue(this.plot.getVisibleStartX());
        if (index < 0) {
            index = 0;
        }
        double maxY = this.getMaxYToDraw(series, index);
        DAChartSeriesItem seriesItem = seriesItems.get(0);
        int oldPixelX = this.plot.getXPixelFromX(seriesItem.getX(), this.r);
        int oldPixelY = this.plot.getYPixelFromY(maxY, seriesItem.getY(), this.r);
        if (seriesItemSize == 1) {
            if (oldPixelX < this.r.x) {
                return;
            }
            Color color = seriesItem.getColor();
            if (color == null) {
                color = series.getColor();
            }
            gc.setForeground(color);
            gc.drawPoint(oldPixelX, oldPixelY);
            return;
        }
        Color color = series.getColor();
        gc.setForeground(color);
        gc.setLineStyle(1);
        seriesItem = seriesItems.get(index);
        double currentX = seriesItem.getX();
        int newPixelX = this.plot.getXPixelFromX(currentX, this.r);
        int newPixelY = this.plot.getYPixelFromY(maxY, seriesItem.getY(), this.r);
        int i = index;
        while (i < seriesItemSize) {
            seriesItem = seriesItems.get(i);
            currentX = seriesItem.getX();
            oldPixelX = newPixelX;
            oldPixelY = newPixelY;
            newPixelX = this.plot.getXPixelFromX(currentX, this.r);
            newPixelY = this.plot.getYPixelFromY(maxY, seriesItem.getY(), this.r);
            gc.drawLine(oldPixelX, oldPixelY, newPixelX, oldPixelY);
            gc.drawLine(newPixelX, oldPixelY, newPixelX, newPixelY);
            if (currentX > this.plot.getVisibleEndX()) {
                return;
            }
            ++i;
        }
        if (bEndVal && (endX = this.plot.getXPixelFromX(this.plot.getValidEndX(), this.r)) > newPixelX) {
            gc.drawLine(newPixelX, newPixelY, endX, newPixelY);
        }
    }

    private void drawImageSeries(GC gc, DAChartSeries series) {
        int pixelStartX;
        List<DAChartSeriesItem> seriesItems = series.getSeriesItemList();
        if (seriesItems == null || !(this.plot instanceof DAScreenshotChartPlot)) {
            return;
        }
        int seriesItemSize = seriesItems.size();
        if (seriesItemSize < 1) {
            return;
        }
        int index = series.getPrevIndexByXvalue(this.plot.getVisibleStartX());
        if (index < 0) {
            index = 0;
        }
        int highlightedImageIndex = ((DAScreenshotChartPlot)this.plot).getHighlightedImageIndex();
        int selectedImageIndex = ((DAScreenshotChartPlot)this.plot).getSelectedImageIndex();
        int i = index;
        while (i < seriesItemSize) {
            DAChartSeriesItem seriesItem = seriesItems.get(i);
            if (seriesItem != null) {
                double currentX = seriesItem.getX();
                pixelStartX = this.plot.getXPixelFromX(currentX, this.r);
                Image image = seriesItem.getImage();
                int yPosition = (this.r.height - image.getBounds().height) / 2 - 1;
                if (this.r.height != 79) {
                    image = new Image((Device)Display.getDefault(), image.getImageData().scaledTo(image.getBounds().width / 2, image.getBounds().height / 2));
                    yPosition = 4;
                }
                if (i != highlightedImageIndex && i != selectedImageIndex) {
                    gc.drawImage(image, pixelStartX, yPosition);
                    gc.setLineWidth(1);
                    gc.setForeground(ColorResources.SCREENSHOT_CHART_BORDER_LINE);
                    gc.drawRectangle(pixelStartX, yPosition, image.getBounds().width, image.getBounds().height);
                }
                if (currentX > this.plot.getVisibleEndX()) break;
            }
            ++i;
        }
        if (selectedImageIndex >= 0 && selectedImageIndex < seriesItems.size()) {
            gc.setForeground(ColorResources.SCREENSHOT_CHART_SELECTED_LINE);
            gc.setLineWidth(2);
            DAChartSeriesItem seriesItem = seriesItems.get(selectedImageIndex);
            Image selectedImage = seriesItem.getImage();
            int yPosition = (this.r.height - selectedImage.getBounds().height) / 2 - 1;
            int highlightedYPosition = 4;
            if (this.r.height != 79) {
                selectedImage = new Image((Device)Display.getDefault(), selectedImage.getImageData().scaledTo(selectedImage.getBounds().width / 2, selectedImage.getBounds().height / 2));
                yPosition = 4;
                highlightedYPosition = 1;
            }
            pixelStartX = this.plot.getXPixelFromX(seriesItem.getX(), this.r);
            int screenshotWidth = selectedImage.getBounds().width;
            int screenshotHeight = selectedImage.getBounds().height;
            if (selectedImageIndex == highlightedImageIndex) {
                gc.drawRectangle(pixelStartX - 1, highlightedYPosition - 1, screenshotWidth + 3, screenshotHeight + 3);
            } else {
                gc.drawImage(selectedImage, pixelStartX, yPosition);
                gc.drawRectangle(pixelStartX - 1, this.r.y + yPosition - 1, screenshotWidth + 3, screenshotHeight + 3);
                gc.setLineWidth(1);
                gc.setForeground(ColorResources.SCREENSHOT_CHART_BORDER_LINE);
                gc.drawRectangle(pixelStartX, yPosition, screenshotWidth, screenshotHeight);
            }
        }
        if (highlightedImageIndex >= 0 && highlightedImageIndex < seriesItems.size()) {
            DAChartSeriesItem seriesItem = seriesItems.get(highlightedImageIndex);
            Image highlightedImage = seriesItem.getImage();
            int highlightedYPosition = 4;
            if (this.r.height != 79) {
                highlightedImage = new Image((Device)Display.getDefault(), highlightedImage.getImageData().scaledTo(highlightedImage.getBounds().width / 2, highlightedImage.getBounds().height / 2));
                highlightedYPosition = 1;
            }
            double currentX = seriesItems.get(highlightedImageIndex).getX();
            int pixelStartX2 = this.plot.getXPixelFromX(currentX, this.r);
            int screenshotWidth = highlightedImage.getBounds().width;
            int screenshotHeight = highlightedImage.getBounds().height;
            gc.drawImage(highlightedImage, pixelStartX2, highlightedYPosition);
            gc.setLineWidth(1);
            gc.setForeground(ColorResources.SCREENSHOT_CHART_BORDER_LINE);
            gc.drawRectangle(pixelStartX2, highlightedYPosition, screenshotWidth, screenshotHeight);
        }
    }

    private void drawEventSeries(GC gc, DAChartSeries series) {
        List<DAChartSeriesItem> seriesItems = series.getSeriesItemList();
        if (seriesItems == null) {
            return;
        }
        int seriesItemSize = seriesItems.size();
        if (seriesItemSize < 1) {
            return;
        }
        Color color = series.getColor();
        gc.setBackground(color);
        gc.setForeground(ColorResources.BLACK);
        gc.setAntialias(1);
        int oldAlpha = gc.getAlpha();
        gc.setAlpha(204);
        int index = series.getPrevIndexByXvalue(this.plot.getVisibleStartX());
        if (index < 0) {
            index = 0;
        }
        int i = index;
        while (i < seriesItemSize) {
            DAChartSeriesItem seriesItem = seriesItems.get(i);
            double currentX = seriesItem.getX();
            int pixelStartX = this.plot.getXPixelFromX(seriesItem.getX(), this.r);
            Color itemColor = seriesItem.getColor();
            int barHeight = (int)((double)(this.r.y + this.r.height) * 0.2);
            if (itemColor != null) {
                gc.setBackground(itemColor);
                gc.fillRectangle(pixelStartX, this.r.y + barHeight, 2, barHeight);
                gc.setBackground(color);
            } else {
                gc.fillRectangle(pixelStartX, this.r.y + barHeight, 2, barHeight);
            }
            if (currentX > this.plot.getVisibleEndX()) break;
            ++i;
        }
        gc.setAlpha(oldAlpha);
    }

    private void drawEventAreaSeries(GC gc, DAChartSeries series) {
        List<DAChartSeriesItem> seriesItems = series.getSeriesItemList();
        if (seriesItems == null) {
            return;
        }
        int seriesItemSize = seriesItems.size();
        if (seriesItemSize < 1) {
            return;
        }
        Color color = series.getColor();
        gc.setBackground(color);
        gc.setAntialias(1);
        int index = series.getPrevIndexByXvalue(this.plot.getVisibleStartX());
        if (index < 0) {
            index = 0;
        }
        int i = index;
        while (i < seriesItemSize) {
            DAChartSeriesItem seriesItem = seriesItems.get(i);
            double currentStartX = seriesItem.getX();
            double currentEndX = seriesItem.getY();
            int pixelStartX = this.plot.getXPixelFromX(currentStartX, this.r);
            int pixelEndX = this.plot.getXPixelFromX(currentEndX, this.r);
            int width = pixelEndX - pixelStartX;
            if (width < 2) {
                width = 2;
            }
            Color itemColor = seriesItem.getColor();
            int barHeight = (int)((double)(this.r.y + this.r.height) * 0.2);
            if (itemColor != null) {
                gc.setBackground(itemColor);
                gc.fillRectangle(pixelStartX, this.r.y + this.r.height - barHeight * 2, width, barHeight);
                gc.setBackground(color);
            } else {
                gc.fillRectangle(pixelStartX, this.r.y + this.r.height - barHeight * 2, width, barHeight);
            }
            if (currentStartX > this.plot.getVisibleEndX()) break;
            ++i;
        }
    }

    private void drawLoadSeries(GC gc, DAChartSeries series) {
        DAChartSeriesItem seriesItem;
        List<DAChartSeriesItem> seriesItems = series.getSeriesItemList();
        if (seriesItems == null) {
            return;
        }
        int seriesItemSize = seriesItems.size();
        if (seriesItemSize < 1) {
            return;
        }
        gc.setBackground(ColorResources.WHITE);
        gc.setAntialias(1);
        int index = series.getPrevIndexByXvalue(this.plot.getVisibleStartX());
        if (index < 0) {
            index = 0;
        }
        int lastIndex = index;
        int i = index;
        while (i < seriesItemSize) {
            seriesItem = seriesItems.get(i);
            double currentX = seriesItem.getX();
            if (currentX > this.plot.getVisibleEndX()) {
                lastIndex = i;
                break;
            }
            lastIndex = i++;
        }
        int heightMargin = (int)((double)(this.r.y + this.r.height) * 0.2);
        int backStartX = this.plot.getXPixelFromX(seriesItems.get(index).getX(), this.r);
        int backWidth = this.plot.getXPixelFromX(seriesItems.get(lastIndex).getX(), this.r) - backStartX;
        gc.fillRectangle(backStartX, this.r.y + heightMargin, backWidth, this.r.y + this.r.height - heightMargin * 2);
        int i2 = index;
        while (i2 < seriesItemSize) {
            seriesItem = seriesItems.get(i2);
            double barWidthTime = seriesItem.getBarWidth();
            if (barWidthTime == -1.0) {
                barWidthTime = series.getBarWidth();
            }
            double currentX = seriesItem.getX();
            int pixelStartX = this.plot.getXPixelFromX(seriesItem.getX(), this.r);
            int barWidth = this.plot.getXPixelFromX(currentX + barWidthTime, this.r) - pixelStartX;
            if (barWidth < 1) {
                barWidth = 2;
            }
            gc.setBackground(this.getColorOfLoad(series, (float)seriesItem.getY() / 100.0f));
            gc.fillRectangle(pixelStartX, this.r.y + heightMargin, barWidth, this.r.y + this.r.height - heightMargin * 2);
            gc.setBackground(series.getColor());
            if (currentX > this.plot.getVisibleEndX()) break;
            ++i2;
        }
        gc.setAlpha(255);
    }

    private Color getColorOfLoad(DAChartSeries series, float bAmount) {
        float b;
        float g;
        Color colorA = series.getColor();
        Color colorB = series.getSecondColor();
        float aAmount = (float)(1.0 - (double)bAmount);
        float r = (float)colorA.getRed() * aAmount + (float)colorB.getRed() * bAmount;
        if (r < 0.0f) {
            r = 0.0f;
        }
        if ((g = (float)colorA.getGreen() * aAmount + (float)colorB.getGreen() * bAmount) < 0.0f) {
            g = 0.0f;
        }
        if ((b = (float)colorA.getBlue() * aAmount + (float)colorB.getBlue() * bAmount) < 0.0f) {
            b = 0.0f;
        }
        return new Color((Device)Display.getCurrent(), (int)r, (int)g, (int)b);
    }

    private void drawArrowSeries(GC gc, DAChartSeries series) {
        List<DAChartSeriesItem> seriesItems = series.getSeriesItemList();
        if (seriesItems == null) {
            return;
        }
        int seriesItemSize = seriesItems.size();
        if (seriesItemSize < 1) {
            return;
        }
        Color color = series.getColor();
        gc.setBackground(color);
        gc.setForeground(ColorResources.WHITE);
        gc.setAntialias(1);
        Font tidFont = series.getFont();
        gc.setFont(tidFont);
        int index = series.getPrevIndexByXvalue(this.plot.getVisibleStartX());
        if (index < 0) {
            index = 0;
        }
        Image arw = ImageResources.CHART_EVENT_CALLEE_ARW;
        Rectangle imageRect = arw.getBounds();
        int i = index;
        while (i < seriesItemSize) {
            DAChartSeriesItem seriesItem = seriesItems.get(i);
            double currentX = seriesItem.getX();
            double arrowPosition = seriesItem.getY();
            int pixelStartX = this.plot.getXPixelFromX(seriesItem.getX(), this.r);
            int barHeight = (int)((double)(this.r.y + this.r.height) * 0.2);
            int barPosY = this.r.y + this.r.height - barHeight * 2;
            gc.fillRectangle(pixelStartX, barPosY, 2, barHeight);
            if (0.0 != arrowPosition) {
                String number = String.valueOf((int)seriesItem.getBarWidth());
                Rectangle arrowRect = imageRect;
                arrowRect.y = barPosY + barHeight / 2 - imageRect.height / 2;
                arrowRect.x = 1.0 == arrowPosition ? pixelStartX + 2 : pixelStartX - imageRect.width;
                gc.drawImage(arw, arrowRect.x, arrowRect.y);
                Point p = gc.textExtent(number, 8);
                gc.drawText(number, arrowRect.x + arrowRect.width / 2 - p.x / 2 - 2, arrowRect.y + arrowRect.height / 2 - p.y / 2, true);
            }
            if (currentX > this.plot.getVisibleEndX()) break;
            ++i;
        }
    }

    private void drawStateSeries(GC gc, DAChartSeries series) {
        List<DAChartSeriesItem> seriesItems = series.getSeriesItemList();
        if (seriesItems == null) {
            return;
        }
        int seriesItemSize = seriesItems.size();
        if (seriesItemSize < 1) {
            return;
        }
        Color color = series.getColor();
        gc.setBackground(color);
        gc.setAntialias(1);
        int oldAlpha = gc.getAlpha();
        gc.setAlpha(204);
        int index = series.getPrevIndexByXvalue(this.plot.getVisibleStartX());
        if (index < 0) {
            index = 0;
        }
        int heightMargin = (int)((double)(this.r.y + this.r.height) * 0.2);
        int prevEndX = 0;
        int i = index;
        while (i < seriesItemSize) {
            DAChartSeriesItem seriesItem = seriesItems.get(i);
            double currentX = seriesItem.getX();
            int pixelStartX = this.plot.getXPixelFromX(seriesItem.getX(), this.r);
            color = seriesItem.getColor();
            seriesItem.getGradationForegroundColor();
            int state = (int)seriesItem.getY();
            if (color != null) {
                gc.setBackground(color);
            }
            switch (state) {
                case 0: {
                    int barWidth = (int)seriesItem.getBarWidth();
                    if (barWidth == -1) {
                        barWidth = 2;
                    }
                    if (!this.equals(this.oldStateBarRectangle, pixelStartX, this.r.y + heightMargin, barWidth, this.r.y + this.r.height / 2 - heightMargin)) {
                        this.oldStateBarRectangle.x = pixelStartX;
                        this.oldStateBarRectangle.y = this.r.y + heightMargin;
                        this.oldStateBarRectangle.width = barWidth;
                        this.oldStateBarRectangle.height = this.r.y + this.r.height / 2 - heightMargin;
                        gc.fillRectangle(this.oldStateBarRectangle);
                    }
                    prevEndX = pixelStartX + barWidth;
                    break;
                }
                case 1: {
                    int diff;
                    int barWidth = i + 1 == seriesItemSize ? this.plot.getXPixelFromX(this.plot.getValidEndX(), this.r) - pixelStartX : this.plot.getXPixelFromX(seriesItems.get(i + 1).getX(), this.r) - pixelStartX;
                    if (barWidth <= 0) {
                        barWidth = 1;
                    }
                    if (pixelStartX < prevEndX) {
                        diff = prevEndX - pixelStartX;
                        pixelStartX = prevEndX;
                        barWidth -= diff;
                    }
                    if (barWidth <= 0) {
                        barWidth = 0;
                    }
                    if (!this.equals(this.oldStateContinueRectangle, pixelStartX, this.r.y + heightMargin, barWidth, this.r.y + this.r.height - heightMargin * 2)) {
                        this.oldStateContinueRectangle.x = pixelStartX;
                        this.oldStateContinueRectangle.y = this.r.y + heightMargin;
                        this.oldStateContinueRectangle.width = barWidth;
                        this.oldStateContinueRectangle.height = this.r.y + this.r.height - heightMargin * 2;
                        gc.fillRectangle(this.oldStateContinueRectangle);
                    }
                    prevEndX = pixelStartX + barWidth;
                    break;
                }
                case 2: {
                    int diff;
                    int barWidth = i + 1 < seriesItemSize ? this.plot.getXPixelFromX(seriesItems.get(i + 1).getX(), this.r) - pixelStartX : 1;
                    if (pixelStartX < prevEndX) {
                        diff = prevEndX - pixelStartX;
                        pixelStartX = prevEndX;
                        barWidth -= diff;
                    }
                    if (barWidth < 0) {
                        barWidth = 0;
                    }
                    if (!this.equals(this.oldStateConnectionRectangle, pixelStartX, this.r.y + heightMargin, barWidth, this.r.y + this.r.height - heightMargin * 2)) {
                        this.oldStateConnectionRectangle.x = pixelStartX;
                        this.oldStateConnectionRectangle.y = this.r.y + heightMargin;
                        this.oldStateConnectionRectangle.width = barWidth;
                        this.oldStateConnectionRectangle.height = this.r.y + this.r.height - heightMargin * 2;
                        gc.fillRectangle(this.oldStateConnectionRectangle);
                    }
                    prevEndX = pixelStartX + barWidth;
                    break;
                }
            }
            if (color != null) {
                gc.setBackground(series.getColor());
            }
            if (currentX > this.plot.getVisibleEndX()) break;
            ++i;
        }
        gc.setAlpha(oldAlpha);
    }

    private void drawDotSeries(GC gc, DAChartSeries series) {
        List<DAChartSeriesItem> seriesItems = series.getSeriesItemList();
        if (seriesItems == null) {
            return;
        }
        int seriesItemSize = seriesItems.size();
        if (seriesItemSize < 1) {
            return;
        }
        int index = series.getPrevIndexByXvalue(this.plot.getVisibleStartX());
        if (index < 0) {
            index = 0;
        }
        int oldAlpha = gc.getAlpha();
        Color oldBackColor = gc.getBackground();
        Color oldForeColor = gc.getForeground();
        int oldLineWidth = gc.getLineWidth();
        for (DAChartSeriesItem seriesItem : seriesItems) {
            int pixelX = this.plot.getXPixelFromX(seriesItem.getX()) - 12;
            int pixelY = 34;
            ArrayList<Integer> dotPolygon = new ArrayList<Integer>();
            dotPolygon.add(pixelX);
            dotPolygon.add(pixelY + 6);
            dotPolygon.add(pixelX + 6);
            dotPolygon.add(pixelY + 12);
            dotPolygon.add(pixelX + 12);
            dotPolygon.add(pixelY + 6);
            dotPolygon.add(pixelX + 6);
            dotPolygon.add(pixelY);
            int[] pointArray = this.convertArray(dotPolygon);
            gc.setForeground(ColorResources.SCREENSHOT_CHART_DOT);
            gc.setBackground(ColorResources.SCREENSHOT_CHART_DOT);
            gc.fillPolygon(pointArray);
        }
        gc.setAlpha(oldAlpha);
        gc.setBackground(oldBackColor);
        gc.setForeground(oldForeColor);
        gc.setLineWidth(oldLineWidth);
    }

    private boolean equals(Rectangle rect, int x, int y, int width, int height) {
        return rect.x == x && rect.y == y && rect.width == width && rect.height == height;
    }

    private int[] convertArray(List<Integer> list) {
        int[] array = new int[list.size()];
        int i = 0;
        while (i < list.size()) {
            array[i] = list.get(i);
            ++i;
        }
        return array;
    }
}

