/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.widgets.chartBoard;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.tizen.dynamicanalyzer.widgets.chartBoard.DAChartBoard;
import org.tizen.dynamicanalyzer.widgets.chartBoard.DAChartBoardItem;

public class DAChartBoardItemList
extends Composite {
    private List<DAChartBoardItem> childItems = new ArrayList<DAChartBoardItem>();
    private DAChartBoard parentBoard;
    private DAChartBoardItem parentItem;

    public DAChartBoardItemList(DAChartBoard parentBoard) {
        super(parentBoard.getListComposite(), 0);
        this.parentBoard = parentBoard;
    }

    public DAChartBoardItemList(DAChartBoardItem parentItem) {
        super((Composite)parentItem, 0);
        this.parentItem = parentItem;
    }

    public void registerItem(DAChartBoardItem item) {
        int itemHeight = (int)((double)item.getHeight() * this.getBoardItemHeightRatio());
        FormData data = new FormData();
        int itemSize = this.childItems.size();
        data.top = itemSize == 0 ? new FormAttachment(0, 0) : new FormAttachment((Control)this.childItems.get(itemSize - 1), 0);
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        data.height = itemHeight;
        item.setLayoutData(data);
        this.childItems.add(item);
        this.layout();
    }

    public void registerItem(DAChartBoardItem item, Comparator c) {
        int itemHeight = (int)((double)item.getHeight() * this.getBoardItemHeightRatio());
        FormData data = new FormData();
        int itemSize = this.childItems.size();
        data.top = itemSize == 0 ? new FormAttachment(0, 0) : new FormAttachment((Control)this.childItems.get(itemSize - 1), 0);
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        data.height = itemHeight;
        item.setLayoutData(data);
        this.childItems.add(item);
        Collections.sort(this.childItems, c);
        itemSize = this.childItems.size();
        int i = 0;
        while (i < itemSize) {
            FormData formdata = (FormData)this.childItems.get(i).getLayoutData();
            formdata.top = i == 0 ? new FormAttachment(0, 0) : new FormAttachment((Control)this.childItems.get(i - 1), 0);
            ++i;
        }
        this.layout();
    }

    public int getListHeight() {
        int listHeight = 0;
        for (DAChartBoardItem childItem : this.childItems) {
            listHeight += childItem.getItemHeight();
        }
        return listHeight;
    }

    public void notifyResizeChild(DAChartBoardItem item) {
        for (DAChartBoardItem childItem : this.childItems) {
            if (!((Object)((Object)childItem)).equals((Object)item)) continue;
            FormData data = (FormData)childItem.getLayoutData();
            data.height = childItem.getItemHeight();
            childItem.setLayoutData(data);
        }
    }

    public int getItemSize() {
        return this.childItems.size();
    }

    public void minimize() {
        for (DAChartBoardItem item : this.childItems) {
            item.minimize();
        }
    }

    public void unMinimize() {
        for (DAChartBoardItem item : this.childItems) {
            item.unMinimize();
        }
    }

    protected void setChartAxis(double startX, double endX) {
        if (this.childItems == null) {
            return;
        }
        int itemsSize = this.childItems.size();
        int i = 0;
        while (i < itemsSize) {
            this.childItems.get(i).setChartAxis(startX, endX);
            ++i;
        }
    }

    protected void setChartValidX(double endX) {
        if (this.childItems == null) {
            return;
        }
        int itemsSize = this.childItems.size();
        int i = 0;
        while (i < itemsSize) {
            this.childItems.get(i).setChartValidX(endX);
            ++i;
        }
    }

    public void clear() {
        if (this.childItems == null) {
            return;
        }
        int itemsSize = this.childItems.size();
        int i = 0;
        while (i < itemsSize) {
            this.childItems.get(i).clear();
            this.childItems.get(i).dispose();
            ++i;
        }
        this.childItems.clear();
    }

    public void contentsClear() {
        if (this.childItems == null) {
            return;
        }
        int itemsSize = this.childItems.size();
        int i = 0;
        while (i < itemsSize) {
            this.childItems.get(i).contentsClear();
            ++i;
        }
    }

    public void hideItem(int index) {
        DAChartBoardItem child = this.childItems.get(index);
        if (!child.isHidden()) {
            child.hide();
            FormData data = (FormData)child.getLayoutData();
            data.height = 0;
            child.setLayoutData(data);
        }
        this.layout();
    }

    public void showItem(int index) {
        DAChartBoardItem childItem = this.childItems.get(index);
        if (childItem.isHidden()) {
            childItem.show();
            int height = childItem.getItemHeight();
            FormData data = (FormData)childItem.getLayoutData();
            data.height = height;
            childItem.setLayoutData(data);
        }
        this.layout();
    }

    public void showAllItems() {
        int i = 0;
        while (i < this.childItems.size()) {
            this.showItem(i);
            DAChartBoardItemList boardItemList = this.childItems.get(i).getChildItemList();
            if (boardItemList != null) {
                int k = 0;
                while (k < boardItemList.getItemSize()) {
                    DAChartBoardItem boardItem = boardItemList.get(k);
                    if (boardItem != null && boardItem.isHidden()) {
                        boardItemList.showItem(k);
                    }
                    ++k;
                }
            }
            ++i;
        }
    }

    public void showChildItem(int parentIndex, int childIndex) {
        this.showItem(parentIndex);
        DAChartBoardItemList boardItemList = this.childItems.get(parentIndex).getChildItemList();
        if (boardItemList == null) {
            return;
        }
        boardItemList.showItem(childIndex);
        this.childItems.get(parentIndex).callNotifyResizeChild();
    }

    public void hideChildItem(int parentIndex, int childIndex) {
        DAChartBoardItemList boardItemList = this.childItems.get(parentIndex).getChildItemList();
        if (boardItemList == null) {
            return;
        }
        boardItemList.hideItem(childIndex);
        this.childItems.get(parentIndex).callNotifyResizeChild();
    }

    public void reArrangeItem(Integer[] a) {
        if (this.childItems == null) {
            return;
        }
        int itemSize = this.childItems.size();
        if (a.length != itemSize) {
            return;
        }
        ArrayList<DAChartBoardItem> itemsTemp = new ArrayList<DAChartBoardItem>();
        int i = 0;
        while (i < itemSize) {
            int index = a[i];
            DAChartBoardItem temp = this.childItems.get(index);
            FormData data = (FormData)temp.getLayoutData();
            data.top = i == 0 ? new FormAttachment(0, 0) : new FormAttachment((Control)itemsTemp.get(i - 1), 0);
            temp.setLayoutData(data);
            itemsTemp.add(temp);
            ++i;
        }
        this.childItems.clear();
        this.childItems.addAll(itemsTemp);
        itemsTemp.clear();
        itemsTemp = null;
    }

    public int getItemChartWidth() {
        int ret = this.getClientArea().width - 190;
        if (ret < 0) {
            ret = 0;
        }
        return ret;
    }

    public DAChartBoardItem get(int index) {
        int itemSize = this.childItems.size();
        if (index >= itemSize) {
            return null;
        }
        return this.childItems.get(index);
    }

    public void sort(Comparator c) {
        Collections.sort(this.childItems, c);
    }

    protected int getItemYPos(int index) {
        int pos = 0;
        int itemSize = this.childItems.size();
        if (itemSize == 0 || index >= itemSize) {
            return -1;
        }
        int i = 0;
        while (i < index) {
            pos += this.childItems.get(i).getItemHeight();
            ++i;
        }
        return pos;
    }

    private double getBoardItemHeightRatio() {
        double itemHeightRatio = this.parentBoard != null ? this.parentBoard.getItemHeightRatio() : (this.parentItem != null ? this.parentItem.getBoardItemHeightRatio() : 2.0);
        return itemHeightRatio;
    }
}

