/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.edc.internal;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.debug.edc.internal.EDCDebugger;
import org.eclipse.cdt.debug.edc.internal.EDCTrace;
import org.eclipse.core.runtime.IPath;

public class PersistentCache {
    private Map<String, CacheEntry> caches = Collections.synchronizedMap(new HashMap());
    private IPath defaultLocation;

    public PersistentCache(IPath defaultLocation) {
        this.defaultLocation = defaultLocation;
    }

    public CacheEntry getCache(String identifier) {
        CacheEntry result = this.caches.get(identifier);
        return result;
    }

    public boolean hasCachedData(String cacheIdentifier) {
        return this.caches.containsKey(cacheIdentifier);
    }

    public synchronized <T> T getCachedData(String cacheIdentifier, T expectedClass, long freshness) {
        Object result = this.getCachedData(cacheIdentifier, expectedClass.getClass(), freshness);
        if (result == null) {
            this.putCachedData(cacheIdentifier, (Serializable)expectedClass, freshness);
            result = expectedClass;
        }
        return (T)result;
    }

    public synchronized <T> T getCachedData(String cacheIdentifier, Class<T> expectedClass, long freshness) {
        CacheEntry cache = this.caches.get(cacheIdentifier);
        if (cache == null && (cache = this.loadCachedData(this.getDefaultLocation(), cacheIdentifier)) != null) {
            this.caches.put(cacheIdentifier, cache);
        }
        if (cache != null) {
            long cachedFreshness = cache.getFreshness();
            Object result = cache.getData(expectedClass);
            if (cachedFreshness == freshness && result != null) {
                if (EDCTrace.PERSISTENT_CACHE_TRACE_ON) {
                    EDCTrace.getTrace().trace(null, "Cache get data: " + cacheIdentifier + " data: " + result);
                }
                return (T)result;
            }
            if (EDCTrace.PERSISTENT_CACHE_TRACE_ON) {
                EDCTrace.getTrace().trace(null, "Stale data. cachedFreshness: " + cachedFreshness + " freshness: " + result + " cache: " + cache);
            }
            this.caches.remove(cache);
            cache.delete();
        }
        return null;
    }

    private CacheEntry loadCachedData(IPath location, String cacheIdentifier) {
        IPath flushPath = location.append(Integer.toString(cacheIdentifier.hashCode())).addFileExtension("txt");
        if (flushPath.toFile().exists()) {
            try {
                final ClassLoader classLoader = ((Object)((Object)EDCDebugger.getDefault())).getClass().getClassLoader();
                FileInputStream fis = new FileInputStream(flushPath.toFile());
                ObjectInputStream ois = new ObjectInputStream(fis){

                    @Override
                    protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
                        String name = desc.getName();
                        try {
                            return classLoader.loadClass(name);
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            return super.resolveClass(desc);
                        }
                    }
                };
                return new CacheEntry(ois);
            }
            catch (Exception exception) {}
        }
        return null;
    }

    public void putCachedData(String cacheIdentifier, Serializable data, long freshness) {
        CacheEntry cache = new CacheEntry(cacheIdentifier, data, freshness);
        this.caches.put(cacheIdentifier, cache);
        if (EDCTrace.PERSISTENT_CACHE_TRACE_ON) {
            EDCTrace.getTrace().trace(null, "Cache put data: " + cacheIdentifier + " data: " + data);
        }
    }

    public void flushAll() {
        Collection<CacheEntry> allCaches = this.caches.values();
        for (CacheEntry entry : allCaches) {
            try {
                entry.flush();
            }
            catch (Exception e) {
                EDCDebugger.getMessageLogger().logException(e);
            }
        }
        this.caches.clear();
    }

    public IPath getDefaultLocation() {
        return this.defaultLocation;
    }

    public void setDefaultLocation(IPath defaultLocation) {
        this.defaultLocation = defaultLocation;
    }

    private class CacheEntry {
        private String identifier;
        private long freshness;
        private Serializable data;
        private IPath location;

        public CacheEntry(String identifier, Serializable data, long freshness) {
            this.identifier = identifier;
            this.freshness = freshness;
            this.data = data;
            this.location = PersistentCache.this.getDefaultLocation().append(Integer.toString(identifier.hashCode())).addFileExtension("txt");
        }

        public CacheEntry(ObjectInputStream ois) throws Exception {
            this.identifier = (String)ois.readObject();
            this.freshness = (Long)ois.readObject();
            this.data = (Serializable)ois.readObject();
            this.location = PersistentCache.this.getDefaultLocation().append(Integer.toString(this.identifier.hashCode())).addFileExtension("txt");
        }

        public IPath getLocation() {
            return this.location;
        }

        private <T> T getData(Class<T> expectedClass) {
            if (expectedClass.isInstance(this.data)) {
                return (T)this.data;
            }
            return null;
        }

        private long getFreshness() {
            return this.freshness;
        }

        private void flush() throws Exception {
            File cacheFile = this.getLocation().toFile();
            if (!cacheFile.exists()) {
                cacheFile.getParentFile().mkdirs();
                cacheFile.createNewFile();
            }
            FileOutputStream fos = new FileOutputStream(cacheFile);
            ObjectOutputStream oos = new ObjectOutputStream(fos);
            oos.writeObject(this.identifier);
            oos.writeObject(this.freshness);
            oos.writeObject(this.data);
            fos.close();
            if (EDCTrace.PERSISTENT_CACHE_TRACE_ON) {
                EDCTrace.getTrace().trace(null, "Cache flush: " + this.identifier + " data: " + this.data);
            }
        }

        public void delete() {
            File cacheFile = this.getLocation().toFile();
            if (cacheFile.exists()) {
                cacheFile.delete();
            }
        }
    }
}

