/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.control;

import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.tizen.dynamicanalyzer.common.AnalyzerManager;
import org.tizen.dynamicanalyzer.common.DAResult;
import org.tizen.dynamicanalyzer.common.DAState;
import org.tizen.dynamicanalyzer.common.Global;
import org.tizen.dynamicanalyzer.communicator.DACommunicator;
import org.tizen.dynamicanalyzer.control.IProgress;
import org.tizen.dynamicanalyzer.control.ProgressTable;
import org.tizen.dynamicanalyzer.control.ResourceMonitor;
import org.tizen.dynamicanalyzer.handlers.CommonAction;
import org.tizen.dynamicanalyzer.handlers.ReplayManager;
import org.tizen.dynamicanalyzer.handlers.UIActionHolder;
import org.tizen.dynamicanalyzer.nl.AnalyzerLabels;
import org.tizen.dynamicanalyzer.nl.MenuBarLabels;
import org.tizen.dynamicanalyzer.project.Project;
import org.tizen.dynamicanalyzer.setting.FlatPreferences;
import org.tizen.dynamicanalyzer.setting.SettingDataManager;
import org.tizen.dynamicanalyzer.setting.UILayoutDataManager;
import org.tizen.dynamicanalyzer.shortcut.ShortCutManager;
import org.tizen.dynamicanalyzer.swap.communicator.DataChannelThread;
import org.tizen.dynamicanalyzer.swap.logparser.DataManagerRegistry;
import org.tizen.dynamicanalyzer.swap.logparser.LogParser;
import org.tizen.dynamicanalyzer.swap.logparser.MessageParser;
import org.tizen.dynamicanalyzer.ui.info.callstack.CallStackInserter;
import org.tizen.dynamicanalyzer.ui.info.screenshot.ScreenshotTimer;
import org.tizen.dynamicanalyzer.ui.page.MenuBar;
import org.tizen.dynamicanalyzer.ui.page.UpdateViewTimer;
import org.tizen.dynamicanalyzer.ui.timeline.dlog.DLogDataManager;
import org.tizen.dynamicanalyzer.ui.toolbar.Toolbar;
import org.tizen.dynamicanalyzer.util.Logger;
import org.tizen.dynamicanalyzer.util.WorkbenchUtil;
import org.tizen.dynamicanalyzer.widgets.da.base.ProgressDialog;
import org.tizen.dynamicanalyzer.workbench.LayoutManager;

public class StartTraceManager
implements Runnable {
    private static final int PROCINFO_WAIT_TIME = 5000;
    private ProgressTable.STAGE lastStage = ProgressTable.STAGE.NONE;
    private boolean cancelAction = false;
    private ProgressDialog progressDlg = null;
    private Thread startThread = null;
    private IProgress initProgress = new IProgress(){

        @Override
        public boolean isCanceled() {
            return StartTraceManager.this.cancelAction;
        }

        @Override
        public void setStageComplete(ProgressTable.STAGE stage) {
            StartTraceManager.this.lastStage = stage;
            int percent = ProgressTable.getPercent(ProgressTable.PHASE.TRACE_START, StartTraceManager.this.lastStage);
            StartTraceManager.this.setProgressPercent(percent);
        }

        @Override
        public void testCancel() throws InterruptedException {
            StartTraceManager.this.testCancel();
        }

        @Override
        public void run() {
        }
    };
    private IProgress startProgress = new IProgress(){

        @Override
        public boolean isCanceled() {
            return StartTraceManager.this.cancelAction;
        }

        @Override
        public void setStageComplete(ProgressTable.STAGE stage) {
            StartTraceManager.this.lastStage = stage;
            int percent = ProgressTable.getPercent(ProgressTable.PHASE.TRACE_START, StartTraceManager.this.lastStage);
            StartTraceManager.this.setProgressPercent(percent);
        }

        @Override
        public void testCancel() throws InterruptedException {
            StartTraceManager.this.testCancel();
        }

        @Override
        public void run() {
            if (Global.isGUIMode()) {
                Toolbar.INSTANCE.startTimer();
                UpdateViewTimer.start();
            }
            StartTraceManager.this.startDlog();
        }
    };

    public StartTraceManager() {
        if (Global.isGUIMode()) {
            this.createProgressDialog();
        }
    }

    private void createProgressDialog() {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                Shell shell = WorkbenchUtil.getWorkbenchWindow().getShell();
                StartTraceManager.this.progressDlg = new ProgressDialog(shell, LayoutManager.getBaseComposite());
                StartTraceManager.this.progressDlg.setProgressStyle(1);
                StartTraceManager.this.progressDlg.setProgressMessage(AnalyzerLabels.DLG_PREPARE_TRACE);
                StartTraceManager.this.progressDlg.setProgressInfo(AnalyzerLabels.DLG_PLEASE_WAIT);
                StartTraceManager.this.progressDlg.setCancelListener(new SelectionListener(){

                    public void widgetDefaultSelected(SelectionEvent arg0) {
                    }

                    public void widgetSelected(SelectionEvent arg0) {
                        StartTraceManager.this.cancelAction = true;
                        if (StartTraceManager.this.startThread != null) {
                            StartTraceManager.this.startThread.interrupt();
                        }
                    }
                });
                StartTraceManager.this.progressDlg.open();
            }
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        DAResult result;
        block256: {
            block266: {
                block257: {
                    block254: {
                        block265: {
                            block255: {
                                block252: {
                                    block264: {
                                        block253: {
                                            block250: {
                                                block263: {
                                                    block251: {
                                                        block248: {
                                                            block262: {
                                                                block249: {
                                                                    block246: {
                                                                        block261: {
                                                                            block247: {
                                                                                block244: {
                                                                                    block260: {
                                                                                        block245: {
                                                                                            block242: {
                                                                                                block259: {
                                                                                                    block243: {
                                                                                                        result = new DAResult(DAResult.ErrorCode.SUCCESS);
                                                                                                        this.startThread = Thread.currentThread();
                                                                                                        if (CommonAction.checkDeviceValidness()) break block242;
                                                                                                        result = new DAResult(DAResult.ErrorCode.ERR_DISCONNECTED);
                                                                                                        if (this.lastStage == ProgressTable.STAGE.FINAL) break block243;
                                                                                                        DAState.changeCurrentState(DAState.PREPARE_CANCEL);
                                                                                                        switch (this.lastStage) {
                                                                                                            case CREATE_UPDATE_TIMER: 
                                                                                                            case FINAL: {
                                                                                                                this.setCancelProgress(ProgressTable.STAGE.CREATE_UPDATE_TIMER);
                                                                                                            }
                                                                                                            case CREATE_SCREENSHOT_TIMER: {
                                                                                                                ScreenshotTimer.stop();
                                                                                                                this.setCancelProgress(ProgressTable.STAGE.CREATE_SCREENSHOT_TIMER);
                                                                                                            }
                                                                                                            case CREATE_REPLAY_TIMER: {
                                                                                                                ReplayManager.resetStopAlarm();
                                                                                                                this.setCancelProgress(ProgressTable.STAGE.CREATE_REPLAY_TIMER);
                                                                                                            }
                                                                                                            case START_CLOCK: {
                                                                                                                this.setCancelProgress(ProgressTable.STAGE.START_CLOCK);
                                                                                                            }
                                                                                                            case SEND_STARTMSG: 
                                                                                                            case WAIT_PROCINFO: {
                                                                                                                try {
                                                                                                                    DACommunicator.stopTrace();
                                                                                                                }
                                                                                                                catch (Exception exception) {
                                                                                                                    Logger.error((Object)"Interrupted during stop trace");
                                                                                                                }
                                                                                                                this.setCancelProgress(ProgressTable.STAGE.SEND_STARTMSG);
                                                                                                            }
                                                                                                            case START_RESOURCE_MONITOR: {
                                                                                                                if (Global.isGUIMode()) {
                                                                                                                    Toolbar.INSTANCE.stopTimer();
                                                                                                                }
                                                                                                                UpdateViewTimer.stop();
                                                                                                                ResourceMonitor.stop();
                                                                                                                this.setCancelProgress(ProgressTable.STAGE.START_RESOURCE_MONITOR);
                                                                                                            }
                                                                                                            case CREATE_CALLSTACK_INSERTER: {
                                                                                                                CallStackInserter.getInstance().stopForced();
                                                                                                                this.setCancelProgress(ProgressTable.STAGE.CREATE_CALLSTACK_INSERTER);
                                                                                                            }
                                                                                                            case CREATE_PAGEMANAGER: {
                                                                                                                DataManagerRegistry.stopThreadsForced();
                                                                                                                this.setCancelProgress(ProgressTable.STAGE.CREATE_PAGEMANAGER);
                                                                                                            }
                                                                                                            case CREATE_LOGPARSER: {
                                                                                                                LogParser.getInstance().stopForced();
                                                                                                                this.setCancelProgress(ProgressTable.STAGE.CREATE_LOGPARSER);
                                                                                                            }
                                                                                                            case CREATE_MESSAGEPARSER: {
                                                                                                                MessageParser.getInstance().stopForced();
                                                                                                                this.setCancelProgress(ProgressTable.STAGE.CREATE_MESSAGEPARSER);
                                                                                                            }
                                                                                                            case CREATE_DATATHREAD: {
                                                                                                                DataChannelThread.getInstance().stopForced();
                                                                                                                this.setCancelProgress(ProgressTable.STAGE.CREATE_DATATHREAD);
                                                                                                            }
                                                                                                            case CREATE_PROJECT: 
                                                                                                            case ESTABLISH_DB: 
                                                                                                            case CREATE_DBTABLE: 
                                                                                                            case RESET_UI: {
                                                                                                                CommonAction.clear();
                                                                                                                this.setCancelProgress(ProgressTable.STAGE.CREATE_PROJECT);
                                                                                                            }
                                                                                                            case CHECK_DEV: 
                                                                                                            case CHECK_APP: 
                                                                                                            case CHECK_CONFIG: {
                                                                                                                break;
                                                                                                            }
                                                                                                        }
                                                                                                        DAState.changeCurrentState(DAState.INIT);
                                                                                                        break block259;
                                                                                                    }
                                                                                                    DAState.changeCurrentState(DAState.RUNNING);
                                                                                                }
                                                                                                if (this.progressDlg != null) {
                                                                                                    Display.getDefault().syncExec(new Runnable(){

                                                                                                        @Override
                                                                                                        public void run() {
                                                                                                            StartTraceManager.this.progressDlg.close();
                                                                                                        }
                                                                                                    });
                                                                                                }
                                                                                                if (!result.isSuccess()) {
                                                                                                    UIActionHolder.getUIAction().showWarning(result);
                                                                                                }
                                                                                                if (!Global.isGUIMode()) return;
                                                                                                ShortCutManager.getInstance().setEnabled(true);
                                                                                                Toolbar.INSTANCE.changeUIState(DAState.getCurrentState());
                                                                                                return;
                                                                                            }
                                                                                            this.setStageComplete(ProgressTable.STAGE.CHECK_DEV);
                                                                                            if (CommonAction.checkApplicationValidness()) break block244;
                                                                                            result = new DAResult(DAResult.ErrorCode.ERR_INVALID_APP);
                                                                                            if (this.lastStage == ProgressTable.STAGE.FINAL) break block245;
                                                                                            DAState.changeCurrentState(DAState.PREPARE_CANCEL);
                                                                                            switch (this.lastStage) {
                                                                                                case CREATE_UPDATE_TIMER: 
                                                                                                case FINAL: {
                                                                                                    this.setCancelProgress(ProgressTable.STAGE.CREATE_UPDATE_TIMER);
                                                                                                }
                                                                                                case CREATE_SCREENSHOT_TIMER: {
                                                                                                    ScreenshotTimer.stop();
                                                                                                    this.setCancelProgress(ProgressTable.STAGE.CREATE_SCREENSHOT_TIMER);
                                                                                                }
                                                                                                case CREATE_REPLAY_TIMER: {
                                                                                                    ReplayManager.resetStopAlarm();
                                                                                                    this.setCancelProgress(ProgressTable.STAGE.CREATE_REPLAY_TIMER);
                                                                                                }
                                                                                                case START_CLOCK: {
                                                                                                    this.setCancelProgress(ProgressTable.STAGE.START_CLOCK);
                                                                                                }
                                                                                                case SEND_STARTMSG: 
                                                                                                case WAIT_PROCINFO: {
                                                                                                    try {
                                                                                                        DACommunicator.stopTrace();
                                                                                                    }
                                                                                                    catch (Exception exception) {
                                                                                                        Logger.error((Object)"Interrupted during stop trace");
                                                                                                    }
                                                                                                    this.setCancelProgress(ProgressTable.STAGE.SEND_STARTMSG);
                                                                                                }
                                                                                                case START_RESOURCE_MONITOR: {
                                                                                                    if (Global.isGUIMode()) {
                                                                                                        Toolbar.INSTANCE.stopTimer();
                                                                                                    }
                                                                                                    UpdateViewTimer.stop();
                                                                                                    ResourceMonitor.stop();
                                                                                                    this.setCancelProgress(ProgressTable.STAGE.START_RESOURCE_MONITOR);
                                                                                                }
                                                                                                case CREATE_CALLSTACK_INSERTER: {
                                                                                                    CallStackInserter.getInstance().stopForced();
                                                                                                    this.setCancelProgress(ProgressTable.STAGE.CREATE_CALLSTACK_INSERTER);
                                                                                                }
                                                                                                case CREATE_PAGEMANAGER: {
                                                                                                    DataManagerRegistry.stopThreadsForced();
                                                                                                    this.setCancelProgress(ProgressTable.STAGE.CREATE_PAGEMANAGER);
                                                                                                }
                                                                                                case CREATE_LOGPARSER: {
                                                                                                    LogParser.getInstance().stopForced();
                                                                                                    this.setCancelProgress(ProgressTable.STAGE.CREATE_LOGPARSER);
                                                                                                }
                                                                                                case CREATE_MESSAGEPARSER: {
                                                                                                    MessageParser.getInstance().stopForced();
                                                                                                    this.setCancelProgress(ProgressTable.STAGE.CREATE_MESSAGEPARSER);
                                                                                                }
                                                                                                case CREATE_DATATHREAD: {
                                                                                                    DataChannelThread.getInstance().stopForced();
                                                                                                    this.setCancelProgress(ProgressTable.STAGE.CREATE_DATATHREAD);
                                                                                                }
                                                                                                case CREATE_PROJECT: 
                                                                                                case ESTABLISH_DB: 
                                                                                                case CREATE_DBTABLE: 
                                                                                                case RESET_UI: {
                                                                                                    CommonAction.clear();
                                                                                                    this.setCancelProgress(ProgressTable.STAGE.CREATE_PROJECT);
                                                                                                }
                                                                                                case CHECK_DEV: 
                                                                                                case CHECK_APP: 
                                                                                                case CHECK_CONFIG: {
                                                                                                    break;
                                                                                                }
                                                                                            }
                                                                                            DAState.changeCurrentState(DAState.INIT);
                                                                                            break block260;
                                                                                        }
                                                                                        DAState.changeCurrentState(DAState.RUNNING);
                                                                                    }
                                                                                    if (this.progressDlg != null) {
                                                                                        Display.getDefault().syncExec(new /* invalid duplicate definition of identical inner class */);
                                                                                    }
                                                                                    if (!result.isSuccess()) {
                                                                                        UIActionHolder.getUIAction().showWarning(result);
                                                                                    }
                                                                                    if (!Global.isGUIMode()) return;
                                                                                    ShortCutManager.getInstance().setEnabled(true);
                                                                                    Toolbar.INSTANCE.changeUIState(DAState.getCurrentState());
                                                                                    return;
                                                                                }
                                                                                this.setStageComplete(ProgressTable.STAGE.CHECK_APP);
                                                                                if (CommonAction.checkConfiguration()) break block246;
                                                                                result = new DAResult(DAResult.ErrorCode.ERR_CONFIG_FAILED);
                                                                                if (this.lastStage == ProgressTable.STAGE.FINAL) break block247;
                                                                                DAState.changeCurrentState(DAState.PREPARE_CANCEL);
                                                                                switch (this.lastStage) {
                                                                                    case CREATE_UPDATE_TIMER: 
                                                                                    case FINAL: {
                                                                                        this.setCancelProgress(ProgressTable.STAGE.CREATE_UPDATE_TIMER);
                                                                                    }
                                                                                    case CREATE_SCREENSHOT_TIMER: {
                                                                                        ScreenshotTimer.stop();
                                                                                        this.setCancelProgress(ProgressTable.STAGE.CREATE_SCREENSHOT_TIMER);
                                                                                    }
                                                                                    case CREATE_REPLAY_TIMER: {
                                                                                        ReplayManager.resetStopAlarm();
                                                                                        this.setCancelProgress(ProgressTable.STAGE.CREATE_REPLAY_TIMER);
                                                                                    }
                                                                                    case START_CLOCK: {
                                                                                        this.setCancelProgress(ProgressTable.STAGE.START_CLOCK);
                                                                                    }
                                                                                    case SEND_STARTMSG: 
                                                                                    case WAIT_PROCINFO: {
                                                                                        try {
                                                                                            DACommunicator.stopTrace();
                                                                                        }
                                                                                        catch (Exception exception) {
                                                                                            Logger.error((Object)"Interrupted during stop trace");
                                                                                        }
                                                                                        this.setCancelProgress(ProgressTable.STAGE.SEND_STARTMSG);
                                                                                    }
                                                                                    case START_RESOURCE_MONITOR: {
                                                                                        if (Global.isGUIMode()) {
                                                                                            Toolbar.INSTANCE.stopTimer();
                                                                                        }
                                                                                        UpdateViewTimer.stop();
                                                                                        ResourceMonitor.stop();
                                                                                        this.setCancelProgress(ProgressTable.STAGE.START_RESOURCE_MONITOR);
                                                                                    }
                                                                                    case CREATE_CALLSTACK_INSERTER: {
                                                                                        CallStackInserter.getInstance().stopForced();
                                                                                        this.setCancelProgress(ProgressTable.STAGE.CREATE_CALLSTACK_INSERTER);
                                                                                    }
                                                                                    case CREATE_PAGEMANAGER: {
                                                                                        DataManagerRegistry.stopThreadsForced();
                                                                                        this.setCancelProgress(ProgressTable.STAGE.CREATE_PAGEMANAGER);
                                                                                    }
                                                                                    case CREATE_LOGPARSER: {
                                                                                        LogParser.getInstance().stopForced();
                                                                                        this.setCancelProgress(ProgressTable.STAGE.CREATE_LOGPARSER);
                                                                                    }
                                                                                    case CREATE_MESSAGEPARSER: {
                                                                                        MessageParser.getInstance().stopForced();
                                                                                        this.setCancelProgress(ProgressTable.STAGE.CREATE_MESSAGEPARSER);
                                                                                    }
                                                                                    case CREATE_DATATHREAD: {
                                                                                        DataChannelThread.getInstance().stopForced();
                                                                                        this.setCancelProgress(ProgressTable.STAGE.CREATE_DATATHREAD);
                                                                                    }
                                                                                    case CREATE_PROJECT: 
                                                                                    case ESTABLISH_DB: 
                                                                                    case CREATE_DBTABLE: 
                                                                                    case RESET_UI: {
                                                                                        CommonAction.clear();
                                                                                        this.setCancelProgress(ProgressTable.STAGE.CREATE_PROJECT);
                                                                                    }
                                                                                    case CHECK_DEV: 
                                                                                    case CHECK_APP: 
                                                                                    case CHECK_CONFIG: {
                                                                                        break;
                                                                                    }
                                                                                }
                                                                                DAState.changeCurrentState(DAState.INIT);
                                                                                break block261;
                                                                            }
                                                                            DAState.changeCurrentState(DAState.RUNNING);
                                                                        }
                                                                        if (this.progressDlg != null) {
                                                                            Display.getDefault().syncExec(new /* invalid duplicate definition of identical inner class */);
                                                                        }
                                                                        if (!result.isSuccess()) {
                                                                            UIActionHolder.getUIAction().showWarning(result);
                                                                        }
                                                                        if (!Global.isGUIMode()) return;
                                                                        ShortCutManager.getInstance().setEnabled(true);
                                                                        Toolbar.INSTANCE.changeUIState(DAState.getCurrentState());
                                                                        return;
                                                                    }
                                                                    this.setStageComplete(ProgressTable.STAGE.CHECK_CONFIG);
                                                                    CommonAction.clear();
                                                                    Project project = new Project();
                                                                    Global.setProject(project);
                                                                    project.init(this.initProgress);
                                                                    project.setMempsAvailable(Global.getCurrentDeviceInfo().getMempAvailable());
                                                                    if (UILayoutDataManager.INSTANCE.isDirty()) {
                                                                        UIActionHolder.getUIAction().setUIElementsBySetting();
                                                                    }
                                                                    UIActionHolder.getUIAction().applyStartTraceUI();
                                                                    UIActionHolder.getUIAction().applyWebProfilingUI(project.isWebApplication());
                                                                    this.setStageComplete(ProgressTable.STAGE.RESET_UI);
                                                                    if (DataChannelThread.getInstance().start()) break block248;
                                                                    result = new DAResult(DAResult.ErrorCode.ERR_START_DATA_CHANNEL);
                                                                    if (this.lastStage == ProgressTable.STAGE.FINAL) break block249;
                                                                    DAState.changeCurrentState(DAState.PREPARE_CANCEL);
                                                                    switch (this.lastStage) {
                                                                        case CREATE_UPDATE_TIMER: 
                                                                        case FINAL: {
                                                                            this.setCancelProgress(ProgressTable.STAGE.CREATE_UPDATE_TIMER);
                                                                        }
                                                                        case CREATE_SCREENSHOT_TIMER: {
                                                                            ScreenshotTimer.stop();
                                                                            this.setCancelProgress(ProgressTable.STAGE.CREATE_SCREENSHOT_TIMER);
                                                                        }
                                                                        case CREATE_REPLAY_TIMER: {
                                                                            ReplayManager.resetStopAlarm();
                                                                            this.setCancelProgress(ProgressTable.STAGE.CREATE_REPLAY_TIMER);
                                                                        }
                                                                        case START_CLOCK: {
                                                                            this.setCancelProgress(ProgressTable.STAGE.START_CLOCK);
                                                                        }
                                                                        case SEND_STARTMSG: 
                                                                        case WAIT_PROCINFO: {
                                                                            try {
                                                                                DACommunicator.stopTrace();
                                                                            }
                                                                            catch (Exception exception) {
                                                                                Logger.error((Object)"Interrupted during stop trace");
                                                                            }
                                                                            this.setCancelProgress(ProgressTable.STAGE.SEND_STARTMSG);
                                                                        }
                                                                        case START_RESOURCE_MONITOR: {
                                                                            if (Global.isGUIMode()) {
                                                                                Toolbar.INSTANCE.stopTimer();
                                                                            }
                                                                            UpdateViewTimer.stop();
                                                                            ResourceMonitor.stop();
                                                                            this.setCancelProgress(ProgressTable.STAGE.START_RESOURCE_MONITOR);
                                                                        }
                                                                        case CREATE_CALLSTACK_INSERTER: {
                                                                            CallStackInserter.getInstance().stopForced();
                                                                            this.setCancelProgress(ProgressTable.STAGE.CREATE_CALLSTACK_INSERTER);
                                                                        }
                                                                        case CREATE_PAGEMANAGER: {
                                                                            DataManagerRegistry.stopThreadsForced();
                                                                            this.setCancelProgress(ProgressTable.STAGE.CREATE_PAGEMANAGER);
                                                                        }
                                                                        case CREATE_LOGPARSER: {
                                                                            LogParser.getInstance().stopForced();
                                                                            this.setCancelProgress(ProgressTable.STAGE.CREATE_LOGPARSER);
                                                                        }
                                                                        case CREATE_MESSAGEPARSER: {
                                                                            MessageParser.getInstance().stopForced();
                                                                            this.setCancelProgress(ProgressTable.STAGE.CREATE_MESSAGEPARSER);
                                                                        }
                                                                        case CREATE_DATATHREAD: {
                                                                            DataChannelThread.getInstance().stopForced();
                                                                            this.setCancelProgress(ProgressTable.STAGE.CREATE_DATATHREAD);
                                                                        }
                                                                        case CREATE_PROJECT: 
                                                                        case ESTABLISH_DB: 
                                                                        case CREATE_DBTABLE: 
                                                                        case RESET_UI: {
                                                                            CommonAction.clear();
                                                                            this.setCancelProgress(ProgressTable.STAGE.CREATE_PROJECT);
                                                                        }
                                                                        case CHECK_DEV: 
                                                                        case CHECK_APP: 
                                                                        case CHECK_CONFIG: {
                                                                            break;
                                                                        }
                                                                    }
                                                                    DAState.changeCurrentState(DAState.INIT);
                                                                    break block262;
                                                                }
                                                                DAState.changeCurrentState(DAState.RUNNING);
                                                            }
                                                            if (this.progressDlg != null) {
                                                                Display.getDefault().syncExec(new /* invalid duplicate definition of identical inner class */);
                                                            }
                                                            if (!result.isSuccess()) {
                                                                UIActionHolder.getUIAction().showWarning(result);
                                                            }
                                                            if (!Global.isGUIMode()) return;
                                                            ShortCutManager.getInstance().setEnabled(true);
                                                            Toolbar.INSTANCE.changeUIState(DAState.getCurrentState());
                                                            return;
                                                        }
                                                        this.setStageComplete(ProgressTable.STAGE.CREATE_DATATHREAD);
                                                        if (MessageParser.getInstance().start()) break block250;
                                                        result = new DAResult(DAResult.ErrorCode.ERR_START_MESSAGE_PARSER);
                                                        if (this.lastStage == ProgressTable.STAGE.FINAL) break block251;
                                                        DAState.changeCurrentState(DAState.PREPARE_CANCEL);
                                                        switch (this.lastStage) {
                                                            case CREATE_UPDATE_TIMER: 
                                                            case FINAL: {
                                                                this.setCancelProgress(ProgressTable.STAGE.CREATE_UPDATE_TIMER);
                                                            }
                                                            case CREATE_SCREENSHOT_TIMER: {
                                                                ScreenshotTimer.stop();
                                                                this.setCancelProgress(ProgressTable.STAGE.CREATE_SCREENSHOT_TIMER);
                                                            }
                                                            case CREATE_REPLAY_TIMER: {
                                                                ReplayManager.resetStopAlarm();
                                                                this.setCancelProgress(ProgressTable.STAGE.CREATE_REPLAY_TIMER);
                                                            }
                                                            case START_CLOCK: {
                                                                this.setCancelProgress(ProgressTable.STAGE.START_CLOCK);
                                                            }
                                                            case SEND_STARTMSG: 
                                                            case WAIT_PROCINFO: {
                                                                try {
                                                                    DACommunicator.stopTrace();
                                                                }
                                                                catch (Exception exception) {
                                                                    Logger.error((Object)"Interrupted during stop trace");
                                                                }
                                                                this.setCancelProgress(ProgressTable.STAGE.SEND_STARTMSG);
                                                            }
                                                            case START_RESOURCE_MONITOR: {
                                                                if (Global.isGUIMode()) {
                                                                    Toolbar.INSTANCE.stopTimer();
                                                                }
                                                                UpdateViewTimer.stop();
                                                                ResourceMonitor.stop();
                                                                this.setCancelProgress(ProgressTable.STAGE.START_RESOURCE_MONITOR);
                                                            }
                                                            case CREATE_CALLSTACK_INSERTER: {
                                                                CallStackInserter.getInstance().stopForced();
                                                                this.setCancelProgress(ProgressTable.STAGE.CREATE_CALLSTACK_INSERTER);
                                                            }
                                                            case CREATE_PAGEMANAGER: {
                                                                DataManagerRegistry.stopThreadsForced();
                                                                this.setCancelProgress(ProgressTable.STAGE.CREATE_PAGEMANAGER);
                                                            }
                                                            case CREATE_LOGPARSER: {
                                                                LogParser.getInstance().stopForced();
                                                                this.setCancelProgress(ProgressTable.STAGE.CREATE_LOGPARSER);
                                                            }
                                                            case CREATE_MESSAGEPARSER: {
                                                                MessageParser.getInstance().stopForced();
                                                                this.setCancelProgress(ProgressTable.STAGE.CREATE_MESSAGEPARSER);
                                                            }
                                                            case CREATE_DATATHREAD: {
                                                                DataChannelThread.getInstance().stopForced();
                                                                this.setCancelProgress(ProgressTable.STAGE.CREATE_DATATHREAD);
                                                            }
                                                            case CREATE_PROJECT: 
                                                            case ESTABLISH_DB: 
                                                            case CREATE_DBTABLE: 
                                                            case RESET_UI: {
                                                                CommonAction.clear();
                                                                this.setCancelProgress(ProgressTable.STAGE.CREATE_PROJECT);
                                                            }
                                                            case CHECK_DEV: 
                                                            case CHECK_APP: 
                                                            case CHECK_CONFIG: {
                                                                break;
                                                            }
                                                        }
                                                        DAState.changeCurrentState(DAState.INIT);
                                                        break block263;
                                                    }
                                                    DAState.changeCurrentState(DAState.RUNNING);
                                                }
                                                if (this.progressDlg != null) {
                                                    Display.getDefault().syncExec(new /* invalid duplicate definition of identical inner class */);
                                                }
                                                if (!result.isSuccess()) {
                                                    UIActionHolder.getUIAction().showWarning(result);
                                                }
                                                if (!Global.isGUIMode()) return;
                                                ShortCutManager.getInstance().setEnabled(true);
                                                Toolbar.INSTANCE.changeUIState(DAState.getCurrentState());
                                                return;
                                            }
                                            this.setStageComplete(ProgressTable.STAGE.CREATE_MESSAGEPARSER);
                                            if (LogParser.getInstance().start()) break block252;
                                            result = new DAResult(DAResult.ErrorCode.ERR_START_LOG_PARSER);
                                            if (this.lastStage == ProgressTable.STAGE.FINAL) break block253;
                                            DAState.changeCurrentState(DAState.PREPARE_CANCEL);
                                            switch (this.lastStage) {
                                                case CREATE_UPDATE_TIMER: 
                                                case FINAL: {
                                                    this.setCancelProgress(ProgressTable.STAGE.CREATE_UPDATE_TIMER);
                                                }
                                                case CREATE_SCREENSHOT_TIMER: {
                                                    ScreenshotTimer.stop();
                                                    this.setCancelProgress(ProgressTable.STAGE.CREATE_SCREENSHOT_TIMER);
                                                }
                                                case CREATE_REPLAY_TIMER: {
                                                    ReplayManager.resetStopAlarm();
                                                    this.setCancelProgress(ProgressTable.STAGE.CREATE_REPLAY_TIMER);
                                                }
                                                case START_CLOCK: {
                                                    this.setCancelProgress(ProgressTable.STAGE.START_CLOCK);
                                                }
                                                case SEND_STARTMSG: 
                                                case WAIT_PROCINFO: {
                                                    try {
                                                        DACommunicator.stopTrace();
                                                    }
                                                    catch (Exception exception) {
                                                        Logger.error((Object)"Interrupted during stop trace");
                                                    }
                                                    this.setCancelProgress(ProgressTable.STAGE.SEND_STARTMSG);
                                                }
                                                case START_RESOURCE_MONITOR: {
                                                    if (Global.isGUIMode()) {
                                                        Toolbar.INSTANCE.stopTimer();
                                                    }
                                                    UpdateViewTimer.stop();
                                                    ResourceMonitor.stop();
                                                    this.setCancelProgress(ProgressTable.STAGE.START_RESOURCE_MONITOR);
                                                }
                                                case CREATE_CALLSTACK_INSERTER: {
                                                    CallStackInserter.getInstance().stopForced();
                                                    this.setCancelProgress(ProgressTable.STAGE.CREATE_CALLSTACK_INSERTER);
                                                }
                                                case CREATE_PAGEMANAGER: {
                                                    DataManagerRegistry.stopThreadsForced();
                                                    this.setCancelProgress(ProgressTable.STAGE.CREATE_PAGEMANAGER);
                                                }
                                                case CREATE_LOGPARSER: {
                                                    LogParser.getInstance().stopForced();
                                                    this.setCancelProgress(ProgressTable.STAGE.CREATE_LOGPARSER);
                                                }
                                                case CREATE_MESSAGEPARSER: {
                                                    MessageParser.getInstance().stopForced();
                                                    this.setCancelProgress(ProgressTable.STAGE.CREATE_MESSAGEPARSER);
                                                }
                                                case CREATE_DATATHREAD: {
                                                    DataChannelThread.getInstance().stopForced();
                                                    this.setCancelProgress(ProgressTable.STAGE.CREATE_DATATHREAD);
                                                }
                                                case CREATE_PROJECT: 
                                                case ESTABLISH_DB: 
                                                case CREATE_DBTABLE: 
                                                case RESET_UI: {
                                                    CommonAction.clear();
                                                    this.setCancelProgress(ProgressTable.STAGE.CREATE_PROJECT);
                                                }
                                                case CHECK_DEV: 
                                                case CHECK_APP: 
                                                case CHECK_CONFIG: {
                                                    break;
                                                }
                                            }
                                            DAState.changeCurrentState(DAState.INIT);
                                            break block264;
                                        }
                                        DAState.changeCurrentState(DAState.RUNNING);
                                    }
                                    if (this.progressDlg != null) {
                                        Display.getDefault().syncExec(new /* invalid duplicate definition of identical inner class */);
                                    }
                                    if (!result.isSuccess()) {
                                        UIActionHolder.getUIAction().showWarning(result);
                                    }
                                    if (!Global.isGUIMode()) return;
                                    ShortCutManager.getInstance().setEnabled(true);
                                    Toolbar.INSTANCE.changeUIState(DAState.getCurrentState());
                                    return;
                                }
                                this.setStageComplete(ProgressTable.STAGE.CREATE_LOGPARSER);
                                DataManagerRegistry.startThreads();
                                this.setStageComplete(ProgressTable.STAGE.CREATE_PAGEMANAGER);
                                CallStackInserter.getInstance().start();
                                this.setStageComplete(ProgressTable.STAGE.CREATE_CALLSTACK_INSERTER);
                                ResourceMonitor.start();
                                this.setStageComplete(ProgressTable.STAGE.START_RESOURCE_MONITOR);
                                result = DACommunicator.startTrace(this.startProgress);
                                if (result.isSuccess()) break block254;
                                if (this.lastStage == ProgressTable.STAGE.FINAL) break block255;
                                DAState.changeCurrentState(DAState.PREPARE_CANCEL);
                                switch (this.lastStage) {
                                    case CREATE_UPDATE_TIMER: 
                                    case FINAL: {
                                        this.setCancelProgress(ProgressTable.STAGE.CREATE_UPDATE_TIMER);
                                    }
                                    case CREATE_SCREENSHOT_TIMER: {
                                        ScreenshotTimer.stop();
                                        this.setCancelProgress(ProgressTable.STAGE.CREATE_SCREENSHOT_TIMER);
                                    }
                                    case CREATE_REPLAY_TIMER: {
                                        ReplayManager.resetStopAlarm();
                                        this.setCancelProgress(ProgressTable.STAGE.CREATE_REPLAY_TIMER);
                                    }
                                    case START_CLOCK: {
                                        this.setCancelProgress(ProgressTable.STAGE.START_CLOCK);
                                    }
                                    case SEND_STARTMSG: 
                                    case WAIT_PROCINFO: {
                                        try {
                                            DACommunicator.stopTrace();
                                        }
                                        catch (Exception exception) {
                                            Logger.error((Object)"Interrupted during stop trace");
                                        }
                                        this.setCancelProgress(ProgressTable.STAGE.SEND_STARTMSG);
                                    }
                                    case START_RESOURCE_MONITOR: {
                                        if (Global.isGUIMode()) {
                                            Toolbar.INSTANCE.stopTimer();
                                        }
                                        UpdateViewTimer.stop();
                                        ResourceMonitor.stop();
                                        this.setCancelProgress(ProgressTable.STAGE.START_RESOURCE_MONITOR);
                                    }
                                    case CREATE_CALLSTACK_INSERTER: {
                                        CallStackInserter.getInstance().stopForced();
                                        this.setCancelProgress(ProgressTable.STAGE.CREATE_CALLSTACK_INSERTER);
                                    }
                                    case CREATE_PAGEMANAGER: {
                                        DataManagerRegistry.stopThreadsForced();
                                        this.setCancelProgress(ProgressTable.STAGE.CREATE_PAGEMANAGER);
                                    }
                                    case CREATE_LOGPARSER: {
                                        LogParser.getInstance().stopForced();
                                        this.setCancelProgress(ProgressTable.STAGE.CREATE_LOGPARSER);
                                    }
                                    case CREATE_MESSAGEPARSER: {
                                        MessageParser.getInstance().stopForced();
                                        this.setCancelProgress(ProgressTable.STAGE.CREATE_MESSAGEPARSER);
                                    }
                                    case CREATE_DATATHREAD: {
                                        DataChannelThread.getInstance().stopForced();
                                        this.setCancelProgress(ProgressTable.STAGE.CREATE_DATATHREAD);
                                    }
                                    case CREATE_PROJECT: 
                                    case ESTABLISH_DB: 
                                    case CREATE_DBTABLE: 
                                    case RESET_UI: {
                                        CommonAction.clear();
                                        this.setCancelProgress(ProgressTable.STAGE.CREATE_PROJECT);
                                    }
                                    case CHECK_DEV: 
                                    case CHECK_APP: 
                                    case CHECK_CONFIG: {
                                        break;
                                    }
                                }
                                DAState.changeCurrentState(DAState.INIT);
                                break block265;
                            }
                            DAState.changeCurrentState(DAState.RUNNING);
                        }
                        if (this.progressDlg != null) {
                            Display.getDefault().syncExec(new /* invalid duplicate definition of identical inner class */);
                        }
                        if (!result.isSuccess()) {
                            UIActionHolder.getUIAction().showWarning(result);
                        }
                        if (!Global.isGUIMode()) return;
                        ShortCutManager.getInstance().setEnabled(true);
                        Toolbar.INSTANCE.changeUIState(DAState.getCurrentState());
                        return;
                    }
                    this.setStageComplete(ProgressTable.STAGE.SEND_STARTMSG);
                    if (Global.isGUIMode()) {
                        Display.getDefault().syncExec(new Runnable(){

                            @Override
                            public void run() {
                                MenuBar.getInstance().setMenuItemEnable(MenuBarLabels.ANALYZE_SCREENSHOT, true);
                                MenuBar.getInstance().setMenuItemEnable(MenuBarLabels.FILE_NEW, false);
                                MenuBar.getInstance().setMenuItemEnable(MenuBarLabels.FILE_LOAD, false);
                            }
                        });
                    }
                    int waittime = 0;
                    while (waittime <= 5000) {
                        if (AnalyzerManager.isProcessInfoArrived()) break;
                        Thread.sleep(100L);
                        waittime += 100;
                        this.testCancel();
                    }
                    if (waittime <= 5000) break block256;
                    result = new DAResult(DAResult.ErrorCode.ERR_NO_PROCINFO);
                    if (this.lastStage == ProgressTable.STAGE.FINAL) break block257;
                    DAState.changeCurrentState(DAState.PREPARE_CANCEL);
                    switch (this.lastStage) {
                        case CREATE_UPDATE_TIMER: 
                        case FINAL: {
                            this.setCancelProgress(ProgressTable.STAGE.CREATE_UPDATE_TIMER);
                        }
                        case CREATE_SCREENSHOT_TIMER: {
                            ScreenshotTimer.stop();
                            this.setCancelProgress(ProgressTable.STAGE.CREATE_SCREENSHOT_TIMER);
                        }
                        case CREATE_REPLAY_TIMER: {
                            ReplayManager.resetStopAlarm();
                            this.setCancelProgress(ProgressTable.STAGE.CREATE_REPLAY_TIMER);
                        }
                        case START_CLOCK: {
                            this.setCancelProgress(ProgressTable.STAGE.START_CLOCK);
                        }
                        case SEND_STARTMSG: 
                        case WAIT_PROCINFO: {
                            try {
                                DACommunicator.stopTrace();
                            }
                            catch (Exception exception) {
                                Logger.error((Object)"Interrupted during stop trace");
                            }
                            this.setCancelProgress(ProgressTable.STAGE.SEND_STARTMSG);
                        }
                        case START_RESOURCE_MONITOR: {
                            if (Global.isGUIMode()) {
                                Toolbar.INSTANCE.stopTimer();
                            }
                            UpdateViewTimer.stop();
                            ResourceMonitor.stop();
                            this.setCancelProgress(ProgressTable.STAGE.START_RESOURCE_MONITOR);
                        }
                        case CREATE_CALLSTACK_INSERTER: {
                            CallStackInserter.getInstance().stopForced();
                            this.setCancelProgress(ProgressTable.STAGE.CREATE_CALLSTACK_INSERTER);
                        }
                        case CREATE_PAGEMANAGER: {
                            DataManagerRegistry.stopThreadsForced();
                            this.setCancelProgress(ProgressTable.STAGE.CREATE_PAGEMANAGER);
                        }
                        case CREATE_LOGPARSER: {
                            LogParser.getInstance().stopForced();
                            this.setCancelProgress(ProgressTable.STAGE.CREATE_LOGPARSER);
                        }
                        case CREATE_MESSAGEPARSER: {
                            MessageParser.getInstance().stopForced();
                            this.setCancelProgress(ProgressTable.STAGE.CREATE_MESSAGEPARSER);
                        }
                        case CREATE_DATATHREAD: {
                            DataChannelThread.getInstance().stopForced();
                            this.setCancelProgress(ProgressTable.STAGE.CREATE_DATATHREAD);
                        }
                        case CREATE_PROJECT: 
                        case ESTABLISH_DB: 
                        case CREATE_DBTABLE: 
                        case RESET_UI: {
                            CommonAction.clear();
                            this.setCancelProgress(ProgressTable.STAGE.CREATE_PROJECT);
                        }
                        case CHECK_DEV: 
                        case CHECK_APP: 
                        case CHECK_CONFIG: {
                            break;
                        }
                    }
                    DAState.changeCurrentState(DAState.INIT);
                    break block266;
                }
                DAState.changeCurrentState(DAState.RUNNING);
            }
            if (this.progressDlg != null) {
                Display.getDefault().syncExec(new /* invalid duplicate definition of identical inner class */);
            }
            if (!result.isSuccess()) {
                UIActionHolder.getUIAction().showWarning(result);
            }
            if (!Global.isGUIMode()) return;
            ShortCutManager.getInstance().setEnabled(true);
            Toolbar.INSTANCE.changeUIState(DAState.getCurrentState());
            return;
        }
        try {
            try {
                this.setStageComplete(ProgressTable.STAGE.WAIT_PROCINFO);
                this.setStageComplete(ProgressTable.STAGE.START_CLOCK);
                ReplayManager.setStopAlarm();
                this.setStageComplete(ProgressTable.STAGE.CREATE_REPLAY_TIMER);
                FlatPreferences feature = FlatPreferences.SCREENSHOT_PERIODICALLY;
                int value = SettingDataManager.INSTANCE.getOptionsPreferencesValue(feature);
                if (value > 0) {
                    ScreenshotTimer.start(value);
                }
                this.setStageComplete(ProgressTable.STAGE.CREATE_SCREENSHOT_TIMER);
                this.setStageComplete(ProgressTable.STAGE.CREATE_UPDATE_TIMER);
                this.setStageComplete(ProgressTable.STAGE.FINAL);
            }
            catch (InterruptedException interruptedException) {
                result = new DAResult(DAResult.ErrorCode.ERR_BY_USER_CANCEL);
                if (this.lastStage != ProgressTable.STAGE.FINAL) {
                    DAState.changeCurrentState(DAState.PREPARE_CANCEL);
                    switch (this.lastStage) {
                        case CREATE_UPDATE_TIMER: 
                        case FINAL: {
                            this.setCancelProgress(ProgressTable.STAGE.CREATE_UPDATE_TIMER);
                        }
                        case CREATE_SCREENSHOT_TIMER: {
                            ScreenshotTimer.stop();
                            this.setCancelProgress(ProgressTable.STAGE.CREATE_SCREENSHOT_TIMER);
                        }
                        case CREATE_REPLAY_TIMER: {
                            ReplayManager.resetStopAlarm();
                            this.setCancelProgress(ProgressTable.STAGE.CREATE_REPLAY_TIMER);
                        }
                        case START_CLOCK: {
                            this.setCancelProgress(ProgressTable.STAGE.START_CLOCK);
                        }
                        case SEND_STARTMSG: 
                        case WAIT_PROCINFO: {
                            try {
                                DACommunicator.stopTrace();
                            }
                            catch (Exception exception) {
                                Logger.error((Object)"Interrupted during stop trace");
                            }
                            this.setCancelProgress(ProgressTable.STAGE.SEND_STARTMSG);
                        }
                        case START_RESOURCE_MONITOR: {
                            if (Global.isGUIMode()) {
                                Toolbar.INSTANCE.stopTimer();
                            }
                            UpdateViewTimer.stop();
                            ResourceMonitor.stop();
                            this.setCancelProgress(ProgressTable.STAGE.START_RESOURCE_MONITOR);
                        }
                        case CREATE_CALLSTACK_INSERTER: {
                            CallStackInserter.getInstance().stopForced();
                            this.setCancelProgress(ProgressTable.STAGE.CREATE_CALLSTACK_INSERTER);
                        }
                        case CREATE_PAGEMANAGER: {
                            DataManagerRegistry.stopThreadsForced();
                            this.setCancelProgress(ProgressTable.STAGE.CREATE_PAGEMANAGER);
                        }
                        case CREATE_LOGPARSER: {
                            LogParser.getInstance().stopForced();
                            this.setCancelProgress(ProgressTable.STAGE.CREATE_LOGPARSER);
                        }
                        case CREATE_MESSAGEPARSER: {
                            MessageParser.getInstance().stopForced();
                            this.setCancelProgress(ProgressTable.STAGE.CREATE_MESSAGEPARSER);
                        }
                        case CREATE_DATATHREAD: {
                            DataChannelThread.getInstance().stopForced();
                            this.setCancelProgress(ProgressTable.STAGE.CREATE_DATATHREAD);
                        }
                        case CREATE_PROJECT: 
                        case ESTABLISH_DB: 
                        case CREATE_DBTABLE: 
                        case RESET_UI: {
                            CommonAction.clear();
                            this.setCancelProgress(ProgressTable.STAGE.CREATE_PROJECT);
                        }
                        case CHECK_DEV: 
                        case CHECK_APP: 
                        case CHECK_CONFIG: {
                            break;
                        }
                    }
                    DAState.changeCurrentState(DAState.INIT);
                } else {
                    DAState.changeCurrentState(DAState.RUNNING);
                }
                if (this.progressDlg != null) {
                    Display.getDefault().syncExec(new /* invalid duplicate definition of identical inner class */);
                }
                if (!result.isSuccess()) {
                    UIActionHolder.getUIAction().showWarning(result);
                }
                if (!Global.isGUIMode()) return;
                ShortCutManager.getInstance().setEnabled(true);
                Toolbar.INSTANCE.changeUIState(DAState.getCurrentState());
                return;
            }
        }
        catch (Throwable throwable) {
            if (this.lastStage != ProgressTable.STAGE.FINAL) {
                DAState.changeCurrentState(DAState.PREPARE_CANCEL);
                switch (this.lastStage) {
                    case CREATE_UPDATE_TIMER: 
                    case FINAL: {
                        this.setCancelProgress(ProgressTable.STAGE.CREATE_UPDATE_TIMER);
                    }
                    case CREATE_SCREENSHOT_TIMER: {
                        ScreenshotTimer.stop();
                        this.setCancelProgress(ProgressTable.STAGE.CREATE_SCREENSHOT_TIMER);
                    }
                    case CREATE_REPLAY_TIMER: {
                        ReplayManager.resetStopAlarm();
                        this.setCancelProgress(ProgressTable.STAGE.CREATE_REPLAY_TIMER);
                    }
                    case START_CLOCK: {
                        this.setCancelProgress(ProgressTable.STAGE.START_CLOCK);
                    }
                    case SEND_STARTMSG: 
                    case WAIT_PROCINFO: {
                        try {
                            DACommunicator.stopTrace();
                        }
                        catch (Exception exception) {
                            Logger.error((Object)"Interrupted during stop trace");
                        }
                        this.setCancelProgress(ProgressTable.STAGE.SEND_STARTMSG);
                    }
                    case START_RESOURCE_MONITOR: {
                        if (Global.isGUIMode()) {
                            Toolbar.INSTANCE.stopTimer();
                        }
                        UpdateViewTimer.stop();
                        ResourceMonitor.stop();
                        this.setCancelProgress(ProgressTable.STAGE.START_RESOURCE_MONITOR);
                    }
                    case CREATE_CALLSTACK_INSERTER: {
                        CallStackInserter.getInstance().stopForced();
                        this.setCancelProgress(ProgressTable.STAGE.CREATE_CALLSTACK_INSERTER);
                    }
                    case CREATE_PAGEMANAGER: {
                        DataManagerRegistry.stopThreadsForced();
                        this.setCancelProgress(ProgressTable.STAGE.CREATE_PAGEMANAGER);
                    }
                    case CREATE_LOGPARSER: {
                        LogParser.getInstance().stopForced();
                        this.setCancelProgress(ProgressTable.STAGE.CREATE_LOGPARSER);
                    }
                    case CREATE_MESSAGEPARSER: {
                        MessageParser.getInstance().stopForced();
                        this.setCancelProgress(ProgressTable.STAGE.CREATE_MESSAGEPARSER);
                    }
                    case CREATE_DATATHREAD: {
                        DataChannelThread.getInstance().stopForced();
                        this.setCancelProgress(ProgressTable.STAGE.CREATE_DATATHREAD);
                    }
                    case CREATE_PROJECT: 
                    case ESTABLISH_DB: 
                    case CREATE_DBTABLE: 
                    case RESET_UI: {
                        CommonAction.clear();
                        this.setCancelProgress(ProgressTable.STAGE.CREATE_PROJECT);
                    }
                    case CHECK_DEV: 
                    case CHECK_APP: 
                    case CHECK_CONFIG: {
                        break;
                    }
                }
                DAState.changeCurrentState(DAState.INIT);
            } else {
                DAState.changeCurrentState(DAState.RUNNING);
            }
            if (this.progressDlg != null) {
                Display.getDefault().syncExec(new /* invalid duplicate definition of identical inner class */);
            }
            if (!result.isSuccess()) {
                UIActionHolder.getUIAction().showWarning(result);
            }
            if (!Global.isGUIMode()) throw throwable;
            ShortCutManager.getInstance().setEnabled(true);
            Toolbar.INSTANCE.changeUIState(DAState.getCurrentState());
            throw throwable;
        }
        if (this.lastStage != ProgressTable.STAGE.FINAL) {
            DAState.changeCurrentState(DAState.PREPARE_CANCEL);
            switch (this.lastStage) {
                case CREATE_UPDATE_TIMER: 
                case FINAL: {
                    this.setCancelProgress(ProgressTable.STAGE.CREATE_UPDATE_TIMER);
                }
                case CREATE_SCREENSHOT_TIMER: {
                    ScreenshotTimer.stop();
                    this.setCancelProgress(ProgressTable.STAGE.CREATE_SCREENSHOT_TIMER);
                }
                case CREATE_REPLAY_TIMER: {
                    ReplayManager.resetStopAlarm();
                    this.setCancelProgress(ProgressTable.STAGE.CREATE_REPLAY_TIMER);
                }
                case START_CLOCK: {
                    this.setCancelProgress(ProgressTable.STAGE.START_CLOCK);
                }
                case SEND_STARTMSG: 
                case WAIT_PROCINFO: {
                    try {
                        DACommunicator.stopTrace();
                    }
                    catch (Exception exception) {
                        Logger.error((Object)"Interrupted during stop trace");
                    }
                    this.setCancelProgress(ProgressTable.STAGE.SEND_STARTMSG);
                }
                case START_RESOURCE_MONITOR: {
                    if (Global.isGUIMode()) {
                        Toolbar.INSTANCE.stopTimer();
                    }
                    UpdateViewTimer.stop();
                    ResourceMonitor.stop();
                    this.setCancelProgress(ProgressTable.STAGE.START_RESOURCE_MONITOR);
                }
                case CREATE_CALLSTACK_INSERTER: {
                    CallStackInserter.getInstance().stopForced();
                    this.setCancelProgress(ProgressTable.STAGE.CREATE_CALLSTACK_INSERTER);
                }
                case CREATE_PAGEMANAGER: {
                    DataManagerRegistry.stopThreadsForced();
                    this.setCancelProgress(ProgressTable.STAGE.CREATE_PAGEMANAGER);
                }
                case CREATE_LOGPARSER: {
                    LogParser.getInstance().stopForced();
                    this.setCancelProgress(ProgressTable.STAGE.CREATE_LOGPARSER);
                }
                case CREATE_MESSAGEPARSER: {
                    MessageParser.getInstance().stopForced();
                    this.setCancelProgress(ProgressTable.STAGE.CREATE_MESSAGEPARSER);
                }
                case CREATE_DATATHREAD: {
                    DataChannelThread.getInstance().stopForced();
                    this.setCancelProgress(ProgressTable.STAGE.CREATE_DATATHREAD);
                }
                case CREATE_PROJECT: 
                case ESTABLISH_DB: 
                case CREATE_DBTABLE: 
                case RESET_UI: {
                    CommonAction.clear();
                    this.setCancelProgress(ProgressTable.STAGE.CREATE_PROJECT);
                }
                case CHECK_DEV: 
                case CHECK_APP: 
                case CHECK_CONFIG: {
                    break;
                }
            }
            DAState.changeCurrentState(DAState.INIT);
        } else {
            DAState.changeCurrentState(DAState.RUNNING);
        }
        if (this.progressDlg != null) {
            Display.getDefault().syncExec(new /* invalid duplicate definition of identical inner class */);
        }
        if (!result.isSuccess()) {
            UIActionHolder.getUIAction().showWarning(result);
        }
        if (!Global.isGUIMode()) return;
        ShortCutManager.getInstance().setEnabled(true);
        Toolbar.INSTANCE.changeUIState(DAState.getCurrentState());
    }

    private void setProgressPercent(int percent) {
        final int per = percent;
        if (this.progressDlg != null) {
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    StartTraceManager.this.progressDlg.setValue(per);
                }
            });
        }
    }

    private void setStageComplete(ProgressTable.STAGE st) throws InterruptedException {
        Logger.debug((Object)("done stage: " + (Object)((Object)st)));
        this.lastStage = st;
        int percent = ProgressTable.getPercent(ProgressTable.PHASE.TRACE_START, this.lastStage);
        if (percent != 100) {
            this.testCancel();
        }
        this.setProgressPercent(percent);
    }

    private void setCancelProgress(ProgressTable.STAGE st) {
        int percent = ProgressTable.getPercent(ProgressTable.PHASE.CANCEL_TRACE_START, st);
        this.setProgressPercent(percent);
    }

    private void testCancel() throws InterruptedException {
        if (this.startThread.isInterrupted() || AnalyzerManager.isExit()) {
            throw new InterruptedException();
        }
    }

    private void startDlog() {
        Thread DlogThread = new Thread(new Runnable(){

            @Override
            public void run() {
                DLogDataManager.getInstance().startDlog();
            }
        });
        DlogThread.start();
    }
}

