/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.protocol;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.tizen.dynamicanalyzer.protocol.IProtocolConfig;
import org.tizen.dynamicanalyzer.protocol.UnknownProtocolException;
import org.tizen.dynamicanalyzer.protocol.p30.ProtocolConfig30;
import org.tizen.dynamicanalyzer.protocol.p30_uihv.ProtocolConfig30_UIHV;
import org.tizen.dynamicanalyzer.protocol.p40.ProtocolConfig40;
import org.tizen.dynamicanalyzer.protocol.p41.ProtocolConfig41;
import org.tizen.dynamicanalyzer.setting.Feature;

public enum Protocol {
    VERSION_UNKNOWN("", 0.0),
    VERSION_30("3.0", 3.1),
    VERSION_30A("3.0 a", 3.01),
    VERSION_30_UIHV("3.0_UIHV", 3.02),
    VERSION_40("4.0", 4.0),
    VERSION_41("4.1", 4.1),
    VERSION_42("4.2", 4.2);

    private String versionName;
    private double versionNum;
    private static final Map<Integer, String> dataMsgNameMap;

    static {
        HashMap<Integer, String> tempMap = new HashMap<Integer, String>();
        tempMap.put(1, "MSG_DATA_PROCESS_INFO");
        tempMap.put(2, "MSG_DATA_TERMINATE");
        tempMap.put(3, "MSG_DATA_ERROR");
        tempMap.put(4, "MSG_DATA_SAMPLE");
        tempMap.put(5, "MSG_DATA_SYSTEM");
        tempMap.put(6, "MSG_DATA_IMAGE");
        tempMap.put(7, "MSG_DATA_RECORD");
        tempMap.put(8, "MSG_FUNCTION_ENTRY");
        tempMap.put(9, "MSG_FUNCTION_EXIT");
        tempMap.put(10, "MSG_SYSCALL_ENTRY");
        tempMap.put(11, "MSG_SYSCALL_EXIT");
        tempMap.put(12, "MSG_FILE_FUNCTION_ENTRY");
        tempMap.put(13, "MSG_FILE_FUNCTION_EXIT");
        tempMap.put(14, "MSG_PROCESS_STATUS_INFO");
        tempMap.put(16, "MSG_CONTEXT_SWITCH_ENTRY");
        tempMap.put(17, "MSG_CONTEXT_SWITCH_EXIT");
        tempMap.put(18, "MSG_PROCESS_MAP");
        tempMap.put(19, "MSG_PROCESS_UNMAP");
        tempMap.put(20, "MSG_PROCESS_COMM");
        tempMap.put(21, "MSG_WEB_FUNCTION_ENTRY");
        tempMap.put(22, "MSG_WEB_FUNCTION_EXIT");
        tempMap.put(25, "MSG_APP_STARTUP");
        tempMap.put(26, "MSG_WEB_APP_STARTUP");
        tempMap.put(32, "MSG_FBI");
        tempMap.put(33, "MSG_UI_HIERARCHY");
        tempMap.put(257, "MSG_PROBE_MEMORY");
        tempMap.put(258, "MSG_PROBE_UICONTROL");
        tempMap.put(259, "MSG_PROBE_UIEVENT");
        tempMap.put(260, "MSG_PROBE_FILE");
        tempMap.put(261, "MSG_PROBE_LIFECYCLE");
        tempMap.put(262, "MSG_PROBE_SCREENSHOT");
        tempMap.put(263, "MSG_PROBE_SCENE");
        tempMap.put(264, "MSG_PROBE_THREAD");
        tempMap.put(265, "MSG_PROBE_CUSTOM");
        tempMap.put(272, "MSG_PROBE_SYNC");
        tempMap.put(273, "MSG_PROBE_NETWORK");
        tempMap.put(274, "MSG_PROBE_GLES20");
        dataMsgNameMap = Collections.unmodifiableMap(tempMap);
    }

    private Protocol(String versionName, double version) {
        this.versionName = versionName;
        this.versionNum = version;
    }

    public String toString() {
        return this.versionName;
    }

    public double getVersionNum() {
        return this.versionNum;
    }

    public static Protocol getVersion(String versionString) {
        Protocol[] versions;
        Protocol[] protocolArray = versions = Protocol.values();
        int n = versions.length;
        int n2 = 0;
        while (n2 < n) {
            Protocol ver = protocolArray[n2];
            if (ver.versionName.equals(versionString)) {
                return ver;
            }
            ++n2;
        }
        return VERSION_UNKNOWN;
    }

    public static IProtocolConfig[] getProtocolConfig(Protocol protocolVersion, Feature feature) throws UnknownProtocolException {
        IProtocolConfig[] configs = null;
        switch (protocolVersion) {
            case VERSION_30: 
            case VERSION_30A: {
                configs = ProtocolConfig30.getProtocolConfig(feature);
                break;
            }
            case VERSION_30_UIHV: {
                configs = ProtocolConfig30_UIHV.getProtocolConfig(feature);
                break;
            }
            case VERSION_40: {
                configs = ProtocolConfig40.getProtocolConfig(feature);
                break;
            }
            case VERSION_41: 
            case VERSION_42: {
                configs = ProtocolConfig41.getProtocolConfig(feature);
                break;
            }
            default: {
                throw new UnknownProtocolException();
            }
        }
        return configs;
    }

    public static String getDataMessageName(int msgid) {
        String name = dataMsgNameMap.get(msgid);
        if (name == null) {
            return "";
        }
        return name;
    }
}

