/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.interactive.data;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.tizen.dynamicanalyzer.database.DBColumn;
import org.tizen.dynamicanalyzer.database.DBTable;
import org.tizen.dynamicanalyzer.util.Logger;

public class InteractiveValueDBTable
extends DBTable {
    private static final String TABLENAME = "CHECKPOINT_VALUE";
    private static final int MAX_BYTES_LEN = 1024;
    public static final String SEQUENCE_NUMBER = "SEQUENCE_NUMBER";
    public static final String SAMPLING_TIME = "SAMPLING_TIME";
    public static final String VARIABLE_ID = "VARIABLE_ID";
    public static final String VALUE_SIZE = "VALUE_SIZE";
    public static final String VALUE = "VALUE";

    @Override
    public String getTableName() {
        return TABLENAME;
    }

    public InteractiveValueDBTable() {
        this.addColumn(new DBColumn(SEQUENCE_NUMBER, "PRIMARY KEY", "BIGINT"));
        this.addColumn(new DBColumn(SAMPLING_TIME, "NOT NULL", "BIGINT"));
        this.addColumn(new DBColumn(VARIABLE_ID, "NOT NULL", "BIGINT"));
        this.addColumn(new DBColumn(VALUE_SIZE, "NOT NULL", "BIGINT"));
        this.addColumn(new DBColumn(VALUE, "NOT NULL", "VARBINARY", 1024));
    }

    @Override
    public boolean prepare(PreparedStatement prep, List<Object> rowData) {
        boolean isPrepared = true;
        int columnsize = this.getColumnSize();
        if (columnsize != rowData.size()) {
            isPrepared = false;
        } else {
            try {
                int index = 1;
                prep.setLong(index++, (Long)rowData.get(COLUMN.SEQUENCE_NUMBER.ordinal()));
                prep.setLong(index++, (Long)rowData.get(COLUMN.SAMPLING_TIME.ordinal()));
                prep.setLong(index++, (Long)rowData.get(COLUMN.VARIABLE_ID.ordinal()));
                prep.setLong(index++, (Long)rowData.get(COLUMN.VALUE_SIZE.ordinal()));
                prep.setBytes(index++, (byte[])rowData.get(COLUMN.VALUE.ordinal()));
            }
            catch (SQLException e) {
                Logger.error((Object)e);
                isPrepared = false;
            }
        }
        return isPrepared;
    }

    @Override
    public List<Object> extractDataFromResultSet(ResultSet rs) {
        ArrayList<Object> row = new ArrayList<Object>();
        try {
            row.add(rs.getLong(1));
            row.add(rs.getLong(2));
            row.add(rs.getLong(3));
            row.add(rs.getLong(4));
            row.add(rs.getBytes(5));
        }
        catch (SQLException e) {
            Logger.error((Object)e);
            return null;
        }
        return row;
    }

    public static enum COLUMN {
        SEQUENCE_NUMBER,
        SAMPLING_TIME,
        VARIABLE_ID,
        VALUE_SIZE,
        VALUE;

    }
}

