/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.interactive.table;

import org.eclipse.nebula.widgets.grid.GridItem;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.tizen.dynamicanalyzer.resources.ColorResources;
import org.tizen.dynamicanalyzer.resources.FontResources;
import org.tizen.dynamicanalyzer.ui.interactive.data.InteractiveUIData;
import org.tizen.dynamicanalyzer.ui.interactive.table.InteractiveTableToggleRenderer;
import org.tizen.dynamicanalyzer.ui.widgets.table.DATableCellRenderer;
import org.tizen.dynamicanalyzer.ui.widgets.table.DATableDataFormat;
import org.tizen.dynamicanalyzer.util.Logger;

public class InteractiveTableCellRenderer
extends DATableCellRenderer {
    @Override
    public void setTree(boolean tree) {
        super.setTree(tree);
        if (tree) {
            this.toggleRenderer = new InteractiveTableToggleRenderer();
            this.toggleRenderer.setDisplay(this.getDisplay());
        }
    }

    @Override
    public void paint(GC gc, Object value) {
        int len;
        Image image;
        GridItem item = (GridItem)value;
        gc.setFont(item.getFont(this.getColumn()));
        boolean drawAsSelected = this.isSelected();
        boolean drawBackground = true;
        if (this.isCellSelected()) {
            drawAsSelected = true;
        }
        if (drawAsSelected) {
            gc.setForeground(ColorResources.TABLE_CONTENTS_SELECTED_START);
            gc.setBackground(ColorResources.TABLE_CONTENTS_SELECTED_START);
        } else if (item.getParent().isEnabled()) {
            Color bg = item.getBackground();
            if (bg != null) {
                gc.setBackground(bg);
            } else {
                drawBackground = false;
            }
        } else {
            gc.setBackground(this.getDisplay().getSystemColor(22));
        }
        if (drawBackground && drawAsSelected) {
            gc.fillGradientRectangle(this.getBounds().x, this.getBounds().y, this.getBounds().width, this.getBounds().height, true);
        } else if (drawBackground) {
            gc.fillRectangle(this.getBounds().x, this.getBounds().y + 1, this.getBounds().width, this.getBounds().height);
        }
        int x = this.leftMargin;
        if (this.isTree()) {
            x += this.getToggleIndent(item);
            if (drawAsSelected) {
                this.toggleRenderer.setSelected(true);
            } else {
                this.toggleRenderer.setSelected(false);
            }
            this.toggleRenderer.setExpanded(item.isExpanded());
            this.toggleRenderer.setHover(this.getHoverDetail().equals("toggle"));
            this.toggleRenderer.setLocation(this.getBounds().x + x, (this.getBounds().height - this.toggleRenderer.getBounds().height) / 2 + this.getBounds().y);
            this.toggleRenderer.paint(gc, item);
            x += this.toggleRenderer.getBounds().width + this.insideMargin;
        }
        if ((image = item.getImage(this.getColumn())) != null) {
            int y = this.getBounds().y;
            gc.drawImage(image, this.getBounds().x + x, y += (this.getBounds().height - image.getBounds().height) / 2);
            x += image.getBounds().width + this.insideMargin;
        }
        int width = this.getBounds().width - x - this.rightMargin;
        String text = item.getText(this.getColumn());
        if (this.getAlignment() == 131072) {
            len = gc.stringExtent((String)text).x;
            if (len < width) {
                x += width - len;
            }
        } else if (this.getAlignment() == 0x1000000 && (len = gc.stringExtent((String)text).x) < width) {
            x += (width - len) / 2;
        }
        if (drawAsSelected) {
            gc.setForeground(ColorResources.TABLE_CONTENTS_SELECTED_FONT_COLOR);
        } else {
            DATableDataFormat tableData = (DATableDataFormat)item.getData();
            InteractiveUIData uiData = (InteractiveUIData)tableData.getObject();
            Color cellColor = ColorResources.TABLE_CONTENTS_FONT_COLOR;
            int checkLocation = uiData.getCheckLocation();
            if (checkLocation == 1) {
                cellColor = ColorResources.SERIES_COLOR_INTERACTIVE_BEFORE;
            } else if (checkLocation == 2) {
                cellColor = ColorResources.SERIES_COLOR_INTERACTIVE_AFTER;
            } else {
                Logger.error((Object)"Impossible case!!");
            }
            gc.setForeground(cellColor);
        }
        gc.setFont(FontResources.TABLE_CELL_FONT);
        if (this.isTree() && this.getColumn() != 0) {
            gc.drawText(text, this.getBounds().x + x, this.getBounds().y + this.textTopMargin, true);
        } else if (!this.isTree() || this.getColumn() != 0) {
            gc.drawText(text, this.getBounds().x + x, this.getBounds().y + this.textTopMargin, true);
        }
        if (item.getParent().getLinesVisible()) {
            gc.setForeground(ColorResources.TABLE_LINE);
            gc.drawLine(this.getBounds().x, this.getBounds().y + this.getBounds().height, this.getBounds().x + this.getBounds().width - 1, this.getBounds().y + this.getBounds().height);
            gc.drawLine(this.getBounds().x + this.getBounds().width - 1, this.getBounds().y, this.getBounds().x + this.getBounds().width - 1, this.getBounds().y + this.getBounds().height);
        }
    }
}

