/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.kernel;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.nebula.widgets.grid.Grid;
import org.eclipse.nebula.widgets.grid.GridItem;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.tizen.dynamicanalyzer.common.AnalyzerManager;
import org.tizen.dynamicanalyzer.common.DASelectionData;
import org.tizen.dynamicanalyzer.common.Global;
import org.tizen.dynamicanalyzer.model.TableInput;
import org.tizen.dynamicanalyzer.ui.kernel.KernelPage;
import org.tizen.dynamicanalyzer.ui.kernel.data.ContextDataDBTable;
import org.tizen.dynamicanalyzer.ui.kernel.data.FunctionDataDBTable;
import org.tizen.dynamicanalyzer.ui.kernel.data.KernelDataManager;
import org.tizen.dynamicanalyzer.ui.kernel.data.KernelDataPerThread;
import org.tizen.dynamicanalyzer.ui.range.RangeDataManager;
import org.tizen.dynamicanalyzer.ui.toolbar.Toolbar;
import org.tizen.dynamicanalyzer.ui.widgets.table.DATableDataFormat;
import org.tizen.dynamicanalyzer.ui.widgets.table.DAWindowingTableComposite;
import org.tizen.dynamicanalyzer.widgets.da.view.DAViewData;
import org.tizen.dynamicanalyzer.widgets.helper.Formatter;

public class KernelListTable
extends DAWindowingTableComposite {
    private KernelDataPerThread selectedData = null;
    private boolean isCoreSelected = true;

    public KernelListTable(Composite parent, int compStyle, int tableStyle) {
        super(parent, compStyle, tableStyle);
        this.setDataType(0);
        this.setContextMenu(1);
        this.table.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                GridItem[] ti = ((Grid)e.widget).getSelection();
                if (ti == null || ti.length == 0) {
                    return;
                }
                int size = ti.length;
                List<Object> startData = ((DATableDataFormat)ti[0].getData()).getData();
                List<Object> endData = ((DATableDataFormat)ti[size - 1].getData()).getData();
                long startTime = (Long)startData.get(KernelListTable.this.timeColumnIndex);
                long endTime = (Long)endData.get(KernelListTable.this.timeColumnIndex);
                DASelectionData data = new DASelectionData(KernelPage.listViewID, startTime, endTime, ti, (Control)KernelListTable.this.table);
                AnalyzerManager.getCurrentPage().updateView((DAViewData)data);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    @Override
    protected List<TableInput> makeTableInput() {
        ArrayList<TableInput> input = new ArrayList<TableInput>();
        List<List<Object>> queriedData = this.getQueriedObjectData();
        if (queriedData == null) {
            return null;
        }
        int size = queriedData.size();
        int i = 0;
        while (i < size) {
            long exectime;
            long endtime;
            long starttime;
            long seqnum;
            List<Object> row = queriedData.get(i);
            ArrayList<String> text = new ArrayList<String>();
            if (this.isCoreSelected) {
                seqnum = (Long)row.get(ContextDataDBTable.COLUMN.SEQ.index);
                starttime = (Long)row.get(ContextDataDBTable.COLUMN.STARTTIME.index);
                endtime = (Long)row.get(ContextDataDBTable.COLUMN.ENDTIME.index);
                exectime = endtime - starttime;
                text.add(row.get(ContextDataDBTable.COLUMN.SEQ.index).toString());
                text.add(row.get(ContextDataDBTable.COLUMN.PID.index).toString());
                text.add(row.get(ContextDataDBTable.COLUMN.TID.index).toString());
                text.add(row.get(ContextDataDBTable.COLUMN.CPUNUM.index).toString());
                text.add(Formatter.toTimeFormat((long)starttime));
                text.add(Formatter.toTimeFormat((long)endtime));
                text.add(Formatter.toTimeFormat((long)exectime));
                text.add(row.get(ContextDataDBTable.COLUMN.STARTADDR.index).toString());
                text.add(row.get(ContextDataDBTable.COLUMN.ENDADDR.index).toString());
                text.add("");
            } else {
                seqnum = (Long)row.get(FunctionDataDBTable.COLUMN.SEQ.index);
                starttime = (Long)row.get(FunctionDataDBTable.COLUMN.STARTTIME.index);
                endtime = (Long)row.get(FunctionDataDBTable.COLUMN.ENDTIME.index);
                exectime = endtime - starttime;
                text.add(row.get(FunctionDataDBTable.COLUMN.SEQ.index).toString());
                text.add(row.get(FunctionDataDBTable.COLUMN.PID.index).toString());
                text.add(row.get(FunctionDataDBTable.COLUMN.TID.index).toString());
                text.add(row.get(FunctionDataDBTable.COLUMN.CPUNUM.index).toString());
                text.add(Formatter.toTimeFormat((long)starttime));
                text.add(Formatter.toTimeFormat((long)endtime));
                text.add(Formatter.toTimeFormat((long)exectime));
                text.add(row.get(FunctionDataDBTable.COLUMN.STARTADDR.index).toString());
                text.add(row.get(FunctionDataDBTable.COLUMN.ENDADDR.index).toString());
                int funcId = (Integer)row.get(FunctionDataDBTable.COLUMN.FUNCID.index);
                text.add(Global.getFunctionName(funcId));
            }
            DATableDataFormat tableData = new DATableDataFormat(seqnum);
            tableData.getData().add(new Long(starttime));
            if (this.isCoreSelected) {
                tableData.setType(64);
            } else {
                tableData.setType(128);
            }
            TableInput tableInput = new TableInput();
            tableInput.setText(text);
            tableInput.setData(tableData);
            input.add(tableInput);
            if (RangeDataManager.getInstance().isBeingAnalyzed()) {
                long analysisStartTime = RangeDataManager.getInstance().getAnalysisStartTime();
                long analysisEndTime = RangeDataManager.getInstance().getAnalysisEndTime();
                if (starttime <= analysisEndTime && endtime >= analysisStartTime) {
                    tableInput.setInRange(true);
                }
            }
            ++i;
        }
        return input;
    }

    @Override
    protected int getItemCountByPid() {
        if (this.selectedData == null) {
            return 0;
        }
        int itemCount = 0;
        int selectedPid = Toolbar.INSTANCE.getSelectedPid();
        if (selectedPid == 0 || this.selectedData.getPid() == selectedPid) {
            itemCount = this.isCoreSelected ? this.selectedData.getCoreFragmentCount() : this.selectedData.getFuncFragmentCount();
        }
        return itemCount;
    }

    @Override
    protected List<String> getDBTableColumnNames() {
        ArrayList<String> columnName = new ArrayList<String>();
        columnName.add("*");
        return columnName;
    }

    @Override
    protected String getDBTableName() {
        if (this.selectedData == null) {
            return null;
        }
        String tablename = this.isCoreSelected ? KernelDataManager.getInstance().getContextDataTable().getTableName() : KernelDataManager.getInstance().getFunctionDataTable().getTableName();
        return tablename;
    }

    @Override
    protected String getSelectQueryOption() {
        String never_option = "TID = -1";
        if (this.selectedData == null) {
            return never_option;
        }
        int selectedPid = Toolbar.INSTANCE.getSelectedPid();
        if (selectedPid == 0 || this.selectedData.getPid() == selectedPid) {
            String option = "TID = " + this.selectedData.getTid() + " order by ";
            option = this.isCoreSelected ? String.valueOf(option) + ContextDataDBTable.COLUMN.STARTTIME.name : String.valueOf(option) + FunctionDataDBTable.COLUMN.STARTTIME.name;
            return option;
        }
        return never_option;
    }

    @Override
    protected String getSelectQueryCountOption() {
        String never_option = "TID = -1";
        if (this.selectedData == null) {
            return never_option;
        }
        int selectedPid = Toolbar.INSTANCE.getSelectedPid();
        if (selectedPid == 0 || this.selectedData.getPid() == selectedPid) {
            String option = "TID = " + this.selectedData.getTid();
            return option;
        }
        return never_option;
    }

    public void setSelectedData(KernelDataPerThread kdata, boolean isCore) {
        this.selectedData = kdata;
        this.isCoreSelected = isCore;
    }

    @Override
    protected String getTimeColumnName() {
        String timestr = this.isCoreSelected ? ContextDataDBTable.COLUMN.STARTTIME.name : FunctionDataDBTable.COLUMN.STARTTIME.name;
        return timestr;
    }
}

