/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.memory.data;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.tizen.dynamicanalyzer.database.DBColumn;
import org.tizen.dynamicanalyzer.database.DBTable;
import org.tizen.dynamicanalyzer.util.Logger;

public class MemAllocDBTable
extends DBTable {
    public static final String TABLENAME = "MEM_ALLOC_DB";

    @Override
    public String getTableName() {
        return TABLENAME;
    }

    public MemAllocDBTable() {
        this.addColumn(new DBColumn(COLUMN.SEQUENCE_NUMBER.name, "PRIMARY KEY", "BIGINT"));
        this.addColumn(new DBColumn(COLUMN.PID.name, "NOT NULL", "INTEGER"));
        this.addColumn(new DBColumn(COLUMN.API_ID.name, "NOT NULL", "INTEGER"));
        this.addColumn(new DBColumn(COLUMN.API_TYPE.name, "NOT NULL", "INTEGER"));
        this.addColumn(new DBColumn(COLUMN.ALLOCATED_ADDRESS.name, "NOT NULL", "BIGINT"));
        this.addColumn(new DBColumn(COLUMN.ALLOCATED_TIME.name, "NOT NULL", "BIGINT"));
        this.addColumn(new DBColumn(COLUMN.CALLER_PC_ADDRESS.name, "", "BIGINT"));
        this.addColumn(new DBColumn(COLUMN.CALLER_LIBRARY_ID.name, "NOT NULL", "INTEGER"));
        this.addColumn(new DBColumn(COLUMN.MESSAGE_ID.name, "NOT NULL", "INTEGER"));
        this.addColumn(new DBColumn(COLUMN.ALLOCATED_MEMORY_SIZE.name, "NOT NULL", "BIGINT"));
        this.setIndexColumn(COLUMN.PID.index);
        this.setIndexColumn(COLUMN.SEQUENCE_NUMBER.index);
        this.setIndexColumn(COLUMN.ALLOCATED_TIME.index);
    }

    @Override
    public boolean prepare(PreparedStatement prep, List<Object> rowData) {
        boolean isPrepared = true;
        int columnsize = this.getColumnSize();
        if (columnsize != rowData.size()) {
            isPrepared = false;
        } else {
            try {
                prep.setLong(1, (Long)rowData.get(COLUMN.SEQUENCE_NUMBER.index));
                prep.setInt(2, (Integer)rowData.get(COLUMN.PID.index));
                prep.setInt(3, (Integer)rowData.get(COLUMN.API_ID.index));
                prep.setInt(4, (Integer)rowData.get(COLUMN.API_TYPE.index));
                prep.setLong(5, (Long)rowData.get(COLUMN.ALLOCATED_ADDRESS.index));
                prep.setLong(6, (Long)rowData.get(COLUMN.ALLOCATED_TIME.index));
                prep.setLong(7, (Long)rowData.get(COLUMN.CALLER_PC_ADDRESS.index));
                prep.setInt(8, (Integer)rowData.get(COLUMN.CALLER_LIBRARY_ID.index));
                prep.setInt(9, (Integer)rowData.get(COLUMN.MESSAGE_ID.index));
                prep.setLong(10, (Long)rowData.get(COLUMN.ALLOCATED_MEMORY_SIZE.index));
            }
            catch (SQLException e) {
                Logger.exception((Throwable)e);
                isPrepared = false;
            }
        }
        return isPrepared;
    }

    @Override
    public List<Object> extractDataFromResultSet(ResultSet rs) {
        ArrayList<Object> row = new ArrayList<Object>();
        try {
            row.add(rs.getLong(1));
            row.add(rs.getInt(2));
            row.add(rs.getInt(3));
            row.add(rs.getInt(4));
            row.add(rs.getLong(5));
            row.add(rs.getLong(6));
            row.add(rs.getLong(7));
            row.add(rs.getInt(8));
            row.add(rs.getInt(9));
            row.add(rs.getLong(10));
        }
        catch (SQLException e) {
            Logger.exception((Throwable)e);
            return null;
        }
        return row;
    }

    public static enum COLUMN {
        SEQUENCE_NUMBER(0, "SEQUENCE_NUMBER"),
        PID(1, "PID"),
        API_ID(2, "API_ID"),
        API_TYPE(3, "API_TYPE"),
        ALLOCATED_ADDRESS(4, "ALLOCATED_ADDRESS"),
        ALLOCATED_TIME(5, "ALLOCATED_TIME"),
        CALLER_PC_ADDRESS(6, "CALLER_PC_ADDRESS"),
        CALLER_LIBRARY_ID(7, "CALLER_LIBRARY_ID"),
        MESSAGE_ID(8, "MESSAGE_ID"),
        ALLOCATED_MEMORY_SIZE(9, "ALLOCATED_MEMORY_SIZE");

        public final int index;
        public final String name;

        private COLUMN(int index, String name) {
            this.index = index;
            this.name = name;
        }
    }
}

