/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.memory.table;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.nebula.widgets.grid.Grid;
import org.eclipse.nebula.widgets.grid.GridItem;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.tizen.dynamicanalyzer.common.DAState;
import org.tizen.dynamicanalyzer.common.Global;
import org.tizen.dynamicanalyzer.model.TableInput;
import org.tizen.dynamicanalyzer.nl.MemoryPageLabels;
import org.tizen.dynamicanalyzer.ui.memory.data.HeapDataManager;
import org.tizen.dynamicanalyzer.ui.toolbar.Toolbar;
import org.tizen.dynamicanalyzer.ui.widgets.table.DATableComposite;
import org.tizen.dynamicanalyzer.ui.widgets.table.DATableDataFormat;
import org.tizen.dynamicanalyzer.ui.widgets.table.DefaultTableComparator;
import org.tizen.dynamicanalyzer.ui.widgets.table.TableColumnSizePackListener;
import org.tizen.dynamicanalyzer.utils.AnalyzerUtil;

public class MemoryAllocationTraceTable
extends DATableComposite {
    private int[] columnSizes = new int[]{60, 105, 50, 90, 70, 295, 105, 15, 800};
    private int[] columnAlignment = new int[]{131072, 0x1000000, 0x1000000, 131072, 131072, 16384, 0x1000000, 16384, 0x1000000};
    private Long StartTime;
    private Long EndTime;
    private String[] columnNames = new String[]{MemoryPageLabels.MEMORY_ALLOCATION_TRACE_VIEW_SEQ, MemoryPageLabels.MEMORY_ALLOCATION_TRACE_VIEW_TIMESTAMP, MemoryPageLabels.MEMORY_ALLOCATION_TRACE_VIEW_LIVE, MemoryPageLabels.MEMORY_ALLOCATION_TRACE_VIEW_ADDRESS, MemoryPageLabels.MEMORY_ALLOCATION_TRACE_VIEW_SIZE, MemoryPageLabels.MEMORY_ALLOCATION_TRACE_VIEW_LIBRARY, MemoryPageLabels.MEMORY_ALLOCATION_TRACE_VIEW_CALLER_FUNCTION, "", "Streaming is not supported. Please select range or stop Tracing"};
    int[] sortTypes;

    public MemoryAllocationTraceTable(Composite parent, int style, int tableStyle) {
        super(parent, style, tableStyle);
        int[] nArray = new int[9];
        nArray[0] = 1;
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 1;
        nArray[4] = 1;
        nArray[5] = 2;
        nArray[6] = 2;
        nArray[8] = 2;
        this.sortTypes = nArray;
        this.StartTime = 0L;
        this.EndTime = 0L;
        this.setTableName(MemoryPageLabels.MEMORY_ALLOCATION_TRACE_VIEW_TITLE);
        this.setComparator(new DefaultTableComparator());
        this.setSortTypes(this.sortTypes);
        this.setColumnAlignment(this.columnAlignment);
        this.setColumns(this.columnNames);
        this.setColumnSize(this.columnSizes);
        this.setTableToolTipEnable(false);
        parent.addControlListener((ControlListener)new TableColumnSizePackListener(this, this.columnSizes));
        this.table.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                GridItem[] items = MemoryAllocationTraceTable.this.table.getSelection();
                if (items == null) {
                    return;
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.table.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
                GridItem[] ti = ((Grid)e.widget).getSelection();
                if (ti == null || ti.length == 0) {
                    return;
                }
                List<Object> markerData = ((DATableDataFormat)ti[0].getData()).getData();
                long markerTime = (Long)markerData.get(1);
                AnalyzerUtil.addMarker(markerTime);
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseUp(MouseEvent e) {
            }
        });
    }

    public void setSelectionRange(Long start, Long end) {
        this.StartTime = start;
        this.EndTime = end;
    }

    @Override
    protected List<TableInput> makeTableInput() {
        List<TableInput> wholedata;
        ArrayList<TableInput> output = new ArrayList<TableInput>();
        if (Global.getProject() == null) {
            return output;
        }
        if (!DAState.isRunning() && this.StartTime == 0L && this.EndTime == 0L && Toolbar.INSTANCE.getSelectedPid() <= 0 && (wholedata = HeapDataManager.getInstance().getWholeAllocationTraceTreeInput()).size() != 0) {
            return wholedata;
        }
        List<List<Object>> allocDataList = null;
        String pidliststring = this.getTargetPIDString();
        allocDataList = HeapDataManager.getInstance().remainedAllocatedListForRange(this.StartTime, this.EndTime, pidliststring);
        if (allocDataList == null || allocDataList.size() == 0) {
            return output;
        }
        int index = 0;
        int size = allocDataList.size();
        int j = 0;
        while (j < size) {
            List<Object> iAllocData = allocDataList.get(j);
            TableInput alloInput = HeapDataManager.getInstance().makeTreeInputForLeakData(iAllocData, index++);
            if (alloInput != null) {
                output.add(alloInput);
            }
            ++j;
        }
        return output;
    }

    public void removeSelection() {
        this.table.removeAll();
        this.updateTable();
    }

    private String getTargetPIDString() {
        ArrayList<Integer> pidlist = new ArrayList<Integer>();
        int[] pids = Global.getProject().getProcessIDs();
        int targetPID = Toolbar.INSTANCE.getSelectedPid();
        if (targetPID > 0) {
            pidlist.add(targetPID);
        } else {
            int i = 0;
            while (i < pids.length) {
                pidlist.add(pids[i]);
                ++i;
            }
        }
        String pidliststring = "(";
        int i = 0;
        while (i < pidlist.size()) {
            pidliststring = String.valueOf(pidliststring) + Integer.toString((Integer)pidlist.get(i));
            if (i != pidlist.size() - 1) {
                pidliststring = String.valueOf(pidliststring) + ", ";
            }
            ++i;
        }
        pidliststring = String.valueOf(pidliststring) + ")";
        return pidliststring;
    }

    @Override
    public void clear() {
        this.table.removeAll();
        this.getSelectionIndex().clear();
        this.getSelections().clear();
        this.StartTime = 0L;
        this.EndTime = 0L;
    }
}

