/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.network.data;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.tizen.dynamicanalyzer.swap.model.data.LogData;
import org.tizen.dynamicanalyzer.swap.model.data.NetworkData;
import org.tizen.dynamicanalyzer.ui.network.data.NetworkDataManager;
import org.tizen.dynamicanalyzer.ui.network.data.type.NetworkAPIType;
import org.tizen.dynamicanalyzer.ui.network.data.type.NetworkSeriesType;
import org.tizen.dynamicanalyzer.ui.summary.SummaryDataManager;
import org.tizen.dynamicanalyzer.util.Logger;
import org.tizen.dynamicanalyzer.utils.AnalyzerUtil;
import org.tizen.dynamicanalyzer.utils.DownloadContentfileManager;

public class NetworkDataMaker {
    private HashMap<String, String> addressByFdHashMap = new HashMap();
    private HashMap<String, String> parentFDByFdHashMap = new HashMap();
    List<NetworkAPIType> noDestinationApiSeriesList = new ArrayList<NetworkAPIType>();
    List<NetworkAPIType> destinationApiSeriesList = new ArrayList<NetworkAPIType>();

    public void clear() {
        this.addressByFdHashMap.clear();
        this.parentFDByFdHashMap.clear();
        this.noDestinationApiSeriesList = new ArrayList<NetworkAPIType>();
        this.destinationApiSeriesList = new ArrayList<NetworkAPIType>();
    }

    public void makeData(List<LogData> inputs) {
        int size = inputs.size();
        int i = 0;
        while (i < size) {
            NetworkData input = (NetworkData)inputs.get(i);
            this.makeEventData(input);
            this.addFailedAPIData(input);
            ++i;
        }
        if (this.destinationApiSeriesList.size() <= 0) {
            return;
        }
        ArrayList<List<Object>> insetApiSeriesData = new ArrayList<List<Object>>();
        ArrayList<NetworkAPIType> removeEventQueue = new ArrayList<NetworkAPIType>();
        for (NetworkAPIType data : this.destinationApiSeriesList) {
            insetApiSeriesData.add(data.getDBInsertData());
            removeEventQueue.add(data);
        }
        NetworkDataManager.getInstance().getAPIDBManger().insert(insetApiSeriesData);
        this.destinationApiSeriesList.removeAll(removeEventQueue);
    }

    private void addFailedAPIData(NetworkData logs) {
        if (logs.getErrno() != 0L) {
            SummaryDataManager.getInstance().getFailedApiDataMaker().makeData(logs);
        }
    }

    private void makeEventData(NetworkData input) {
        String apiName = input.getApiName();
        String ipAddress = input.getdestinationIPAddress().trim();
        String portAddress = input.getDestinationPortAddress().trim();
        String apiAddress = "";
        if (!portAddress.equals("0")) {
            apiAddress = String.valueOf(ipAddress) + "\n" + portAddress;
        }
        String apiFD = Long.toString(input.getFdValue()).trim();
        apiFD = this.getHexString(apiFD);
        int apiId = input.getApiId();
        int apiType = input.getFdApiType();
        long time = input.getTime();
        long errno = input.getErrno();
        long seq = input.getSeq();
        int pId = input.getPid();
        int tId = input.getTid();
        String parameter = input.getArgs();
        String returnValue = input.getReturn();
        int byteSize = input.getPacketMessageSize();
        String payloadInfo = input.getPacketMessage();
        String parentAddress = this.addressByFdHashMap.get(apiFD);
        if (parentAddress != null) {
            apiAddress = parentAddress;
        }
        switch (apiType) {
            case 0: {
                break;
            }
            case 8: {
                String[] strInput = parameter.split(",");
                if (strInput.length <= 0) {
                    Logger.error((Object)("argument length is wrong : " + input.getApiName()));
                    break;
                }
                apiAddress = strInput[1].trim();
                this.addressByFdHashMap.put(apiFD, apiAddress);
                break;
            }
            case 9: {
                this.setStartSeries(apiAddress, apiFD, time, -1, 2, apiId, pId);
                break;
            }
            case 10: {
                String clientFD = returnValue;
                this.addressByFdHashMap.put(clientFD, parentAddress);
                this.setEndSeries(apiAddress, apiFD, time, 2);
                break;
            }
            case 1: {
                if (errno != 0L) break;
                this.addressByFdHashMap.remove(apiFD);
                this.setEndSeries(apiAddress, apiFD, time, 0);
                break;
            }
            case 2: {
                this.setStartSeries(apiAddress, apiFD, time, -1, 3, apiId, pId);
                break;
            }
            case 3: {
                this.setEndSeries(apiAddress, apiFD, time, 3);
                payloadInfo = DownloadContentfileManager.getDowonloadFilePath(payloadInfo);
                break;
            }
            case 4: {
                this.setStartSeries(apiAddress, apiFD, time, -1, 4, apiId, pId);
                break;
            }
            case 5: {
                this.setEndSeries(apiAddress, apiFD, time, 4);
                payloadInfo = DownloadContentfileManager.getDowonloadFilePath(payloadInfo);
                break;
            }
            case 11: {
                this.setStartSeries(apiAddress, apiFD, time, -1, 2, apiId, pId);
                break;
            }
            case 12: {
                this.setEndSeries(apiAddress, apiFD, time, 2);
                break;
            }
            case 6: {
                String[] strInput = parameter.split(",");
                if (strInput.length <= 0) {
                    Logger.error((Object)("argument length is wrong : " + input.getApiName()));
                    break;
                }
                apiAddress = strInput[1].trim();
                this.addressByFdHashMap.put(apiFD, apiAddress);
                break;
            }
            case 7: {
                break;
            }
            case 13: {
                if (!apiName.contains("epoll_ctl")) break;
                String[] strInput = parameter.split(",");
                if (strInput.length <= 0) {
                    Logger.error((Object)("argument length is wrong : " + input.getApiName()));
                    break;
                }
                String clientFD = strInput[0].trim();
                this.addressByFdHashMap.put(clientFD, parentAddress);
                apiFD = clientFD;
                this.addressByFdHashMap.put(apiFD, apiAddress);
                break;
            }
            case 14: {
                String[] strInput = parameter.split(",");
                int cfr_ignored_0 = strInput.length;
                String clientAddress = strInput[2].trim();
                this.addressByFdHashMap.put(apiFD, clientAddress);
                this.parentFDByFdHashMap.put(apiFD, apiFD);
                break;
            }
            case 16: {
                String clientFD = returnValue;
                String parrentAddress = this.addressByFdHashMap.get(apiFD);
                if (parrentAddress != null) {
                    apiAddress = parrentAddress.trim();
                }
                this.addressByFdHashMap.put(clientFD, apiAddress);
                apiFD = clientFD;
                break;
            }
            case 17: {
                String clientFD = parameter;
                if (clientFD.contains("")) break;
                apiFD = clientFD;
                break;
            }
            case 18: {
                String parrentAddress;
                String clientFD = returnValue;
                String parretnFD = this.parentFDByFdHashMap.get(apiFD);
                if (parretnFD != null) {
                    apiFD = parretnFD;
                }
                if ((parrentAddress = this.addressByFdHashMap.get(apiFD)) != null) {
                    apiAddress = parrentAddress;
                }
                this.addressByFdHashMap.put(clientFD, apiAddress);
                this.parentFDByFdHashMap.put(clientFD, apiFD);
                break;
            }
            case 19: {
                String parrentAddress;
                String parretnFD = this.parentFDByFdHashMap.get(apiFD);
                if (parretnFD != null) {
                    apiFD = parretnFD;
                }
                if ((parrentAddress = this.addressByFdHashMap.get(apiFD)) == null) break;
                apiAddress = parrentAddress;
                break;
            }
            case 20: {
                String parrentAddress;
                String parretnFD = this.parentFDByFdHashMap.get(apiFD);
                if (parretnFD != null) {
                    apiFD = parretnFD;
                }
                if ((parrentAddress = this.addressByFdHashMap.get(apiFD)) == null) break;
                apiAddress = parrentAddress;
                break;
            }
            case 21: {
                String parrentAddress;
                String clientFD = returnValue;
                String parretnFD = this.parentFDByFdHashMap.get(apiFD);
                if (parretnFD != null) {
                    apiFD = parretnFD;
                }
                if ((parrentAddress = this.addressByFdHashMap.get(apiFD)) != null) {
                    apiAddress = parrentAddress;
                }
                this.addressByFdHashMap.put(clientFD, apiAddress);
                this.parentFDByFdHashMap.put(clientFD, apiFD);
                break;
            }
            case 22: {
                String parrentAddress;
                String parretnFD = this.parentFDByFdHashMap.get(apiFD);
                if (parretnFD != null) {
                    apiFD = parretnFD;
                }
                if ((parrentAddress = this.addressByFdHashMap.get(apiFD)) == null) break;
                apiAddress = parrentAddress;
                break;
            }
            case 23: {
                if (errno != 0L) break;
                this.addressByFdHashMap.remove(apiFD);
                break;
            }
            default: {
                Logger.error((Object)("makeEventData : no case NetworkChartDataEvent : " + apiType));
                return;
            }
        }
        NetworkAPIType seriesType = new NetworkAPIType(seq, apiAddress, apiFD, time, apiId, errno, pId, tId, parameter, returnValue, byteSize, payloadInfo, apiType, input.getCallerPcAddr(), input.getLibName());
        if (apiAddress.equals("")) {
            this.noDestinationApiSeriesList.add(seriesType);
        } else {
            this.updateUnDestinationApiSeriesList(seriesType);
            this.destinationApiSeriesList.add(seriesType);
            if (NetworkDataManager.getInstance().getCheckStatusSeries().get(apiFD) == null) {
                NetworkDataManager.getInstance().getCheckStatusSeries().put(apiFD.trim(), apiAddress.trim());
                this.setStartSeries(apiAddress, apiFD, time, -1, 0, apiId, pId);
            }
        }
    }

    private void setStartSeries(String apiAddress, String apiFD, long time, int eventType, int apiType, int apiId, int pId) {
        NetworkSeriesType statusType = new NetworkSeriesType(apiAddress, apiFD, time, -1L, apiType, apiId, pId);
        NetworkDataManager.getInstance().setStartSeriesData(statusType);
    }

    private void setEndSeries(String apiAddress, String apiFD, long time, int apiType) {
        NetworkDataManager.getInstance().setEndSeriesData(apiAddress, apiFD, time, apiType);
    }

    private void updateUnDestinationApiSeriesList(NetworkAPIType seriesType) {
        ArrayList<NetworkAPIType> removeEventQueue = new ArrayList<NetworkAPIType>();
        for (NetworkAPIType event : this.noDestinationApiSeriesList) {
            if (!event.getFdStr().equals(seriesType.getFdStr())) continue;
            event.setDestinationAddress(seriesType.getDestinationAddress());
            this.destinationApiSeriesList.add(event);
            removeEventQueue.add(event);
        }
        this.noDestinationApiSeriesList.removeAll(removeEventQueue);
    }

    private String getHexString(String input) {
        String retStr = null;
        long lInput = Long.parseLong(input);
        retStr = lInput < 0x10000000L ? Long.toString(lInput) : AnalyzerUtil.toHexdecimal(lInput);
        return retStr;
    }
}

