/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.opengl.data.DB;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.tizen.dynamicanalyzer.database.DBColumn;
import org.tizen.dynamicanalyzer.database.DBTable;
import org.tizen.dynamicanalyzer.database.SqlConnectionManager;
import org.tizen.dynamicanalyzer.ui.opengl.data.DB.GLChartDBType;
import org.tizen.dynamicanalyzer.ui.toolbar.Toolbar;
import org.tizen.dynamicanalyzer.util.Logger;

public class GLFrameTimeDBTableManager
extends DBTable {
    private static final String TABLENAME = "GL_FRAME_TIME";
    public static final String CHART_TIME = "CHART_TIME";
    public static final String FRAME_RATE = "FRAME_RATE_TIME";
    public static final String FRAME_MAKING_TIME = "FRAME_MAKING_TIME";
    public static final String ERROR_INFO = "ERROR_INFO";
    public static final String PID = "PID";
    public static final int TABLE_CHART_TIME_INDEX = 0;
    public static final int TABLE_FRAME_RATE_INDEX = 1;
    public static final int TABLE_FRAME_MAKING_TIME_INDEX = 2;
    public static final int TABLE_ERROR_INFO_INDEX = 3;
    public static final int TABLE_PID_INDEX = 4;
    private static final String SELECT_COUNT_FRAME_TIME_TABLE_QUERY = "select count(*) from GL_FRAME_TIME";
    private static final String SELECT_FRAME_TIME_TABLE_QUERY = "select CHART_TIME,FRAME_RATE_TIME,FRAME_MAKING_TIME,ERROR_INFO from GL_FRAME_TIME where CHART_TIME between '%s' and '%s'";
    private static final String SELECT_PID_FRAME_TIME_TABLE_QUERY = "select CHART_TIME,FRAME_RATE_TIME,FRAME_MAKING_TIME,ERROR_INFO from GL_FRAME_TIME where CHART_TIME between '%s' and '%s' and PID = '%s'";

    @Override
    public String getTableName() {
        return TABLENAME;
    }

    public GLFrameTimeDBTableManager() {
        this.addColumn(new DBColumn(CHART_TIME, "NOT NULL", "INTEGER"));
        this.addColumn(new DBColumn(FRAME_RATE, "NOT NULL", "INTEGER"));
        this.addColumn(new DBColumn(FRAME_MAKING_TIME, "NOT NULL", "INTEGER"));
        this.addColumn(new DBColumn(ERROR_INFO, "NOT NULL", "BOOLEAN"));
        this.addColumn(new DBColumn(PID, "NOT NULL", "INTEGER"));
        this.setIndexColumn(0);
    }

    /*
     * Exception decompiling
     */
    public int getFrameSize() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public List<GLChartDBType> selectFrameTime(double startIndex, double endIndex) {
        ResultSet rs;
        String query = String.format(SELECT_FRAME_TIME_TABLE_QUERY, startIndex, endIndex);
        if (Toolbar.INSTANCE.getSelectedPid() != 0) {
            query = String.format(SELECT_PID_FRAME_TIME_TABLE_QUERY, startIndex, endIndex, Toolbar.INSTANCE.getSelectedPid());
        }
        if ((rs = SqlConnectionManager.executeQueryRS(query)) == null) {
            SqlConnectionManager.releaseResultSet(rs);
            return null;
        }
        ArrayList<GLChartDBType> returnValue = new ArrayList<GLChartDBType>();
        try {
            while (rs.next()) {
                GLChartDBType chartData = new GLChartDBType();
                chartData.setChartTime(rs.getInt(1));
                chartData.setFrameMakingTime(rs.getInt(3));
                chartData.setErrno(rs.getBoolean(4));
                returnValue.add(chartData);
            }
            SqlConnectionManager.releaseResultSet(rs);
        }
        catch (SQLException e) {
            Logger.exception((Throwable)e);
        }
        return returnValue;
    }

    @Override
    public boolean prepare(PreparedStatement prep, List<Object> rowData) {
        boolean isPrepared = true;
        int columnsize = this.getColumnSize();
        if (columnsize != rowData.size()) {
            isPrepared = false;
        } else {
            try {
                prep.setInt(1, (Integer)rowData.get(0));
                prep.setInt(2, (Integer)rowData.get(1));
                prep.setInt(3, (Integer)rowData.get(2));
                prep.setBoolean(4, (Boolean)rowData.get(3));
                prep.setInt(5, (Integer)rowData.get(4));
            }
            catch (SQLException e) {
                Logger.exception((Throwable)e);
                isPrepared = false;
            }
        }
        return isPrepared;
    }
}

