/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.toolbar;

import java.util.ArrayList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.tizen.dynamicanalyzer.ui.toolbar.ToolBarComboListener;
import org.tizen.dynamicanalyzer.ui.toolbar.ToolBarComboRenderer;
import org.tizen.dynamicanalyzer.util.Logger;
import org.tizen.dynamicanalyzer.widgets.button.DACustomButton;
import org.tizen.dynamicanalyzer.widgets.button.DACustomButtonAttribute;
import org.tizen.dynamicanalyzer.widgets.button.IDACustomButtonRenderer;
import org.tizen.dynamicanalyzer.widgets.combo.DACustomComboPopupRenderer;
import org.tizen.dynamicanalyzer.widgets.combo.IDACustomComboPopupRenderer;
import org.tizen.dynamicanalyzer.widgets.combo.Messages;
import org.tizen.dynamicanalyzer.widgets.helper.ColorResources;

public class DAToolBarCustomCombo
extends Canvas {
    public static final int MAX_SIZE = 10;
    public static final int STATE_NORMAL = 0;
    public static final int STATE_HOVER = 1;
    public static final int STATE_PUSH = 2;
    public static final int STATE_DISABLE = 3;
    public static final int STATE_DROP = 4;
    public static final int TEXT_ALIGN_CENTER = 0x1000000;
    public static final int TEXT_ALIGN_LEFT = 16384;
    public static final int TEXT_ALIGN_RIGHT = 131072;
    public static final int TYPE_IMAGE = 0;
    public static final int TYPE_COLOR = 1;
    public static final int TYPE_GRADATION = 2;
    private static final int pageSize = 5;
    Composite parent;
    private Canvas combo = null;
    private Canvas popup = null;
    private int itemHeight = 0;
    private int tmpItemIndex = 0;
    private int itemIndex = 0;
    private boolean dirty = false;
    private Timer closeTimer = null;
    private static final int CLOSE_WAITING_TIME = 500;
    private List<String> items;
    private List<Rectangle> rects = null;
    private boolean enabled = true;
    private Shell childShell = null;
    private Shell parentShell = null;
    private int selection = 0;
    private int tmpSelection = 0;
    private Font itemFont = null;
    private Color itemFontColor = null;
    private IDACustomComboPopupRenderer popupRenderer = new DACustomComboPopupRenderer();
    private int state = 0;
    protected DACustomButtonAttribute attr;
    private boolean showSelectedText = true;
    private ToolBarComboRenderer comboRenderer = new ToolBarComboRenderer();
    private static final int arrowButtonHeight = 15;
    private DACustomButton upArrowButton = null;
    private DACustomButton downArrowButton = null;
    private Image buttonUp = null;
    private Image buttonDown = null;
    private List<Color> arrowColors = null;
    private List<Color> arrowOutlineColors = null;
    private List<Image> arrowImages = null;
    private IDACustomButtonRenderer buttonRenderer = null;
    private int whatcombo = 0;
    private Listener popupSelectionListener = new ToolBarComboListener(){

        @Override
        public void selectionEvent(DAToolBarCustomCombo combo) {
            Logger.debug((Object)("default selection" + combo.getText()));
        }
    };
    private Listener parentShellListener = new Listener(){

        public void handleEvent(Event event) {
            if (event.type == 10 && DAToolBarCustomCombo.this.childShell != null && !DAToolBarCustomCombo.this.childShell.isDisposed()) {
                DAToolBarCustomCombo.this.childShell.close();
                DAToolBarCustomCombo.this.childShell = null;
            }
        }
    };
    private Listener comboMouseListener = new Listener(){

        public void handleEvent(Event event) {
            Canvas comboArea = (Canvas)event.widget;
            Rectangle rect = comboArea.getClientArea();
            if (DAToolBarCustomCombo.this.enabled) {
                if (event.type == 6) {
                    DAToolBarCustomCombo.this.changeComboState(1);
                    if (DAToolBarCustomCombo.this.closeTimer != null) {
                        DAToolBarCustomCombo.this.closeTimer.cancel();
                        DAToolBarCustomCombo.this.closeTimer = null;
                    }
                }
                if (event.type == 32 && rect.contains(event.x, event.y)) {
                    if ((event.stateMask & 0x80000) != 0) {
                        DAToolBarCustomCombo.this.changeComboState(2);
                    } else if ((event.stateMask & 0x80000) == 0) {
                        DAToolBarCustomCombo.this.changeComboState(1);
                    }
                }
                if (event.type == 3) {
                    DAToolBarCustomCombo.this.changeComboState(2);
                }
                if (event.type == 4) {
                    DAToolBarCustomCombo.this.changeComboState(1);
                    if (DAToolBarCustomCombo.this.childShell == null || DAToolBarCustomCombo.this.childShell.isDisposed()) {
                        if (DAToolBarCustomCombo.this.closeTimer != null) {
                            DAToolBarCustomCombo.this.closeTimer.cancel();
                            DAToolBarCustomCombo.this.closeTimer = null;
                        }
                        DAToolBarCustomCombo.this.openChildShell();
                    } else {
                        DAToolBarCustomCombo.this.childShell.close();
                        DAToolBarCustomCombo.this.childShell = null;
                    }
                }
                if (event.type == 5) {
                    if (!rect.contains(event.x, event.y)) {
                        DAToolBarCustomCombo.this.changeComboState(0);
                    } else if (!rect.contains(event.x, event.y)) {
                        if ((event.stateMask & 0x80000) != 0) {
                            DAToolBarCustomCombo.this.changeComboState(2);
                        } else if ((event.stateMask & 0x80000) == 0) {
                            DAToolBarCustomCombo.this.changeComboState(1);
                        }
                    }
                }
                if (event.type == 7) {
                    DAToolBarCustomCombo.this.changeComboState(0);
                    if (event.x < rect.x || event.x >= rect.x + rect.width || event.y < rect.y) {
                        DAToolBarCustomCombo.this.closePopup(500);
                    }
                }
            }
        }
    };
    private PaintListener popupPaintListener = new PaintListener(){

        public void paintControl(PaintEvent e) {
            List<String> items = DAToolBarCustomCombo.this.getItems();
            ArrayList<String> input = new ArrayList<String>();
            int size = items.size() > 10 ? 10 : items.size();
            int i = 0;
            while (i < size) {
                input.add(items.get(DAToolBarCustomCombo.this.tmpItemIndex + i));
                ++i;
            }
            if (input.size() != DAToolBarCustomCombo.this.getRects().size()) {
                int rectsSize;
                int inputSize = input.size();
                if (inputSize > (rectsSize = DAToolBarCustomCombo.this.getRects().size())) {
                    DAToolBarCustomCombo.this.reAdjustRectsAdd(rectsSize, inputSize);
                }
                if (inputSize < rectsSize) {
                    DAToolBarCustomCombo.this.reAdjustRectsRemove(rectsSize, inputSize);
                }
                DAToolBarCustomCombo.this.popupRenderer.draw(e.gc, DAToolBarCustomCombo.this.popup, DAToolBarCustomCombo.this.getRects(), DAToolBarCustomCombo.this.tmpSelection, input, DAToolBarCustomCombo.this.itemFont, DAToolBarCustomCombo.this.itemFontColor);
                DAToolBarCustomCombo.this.childShell.close();
                DAToolBarCustomCombo.this.childShell = null;
                DAToolBarCustomCombo.this.openChildShell();
                DAToolBarCustomCombo.this.redraw();
            } else {
                DAToolBarCustomCombo.this.popupRenderer.draw(e.gc, DAToolBarCustomCombo.this.popup, DAToolBarCustomCombo.this.getRects(), DAToolBarCustomCombo.this.tmpSelection, input, DAToolBarCustomCombo.this.itemFont, DAToolBarCustomCombo.this.itemFontColor);
            }
        }
    };
    private Listener popupMouseEventListener = new Listener(){

        public void handleEvent(Event event) {
            if (event.type == 5) {
                List rs = DAToolBarCustomCombo.this.getRects();
                int size = rs.size();
                int i = 0;
                while (i < size) {
                    if (((Rectangle)rs.get(i)).contains(event.x, event.y)) {
                        DAToolBarCustomCombo.this.tmpSelection = i;
                        DAToolBarCustomCombo.this.popup.redraw();
                        break;
                    }
                    ++i;
                }
            }
            if (event.type == 4) {
                DAToolBarCustomCombo.this.selection = DAToolBarCustomCombo.this.tmpSelection;
                DAToolBarCustomCombo.this.itemIndex = DAToolBarCustomCombo.this.tmpItemIndex;
            }
            if (event.type == 37) {
                int size = DAToolBarCustomCombo.this.getItems().size();
                if (DAToolBarCustomCombo.this.downArrowButton != null && !DAToolBarCustomCombo.this.downArrowButton.isDisposed() && DAToolBarCustomCombo.this.upArrowButton != null && !DAToolBarCustomCombo.this.upArrowButton.isDisposed()) {
                    if (event.count < 0) {
                        if (DAToolBarCustomCombo.this.tmpItemIndex - event.count + 10 >= size - 1) {
                            DAToolBarCustomCombo.this.tmpItemIndex = size - 10;
                            DAToolBarCustomCombo.this.downArrowButton.setButtonEnabled(false);
                        } else {
                            DAToolBarCustomCombo dAToolBarCustomCombo = DAToolBarCustomCombo.this;
                            dAToolBarCustomCombo.tmpItemIndex = dAToolBarCustomCombo.tmpItemIndex - event.count;
                        }
                        if (DAToolBarCustomCombo.this.tmpItemIndex > 0) {
                            DAToolBarCustomCombo.this.upArrowButton.setButtonEnabled(true);
                        }
                    } else {
                        if (DAToolBarCustomCombo.this.tmpItemIndex - event.count < 0) {
                            DAToolBarCustomCombo.this.tmpItemIndex = 0;
                            DAToolBarCustomCombo.this.upArrowButton.setButtonEnabled(false);
                        } else {
                            DAToolBarCustomCombo dAToolBarCustomCombo = DAToolBarCustomCombo.this;
                            dAToolBarCustomCombo.tmpItemIndex = dAToolBarCustomCombo.tmpItemIndex - event.count;
                        }
                        if (DAToolBarCustomCombo.this.tmpItemIndex + event.count < size - 1) {
                            DAToolBarCustomCombo.this.downArrowButton.setButtonEnabled(true);
                        }
                    }
                    DAToolBarCustomCombo.this.popup.redraw();
                }
            }
            if (event.type == 7) {
                Canvas canvas = (Canvas)event.widget;
                Rectangle rect = canvas.getClientArea();
                if (event.x < rect.x || event.x >= rect.x + rect.width || event.y < rect.y || event.y >= rect.y + rect.height) {
                    DAToolBarCustomCombo.this.closePopup(500);
                }
            }
            if ((event.type == 6 || event.type == 15) && DAToolBarCustomCombo.this.closeTimer != null) {
                DAToolBarCustomCombo.this.closeTimer.cancel();
                DAToolBarCustomCombo.this.closeTimer = null;
            }
        }
    };
    private PaintListener comboPaintListener = new PaintListener(){

        public void paintControl(PaintEvent e) {
            DAToolBarCustomCombo.this.comboRenderer.draw(e.gc, DAToolBarCustomCombo.this.combo, DAToolBarCustomCombo.this.state, DAToolBarCustomCombo.this.attr, DAToolBarCustomCombo.this.whatcombo, DAToolBarCustomCombo.this.isChildShellOpened());
        }
    };
    private Listener upButtonMouseListener = new Listener(){

        public void handleEvent(Event event) {
            DACustomButton upButton = (DACustomButton)event.widget;
            Rectangle rect = upButton.getBounds();
            if (event.type == 7 && (event.y < rect.y || event.x < rect.x || event.x >= rect.x + rect.width)) {
                DAToolBarCustomCombo.this.closePopup(500);
            }
            if ((event.type == 6 || event.type == 15) && DAToolBarCustomCombo.this.closeTimer != null) {
                DAToolBarCustomCombo.this.closeTimer.cancel();
                DAToolBarCustomCombo.this.closeTimer = null;
            }
            if (event.type == 4) {
                if (!DAToolBarCustomCombo.this.upArrowButton.isButtonEnabled()) {
                    return;
                }
                if (DAToolBarCustomCombo.this.upArrowButton != null) {
                    Rectangle rectangle = DAToolBarCustomCombo.this.upArrowButton.getBounds();
                    int x = event.x;
                    int y = event.y;
                    if (x < 0 || x > rectangle.width || y < 0 || y > rectangle.height) {
                        return;
                    }
                }
                int size = DAToolBarCustomCombo.this.getItems().size();
                if (DAToolBarCustomCombo.this.tmpItemIndex - 5 < 0) {
                    DAToolBarCustomCombo.this.tmpItemIndex = 0;
                    DAToolBarCustomCombo.this.upArrowButton.setButtonEnabled(false);
                } else {
                    DAToolBarCustomCombo dAToolBarCustomCombo = DAToolBarCustomCombo.this;
                    dAToolBarCustomCombo.tmpItemIndex = dAToolBarCustomCombo.tmpItemIndex - 5;
                }
                if (DAToolBarCustomCombo.this.tmpItemIndex + 5 < size - 1) {
                    DAToolBarCustomCombo.this.downArrowButton.setButtonEnabled(true);
                }
                DAToolBarCustomCombo.this.popup.redraw();
            }
        }
    };
    private Listener downButtonMouseListener = new Listener(){

        public void handleEvent(Event event) {
            DACustomButton upButton = (DACustomButton)event.widget;
            Rectangle rect = upButton.getClientArea();
            if (event.type == 7 && (event.x < rect.x || event.x >= rect.x + rect.width || event.y >= rect.y + rect.height)) {
                DAToolBarCustomCombo.this.closePopup(500);
            }
            if ((event.type == 6 || event.type == 15) && DAToolBarCustomCombo.this.closeTimer != null) {
                DAToolBarCustomCombo.this.closeTimer.cancel();
                DAToolBarCustomCombo.this.closeTimer = null;
            }
            if (event.type == 4) {
                if (!DAToolBarCustomCombo.this.downArrowButton.isButtonEnabled()) {
                    return;
                }
                if (DAToolBarCustomCombo.this.downArrowButton != null) {
                    Rectangle rectangle = DAToolBarCustomCombo.this.downArrowButton.getBounds();
                    int x = event.x;
                    int y = event.y;
                    if (x < 0 || x > rectangle.width || y < 0 || y > rectangle.height) {
                        return;
                    }
                }
                int size = DAToolBarCustomCombo.this.getItems().size();
                if (DAToolBarCustomCombo.this.tmpItemIndex + 5 + 10 >= size - 1) {
                    DAToolBarCustomCombo.this.tmpItemIndex = size - 10;
                    DAToolBarCustomCombo.this.downArrowButton.setButtonEnabled(false);
                } else {
                    DAToolBarCustomCombo dAToolBarCustomCombo = DAToolBarCustomCombo.this;
                    dAToolBarCustomCombo.tmpItemIndex = dAToolBarCustomCombo.tmpItemIndex + 5;
                }
                if (DAToolBarCustomCombo.this.tmpItemIndex > 0) {
                    DAToolBarCustomCombo.this.upArrowButton.setButtonEnabled(true);
                }
                DAToolBarCustomCombo.this.popup.redraw();
            }
        }
    };

    public DAToolBarCustomCombo(Composite parent, int style) {
        super(parent, style);
        this.combo = this;
        this.parent = parent;
        this.parentShell = parent.getShell();
        this.parentShell.addListener(10, this.parentShellListener);
        this.addPaintListener(this.comboPaintListener);
        this.setForeground(ColorResources.WHITE);
        this.addListeners();
        this.initCombo();
        this.attr = new DACustomButtonAttribute();
        this.attr.setAlign(16384);
    }

    protected void addListeners() {
        this.addListener(6, this.comboMouseListener);
        this.addListener(32, this.comboMouseListener);
        this.addListener(7, this.comboMouseListener);
        this.addListener(3, this.comboMouseListener);
        this.addListener(5, this.comboMouseListener);
        this.addListener(4, this.comboMouseListener);
    }

    public void setFontPoint(Point fontPoint) {
        this.attr.setFontPoint(fontPoint);
    }

    public String getText() {
        if (this.selection < 0) {
            return this.attr.getText();
        }
        if (this.getItems().size() > 0) {
            return this.getItems().get(this.itemIndex + this.selection);
        }
        return null;
    }

    public List<String> getItems() {
        if (this.items == null) {
            this.items = new ArrayList<String>();
        }
        return this.items;
    }

    public int setDeviceCombo(int isCom) {
        this.whatcombo = isCom;
        return this.whatcombo;
    }

    private List<Rectangle> getRects() {
        if (this.rects == null) {
            this.rects = new ArrayList<Rectangle>();
        }
        return this.rects;
    }

    private void changeComboState(int s) {
        this.state = s;
        this.redraw();
    }

    public void addSelectionListener(ToolBarComboListener listener) {
        this.popupSelectionListener = listener;
    }

    private int getShellWidth() {
        if (this.getItems().isEmpty()) {
            return 0;
        }
        int max = 0;
        int size = this.items.size();
        GC gc = new GC((Drawable)this.parent.getDisplay(), 0);
        int i = 0;
        while (i < size) {
            Point p = gc.textExtent(this.items.get(i), 8);
            if (p.x > max) {
                max = p.x;
            }
            ++i;
        }
        gc.dispose();
        return max += 10;
    }

    public int getItemHeight() {
        return this.itemHeight;
    }

    public void setItemHeight(int height) {
        this.itemHeight = height;
    }

    private void openChildShell() {
        FormData data;
        this.childShell = new Shell(this.parent.getShell(), 8);
        this.childShell.setLayout((Layout)new FormLayout());
        Point p = this.combo.toDisplay(0, 0);
        Rectangle rect = this.combo.getBounds();
        int size = this.getItems().size();
        int boundSize = size > 10 ? 10 : (size > 0 ? size : 1);
        int textSize = this.getShellWidth() + 4;
        int shellWidth = textSize > rect.width ? textSize : rect.width;
        int height = 0;
        height = this.getItemHeight() == 0 ? rect.height : this.getItemHeight();
        int shellHeight = height * boundSize + 5;
        this.childShell.setSize(shellWidth, shellHeight);
        this.childShell.setLocation(p.x, p.y + rect.height);
        this.childShell.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (DAToolBarCustomCombo.this.closeTimer != null) {
                    DAToolBarCustomCombo.this.closeTimer.cancel();
                    DAToolBarCustomCombo.this.closeTimer = null;
                }
            }
        });
        this.setSelect(this.attr.getText());
        this.tmpSelection = this.selection;
        this.tmpItemIndex = this.itemIndex;
        this.popup = new Canvas((Composite)this.childShell, 0x20000000);
        this.popup.setData((Object)this);
        this.popup.setBackground(ColorResources.WHITE);
        this.popup.addPaintListener(this.popupPaintListener);
        this.popup.addListener(4, this.popupMouseEventListener);
        this.popup.addListener(5, this.popupMouseEventListener);
        this.popup.addListener(15, this.popupMouseEventListener);
        this.popup.addListener(4, this.popupSelectionListener);
        this.popup.addListener(37, this.popupMouseEventListener);
        this.popup.addListener(7, this.popupMouseEventListener);
        this.popup.addListener(6, this.popupMouseEventListener);
        if (size > 10) {
            this.upArrowButton = this.makeButton();
            if (this.buttonUp == null) {
                this.upArrowButton.setText(Messages.DACustomCombo_1);
            } else {
                this.upArrowButton.setButtonImages(this.buttonUp, this.buttonUp, this.buttonUp, this.buttonUp);
            }
            data = new FormData();
            data.top = new FormAttachment(0, 0);
            data.left = new FormAttachment(0, 0);
            data.right = new FormAttachment(100, 0);
            data.height = 15;
            this.upArrowButton.setLayoutData((Object)data);
            this.upArrowButton.addListener(7, this.upButtonMouseListener);
            this.upArrowButton.addListener(6, this.upButtonMouseListener);
            this.upArrowButton.addListener(4, this.upButtonMouseListener);
            this.upArrowButton.addListener(15, this.upButtonMouseListener);
            shellHeight += 15;
            if (this.tmpItemIndex > 0) {
                this.upArrowButton.setButtonEnabled(true);
            } else {
                this.upArrowButton.setButtonEnabled(false);
            }
            data = new FormData();
            data.top = new FormAttachment((Control)this.upArrowButton, 0);
            data.left = new FormAttachment(0, 0);
            data.right = new FormAttachment(100, 0);
            data.height = height * boundSize + 5 - 2;
            this.popup.setLayoutData((Object)data);
            this.downArrowButton = this.makeButton();
            if (this.buttonDown == null) {
                this.downArrowButton.setText(Messages.DACustomCombo_2);
            } else {
                this.downArrowButton.setButtonImages(this.buttonDown, this.buttonDown, this.buttonDown, this.buttonDown);
            }
            data = new FormData();
            data.top = new FormAttachment((Control)this.popup, 0);
            data.left = new FormAttachment(0, 0);
            data.right = new FormAttachment(100, 0);
            data.height = 15;
            this.downArrowButton.setLayoutData((Object)data);
            this.downArrowButton.addListener(7, this.downButtonMouseListener);
            this.downArrowButton.addListener(6, this.downButtonMouseListener);
            this.downArrowButton.addListener(4, this.downButtonMouseListener);
            this.downArrowButton.addListener(15, this.downButtonMouseListener);
            shellHeight += 15;
            if (this.tmpItemIndex + 10 < size - 1) {
                this.downArrowButton.setButtonEnabled(true);
            } else {
                this.downArrowButton.setButtonEnabled(false);
            }
            this.childShell.setSize(shellWidth, shellHeight);
        } else {
            data = new FormData();
            data.top = new FormAttachment(0, 0);
            data.left = new FormAttachment(0, 0);
            data.right = new FormAttachment(100, 0);
            data.height = shellHeight - 2;
            this.popup.setLayoutData((Object)data);
        }
        this.getRects().clear();
        int i = 0;
        while (i < boundSize) {
            Rectangle r = new Rectangle(2, 2 + i * height, shellWidth - 2, height);
            this.getRects().add(r);
            ++i;
        }
        this.childShell.open();
    }

    public void reAdjustRectsAdd(int sizeofRects, int sizeofInput) {
        int i = sizeofRects;
        while (i < sizeofInput) {
            Rectangle rect = this.combo.getBounds();
            int textSize = this.getShellWidth() + 4;
            int shellWidth = textSize > rect.width ? textSize : rect.width;
            int height = 0;
            height = this.getItemHeight() == 0 ? rect.height : this.getItemHeight();
            Rectangle r = new Rectangle(2, 50 + i * height, shellWidth - 2, height);
            this.getRects().add(i, r);
            ++i;
        }
    }

    public void reAdjustRectsRemove(int sizeofRects, int sizeofInput) {
        int i = sizeofInput;
        while (i < sizeofRects) {
            this.getRects().remove(i);
            ++i;
        }
    }

    public void setItemFont(Font itemFont) {
        this.itemFont = itemFont;
    }

    public void setText(String text) {
        if (!this.setSelect(text)) {
            this.attr.setText(text);
            this.selection = -1;
            this.redraw();
        }
    }

    public void setTextForce(String text) {
        this.attr.setText(text);
        this.selection = -1;
        this.redraw();
    }

    private boolean setSelect(String text) {
        if (this.getItems().isEmpty()) {
            return false;
        }
        int index = this.items.indexOf(text);
        if (index < 0) {
            Logger.debug((Object)"Combo indexing bug!");
            return false;
        }
        this.itemIndex = 0;
        int size = this.items.size();
        if (size < 10) {
            this.selection = index;
            this.select(this.selection);
        } else if (index + 10 >= size) {
            int lower = size - index;
            this.selection = 10 - lower;
            this.itemIndex = size - 10;
            this.select(this.selection);
        } else {
            if (index >= 10) {
                this.itemIndex = index / 10;
                this.itemIndex *= 10;
                index %= 10;
            }
            this.selection = index;
            this.select(this.selection);
        }
        return true;
    }

    public void upEvent() {
        if (this.isShowSelectedText()) {
            if (this.getItems().size() > 0) {
                this.setText(this.getItems().get(this.itemIndex + this.selection));
            }
        } else if (this.attr.getText() != null) {
            this.setText(this.attr.getText());
        } else {
            this.setText("");
        }
        if (this.childShell != null) {
            this.childShell.close();
        }
        this.childShell = null;
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.enabled = enabled;
        if (enabled) {
            this.changeComboState(0);
            this.setBackgroundImageAndColor(0);
        } else {
            this.changeComboState(3);
            this.setBackgroundImageAndColor(3);
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    if (DAToolBarCustomCombo.this.childShell != null && !DAToolBarCustomCombo.this.childShell.isDisposed()) {
                        DAToolBarCustomCombo.this.childShell.close();
                        DAToolBarCustomCombo.this.childShell = null;
                    }
                }
            });
        }
    }

    private void setBackgroundImageAndColor(int state) {
        int drawType = this.attr.getDrawType();
        if (drawType == 0) {
            this.setBackgroundImage(this.attr.getImage(state));
        } else if (drawType == 1) {
            this.setBackground(this.attr.getColor(state));
        } else if (drawType == 2) {
            int index = state * 2;
            this.setForeground(this.attr.getColor(index));
            this.setBackground(this.attr.getColor(index + 1));
        } else {
            Logger.debug((Object)("DACustomCombo drawType : " + state));
        }
    }

    public void setComboRender(ToolBarComboRenderer newRenderer) {
        this.comboRenderer = newRenderer;
    }

    public void setComboPopupRender(DACustomComboPopupRenderer newRenderer) {
        this.popupRenderer = newRenderer;
    }

    public void add(String item) {
        if (this.dirty) {
            this.getItems().add(item);
        } else {
            this.getItems().set(0, item);
            this.dirty = true;
        }
    }

    public void select(int index) {
        this.selection = index;
        if (this.isShowSelectedText()) {
            String text = this.items.get(this.itemIndex + this.selection);
            this.attr.setText(text);
            this.setToolTipText(text);
        }
        this.redraw();
    }

    public String getItem(int index) {
        if (this.getItems().size() > 0) {
            return this.getItems().get(index);
        }
        return "";
    }

    public void setComboColors(Color normal, Color push, Color hover, Color disable) {
        this.attr.setColor(0, normal);
        this.attr.setColor(1, hover);
        this.attr.setColor(2, push);
        this.attr.setColor(3, disable);
        this.attr.setDrawType(1);
    }

    public void setComboGradation(Color normalStart, Color normalEnd, Color pushStart, Color pushEnd, Color hoverStart, Color hoverEnd, Color disableStart, Color disableEnd) {
        this.attr.setColor(0, normalStart);
        this.attr.setColor(1, normalEnd);
        this.attr.setColor(2, hoverStart);
        this.attr.setColor(3, hoverEnd);
        this.attr.setColor(4, pushStart);
        this.attr.setColor(5, pushEnd);
        this.attr.setColor(6, disableStart);
        this.attr.setColor(7, disableEnd);
        this.attr.setDrawType(2);
    }

    public void setImages(Image normal, Image hover, Image push, Image disable) {
        if (normal == null || hover == null || push == null || disable == null) {
            Logger.debug((Object)"DACustomCombo setImages parameter is null");
            return;
        }
        this.attr.setImage(0, normal);
        this.attr.setImage(1, hover);
        this.attr.setImage(2, push);
        this.attr.setImage(3, disable);
        this.attr.setDrawType(0);
    }

    public void setOutlineColors(Color normal, Color push, Color hover, Color disable) {
        this.attr.setOutlineColor(0, normal);
        this.attr.setOutlineColor(1, hover);
        this.attr.setOutlineColor(2, push);
        this.attr.setOutlineColor(3, disable);
    }

    public void setComboImages(Image normal, Image push, Image hover, Image disable) {
        this.attr.setButtonImage(0, normal);
        this.attr.setButtonImage(1, hover);
        this.attr.setButtonImage(2, push);
        this.attr.setButtonImage(3, disable);
    }

    public void setComboImagePoint(Point comboImagePoint) {
        this.attr.setButtonImagePoint(comboImagePoint);
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void initCombo() {
        this.getItems().clear();
        this.tmpItemIndex = 0;
        this.selection = 0;
        this.items.add("");
        this.dirty = false;
        this.itemIndex = 0;
    }

    public void initComboText(String text) {
        this.getItems().clear();
        this.tmpItemIndex = 0;
        this.selection = 0;
        this.items.add(text);
        this.dirty = false;
        this.itemIndex = 0;
    }

    public void setComboButtonColor(Color normal, Color push, Color hover, Color disable) {
        this.arrowColors = new ArrayList<Color>();
        this.arrowColors.add(normal);
        this.arrowColors.add(hover);
        this.arrowColors.add(push);
        this.arrowColors.add(disable);
    }

    public void setComboButtonImage(Image normal, Image push, Image hover, Image disable) {
        this.arrowImages = new ArrayList<Image>();
        this.arrowImages.add(normal);
        this.arrowImages.add(push);
        this.arrowImages.add(hover);
        this.arrowImages.add(disable);
    }

    public void setComboButtonGradation(Color normalStart, Color normalEnd, Color pushStart, Color pushEnd, Color hoverStart, Color hoverEnd, Color disableStart, Color disableEnd) {
        this.arrowColors = new ArrayList<Color>();
        this.arrowColors.add(normalStart);
        this.arrowColors.add(normalEnd);
        this.arrowColors.add(hoverStart);
        this.arrowColors.add(hoverEnd);
        this.arrowColors.add(pushStart);
        this.arrowColors.add(pushEnd);
        this.arrowColors.add(disableStart);
        this.arrowColors.add(disableEnd);
    }

    private List<Color> getArrowOutlineColors() {
        if (this.arrowOutlineColors == null) {
            this.arrowOutlineColors = new ArrayList<Color>();
        }
        return this.arrowOutlineColors;
    }

    public void setArrowOutlineColors(Color normal, Color push, Color hover, Color disable) {
        List<Color> comboArrowOutlineColors = this.getArrowOutlineColors();
        comboArrowOutlineColors.add(normal);
        comboArrowOutlineColors.add(hover);
        comboArrowOutlineColors.add(push);
        comboArrowOutlineColors.add(disable);
    }

    private DACustomButton makeButton() {
        DACustomButton button = null;
        if (this.arrowImages != null) {
            button = new DACustomButton((Composite)this.childShell, this.arrowImages.get(0), this.arrowImages.get(2), this.arrowImages.get(1), this.arrowImages.get(3));
        } else if (this.arrowColors != null) {
            if (this.arrowColors.size() > 4) {
                button = new DACustomButton((Composite)this.childShell, this.arrowColors.get(0), this.arrowColors.get(1), this.arrowColors.get(4), this.arrowColors.get(5), this.arrowColors.get(2), this.arrowColors.get(3), this.arrowColors.get(6), this.arrowColors.get(7));
            } else {
                button = new DACustomButton((Composite)this.childShell, 0);
                button.setColors(this.arrowColors.get(0), this.arrowColors.get(2), this.arrowColors.get(1), this.arrowColors.get(3));
            }
            if (this.arrowOutlineColors != null) {
                button.setOutlineColors(this.arrowOutlineColors.get(0), this.arrowOutlineColors.get(2), this.arrowOutlineColors.get(1), this.arrowOutlineColors.get(3));
            }
        } else {
            button = new DACustomButton((Composite)this.childShell, 0);
        }
        if (this.buttonRenderer != null) {
            button.setRenderer(this.buttonRenderer);
        }
        return button;
    }

    public void setButtonRenderer(IDACustomButtonRenderer renderer) {
        this.buttonRenderer = renderer;
    }

    public void setButtonImages(Image up, Image down) {
        this.buttonUp = up;
        this.buttonDown = down;
    }

    public boolean isChildShellOpened() {
        return this.childShell != null && !this.childShell.isDisposed();
    }

    public void closePopup(int interval) {
        if (this.childShell == null || this.childShell.isDisposed()) {
            return;
        }
        this.closeTimer = new Timer();
        this.closeTimer.schedule(new TimerTask(){

            @Override
            public void run() {
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (DAToolBarCustomCombo.this.childShell != null && !DAToolBarCustomCombo.this.childShell.isDisposed()) {
                            DAToolBarCustomCombo.this.childShell.close();
                            DAToolBarCustomCombo.this.childShell = null;
                            DAToolBarCustomCombo.this.redraw();
                        } else {
                            Logger.debug((Object)"combo timer bug : try close child shell ");
                        }
                    }
                });
            }
        }, interval);
    }

    public void setTextAlign(int align) {
        this.attr.setAlign(align);
    }

    public void setComboFont(Font font) {
        this.attr.setFont(font);
    }

    public void setFontColors(Color normal, Color push, Color hover, Color disable) {
        this.attr.setFontColor(0, normal);
        this.attr.setFontColor(2, push);
        this.attr.setFontColor(1, hover);
        this.attr.setFontColor(3, disable);
    }

    public void setItemFontColor(Color itemFontColor) {
        this.itemFontColor = itemFontColor;
    }

    public boolean isShowSelectedText() {
        return this.showSelectedText;
    }

    public void setShowSelectedText(boolean showSelectedText) {
        this.showSelectedText = showSelectedText;
    }
}

