/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.toolbar;

import java.util.Map;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.tizen.dynamicanalyzer.common.Global;
import org.tizen.dynamicanalyzer.communicator.DACommunicator;
import org.tizen.dynamicanalyzer.handlers.UIActionHolder;
import org.tizen.dynamicanalyzer.nl.AnalyzerLabels;
import org.tizen.dynamicanalyzer.nl.UserErrorWarningLabels;
import org.tizen.dynamicanalyzer.nl.WidgetLabels;
import org.tizen.dynamicanalyzer.resources.ColorResources;
import org.tizen.dynamicanalyzer.ui.toolbar.ProcessExplorer;
import org.tizen.dynamicanalyzer.widgets.button.DACustomButton;
import org.tizen.dynamicanalyzer.widgets.button.DACustomButtonClickEventListener;
import org.tizen.dynamicanalyzer.widgets.da.base.DAButton;
import org.tizen.dynamicanalyzer.widgets.da.base.DAMessageBox;

public class ProcessExplorerDialog
extends DAMessageBox {
    private final int WIDTH = 446;
    private final int HEIGHT = 600;
    private ProcessExplorer explorer = null;
    private DACustomButton okButton = null;
    private DACustomButton cancelButton = null;

    public ProcessExplorerDialog(Shell parentShell) {
        super(parentShell);
        int dialogLocationX = this.shell.getParent().getLocation().x + (this.shell.getParent().getSize().x - 446) / 2;
        int dialogLocationY = this.shell.getParent().getLocation().y + (this.shell.getParent().getSize().y - 600) / 2;
        this.shell.setLocation(dialogLocationX, dialogLocationY);
        this.shell.setLayout((Layout)new FormLayout());
        this.shell.setSize(446, 600);
        this.shell.setBackground(ColorResources.DIALOG_BG_UPPER);
        this.shell.setText(AnalyzerLabels.SELECT_PROCESS);
        this.explorer = new ProcessExplorer((Composite)this.shell);
        FormData data = new FormData();
        data.top = new FormAttachment(0, 15);
        data.left = new FormAttachment(0, 6);
        data.right = new FormAttachment(100, -6);
        data.bottom = new FormAttachment(100, -106);
        this.explorer.setLayoutData(data);
        this.explorer.setDeviceInfo(Global.getCurrentDeviceInfo());
        Label warningLabel = new Label((Composite)this.shell, 0x40000040);
        data = new FormData();
        data.top = new FormAttachment((Control)this.explorer, 10);
        data.left = new FormAttachment(0, 10);
        data.right = new FormAttachment(100, -10);
        data.height = 36;
        warningLabel.setLayoutData((Object)data);
        warningLabel.setBackground(ColorResources.DIALOG_BG_UPPER);
        warningLabel.setAlignment(16384);
        warningLabel.setForeground(ColorResources.RED);
        warningLabel.setText(UserErrorWarningLabels.WARNING_RUNNING_PROCESS_LIMIT);
        Composite buttonComp = new Composite((Composite)this.shell, 0);
        buttonComp.setLayout((Layout)new FormLayout());
        buttonComp.setBackground(ColorResources.DIALOG_BG_LOWER);
        buttonComp.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                Composite comp = (Composite)e.widget;
                Rectangle rect = comp.getClientArea();
                e.gc.setForeground(ColorResources.DIALOG_SUNKEN_1);
                e.gc.drawLine(rect.x, rect.y, rect.x + rect.width, rect.y);
                e.gc.setForeground(ColorResources.DIALOG_SUNKEN_2);
                e.gc.drawLine(rect.x, rect.y + 1, rect.x + rect.width, rect.y + 1);
            }
        });
        FormData compData = new FormData();
        compData.top = new FormAttachment((Control)warningLabel, 10);
        compData.left = new FormAttachment(0, 0);
        compData.right = new FormAttachment(100, 0);
        compData.bottom = new FormAttachment(100, 0);
        buttonComp.setLayoutData((Object)compData);
        this.okButton = new DAButton(buttonComp, 0);
        data = new FormData();
        data.top = new FormAttachment(0, 11);
        data.left = new FormAttachment(50, -90);
        data.height = 24;
        data.width = 86;
        this.okButton.setLayoutData((Object)data);
        this.okButton.setText(WidgetLabels.OK);
        this.okButton.addClickListener(new DACustomButtonClickEventListener(){

            public void handleClickEvent(DACustomButton button) {
                ProcessExplorerDialog.this.result = ProcessExplorerDialog.this.explorer.getSelectedProcess();
                if (ProcessExplorerDialog.this.result != null) {
                    Boolean process_validation = ProcessExplorerDialog.this.checkInvalidProcess((Map)ProcessExplorerDialog.this.result);
                    if (process_validation.booleanValue()) {
                        ProcessExplorerDialog.this.shell.dispose();
                    } else {
                        UIActionHolder.getUIAction().showWarning("Selected Process isn't running. Reselect process");
                        ProcessExplorerDialog.this.explorer.updateData();
                    }
                } else {
                    ProcessExplorerDialog.this.shell.dispose();
                }
            }
        });
        this.cancelButton = new DAButton(buttonComp, 0);
        data = new FormData();
        data.top = new FormAttachment(0, 11);
        data.left = new FormAttachment(50, 4);
        data.height = 24;
        data.width = 86;
        this.cancelButton.setLayoutData((Object)data);
        this.cancelButton.setText(WidgetLabels.CANCEL);
        this.cancelButton.addClickListener(new DACustomButtonClickEventListener(){

            public void handleClickEvent(DACustomButton button) {
                ProcessExplorerDialog.this.shell.dispose();
            }
        });
    }

    public Boolean checkInvalidProcess(Map<Integer, String> result) {
        Map<Integer, String> processes = DACommunicator.getProcessList();
        for (Map.Entry<Integer, String> result_entry : result.entrySet()) {
            Integer result_key = result_entry.getKey();
            if (!processes.containsKey(result_key)) {
                return false;
            }
            String Compare = processes.get(result_key);
            if (Compare.contains(result_entry.getValue())) continue;
            return false;
        }
        return true;
    }

    public void setProcessList(Map<Integer, String> proc) {
        this.explorer.setSelectedProcess(proc);
    }

    protected boolean run() {
        super.run();
        this.explorer.updateData();
        return true;
    }
}

