/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.toolbar.setting;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.tizen.dynamicanalyzer.communicator.CommunicatorUtils;
import org.tizen.dynamicanalyzer.communicator.DeviceInfo;
import org.tizen.dynamicanalyzer.communicator.DeviceManager;
import org.tizen.dynamicanalyzer.control.ApplistManager;
import org.tizen.dynamicanalyzer.nl.ConfigureLabels;
import org.tizen.dynamicanalyzer.project.AppInfo;
import org.tizen.dynamicanalyzer.project.PackageInfo;
import org.tizen.dynamicanalyzer.resources.ColorResources;
import org.tizen.dynamicanalyzer.resources.FontResources;
import org.tizen.dynamicanalyzer.resources.ImageResources;
import org.tizen.dynamicanalyzer.ui.toolbar.RemoteDeviceDialog;
import org.tizen.dynamicanalyzer.ui.toolbar.setting.TargetDialog;
import org.tizen.dynamicanalyzer.util.Logger;
import org.tizen.dynamicanalyzer.util.WorkbenchUtil;
import org.tizen.dynamicanalyzer.widgets.button.DACustomButton;
import org.tizen.dynamicanalyzer.widgets.button.DACustomButtonClickEventListener;
import org.tizen.dynamicanalyzer.widgets.button.toggle.DACustomFeatureToggleButton;
import org.tizen.dynamicanalyzer.widgets.da.view.DAPageComposite;
import org.tizen.sdblib.IShellOutputReceiver;
import org.tizen.sdblib.receiver.MultiLineReceiver;

public class TargetDialogTargetPage
extends DAPageComposite {
    private Composite targetParentComp = null;
    private TargetDialog targetDialog = null;
    private List<DeviceInfo> deviceList = new ArrayList<DeviceInfo>();
    private ScrolledComposite targetScrolledComposite = null;
    private Composite targetCom = null;
    private Cursor daCursor = null;
    private List<DACustomFeatureToggleButton> targetList = new ArrayList<DACustomFeatureToggleButton>();
    private Listener toggleUpListener = new Listener(){

        public void handleEvent(Event event) {
            DACustomFeatureToggleButton toggleButton = (DACustomFeatureToggleButton)event.widget;
            if (!toggleButton.isToggled()) {
                toggleButton.getParent().setBackground(ColorResources.FEATURE_TARGETCOMP_BACKGROUND);
            } else {
                toggleButton.getParent().setBackground(ColorResources.FEATURE_FEATURELISTCOMP_SELECT_BACKGROUND);
                for (DACustomFeatureToggleButton other : TargetDialogTargetPage.this.targetList) {
                    if (other.getToolTipText().equals(toggleButton.getToolTipText()) || !other.isToggled()) continue;
                    other.setToggled(false);
                    other.getParent().setBackground(ColorResources.FEATURE_TARGETCOMP_BACKGROUND);
                }
            }
            for (DeviceInfo device : TargetDialogTargetPage.this.deviceList) {
                String serial = device.getIDevice().getSerialNumber();
                if (!serial.equals(toggleButton.getToolTipText())) continue;
                if (toggleButton.isToggled()) {
                    TargetDialogTargetPage.this.targetDialog.getAppListPage().drawAppList(TargetDialogTargetPage.this.updateAppListFromTarget(device));
                    TargetDialogTargetPage.this.targetDialog.getInfoPage().drawDeviceInfoPage(device);
                    TargetDialogTargetPage.this.targetDialog.getInfoPage().drawAppInfoPage(null);
                    break;
                }
                TargetDialogTargetPage.this.targetDialog.getAppListPage().drawAppList(null);
                TargetDialogTargetPage.this.targetDialog.getInfoPage().drawDeviceInfoPage(null);
                TargetDialogTargetPage.this.targetDialog.getInfoPage().drawAppInfoPage(null);
                break;
            }
            TargetDialogTargetPage.this.targetDialog.setOKButtonEnable(false);
        }
    };
    private Listener toggleDownListener = new Listener(){

        public void handleEvent(Event event) {
            DACustomFeatureToggleButton toggleButton = (DACustomFeatureToggleButton)event.widget;
            if (toggleButton.isToggled()) {
                toggleButton.getParent().setBackground(ColorResources.FEATURE_TARGETCOMP_BACKGROUND);
            }
        }
    };
    private Listener cursorListener = new Listener(){

        public void handleEvent(Event event) {
            if (event.type == 6 || event.type == 7) {
                DACustomFeatureToggleButton toggleButton = (DACustomFeatureToggleButton)event.widget;
                toggleButton.setFocus();
                if (TargetDialogTargetPage.this.daCursor != null) {
                    TargetDialogTargetPage.this.daCursor.dispose();
                }
                if (event.type == 6) {
                    TargetDialogTargetPage.this.daCursor = new Cursor((Device)TargetDialogTargetPage.this.getShell().getDisplay(), 21);
                } else if (event.type == 7) {
                    TargetDialogTargetPage.this.daCursor = new Cursor((Device)TargetDialogTargetPage.this.getShell().getDisplay(), 0);
                } else {
                    return;
                }
                TargetDialogTargetPage.this.getShell().setCursor(TargetDialogTargetPage.this.daCursor);
            }
        }
    };

    public TargetDialogTargetPage(Composite parent, TargetDialog targetDialog, int style) {
        super(parent, style);
        this.setLayout((Layout)new FormLayout());
        this.setBackground(ColorResources.FEATURE_TARGETCOMP_BACKGROUND);
        this.targetDialog = targetDialog;
        this.targetParentComp = parent;
        Composite connectComp = new Composite(this.targetParentComp, 0);
        FormData data = new FormData();
        data.top = new FormAttachment(0, 419);
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        data.bottom = new FormAttachment(100, 0);
        connectComp.setLayoutData((Object)data);
        connectComp.setLayout((Layout)new FormLayout());
        connectComp.setBackground(ColorResources.FEATURE_TARGETCOMP_BACKGROUND);
        DACustomButton connectbutton = new DACustomButton(connectComp, 0);
        connectbutton.setImages(ImageResources.CONNECT_BTN_NOR, ImageResources.CONNECT_BTN_SEL, ImageResources.CONNECT_BTN_OVER, ImageResources.CONNECT_BTN_NOR);
        data = new FormData();
        data.top = new FormAttachment(0, 20);
        data.left = new FormAttachment(0, 27);
        data.width = 126;
        data.height = 30;
        connectbutton.setLayoutData((Object)data);
        connectbutton.addClickListener(new DACustomButtonClickEventListener(){

            public void handleClickEvent(DACustomButton button) {
                Shell shell = WorkbenchUtil.getWorkbenchWindow().getShell();
                RemoteDeviceDialog pdialog = new RemoteDeviceDialog(shell);
                pdialog.open();
                String newDevice = pdialog.getAddress();
                if (newDevice != null && !newDevice.isEmpty()) {
                    TargetDialogTargetPage.this.drawTarageData();
                }
            }
        });
        this.drawTarageData();
    }

    public void drawTarageData() {
        this.deviceList.clear();
        this.targetList.clear();
        if (this.targetScrolledComposite != null) {
            this.targetScrolledComposite.dispose();
            this.targetScrolledComposite = null;
        }
        if (this.targetCom != null) {
            this.targetCom.dispose();
            this.targetCom = null;
        }
        this.targetScrolledComposite = new ScrolledComposite(this.targetParentComp, 512);
        this.targetScrolledComposite.setLayout((Layout)new FormLayout());
        FormData data = new FormData();
        data.top = new FormAttachment(0, 0);
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        data.bottom = new FormAttachment(100, -70);
        this.targetScrolledComposite.setLayoutData((Object)data);
        this.targetScrolledComposite.setExpandHorizontal(true);
        this.targetScrolledComposite.setExpandVertical(true);
        this.targetScrolledComposite.setBackground(ColorResources.FEATURE_TARGETCOMP_BACKGROUND);
        this.targetCom = new Composite((Composite)this.targetScrolledComposite, 0);
        this.targetCom.setBackground(ColorResources.FEATURE_TARGETCOMP_BACKGROUND);
        this.targetCom.setLayout((Layout)new RowLayout(512));
        this.targetScrolledComposite.setContent((Control)this.targetCom);
        Composite buttonComp = new Composite(this.targetCom, 0);
        buttonComp.setLayoutData((Object)new RowData(-1, 15));
        buttonComp.setLayout((Layout)new FillLayout());
        if (this.getConnectedTargets()) {
            for (DeviceInfo device : this.deviceList) {
                try {
                    String profileName = device.getIDevice().getPlatformInfo().getProfileName();
                    String serial = device.getIDevice().getSerialNumber();
                    DACustomFeatureToggleButton toggle = this.createToggleButton(this.targetCom, profileName, serial);
                    toggle.addListener(4, this.toggleUpListener);
                    toggle.addListener(3, this.toggleDownListener);
                    toggle.addListener(6, this.cursorListener);
                    toggle.addListener(7, this.cursorListener);
                    this.targetList.add(toggle);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        } else {
            Logger.debug((Object)"Failed : Getting connected device information");
        }
        this.targetParentComp.layout(true);
        this.targetScrolledComposite.layout();
        this.targetScrolledComposite.setMinSize(this.targetCom.computeSize(-1, -1));
    }

    public boolean selectDevice(DeviceInfo curDev) {
        String selectedDevStr = curDev.getIDevice().getSerialNumber();
        for (DACustomFeatureToggleButton toggleButton : this.targetList) {
            if (!toggleButton.getToolTipText().equals(selectedDevStr)) continue;
            toggleButton.setToggled(true);
            toggleButton.getParent().setBackground(ColorResources.FEATURE_FEATURELISTCOMP_SELECT_BACKGROUND);
            this.targetDialog.getAppListPage().drawAppList(this.updateAppListFromTarget(curDev));
            this.targetDialog.getInfoPage().drawDeviceInfoPage(curDev);
            return true;
        }
        return false;
    }

    private DACustomFeatureToggleButton createToggleButton(Composite composit, String profile, String serial) {
        Composite buttonComp = new Composite(composit, 0);
        buttonComp.setLayoutData((Object)new RowData(-1, 65));
        buttonComp.setBackground(ColorResources.FEATURE_TARGETCOMP_BACKGROUND);
        buttonComp.setLayout((Layout)new FormLayout());
        Image normalImage = ProfileDisplayInfo.getImage(profile);
        Image pushImage = ProfileDisplayInfo.getFocusImage(profile);
        Image hoverImage = ProfileDisplayInfo.getOverImage(profile);
        DACustomFeatureToggleButton toggle = new DACustomFeatureToggleButton(buttonComp, 0);
        toggle.setColors(ColorResources.FEATURE_TARGETCOMP_BACKGROUND, ColorResources.FEATURE_TARGETCOMP_BACKGROUND, ColorResources.FEATURE_TARGETCOMP_BACKGROUND, ColorResources.FEATURE_TARGETCOMP_BACKGROUND, ColorResources.FEATURE_FEATURELISTCOMP_SELECT_BACKGROUND, ColorResources.FEATURE_FEATURELISTCOMP_SELECT_BACKGROUND, ColorResources.FEATURE_FEATURELISTCOMP_SELECT_BACKGROUND);
        toggle.setButtonImages(normalImage, pushImage, hoverImage, normalImage, pushImage, hoverImage, pushImage);
        toggle.setButtonImagePoint(new Point(0, 0));
        if (profile.toLowerCase().equals("tv")) {
            toggle.setTitle("TV");
        } else {
            toggle.setTitle(profile);
            toggle.setCapitalize(true);
        }
        toggle.setFontPoint(new Point(55, 10));
        toggle.setFontColors(ColorResources.SETTING_COLOR, ColorResources.SETTING_COLOR, ColorResources.SETTING_COLOR, ColorResources.SETTING_COLOR);
        toggle.setButtonFont(FontResources.SETTING_BUTTON_FONT);
        toggle.setBackground(ColorResources.FEATURE_TARGETCOMP_BACKGROUND);
        toggle.setToolTipText(serial);
        FormData data = new FormData();
        data.top = new FormAttachment(0, 13);
        data.left = new FormAttachment(0, 20);
        data.height = 40;
        data.width = 155;
        toggle.setLayoutData((Object)data);
        return toggle;
    }

    private boolean getConnectedTargets() {
        boolean ret = true;
        List<DeviceInfo> devices = DeviceManager.getDevices();
        if (devices == null) {
            return false;
        }
        for (DeviceInfo device : devices) {
            try {
                this.deviceList.add(device);
            }
            catch (Exception exception) {
                ret = false;
            }
        }
        return ret;
    }

    private Map<String, PackageInfo> updateAppListFromTarget(DeviceInfo curDev) {
        if (curDev == null) {
            return null;
        }
        ArrayList<String> unittestLines = new ArrayList<String>();
        ArrayList<String> imeLines = new ArrayList<String>();
        final ArrayList<String> pkginfoLines = new ArrayList<String>();
        CommunicatorUtils.execShellCommand(curDev.getIDevice(), "/usr/bin/pkginfo --listpkg", (IShellOutputReceiver)new MultiLineReceiver(){

            public void processNewLines(String[] appLines) {
                int i = 0;
                while (i < appLines.length) {
                    pkginfoLines.add(appLines[i]);
                    ++i;
                }
            }
        });
        pkginfoLines.add("");
        pkginfoLines.add("pkg_type[unknown]pkgid[_Running process_]preload[1]");
        pkginfoLines.add(String.valueOf(AppInfo.PROPERTY.APPID.name) + ":" + "_Running process_");
        pkginfoLines.add(String.valueOf(AppInfo.PROPERTY.PACKAGE.name) + ":" + "_Running process_");
        pkginfoLines.add(String.valueOf(AppInfo.PROPERTY.LABEL.name) + ":" + "[Running process]");
        pkginfoLines.add(String.valueOf(AppInfo.PROPERTY.APPTYPE.name) + ":" + "running");
        pkginfoLines.add("");
        pkginfoLines.add("pkg_type[unknown]pkgid[_Common executable_]preload[1]");
        pkginfoLines.add(String.valueOf(AppInfo.PROPERTY.APPID.name) + ":" + "_Common executable_");
        pkginfoLines.add(String.valueOf(AppInfo.PROPERTY.PACKAGE.name) + ":" + "_Common executable_");
        pkginfoLines.add(String.valueOf(AppInfo.PROPERTY.LABEL.name) + ":" + "[Common executable]");
        pkginfoLines.add(String.valueOf(AppInfo.PROPERTY.APPTYPE.name) + ":" + "executable");
        pkginfoLines.add("");
        pkginfoLines.add("pkg_type[unknown]pkgid[_Without executable_]preload[1]");
        pkginfoLines.add(String.valueOf(AppInfo.PROPERTY.APPID.name) + ":" + "_Without executable_");
        pkginfoLines.add(String.valueOf(AppInfo.PROPERTY.PACKAGE.name) + ":" + "_Without executable_");
        pkginfoLines.add(String.valueOf(AppInfo.PROPERTY.LABEL.name) + ":" + "[Without executable]");
        pkginfoLines.add(String.valueOf(AppInfo.PROPERTY.APPTYPE.name) + ":" + "none");
        pkginfoLines.add("");
        curDev.updatePackageList(ApplistManager.parseTizenPkginfo(pkginfoLines, unittestLines, imeLines, curDev.getIDevice().getAppInstallPath()));
        return curDev.getPackageInfoHash();
    }

    private static enum ProfileDisplayInfo {
        PROFILE_NAME_MOBILE(0, ConfigureLabels.TARGET_NAME_FLAT_MOBILE_FOCUS, ImageResources.TARGET_NAME_FLAT_MOBILE_SEL, ImageResources.TARGET_NAME_FLAT_MOBILE_NORMAL, ImageResources.TARGET_NAME_FLAT_MOBILE_OVER),
        PROFILE_NAME_TV(1, ConfigureLabels.TARGET_NAME_FLAT_TV_FOCUS, ImageResources.TARGET_NAME_FLAT_TV_SEL, ImageResources.TARGET_NAME_FLAT_TV_NORMAL, ImageResources.TARGET_NAME_FLAT_TV_OVER),
        PROFILE_NAME_WEARABLE(2, ConfigureLabels.TARGET_NAME_FLAT_WEARABLE_FOCUS, ImageResources.TARGET_NAME_FLAT_WEARABLE_SEL, ImageResources.TARGET_NAME_FLAT_WEARABLE_NORMAL, ImageResources.TARGET_NAME_FLAT_WEARABLE_OVER);

        private String displayName = null;
        private Image focusImage = null;
        private Image normalImage = null;
        private Image overImage = null;

        private ProfileDisplayInfo(int id, String displayName, Image focusImage, Image normalImage, Image overImage) {
            this.displayName = displayName;
            this.focusImage = focusImage;
            this.normalImage = normalImage;
            this.overImage = overImage;
        }

        public static Image getImage(String displayName) {
            ProfileDisplayInfo[] profiles;
            ProfileDisplayInfo[] profileDisplayInfoArray = profiles = ProfileDisplayInfo.values();
            int n = profiles.length;
            int n2 = 0;
            while (n2 < n) {
                ProfileDisplayInfo profile = profileDisplayInfoArray[n2];
                if (profile.displayName.equals(displayName)) {
                    return profile.normalImage;
                }
                ++n2;
            }
            return null;
        }

        public static Image getFocusImage(String displayName) {
            ProfileDisplayInfo[] profiles;
            ProfileDisplayInfo[] profileDisplayInfoArray = profiles = ProfileDisplayInfo.values();
            int n = profiles.length;
            int n2 = 0;
            while (n2 < n) {
                ProfileDisplayInfo profile = profileDisplayInfoArray[n2];
                if (profile.displayName.equals(displayName)) {
                    return profile.focusImage;
                }
                ++n2;
            }
            return null;
        }

        public static Image getOverImage(String displayName) {
            ProfileDisplayInfo[] profiles;
            ProfileDisplayInfo[] profileDisplayInfoArray = profiles = ProfileDisplayInfo.values();
            int n = profiles.length;
            int n2 = 0;
            while (n2 < n) {
                ProfileDisplayInfo profile = profileDisplayInfoArray[n2];
                if (profile.displayName.equals(displayName)) {
                    return profile.overImage;
                }
                ++n2;
            }
            return null;
        }
    }
}

