/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.widgets.da.base;

import java.util.ArrayList;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.tizen.dynamicanalyzer.resources.ColorResources;
import org.tizen.dynamicanalyzer.resources.FontResources;
import org.tizen.dynamicanalyzer.resources.ImageResources;
import org.tizen.dynamicanalyzer.widgets.animation.DAAnimationIcon;
import org.tizen.dynamicanalyzer.widgets.button.DACustomButton;
import org.tizen.dynamicanalyzer.widgets.button.DACustomButtonClickEventListener;

public class IndeterminateProgressDialog {
    public static final int DIALOG_TYPE_SMALL = 0;
    public static final int DIALOG_TYPE_MIDDLE = 1;
    public static final int DIALOG_TYPE_LARGE = 2;
    private Shell parent = null;
    private Shell shell = null;
    private Composite baseComposite = null;
    private Composite progressComp = null;
    private String upperText = "";
    private String bottomText = "";
    private DACustomButton cancelButton = null;
    private DAAnimationIcon loadingIcon = null;
    private DAAnimationIcon progressIcon = null;
    private DACustomButtonClickEventListener cancelButtonListener = null;
    private Listener shellMouseListener = new Listener(){
        boolean down = false;
        Point downPoint = new Point(0, 0);

        public void handleEvent(Event event) {
            int id = event.type;
            if (event.widget instanceof Shell) {
                this.down = false;
            } else {
                switch (id) {
                    case 3: {
                        this.downPoint.x = event.x;
                        this.downPoint.y = event.y;
                        this.down = true;
                        break;
                    }
                    case 4: {
                        this.down = false;
                        break;
                    }
                    case 5: {
                        if (!this.down || IndeterminateProgressDialog.this.shell == null) break;
                        Point p = IndeterminateProgressDialog.this.shell.getLocation();
                        p.x += event.x - this.downPoint.x;
                        p.y += event.y - this.downPoint.y;
                        IndeterminateProgressDialog.this.shell.setLocation(p);
                        break;
                    }
                }
            }
        }
    };

    public IndeterminateProgressDialog(Shell parent, Composite base) {
        this.parent = parent;
        this.baseComposite = base;
    }

    public void open() {
        this.createProgress();
        if (this.shell != null) {
            this.shell.setLayout((Layout)new FormLayout());
            this.shell.addPaintListener(new PaintListener(){

                public void paintControl(PaintEvent e) {
                    Rectangle rect = IndeterminateProgressDialog.this.shell.getClientArea();
                    e.gc.setForeground(ColorResources.STOP_PROGRESS_LINE2_COLOR);
                    e.gc.drawRectangle(rect.x, rect.y, rect.width - 1, rect.height - 1);
                    e.gc.setForeground(ColorResources.STOP_PROGRESS_LINE1_COLOR);
                    e.gc.drawRectangle(rect.x + 1, rect.y + 1, rect.width - 3, rect.height - 3);
                }
            });
            this.shell.getDisplay().addFilter(3, this.shellMouseListener);
            this.shell.getDisplay().addFilter(4, this.shellMouseListener);
            this.shell.getDisplay().addFilter(5, this.shellMouseListener);
            this.shell.addListener(31, new Listener(){

                public void handleEvent(Event event) {
                    if (event.detail == 2) {
                        event.doit = false;
                    }
                }
            });
            this.shell.open();
            this.baseComposite.setEnabled(false);
        }
    }

    public void createProgress() {
        this.shell = new Shell(this.parent, 65544);
        this.shell.setSize(300, 110);
        this.progressComp = new Composite((Composite)this.shell, 0);
        this.progressComp.setLayout((Layout)new FormLayout());
        this.progressComp.setBackground(ColorResources.DIALOG_BG_LOWER);
        FormData data = new FormData();
        data.top = new FormAttachment(0, 2);
        data.left = new FormAttachment(0, 2);
        data.right = new FormAttachment(100, -2);
        data.bottom = new FormAttachment(100, -2);
        this.progressComp.setLayoutData((Object)data);
        this.loadingIcon = this.createLoadingIcon(this.progressComp);
        data = new FormData();
        data.top = new FormAttachment(0, 11);
        data.left = new FormAttachment(0, 11);
        data.width = 24;
        data.height = 24;
        this.loadingIcon.setLayoutData((Object)data);
        this.loadingIcon.start();
        Label upperLabel = new Label(this.progressComp, 0x40004000);
        upperLabel.setText(this.upperText);
        upperLabel.setFont(FontResources.PROGRESS_FONT);
        upperLabel.setForeground(ColorResources.BLACK);
        data = new FormData();
        data.top = new FormAttachment(0, 17);
        data.left = new FormAttachment(0, 40);
        data.right = new FormAttachment(95, 0);
        upperLabel.setLayoutData((Object)data);
        this.progressIcon = this.createProgressIcon(this.progressComp);
        data = new FormData();
        data.top = new FormAttachment(0, 44);
        data.left = new FormAttachment(0, 11);
        data.width = 276;
        data.height = 22;
        this.progressIcon.setLayoutData((Object)data);
        this.progressIcon.start();
        Label bottomLabel = new Label(this.progressComp, 0x40004000);
        bottomLabel.setText(this.bottomText);
        bottomLabel.setFont(FontResources.STOP_PROGRESS_FONT);
        bottomLabel.setForeground(ColorResources.STOP_PROGRESS_INFO_FONT_COLOR);
        data = new FormData();
        data.left = new FormAttachment(0, 12);
        data.top = new FormAttachment((Control)this.progressIcon, 10);
        data.height = 20;
        bottomLabel.setLayoutData((Object)data);
        FormData okData = new FormData();
        okData.top = new FormAttachment((Control)this.progressIcon, 10);
        okData.right = new FormAttachment(100, -12);
        okData.width = 88;
        okData.height = 22;
        this.cancelButton = this.createButton(this.progressComp, "Cancel", okData);
        this.cancelButton.setLayoutData((Object)okData);
        if (this.cancelButtonListener != null) {
            this.cancelButton.addClickListener(this.cancelButtonListener);
        }
    }

    public void close() {
        if (this.loadingIcon != null) {
            this.loadingIcon.stopTimer();
        }
        if (this.progressIcon != null) {
            this.progressIcon.stopTimer();
        }
        if (this.shell != null) {
            if (!this.shell.isDisposed()) {
                this.shell.dispose();
            }
            this.shell = null;
        }
        this.baseComposite.setEnabled(true);
    }

    public void setProgressMessage(String message) {
        this.upperText = message;
    }

    public void setProgressInfo(String infoMessage) {
        this.bottomText = infoMessage;
    }

    private DACustomButton createButton(Composite comp, String text, FormData data) {
        DACustomButton button = new DACustomButton(comp, 0);
        button.setText(text);
        button.setLayoutData((Object)data);
        button.setGradation(ColorResources.BUTTON_NORMAL_COLOR_START, ColorResources.BUTTON_NORMAL_COLOR_END, ColorResources.BUTTON_PUSH_COLOR_START, ColorResources.BUTTON_PUSH_COLOR_END, ColorResources.BUTTON_HOVER_COLOR_START, ColorResources.BUTTON_HOVER_COLOR_END, ColorResources.BUTTON_DISABLE_COLOR_START, ColorResources.BUTTON_DISABLE_COLOR_END);
        button.setFontColors(ColorResources.BUTTON_NORMAL_FONT_COLOR, ColorResources.BUTTON_PUSH_FONT_COLOR, ColorResources.BUTTON_HOVER_FONT_COLOR, ColorResources.BUTTON_DISABLE_FONT_COLOR);
        button.setOutlineColors(ColorResources.BUTTON_OUTLINE_NORMAL_COLOR, ColorResources.BUTTON_OUTLINE_PUSH_COLOR, ColorResources.BUTTON_OUTLINE_HOVER_COLOR, ColorResources.BUTTON_OUTLINE_DISABLE_COLOR);
        button.setOutlineInColors(ColorResources.BUTTON_OUTLINE_NORMAL_IN_COLOR, ColorResources.BUTTON_OUTLINE_PUSH_IN_COLOR, ColorResources.BUTTON_OUTLINE_HOVER_IN_COLOR, ColorResources.BUTTON_OUTLINE_DISABLE_IN_COLOR);
        button.setButtonFont(FontResources.DIALOG_BUTTON_FONT);
        return button;
    }

    public void setCancelListener(DACustomButtonClickEventListener listener) {
        this.cancelButtonListener = listener;
    }

    public void setCancelEnabled(final boolean enable) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                IndeterminateProgressDialog.this.cancelButton.setButtonEnabled(enable);
            }
        });
    }

    private DAAnimationIcon createLoadingIcon(Composite comp) {
        ArrayList<Image> loadingImage = new ArrayList<Image>();
        loadingImage.add(ImageResources.STOP_PROGRESS_LOADING_01);
        loadingImage.add(ImageResources.STOP_PROGRESS_LOADING_02);
        loadingImage.add(ImageResources.STOP_PROGRESS_LOADING_03);
        loadingImage.add(ImageResources.STOP_PROGRESS_LOADING_04);
        loadingImage.add(ImageResources.STOP_PROGRESS_LOADING_05);
        loadingImage.add(ImageResources.STOP_PROGRESS_LOADING_06);
        loadingImage.add(ImageResources.STOP_PROGRESS_LOADING_07);
        loadingImage.add(ImageResources.STOP_PROGRESS_LOADING_08);
        return new DAAnimationIcon(comp, 0, loadingImage);
    }

    private DAAnimationIcon createProgressIcon(Composite comp) {
        ArrayList<Image> progressImage = new ArrayList<Image>();
        progressImage.add(ImageResources.INDETERMINATE_PROGRESS_01);
        progressImage.add(ImageResources.INDETERMINATE_PROGRESS_02);
        return new DAAnimationIcon(comp, 0, progressImage);
    }
}

