/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.edc.internal.eval.ast.engine;

import java.util.Stack;
import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTArrayModifier;
import org.eclipse.cdt.core.dom.ast.IASTArraySubscriptExpression;
import org.eclipse.cdt.core.dom.ast.IASTBinaryExpression;
import org.eclipse.cdt.core.dom.ast.IASTCastExpression;
import org.eclipse.cdt.core.dom.ast.IASTComment;
import org.eclipse.cdt.core.dom.ast.IASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTEnumerationSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTFieldReference;
import org.eclipse.cdt.core.dom.ast.IASTIdExpression;
import org.eclipse.cdt.core.dom.ast.IASTInitializer;
import org.eclipse.cdt.core.dom.ast.IASTLiteralExpression;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTParameterDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTPointerOperator;
import org.eclipse.cdt.core.dom.ast.IASTProblem;
import org.eclipse.cdt.core.dom.ast.IASTStatement;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.IASTTypeId;
import org.eclipse.cdt.core.dom.ast.IASTUnaryExpression;
import org.eclipse.cdt.debug.edc.internal.EDCTrace;
import org.eclipse.cdt.debug.edc.internal.eval.ast.engine.ASTEvalMessages;
import org.eclipse.cdt.debug.edc.internal.eval.ast.engine.instructions.ArraySubscript;
import org.eclipse.cdt.debug.edc.internal.eval.ast.engine.instructions.CompoundInstruction;
import org.eclipse.cdt.debug.edc.internal.eval.ast.engine.instructions.EvaluateID;
import org.eclipse.cdt.debug.edc.internal.eval.ast.engine.instructions.FieldReference;
import org.eclipse.cdt.debug.edc.internal.eval.ast.engine.instructions.Instruction;
import org.eclipse.cdt.debug.edc.internal.eval.ast.engine.instructions.InstructionSequence;
import org.eclipse.cdt.debug.edc.internal.eval.ast.engine.instructions.NoOp;
import org.eclipse.cdt.debug.edc.internal.eval.ast.engine.instructions.OperatorAddrOf;
import org.eclipse.cdt.debug.edc.internal.eval.ast.engine.instructions.OperatorBinaryAnd;
import org.eclipse.cdt.debug.edc.internal.eval.ast.engine.instructions.OperatorBinaryOr;
import org.eclipse.cdt.debug.edc.internal.eval.ast.engine.instructions.OperatorBinaryXor;
import org.eclipse.cdt.debug.edc.internal.eval.ast.engine.instructions.OperatorBitwiseNot;
import org.eclipse.cdt.debug.edc.internal.eval.ast.engine.instructions.OperatorCast;
import org.eclipse.cdt.debug.edc.internal.eval.ast.engine.instructions.OperatorCastValue;
import org.eclipse.cdt.debug.edc.internal.eval.ast.engine.instructions.OperatorDivide;
import org.eclipse.cdt.debug.edc.internal.eval.ast.engine.instructions.OperatorEquals;
import org.eclipse.cdt.debug.edc.internal.eval.ast.engine.instructions.OperatorGreaterEqual;
import org.eclipse.cdt.debug.edc.internal.eval.ast.engine.instructions.OperatorGreaterThan;
import org.eclipse.cdt.debug.edc.internal.eval.ast.engine.instructions.OperatorIndirection;
import org.eclipse.cdt.debug.edc.internal.eval.ast.engine.instructions.OperatorLessEqual;
import org.eclipse.cdt.debug.edc.internal.eval.ast.engine.instructions.OperatorLessThan;
import org.eclipse.cdt.debug.edc.internal.eval.ast.engine.instructions.OperatorLogicalAnd;
import org.eclipse.cdt.debug.edc.internal.eval.ast.engine.instructions.OperatorLogicalNot;
import org.eclipse.cdt.debug.edc.internal.eval.ast.engine.instructions.OperatorLogicalOr;
import org.eclipse.cdt.debug.edc.internal.eval.ast.engine.instructions.OperatorMinus;
import org.eclipse.cdt.debug.edc.internal.eval.ast.engine.instructions.OperatorModulo;
import org.eclipse.cdt.debug.edc.internal.eval.ast.engine.instructions.OperatorMultiply;
import org.eclipse.cdt.debug.edc.internal.eval.ast.engine.instructions.OperatorNotEquals;
import org.eclipse.cdt.debug.edc.internal.eval.ast.engine.instructions.OperatorPlus;
import org.eclipse.cdt.debug.edc.internal.eval.ast.engine.instructions.OperatorShiftLeft;
import org.eclipse.cdt.debug.edc.internal.eval.ast.engine.instructions.OperatorShiftRight;
import org.eclipse.cdt.debug.edc.internal.eval.ast.engine.instructions.OperatorUnaryMinus;
import org.eclipse.cdt.debug.edc.internal.eval.ast.engine.instructions.OperatorUnaryPlus;
import org.eclipse.cdt.debug.edc.internal.eval.ast.engine.instructions.PushBoolean;
import org.eclipse.cdt.debug.edc.internal.eval.ast.engine.instructions.PushChar;
import org.eclipse.cdt.debug.edc.internal.eval.ast.engine.instructions.PushDouble;
import org.eclipse.cdt.debug.edc.internal.eval.ast.engine.instructions.PushFloat;
import org.eclipse.cdt.debug.edc.internal.eval.ast.engine.instructions.PushLongOrBigInteger;
import org.eclipse.cdt.debug.edc.internal.eval.ast.engine.instructions.PushString;
import org.eclipse.cdt.internal.core.dom.parser.ASTAmbiguousNode;

public class ASTInstructionCompiler
extends ASTVisitor {
    private final Stack<Instruction> stack = new Stack();
    private final InstructionSequence instructions;
    private int counter;
    private String errorMessage;
    private boolean active = true;

    public ASTInstructionCompiler(String snippet) {
        super(true);
        this.instructions = new InstructionSequence(snippet);
    }

    private void push(Instruction i) {
        this.stack.push(i);
    }

    private Instruction pop() {
        return this.stack.pop();
    }

    public InstructionSequence getInstructions() {
        return this.instructions;
    }

    public boolean hasErrors() {
        return this.errorMessage != null;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    private boolean isActive() {
        return this.active;
    }

    private void storeInstruction() {
        Instruction instruction = this.pop();
        ++this.counter;
        if (instruction instanceof CompoundInstruction) {
            ((CompoundInstruction)instruction).setEnd(this.counter);
        }
        this.instructions.add(instruction);
    }

    public int leave(IASTArrayModifier arrayModifier) {
        if (EDCTrace.EXPRESSION_PARSE_TRACE_ON) {
            EDCTrace.getTrace().traceEntry(null, (Object)EDCTrace.fixArg(arrayModifier));
        }
        return super.leave(arrayModifier);
    }

    public int leave(IASTComment comment) {
        if (EDCTrace.EXPRESSION_PARSE_TRACE_ON) {
            EDCTrace.getTrace().traceEntry(null, (Object)EDCTrace.fixArg(comment));
        }
        return super.leave(comment);
    }

    public int leave(IASTDeclaration declaration) {
        if (EDCTrace.EXPRESSION_PARSE_TRACE_ON) {
            EDCTrace.getTrace().traceEntry(null, (Object)EDCTrace.fixArg(declaration));
        }
        return super.leave(declaration);
    }

    public int leave(IASTDeclarator declarator) {
        if (EDCTrace.EXPRESSION_PARSE_TRACE_ON) {
            EDCTrace.getTrace().traceEntry(null, (Object)EDCTrace.fixArg(declarator));
        }
        return super.leave(declarator);
    }

    public int leave(IASTDeclSpecifier declSpec) {
        if (EDCTrace.EXPRESSION_PARSE_TRACE_ON) {
            EDCTrace.getTrace().traceEntry(null, (Object)EDCTrace.fixArg(declSpec));
        }
        return super.leave(declSpec);
    }

    public int leave(IASTEnumerationSpecifier.IASTEnumerator enumerator) {
        if (EDCTrace.EXPRESSION_PARSE_TRACE_ON) {
            EDCTrace.getTrace().traceEntry(null, (Object)EDCTrace.fixArg(enumerator));
        }
        return super.leave(enumerator);
    }

    public int leave(IASTExpression expression) {
        if (!this.isActive() || this.hasErrors()) {
            return 3;
        }
        this.storeInstruction();
        if (EDCTrace.EXPRESSION_PARSE_TRACE_ON) {
            EDCTrace.getTrace().traceEntry(null, (Object)EDCTrace.fixArg(expression));
        }
        return super.leave(expression);
    }

    public int leave(IASTInitializer initializer) {
        if (EDCTrace.EXPRESSION_PARSE_TRACE_ON) {
            EDCTrace.getTrace().traceEntry(null, (Object)EDCTrace.fixArg(initializer));
        }
        return super.leave(initializer);
    }

    public int leave(IASTName name) {
        if (EDCTrace.EXPRESSION_PARSE_TRACE_ON) {
            EDCTrace.getTrace().traceEntry(null, (Object)EDCTrace.fixArg(name));
        }
        return super.leave(name);
    }

    public int leave(IASTParameterDeclaration parameterDeclaration) {
        if (EDCTrace.EXPRESSION_PARSE_TRACE_ON) {
            EDCTrace.getTrace().traceEntry(null, (Object)EDCTrace.fixArg(parameterDeclaration));
        }
        return super.leave(parameterDeclaration);
    }

    public int leave(IASTPointerOperator ptrOperator) {
        if (EDCTrace.EXPRESSION_PARSE_TRACE_ON) {
            EDCTrace.getTrace().traceEntry(null, (Object)EDCTrace.fixArg(ptrOperator));
        }
        return super.leave(ptrOperator);
    }

    public int leave(IASTProblem problem) {
        if (EDCTrace.EXPRESSION_PARSE_TRACE_ON) {
            EDCTrace.getTrace().traceEntry(null, (Object)EDCTrace.fixArg(problem));
        }
        return super.leave(problem);
    }

    public int leave(IASTStatement statement) {
        if (EDCTrace.EXPRESSION_PARSE_TRACE_ON) {
            EDCTrace.getTrace().traceEntry(null, (Object)EDCTrace.fixArg(statement));
        }
        return super.leave(statement);
    }

    public int leave(IASTTranslationUnit tu) {
        if (EDCTrace.EXPRESSION_PARSE_TRACE_ON) {
            EDCTrace.getTrace().traceEntry(null, (Object)EDCTrace.fixArg(tu));
        }
        return super.leave(tu);
    }

    public int leave(IASTTypeId typeId) {
        if (EDCTrace.EXPRESSION_PARSE_TRACE_ON) {
            EDCTrace.getTrace().traceEntry(null, (Object)EDCTrace.fixArg(typeId));
        }
        return super.leave(typeId);
    }

    public int visit(IASTArrayModifier arrayModifier) {
        if (EDCTrace.EXPRESSION_PARSE_TRACE_ON) {
            EDCTrace.getTrace().traceEntry(null, (Object)EDCTrace.fixArg(arrayModifier));
        }
        return super.visit(arrayModifier);
    }

    public int visit(IASTComment comment) {
        if (EDCTrace.EXPRESSION_PARSE_TRACE_ON) {
            EDCTrace.getTrace().traceEntry(null, (Object)EDCTrace.fixArg(comment));
        }
        return super.visit(comment);
    }

    public int visit(IASTDeclaration declaration) {
        if (EDCTrace.EXPRESSION_PARSE_TRACE_ON) {
            EDCTrace.getTrace().traceEntry(null, (Object)EDCTrace.fixArg(declaration));
        }
        return super.visit(declaration);
    }

    public int visit(IASTDeclarator declarator) {
        if (EDCTrace.EXPRESSION_PARSE_TRACE_ON) {
            EDCTrace.getTrace().traceEntry(null, (Object)EDCTrace.fixArg(declarator));
        }
        return super.visit(declarator);
    }

    public int visit(IASTDeclSpecifier declSpec) {
        if (EDCTrace.EXPRESSION_PARSE_TRACE_ON) {
            EDCTrace.getTrace().traceEntry(null, (Object)EDCTrace.fixArg(declSpec));
        }
        return super.visit(declSpec);
    }

    public int visit(IASTEnumerationSpecifier.IASTEnumerator enumerator) {
        if (EDCTrace.EXPRESSION_PARSE_TRACE_ON) {
            EDCTrace.getTrace().traceEntry(null, (Object)EDCTrace.fixArg(enumerator));
        }
        return super.visit(enumerator);
    }

    public int visit(IASTInitializer initializer) {
        if (EDCTrace.EXPRESSION_PARSE_TRACE_ON) {
            EDCTrace.getTrace().traceEntry(null, (Object)EDCTrace.fixArg(initializer));
        }
        return super.visit(initializer);
    }

    public int visit(IASTParameterDeclaration parameterDeclaration) {
        if (EDCTrace.EXPRESSION_PARSE_TRACE_ON) {
            EDCTrace.getTrace().traceEntry(null, (Object)EDCTrace.fixArg("visit: " + parameterDeclaration.getClass().getSimpleName()));
        }
        return super.visit(parameterDeclaration);
    }

    public int visit(IASTPointerOperator ptrOperator) {
        if (EDCTrace.EXPRESSION_PARSE_TRACE_ON) {
            EDCTrace.getTrace().traceEntry(null, (Object)EDCTrace.fixArg(ptrOperator));
        }
        return super.visit(ptrOperator);
    }

    public int visit(IASTStatement statement) {
        if (EDCTrace.EXPRESSION_PARSE_TRACE_ON) {
            EDCTrace.getTrace().traceEntry(null, (Object)EDCTrace.fixArg(statement));
        }
        return super.visit(statement);
    }

    public int visit(IASTTranslationUnit tu) {
        if (EDCTrace.EXPRESSION_PARSE_TRACE_ON) {
            EDCTrace.getTrace().traceEntry(null, (Object)EDCTrace.fixArg(tu));
        }
        return super.visit(tu);
    }

    public int visit(IASTTypeId typeId) {
        if (EDCTrace.EXPRESSION_PARSE_TRACE_ON) {
            EDCTrace.getTrace().traceEntry(null, (Object)EDCTrace.fixArg(typeId));
        }
        return super.visit(typeId);
    }

    public int visit(ASTAmbiguousNode astAmbiguousNode) {
        if (EDCTrace.EXPRESSION_PARSE_TRACE_ON) {
            EDCTrace.getTrace().traceEntry(null, (Object)EDCTrace.fixArg(astAmbiguousNode));
        }
        return super.visit(astAmbiguousNode);
    }

    public int visit(IASTName name) {
        if (EDCTrace.EXPRESSION_PARSE_TRACE_ON) {
            EDCTrace.getTrace().traceEntry(null, (Object)EDCTrace.fixArg(name));
        }
        return super.visit(name);
    }

    public int visit(IASTProblem problem) {
        if (EDCTrace.EXPRESSION_PARSE_TRACE_ON) {
            EDCTrace.getTrace().traceEntry(null, (Object)EDCTrace.fixArg(problem));
        }
        return super.visit(problem);
    }

    public int visit(IASTExpression expression) {
        if (EDCTrace.EXPRESSION_PARSE_TRACE_ON) {
            EDCTrace.getTrace().traceEntry(null, (Object)EDCTrace.fixArg(expression));
        }
        if (expression instanceof IASTLiteralExpression) {
            this.visitLiteralExpression((IASTLiteralExpression)expression);
        } else if (expression instanceof IASTBinaryExpression) {
            this.visitBinaryExpression((IASTBinaryExpression)expression);
        } else if (expression instanceof IASTUnaryExpression) {
            this.visitUnaryExpression((IASTUnaryExpression)expression);
        } else if (expression instanceof IASTIdExpression) {
            this.visitIDExpression((IASTIdExpression)expression);
        } else if (expression instanceof IASTArraySubscriptExpression) {
            this.visitArraySubscriptExpression((IASTArraySubscriptExpression)expression);
        } else if (expression instanceof IASTFieldReference) {
            this.visitFieldReference((IASTFieldReference)expression);
        } else if (expression instanceof IASTCastExpression) {
            this.visitCastExpression((IASTCastExpression)expression);
        } else {
            this.push(new NoOp(this.counter));
        }
        return super.visit(expression);
    }

    private void visitIDExpression(IASTIdExpression expression) {
        this.push(new EvaluateID(expression));
    }

    private void visitArraySubscriptExpression(IASTArraySubscriptExpression expression) {
        this.push(new ArraySubscript(this.counter));
    }

    private void visitFieldReference(IASTFieldReference expression) {
        this.push(new FieldReference(expression, this.counter));
    }

    private void visitCastExpression(IASTCastExpression expression) {
        if (expression.getOperator() == 3) {
            this.push(new OperatorCastValue(this.counter, expression));
        } else {
            this.push(new OperatorCast(this.counter, expression));
        }
    }

    private void visitLiteralExpression(IASTLiteralExpression expression) {
        int kind = expression.getKind();
        String value = new String(expression.getValue());
        switch (kind) {
            case 0: {
                try {
                    this.push(new PushLongOrBigInteger(value));
                }
                catch (NumberFormatException numberFormatException) {
                    this.errorMessage = ASTEvalMessages.ASTInstructionCompiler_InvalidNumber;
                }
                break;
            }
            case 1: {
                try {
                    if (value.toUpperCase().endsWith("F")) {
                        this.push(new PushFloat(value));
                        break;
                    }
                    this.push(new PushDouble(value));
                }
                catch (NumberFormatException numberFormatException) {
                    this.errorMessage = ASTEvalMessages.ASTInstructionCompiler_InvalidNumber;
                }
                break;
            }
            case 2: {
                try {
                    this.push(new PushChar(value));
                }
                catch (NumberFormatException numberFormatException) {
                    this.errorMessage = ASTEvalMessages.ASTInstructionCompiler_InvalidNumber;
                }
                break;
            }
            case 3: {
                this.push(new PushString(value));
                break;
            }
            case 6: {
                this.push(new PushBoolean(false));
                break;
            }
            case 5: {
                this.push(new PushBoolean(true));
                break;
            }
            case 4: {
                this.push(new EvaluateID("this"));
                break;
            }
            default: {
                this.push(new NoOp(this.counter));
            }
        }
    }

    private void visitBinaryExpression(IASTBinaryExpression expression) {
        int op = expression.getOperator();
        switch (op) {
            case 12: {
                this.push(new OperatorBinaryAnd(this.counter));
                break;
            }
            case 14: {
                this.push(new OperatorBinaryOr(this.counter));
                break;
            }
            case 13: {
                this.push(new OperatorBinaryXor(this.counter));
                break;
            }
            case 4: {
                this.push(new OperatorPlus(this.counter));
                break;
            }
            case 5: {
                this.push(new OperatorMinus(this.counter));
                break;
            }
            case 1: {
                this.push(new OperatorMultiply(this.counter));
                break;
            }
            case 2: {
                this.push(new OperatorDivide(this.counter));
                break;
            }
            case 3: {
                this.push(new OperatorModulo(this.counter));
                break;
            }
            case 6: {
                this.push(new OperatorShiftLeft(this.counter));
                break;
            }
            case 7: {
                this.push(new OperatorShiftRight(this.counter));
                break;
            }
            case 28: {
                this.push(new OperatorEquals(this.counter));
                break;
            }
            case 29: {
                this.push(new OperatorNotEquals(this.counter));
                break;
            }
            case 11: {
                this.push(new OperatorGreaterEqual(this.counter));
                break;
            }
            case 9: {
                this.push(new OperatorGreaterThan(this.counter));
                break;
            }
            case 10: {
                this.push(new OperatorLessEqual(this.counter));
                break;
            }
            case 8: {
                this.push(new OperatorLessThan(this.counter));
                break;
            }
            case 15: {
                this.push(new OperatorLogicalAnd(this.counter));
                break;
            }
            case 16: {
                this.push(new OperatorLogicalOr(this.counter));
                break;
            }
            default: {
                this.push(new NoOp(this.counter));
            }
        }
    }

    private void visitUnaryExpression(IASTUnaryExpression expression) {
        int op = expression.getOperator();
        switch (op) {
            case 3: {
                this.push(new OperatorUnaryMinus(this.counter));
                break;
            }
            case 7: {
                this.push(new OperatorLogicalNot(this.counter));
                break;
            }
            case 2: {
                this.push(new OperatorUnaryPlus(this.counter));
                break;
            }
            case 6: {
                this.push(new OperatorBitwiseNot(this.counter));
                break;
            }
            case 4: {
                this.push(new OperatorIndirection(this.counter));
                break;
            }
            case 5: {
                this.push(new OperatorAddrOf(this.counter));
                break;
            }
            default: {
                this.push(new NoOp(this.counter));
            }
        }
    }
}

