/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.common;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.tizen.dynamicanalyzer.common.path.PathManager;
import org.tizen.dynamicanalyzer.communicator.DACommunicator;
import org.tizen.dynamicanalyzer.nl.ConfigureLabels;
import org.tizen.dynamicanalyzer.ui.common.explorer.FileExplorerDialog;
import org.tizen.dynamicanalyzer.util.CommonUtil;
import org.tizen.dynamicanalyzer.util.Logger;
import org.tizen.dynamicanalyzer.util.WorkbenchUtil;

public class DALogExport {
    private String LogexportPath;
    private String LogZipPath;
    private String ExportLogName;

    public DALogExport() {
        Boolean result = false;
        result = this.exportPathDialog();
        if (!result.booleanValue()) {
            Logger.debug((Object)"selected export path is wrong");
            return;
        }
        result = this.exportDALog();
        if (!result.booleanValue()) {
            Logger.debug((Object)"export DAConsoleLog failed");
        }
        if (!(result = this.exportDaemonLog()).booleanValue()) {
            Logger.debug((Object)"export DaemonLog failed");
        }
        if (!(result = this.exportDataLog()).booleanValue()) {
            Logger.debug((Object)"export DataLog failed");
        }
        if (!(result = this.exportControlLog()).booleanValue()) {
            Logger.debug((Object)"export ControlLog failed");
        }
        if (!(result = this.compressLogs()).booleanValue()) {
            Logger.debug((Object)"compress Logs failed");
        }
        if (!(result = Boolean.valueOf(this.removeTemp())).booleanValue()) {
            Logger.debug((Object)"remove temp failed");
        }
    }

    private Boolean exportPathDialog() {
        FileExplorerDialog dialog = new FileExplorerDialog(WorkbenchUtil.getWorkbenchWindow().getShell());
        dialog.setTitle(ConfigureLabels.EXPORT_DIALOG_SELECT_EXPORT_PATH);
        dialog.getExplorer().setRoot(CommonUtil.getHomeDirectory());
        Object result = dialog.open();
        if (result == null) {
            return false;
        }
        if (result instanceof Boolean && !((Boolean)result).booleanValue()) {
            return false;
        }
        this.LogexportPath = result.toString();
        int cutStart = this.LogexportPath.indexOf("[");
        int cutEnd = this.LogexportPath.indexOf("]");
        String tmpPath = this.LogexportPath.substring(cutStart + 1, cutEnd);
        SimpleDateFormat format = new SimpleDateFormat("yyyy_MM_dd_HH-mm-ss", Locale.KOREA);
        Date date = new Date();
        String logPostFix = format.format(date);
        this.ExportLogName = "DALogs_" + logPostFix;
        this.LogZipPath = tmpPath;
        this.setLogExportPath(String.valueOf(tmpPath) + "/" + this.ExportLogName);
        return true;
    }

    private void setLogExportPath(String path) {
        this.LogexportPath = path;
    }

    private Boolean exportDALog() {
        File src = this.getLastDALog(PathManager.DA_LOG_PATH);
        File dirCheck = new File(this.LogexportPath);
        File dest = new File(String.valueOf(this.LogexportPath) + "/" + "da_console.log");
        if (!this.checkDirectory(dirCheck)) {
            return false;
        }
        if (!this.copyLogFile(src, dest).booleanValue()) {
            return false;
        }
        return true;
    }

    private Boolean exportDaemonLog() {
        DACommunicator.exportCustomPathDaemonLog(this.LogexportPath);
        return true;
    }

    private Boolean exportDataLog() {
        File src = new File(PathManager.DA_DEBUG_DATA_CHANNEL_LOG_FILE);
        File dest = new File(String.valueOf(this.LogexportPath) + "/" + "da_data.log");
        if (!this.copyLogFile(src, dest).booleanValue()) {
            return false;
        }
        return true;
    }

    private Boolean exportControlLog() {
        File src = new File(PathManager.DA_DEBUG_CONTROL_CHANNEL_LOG_FILE);
        File dest = new File(String.valueOf(this.LogexportPath) + "/" + "da_control.log");
        if (!this.copyLogFile(src, dest).booleanValue()) {
            return false;
        }
        return true;
    }

    private Boolean copyLogFile(File source, File dest) {
        FileInputStream input = null;
        OutputStream output = null;
        try {
            try {
                int bytesRead;
                input = new FileInputStream(source);
                output = new FileOutputStream(dest);
                byte[] buf = new byte[1024];
                while ((bytesRead = ((InputStream)input).read(buf)) > 0) {
                    output.write(buf, 0, bytesRead);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                Boolean bl = false;
                try {
                    if (input != null) {
                        ((InputStream)input).close();
                    }
                    if (output != null) {
                        output.close();
                    }
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                    return false;
                }
                return bl;
            }
        }
        finally {
            try {
                if (input != null) {
                    ((InputStream)input).close();
                }
                if (output != null) {
                    output.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                return false;
            }
        }
        return true;
    }

    private File getLastDALog(String dir) {
        File fl = new File(dir);
        File[] files = fl.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isFile();
            }
        });
        long lastMod = Long.MIN_VALUE;
        File lastModFile = null;
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.toString().contains("da_log_") && file.lastModified() > lastMod) {
                lastModFile = file;
                lastMod = file.lastModified();
            }
            ++n2;
        }
        return lastModFile;
    }

    private Boolean compressLogs() {
        ZipOutputStream zip = null;
        FileOutputStream fileWriter = null;
        String srcFolder = this.LogexportPath;
        String destZipFile = String.valueOf(this.LogZipPath) + "/" + this.ExportLogName + ".zip";
        try {
            fileWriter = new FileOutputStream(destZipFile);
            zip = new ZipOutputStream(fileWriter);
            this.addFolderToZip("", srcFolder, zip);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        if (zip != null) {
            try {
                zip.flush();
                zip.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return true;
    }

    private void addFileToZip(String path, String srcFile, ZipOutputStream zip) {
        File folder = new File(srcFile);
        if (folder.isDirectory()) {
            this.addFolderToZip(path, srcFile, zip);
        } else {
            byte[] buf = new byte[1024];
            try {
                int len;
                FileInputStream in = new FileInputStream(srcFile);
                zip.putNextEntry(new ZipEntry(String.valueOf(path) + "/" + folder.getName()));
                while ((len = in.read(buf)) > 0) {
                    zip.write(buf, 0, len);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void addFolderToZip(String path, String srcFolder, ZipOutputStream zip) {
        File folder = new File(srcFolder);
        String[] stringArray = folder.list();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String fileName = stringArray[n2];
            this.addFileToZip(folder.getName(), String.valueOf(srcFolder) + "/" + fileName, zip);
            ++n2;
        }
    }

    private boolean checkDirectory(File file) {
        if (!file.exists()) {
            if (!file.mkdirs()) {
                return false;
            }
        } else {
            File[] destroy;
            File[] fileArray = destroy = file.listFiles();
            int n = destroy.length;
            int n2 = 0;
            while (n2 < n) {
                File des = fileArray[n2];
                if (!des.delete()) {
                    return false;
                }
                ++n2;
            }
        }
        return true;
    }

    private boolean removeTemp() {
        File file = new File(this.LogexportPath);
        this.checkDirectory(file);
        file.delete();
        return true;
    }
}

