/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.common;

import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public enum DAState {
    INIT,
    DONE,
    RUNNING,
    PREPARE_START,
    PREPARE_STOP,
    PREPARE_CANCEL;

    private static volatile DAState currentState;
    private static final Lock stateLock;
    private static final Condition doneCondition;
    private static final Condition preparedCondition;

    static {
        currentState = INIT;
        stateLock = new ReentrantLock();
        doneCondition = stateLock.newCondition();
        preparedCondition = stateLock.newCondition();
    }

    public static DAState getCurrentState() {
        return currentState;
    }

    public static boolean changeCurrentState(DAState state) {
        boolean ret = false;
        stateLock.lock();
        try {
            switch (state) {
                case INIT: 
                case DONE: {
                    currentState = state;
                    doneCondition.signalAll();
                    preparedCondition.signalAll();
                    ret = true;
                    break;
                }
                case RUNNING: {
                    if (currentState == PREPARE_START) {
                        currentState = state;
                        preparedCondition.signalAll();
                        ret = true;
                    }
                    break;
                }
                case PREPARE_START: {
                    if (DAState.isStartable()) {
                        currentState = state;
                        ret = true;
                    }
                    break;
                }
                case PREPARE_STOP: {
                    if (DAState.isRunning()) {
                        currentState = state;
                        ret = true;
                    }
                    break;
                }
                case PREPARE_CANCEL: {
                    if (currentState == PREPARE_START) {
                        currentState = state;
                        ret = true;
                    }
                    break;
                }
            }
        }
        finally {
            stateLock.unlock();
        }
        return ret;
    }

    public static void waitDone() throws InterruptedException {
        stateLock.lock();
        try {
            while (currentState != DONE) {
                doneCondition.await();
            }
        }
        finally {
            stateLock.unlock();
        }
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void waitPrepared() throws InterruptedException {
        stateLock.lock();
        try {
            block6: {
                block5: {
                    if (!true) break block5;
                    if (DAState.isRunning()) return;
                    if (DAState.isStartable()) break block6;
                }
                do {
                    preparedCondition.await();
                    if (DAState.isRunning()) return;
                } while (!DAState.isStartable());
            }
            return;
        }
        finally {
            stateLock.unlock();
        }
    }

    public static boolean isRunning() {
        return currentState == RUNNING;
    }

    public static boolean isStartable() {
        return currentState == INIT || currentState == DONE;
    }
}

