/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.control;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.tizen.dynamicanalyzer.util.Logger;

public abstract class DataThread<E>
implements Runnable {
    private Thread thread = null;
    private final Object threadLock = new Object();
    private BlockingQueue<E> dataQueue = new LinkedBlockingQueue();

    protected abstract String getThreadName();

    protected abstract boolean workAfterStart();

    protected abstract boolean workAfterStopNormal();

    protected abstract boolean workAfterStopForced();

    protected abstract void resetBeforeStart();

    protected abstract void clearAfterStop();

    protected final void clearQueue() {
        this.dataQueue.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean start() {
        Object object = this.threadLock;
        synchronized (object) {
            block6: {
                if (!this.isThreadAlive()) break block6;
                try {
                    this.thread.interrupt();
                    this.thread.join();
                    this.thread = null;
                }
                catch (InterruptedException e) {
                    Logger.exception((Throwable)e);
                    return false;
                }
            }
            this.clearQueue();
            this.resetBeforeStart();
            this.thread = new Thread(null, this, this.getThreadName());
            this.thread.start();
            return this.workAfterStart();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean stopNormal() {
        Object object = this.threadLock;
        synchronized (object) {
            block6: {
                if (!this.isThreadAlive()) break block6;
                try {
                    this.thread.join();
                    this.thread = null;
                    Logger.debug((Object)(String.valueOf(this.getThreadName()) + " thread joined!"));
                }
                catch (InterruptedException e) {
                    Logger.exception((Throwable)e);
                    return false;
                }
            }
            this.clearQueue();
            this.clearAfterStop();
            return this.workAfterStopNormal();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean stopForced() {
        Object object = this.threadLock;
        synchronized (object) {
            block6: {
                if (!this.isThreadAlive()) break block6;
                try {
                    this.thread.interrupt();
                    this.thread.join();
                    this.thread = null;
                    Logger.debug((Object)(String.valueOf(this.getThreadName()) + " thread joined!"));
                }
                catch (InterruptedException e) {
                    Logger.exception((Throwable)e);
                    return false;
                }
            }
            this.clearQueue();
            this.clearAfterStop();
            return this.workAfterStopForced();
        }
    }

    public boolean isThreadAlive() {
        return this.thread != null && this.thread.isAlive();
    }

    protected final boolean testThread(Thread currentThread) {
        return currentThread == this.thread && !currentThread.isInterrupted();
    }

    public final boolean pushData(E data) {
        return this.dataQueue.offer(data);
    }

    protected final E pollData() {
        E data = null;
        try {
            data = this.dataQueue.take();
        }
        catch (InterruptedException interruptedException) {
            Logger.debug((Object)(String.valueOf(this.getThreadName()) + " is interrupted while taking from queue"));
        }
        return data;
    }
}

