/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.handlers;

import java.util.Map;
import org.eclipse.swt.widgets.Display;
import org.tizen.dynamicanalyzer.common.AnalyzerManager;
import org.tizen.dynamicanalyzer.common.DAResult;
import org.tizen.dynamicanalyzer.common.Global;
import org.tizen.dynamicanalyzer.communicator.DACommunicator;
import org.tizen.dynamicanalyzer.communicator.DeviceInfo;
import org.tizen.dynamicanalyzer.control.ApplistManager;
import org.tizen.dynamicanalyzer.project.PackageInfo;
import org.tizen.dynamicanalyzer.project.Project;
import org.tizen.dynamicanalyzer.ui.page.BaseView;
import org.tizen.dynamicanalyzer.ui.page.UpdateViewTimer;
import org.tizen.dynamicanalyzer.ui.toolbar.Toolbar;
import org.tizen.dynamicanalyzer.util.Logger;
import org.tizen.dynamicanalyzer.util.WorkbenchUtil;

public class CommonAction {
    public static boolean configure() {
        boolean ret = false;
        DeviceInfo curDev = Global.getCurrentDeviceInfo();
        if (curDev != null) {
            DAResult result;
            try {
                result = DACommunicator.configure();
            }
            catch (InterruptedException interruptedException) {
                Logger.error((Object)"Interrupted during send configuration message");
                result = new DAResult(DAResult.ErrorCode.ERR_CONFIG_FAILED);
            }
            if (result.isSuccess()) {
                curDev.setConfigSuccess(true);
                ret = true;
            } else {
                curDev.setConfigSuccess(false);
            }
        }
        return ret;
    }

    public static boolean checkDeviceValidness() {
        DeviceInfo curDev = Global.getCurrentDeviceInfo();
        if (curDev == null) {
            Logger.debug((Object)"Current device is null");
            return false;
        }
        return true;
    }

    public static boolean checkApplicationValidness() {
        PackageInfo curPkg = Global.getCurrentApplication();
        if (curPkg == null) {
            Logger.debug((Object)"Current application is null");
            return false;
        }
        Map<String, PackageInfo> pkgInfos = DACommunicator.updateAppListFromTarget();
        if (pkgInfos == null) {
            Logger.debug((Object)"There is no application in selected device");
            return false;
        }
        boolean bFound = false;
        String pkgID = curPkg.getPackageId();
        PackageInfo fPkg = pkgInfos.get(pkgID);
        if (fPkg != null && !ApplistManager.isInBlackList(fPkg.getMainApp())) {
            bFound = true;
        }
        return bFound;
    }

    public static boolean checkConfiguration() {
        DeviceInfo curDev = Global.getCurrentDeviceInfo();
        if (curDev == null) {
            Logger.debug((Object)"Current device is null");
            return false;
        }
        if (!curDev.isConfigSuccess()) {
            return CommonAction.configure();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clear() {
        UpdateViewTimer.stop();
        Project project = Global.getProject();
        if (project != null) {
            Project project2 = project;
            synchronized (project2) {
                project.close();
                Global.setProject(null);
            }
        }
        if (Global.isGUIMode()) {
            CommonAction.resetGUIElements();
        }
        AnalyzerManager.clear();
    }

    private static void resetGUIElements() {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                ((BaseView)WorkbenchUtil.getViewPart((String)BaseView.ID)).clear();
                Toolbar.INSTANCE.clearTimer();
            }
        });
    }
}

