/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.setting;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.tizen.dynamicanalyzer.common.Global;
import org.tizen.dynamicanalyzer.common.path.PathManager;
import org.tizen.dynamicanalyzer.communicator.DeviceInfo;
import org.tizen.dynamicanalyzer.protocol.DebugLog;
import org.tizen.dynamicanalyzer.protocol.IProtocolConfig;
import org.tizen.dynamicanalyzer.protocol.Protocol;
import org.tizen.dynamicanalyzer.protocol.UnknownProtocolException;
import org.tizen.dynamicanalyzer.setting.Feature;
import org.tizen.dynamicanalyzer.setting.FeatureData;
import org.tizen.dynamicanalyzer.setting.FeatureValueData;
import org.tizen.dynamicanalyzer.setting.FlatFeature;
import org.tizen.dynamicanalyzer.setting.FlatPreferences;
import org.tizen.dynamicanalyzer.setting.SettingConstants;
import org.tizen.dynamicanalyzer.setting.TargetData;
import org.tizen.dynamicanalyzer.setting.Template;
import org.tizen.dynamicanalyzer.setting.TemplateData;
import org.tizen.dynamicanalyzer.util.CommonUtil;
import org.tizen.dynamicanalyzer.util.Logger;

public enum SettingDataManager {
    INSTANCE;

    private boolean parsingSuccess = true;
    private double version = 0.0;
    private int logLevel = 0;
    private List<Feature> defaultFeatureList = new ArrayList<Feature>();
    private List<Long> totalOverheadRange = new ArrayList<Long>();
    private String initTarget = null;
    private List<FeatureValueData> initOptionsSelectedFeatureList = new ArrayList<FeatureValueData>();
    private String selectedTarget = null;
    private List<FeatureValueData> optionsSelectedFeatureList = new ArrayList<FeatureValueData>();
    private List<FlatPreferences> optionsSelectedPreferenceList = new ArrayList<FlatPreferences>();
    private Map<String, TargetData> targetListMap = new LinkedHashMap<String, TargetData>();
    private boolean isPlatformDA = false;
    private boolean isNewSetting = false;

    private SettingDataManager() {
        if (SettingConstants.SettingFilePath == null) {
            SettingConstants.SettingFilePath = String.valueOf(PathManager.DA_CONFIG_FOLDER_PATH) + File.separator;
        }
        this.readFlatFeatureFile();
        this.readFeatureFile();
        this.readTemplateFile();
        this.readSettingFile();
    }

    public boolean isParsingSuccess() {
        return this.parsingSuccess;
    }

    private void readFlatFeatureFile() {
        block8: {
            File csv = new File(String.valueOf(SettingConstants.SettingFilePath) + "flatfeature");
            BufferedReader in = null;
            String content = null;
            try {
                in = new BufferedReader(new FileReader(csv));
                while ((content = in.readLine()) != null) {
                    String[] list = content.split("\\|", -1);
                    if (list == null) continue;
                    int index = Integer.parseInt(list[0]);
                    FlatFeature feature = FlatFeature.getFlatFeature(index);
                    if (feature == null) {
                        Logger.error((Object)("unknown feature : " + list[0] + ", " + list[1]));
                        continue;
                    }
                    feature.setOverheadRanking(list[9]);
                }
            }
            catch (FileNotFoundException e) {
                this.parsingSuccess = false;
                Logger.exception((Throwable)e);
                CommonUtil.tryClose((Object[])new Object[]{in});
                break block8;
            }
            catch (IOException e) {
                try {
                    Logger.exception((Throwable)e);
                }
                catch (Throwable throwable) {
                    CommonUtil.tryClose((Object[])new Object[]{in});
                    throw throwable;
                }
                CommonUtil.tryClose((Object[])new Object[]{in});
                break block8;
            }
            CommonUtil.tryClose((Object[])new Object[]{in});
        }
    }

    private void readFeatureFile() {
        block9: {
            File csv = new File(String.valueOf(SettingConstants.SettingFilePath) + "feature");
            BufferedReader in = null;
            String content = null;
            try {
                in = new BufferedReader(new FileReader(csv));
                while ((content = in.readLine()) != null) {
                    int parentIndex;
                    String[] list = content.split("\\|", -1);
                    if (list == null) continue;
                    int index = Integer.parseInt(list[0]);
                    Feature feature = Feature.getFeature(index);
                    if (feature == null) {
                        Logger.error((Object)("unknown feature : " + list[0] + ", " + list[1]));
                        continue;
                    }
                    FeatureData featureData = feature.getData();
                    featureData.setFeatureType(Integer.parseInt(list[2]));
                    if (list[3] != null && !list[3].isEmpty() && Feature.getFeature(parentIndex = Integer.parseInt(list[3])) != null) {
                        featureData.setParentIndex(parentIndex);
                    }
                    featureData.makePageList(list[4]);
                    featureData.makeChartList(list[5]);
                    featureData.setMinValue(list[6]);
                    featureData.setMaxValue(list[7]);
                    featureData.setDefaultValue(list[8]);
                    featureData.setOverheadRanking(list[9]);
                }
            }
            catch (FileNotFoundException e) {
                this.parsingSuccess = false;
                Logger.exception((Throwable)e);
                CommonUtil.tryClose((Object[])new Object[]{in});
                break block9;
            }
            catch (IOException e) {
                try {
                    Logger.exception((Throwable)e);
                }
                catch (Throwable throwable) {
                    CommonUtil.tryClose((Object[])new Object[]{in});
                    throw throwable;
                }
                CommonUtil.tryClose((Object[])new Object[]{in});
                break block9;
            }
            CommonUtil.tryClose((Object[])new Object[]{in});
        }
    }

    private void readTemplateFile() {
        block9: {
            File csv = new File(String.valueOf(SettingConstants.SettingFilePath) + "template");
            BufferedReader in = null;
            String content = null;
            try {
                in = new BufferedReader(new FileReader(csv));
                while ((content = in.readLine()) != null) {
                    String[] list = content.split("\\|", -1);
                    if (list == null) continue;
                    int index = Integer.parseInt(list[0]);
                    Template template = Template.getTemplate(index);
                    if (template == null) {
                        Logger.error((Object)("unknown template : " + list[0] + ", " + list[1]));
                        continue;
                    }
                    TemplateData templateDate = template.getData();
                    int i = 2;
                    while (i < list.length) {
                        templateDate.makeFeatureList(list[i]);
                        ++i;
                    }
                }
            }
            catch (FileNotFoundException e) {
                this.parsingSuccess = false;
                Logger.exception((Throwable)e);
                CommonUtil.tryClose((Object[])new Object[]{in});
                break block9;
            }
            catch (IOException e) {
                try {
                    Logger.exception((Throwable)e);
                }
                catch (Throwable throwable) {
                    CommonUtil.tryClose((Object[])new Object[]{in});
                    throw throwable;
                }
                CommonUtil.tryClose((Object[])new Object[]{in});
                break block9;
            }
            CommonUtil.tryClose((Object[])new Object[]{in});
        }
    }

    private void readSettingFile() {
        block29: {
            File csv = new File(String.valueOf(SettingConstants.SettingFilePath) + "setting");
            BufferedReader in = null;
            String content = null;
            try {
                in = new BufferedReader(new FileReader(csv));
                while ((content = in.readLine()) != null) {
                    String[] valueList;
                    int i;
                    String[] list = content.split("\\|");
                    if (list[0].equals("Version")) {
                        this.version = Double.parseDouble(list[1]);
                        continue;
                    }
                    if (list[0].equals("Log Level")) {
                        this.logLevel = Integer.parseInt(list[1]);
                        continue;
                    }
                    if (list[0].equals("Debug Print")) {
                        DebugLog.enableDebugPrint(list[1].equals("Y"));
                        continue;
                    }
                    if (list[0].equals("Available Target List")) {
                        i = 1;
                        while (i < list.length) {
                            if (this.targetListMap.get(list[i]) == null) {
                                this.targetListMap.put(list[i], new TargetData(list[i]));
                            }
                            ++i;
                        }
                        continue;
                    }
                    if (list[0].equals("Selected Target")) {
                        this.selectedTarget = list[1];
                        this.initTarget = new String(list[1]);
                        continue;
                    }
                    if (list[0].equals("Default Feature List")) {
                        i = 1;
                        while (i < list.length) {
                            this.defaultFeatureList.add(Feature.getFeature(Integer.parseInt(list[i])));
                            ++i;
                        }
                        continue;
                    }
                    if (list[0].equals("Total Overhead Range")) {
                        i = 1;
                        while (i < list.length) {
                            this.totalOverheadRange.add(Long.parseLong(list[i]));
                            ++i;
                        }
                        continue;
                    }
                    if (list[0].equals("Options Selected Feature List")) {
                        i = 1;
                        while (i < list.length) {
                            valueList = list[i].split(":");
                            FeatureValueData feature = new FeatureValueData(Feature.getFeature(Integer.parseInt(valueList[0])));
                            if (valueList.length > 1) {
                                feature.setValue(Integer.parseInt(valueList[1]));
                            }
                            this.optionsSelectedFeatureList.add(feature);
                            ++i;
                        }
                        this.copyFeatureList(this.optionsSelectedFeatureList, this.initOptionsSelectedFeatureList);
                        continue;
                    }
                    if (list[0].equals("Selected Preferences")) {
                        i = 1;
                        while (i < list.length) {
                            valueList = list[i].split(":");
                            FlatPreferences selected = FlatPreferences.getFlatPreferences(Integer.parseInt(valueList[0]));
                            if (selected != null) {
                                if (valueList.length > 1) {
                                    selected.setValue(Integer.parseInt(valueList[1]));
                                }
                                this.optionsSelectedPreferenceList.add(selected);
                            }
                            ++i;
                        }
                        continue;
                    }
                    if (list[0].equals("Platform Dynamic Analyzer")) {
                        i = 1;
                        while (i < list.length) {
                            valueList = list[i].split(":");
                            if (valueList.length > 0 && valueList[0].toLowerCase().equals("y")) {
                                this.isPlatformDA = true;
                            }
                            ++i;
                        }
                        continue;
                    }
                    if (this.targetListMap.get(list[0]) != null) {
                        this.getTarget(list[0]).makeDetailInformation(list);
                        continue;
                    }
                    Logger.warning((Object)("not available target : " + list[0]));
                }
            }
            catch (FileNotFoundException e) {
                this.parsingSuccess = false;
                Logger.exception((Throwable)e);
                CommonUtil.tryClose((Object[])new Object[]{in});
                break block29;
            }
            catch (IOException e) {
                try {
                    Logger.exception((Throwable)e);
                }
                catch (Throwable throwable) {
                    CommonUtil.tryClose((Object[])new Object[]{in});
                    throw throwable;
                }
                CommonUtil.tryClose((Object[])new Object[]{in});
                break block29;
            }
            CommonUtil.tryClose((Object[])new Object[]{in});
        }
    }

    private void writeSettingFile() {
        block7: {
            File csv = new File(String.valueOf(SettingConstants.SettingFilePath) + "setting");
            FileWriter fileWriter = null;
            BufferedWriter buffWriter = null;
            PrintWriter printWriter = null;
            try {
                try {
                    fileWriter = new FileWriter(csv);
                    buffWriter = new BufferedWriter(fileWriter);
                    printWriter = new PrintWriter(buffWriter);
                    printWriter.println("Version|" + this.version);
                    printWriter.println("Log Level|" + this.logLevel);
                    printWriter.println("Debug Print|" + (DebugLog.isEnabled() ? "Y" : "N"));
                    if (this.isPlatformDA) {
                        printWriter.println("Platform Dynamic Analyzer|Y");
                    }
                    printWriter.println(this.writeTargetData());
                    printWriter.println("Selected Target|" + this.selectedTarget);
                    printWriter.println(this.writeDefaultFeatureList("Default Feature List"));
                    printWriter.println(this.writeCollection(this.totalOverheadRange, "Total Overhead Range"));
                    printWriter.println("Options Selected Feature List|" + this.writeOptionsSelectedFeatureListData());
                    printWriter.println("Selected Preferences|" + this.writeOptionsSelectedPreferencesListData());
                    for (Map.Entry<String, TargetData> entry : this.targetListMap.entrySet()) {
                        TargetData target = entry.getValue();
                        target.writeSelectedData(printWriter);
                    }
                    printWriter.checkError();
                }
                catch (IOException e) {
                    Logger.exception((Throwable)e);
                    CommonUtil.tryClose((Object[])new Object[]{fileWriter, buffWriter, printWriter});
                    break block7;
                }
            }
            catch (Throwable throwable) {
                CommonUtil.tryClose((Object[])new Object[]{fileWriter, buffWriter, printWriter});
                throw throwable;
            }
            CommonUtil.tryClose((Object[])new Object[]{fileWriter, buffWriter, printWriter});
        }
    }

    private String writeTargetData() {
        Set<String> targetNameList = this.targetListMap.keySet();
        StringBuffer buffer = new StringBuffer();
        buffer.append("Available Target List");
        Iterator<String> iter = targetNameList.iterator();
        while (iter.hasNext()) {
            buffer.append("|" + iter.next());
        }
        return buffer.toString();
    }

    private String writeDefaultFeatureList(String key) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(String.valueOf(key) + "|");
        int i = 0;
        while (i < this.defaultFeatureList.size()) {
            if (i < this.defaultFeatureList.size() - 1) {
                buffer.append(String.valueOf(this.defaultFeatureList.get(i).getIndex()) + "|");
            } else {
                buffer.append(this.defaultFeatureList.get(i).getIndex());
            }
            ++i;
        }
        return buffer.toString();
    }

    private <T> String writeCollection(Collection<T> collection, String key) {
        StringBuffer subBuffer = new StringBuffer();
        for (T element : collection) {
            if (subBuffer.length() > 0) {
                subBuffer.append("|");
            }
            subBuffer.append(element.toString());
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append(key);
        buffer.append("|");
        buffer.append(subBuffer);
        return buffer.toString();
    }

    private String writeOptionsSelectedFeatureListData() {
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < this.optionsSelectedFeatureList.size()) {
            FeatureValueData feature = this.optionsSelectedFeatureList.get(i);
            buffer.append(feature.getKey().getIndex());
            if (feature.getValue() >= 0) {
                buffer.append(String.valueOf(":" + feature.getValue()));
            }
            if (i < this.optionsSelectedFeatureList.size() - 1) {
                buffer.append("|");
            }
            ++i;
        }
        return buffer.toString();
    }

    private String writeOptionsSelectedPreferencesListData() {
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < this.optionsSelectedPreferenceList.size()) {
            FlatPreferences feature = this.optionsSelectedPreferenceList.get(i);
            buffer.append(feature.getIndex());
            if (feature.getValue() >= 0) {
                buffer.append(String.valueOf(":" + feature.getValue()));
            }
            if (i < this.optionsSelectedPreferenceList.size() - 1) {
                buffer.append("|");
            }
            ++i;
        }
        return buffer.toString();
    }

    public int getSelectedOverheadLevel(String targetName) {
        int totalRange = 0;
        long calculateValue = 0L;
        TargetData target = this.getTarget(targetName);
        if (target != null) {
            int i = 0;
            while (i < this.optionsSelectedFeatureList.size()) {
                calculateValue += this.getFeatureOverheadValue(target, this.optionsSelectedFeatureList.get(i).getKey(), true);
                ++i;
            }
            List<FeatureValueData> featureList = target.getSelectedFeatureList();
            int i2 = 0;
            while (i2 < featureList.size()) {
                calculateValue += this.getFeatureOverheadValue(target, featureList.get(i2).getKey(), false);
                ++i2;
            }
        }
        int i = 0;
        while (i < this.totalOverheadRange.size()) {
            if (calculateValue <= this.totalOverheadRange.get(i)) {
                return i + 1;
            }
            if (i == this.totalOverheadRange.size() - 1 && this.totalOverheadRange.get(i) < calculateValue) {
                return this.totalOverheadRange.size() + 1;
            }
            ++i;
        }
        return totalRange;
    }

    private long getFeatureOverheadValue(TargetData target, Feature feature, boolean isOption) {
        long calculateValue = 0L;
        IProtocolConfig[] pconfigs = null;
        try {
            pconfigs = Protocol.getProtocolConfig(target.getProtocolVersion(), feature);
        }
        catch (UnknownProtocolException e) {
            Logger.warning((Object)e.getMessage());
        }
        if (pconfigs != null) {
            int i = 0;
            while (i < pconfigs.length) {
                long overhead = pconfigs[i].getOverhead();
                int callcount = pconfigs[i].getCallcount();
                if (callcount > 0) {
                    calculateValue += overhead * (long)callcount;
                } else if (pconfigs[i].getFeatureForFrequency() != null) {
                    Feature featureForFrequency = pconfigs[i].getFeatureForFrequency();
                    calculateValue = (long)((double)calculateValue + (double)overhead * this.calculateCallcount(target, featureForFrequency, isOption));
                }
                ++i;
            }
        }
        return calculateValue;
    }

    private double calculateCallcount(TargetData target, Feature featureForFrequency, boolean isOption) {
        int inputValue = 0;
        double count = 0.0;
        if (isOption) {
            inputValue = this.getOptionsFeatureValue(featureForFrequency);
        } else {
            inputValue = target.getSelectedFeatureValue(featureForFrequency);
            if (inputValue < 0) {
                inputValue = featureForFrequency.getData().getDefaultValue();
            }
        }
        if (featureForFrequency.equals(Feature.SYSTEM_SAMPLING_RATE) || featureForFrequency.equals(Feature.FUNCTION_SAMPLING_RATE)) {
            count = 1000.0 / (double)inputValue;
        } else if (featureForFrequency.equals(Feature.SCREENSHOT_PERIODICALLY)) {
            count = 1.0 / (double)inputValue;
        }
        return count * 30.0;
    }

    public Set<String> getOptionsSelectedFeatureChartSet() {
        HashSet<String> selectedChartSet = new HashSet<String>();
        int i = 0;
        while (i < this.optionsSelectedFeatureList.size()) {
            FeatureData feature = this.optionsSelectedFeatureList.get(i).getKey().getData();
            if (feature.getChartList().size() > 0) {
                selectedChartSet.addAll(feature.getChartList());
            }
            ++i;
        }
        return selectedChartSet;
    }

    public Set<String> getSelectedChartSet(String targetName) {
        TargetData target = this.getTarget(targetName);
        if (target != null) {
            HashSet<String> selectedChartSet = new HashSet<String>();
            List<FlatFeature> featureList = target.getSelectedFlatFeatureList();
            int i = 0;
            while (i < featureList.size()) {
                if (featureList.get(i).getChart() != null) {
                    selectedChartSet.add(featureList.get(i).getChart());
                }
                ++i;
            }
            return selectedChartSet;
        }
        Logger.warning((Object)("Does not exist targetName : " + targetName));
        return null;
    }

    public String getSelectedTarget() {
        return this.selectedTarget;
    }

    public void setSelectedTarget(String selectedTarget) {
        this.selectedTarget = selectedTarget;
    }

    public Map<String, TargetData> getTargetListMap() {
        return Collections.unmodifiableMap(this.targetListMap);
    }

    public TargetData getTarget(String targetName) {
        if (targetName == null) {
            return this.targetListMap.get(this.selectedTarget);
        }
        return this.targetListMap.get(targetName);
    }

    public TargetData getConnectedTarget() {
        TargetData tData;
        String profileName;
        DeviceInfo currentDevice = Global.getCurrentDeviceInfo();
        if (currentDevice != null && (profileName = currentDevice.getPlatformName()) != null && !profileName.isEmpty() && (tData = this.targetListMap.get(profileName)) != null) {
            return tData;
        }
        return this.targetListMap.get(this.selectedTarget);
    }

    public List<Feature> getDefaultFeatureList() {
        return Collections.unmodifiableList(this.defaultFeatureList);
    }

    public List<FeatureValueData> getOptionsSelectedFeatureList() {
        return Collections.unmodifiableList(this.optionsSelectedFeatureList);
    }

    public List<FlatPreferences> getOptionsSelectedPreferencesList() {
        return Collections.unmodifiableList(this.optionsSelectedPreferenceList);
    }

    public void addOptionsSelectedFeature(Feature feature, int featureValue) {
        FeatureValueData featureData = this.getFeatureValueData(this.optionsSelectedFeatureList, feature);
        if (featureData == null) {
            featureData = new FeatureValueData(feature);
            this.optionsSelectedFeatureList.add(featureData);
        }
        featureData.setValue(featureValue);
    }

    public void addOptionsSelectedPreference(FlatPreferences feature, int featureValue) {
        int index = this.getFlatPreferences(this.optionsSelectedPreferenceList, feature);
        if (index == -1) {
            FlatPreferences featureData = FlatPreferences.getFlatPreferences(feature.getIndex());
            featureData.setValue(featureValue);
            this.optionsSelectedPreferenceList.add(featureData);
        } else {
            this.optionsSelectedPreferenceList.get(index).setValue(featureValue);
        }
    }

    public void deleteOptionsSelectedFeature(Feature feature) {
        int i = 0;
        while (i < this.optionsSelectedFeatureList.size()) {
            if (this.optionsSelectedFeatureList.get(i).getKey().equals(feature)) {
                this.optionsSelectedFeatureList.remove(i);
                break;
            }
            ++i;
        }
    }

    public void deleteOptionsSelectedPreference(FlatPreferences feature) {
        int i = 0;
        while (i < this.optionsSelectedPreferenceList.size()) {
            if (this.optionsSelectedPreferenceList.get(i).equals(feature)) {
                this.optionsSelectedPreferenceList.remove(i);
                break;
            }
            ++i;
        }
    }

    public boolean isOptionsSelectedFeature(Feature feature) {
        FeatureValueData featureVal = this.getFeatureValueData(this.optionsSelectedFeatureList, feature);
        return featureVal != null;
    }

    public boolean isOptionsSelectedPrefereces(FlatPreferences feature) {
        int index = this.getFlatPreferences(this.optionsSelectedPreferenceList, feature);
        return index != -1;
    }

    public int getOptionsFeatureValue(Feature feature) {
        int value = 0;
        FeatureValueData featureVal = this.getFeatureValueData(this.optionsSelectedFeatureList, feature);
        value = featureVal != null ? featureVal.getValue() : feature.getData().getDefaultValue();
        return value;
    }

    public int getOptionsPreferencesValue(FlatPreferences feature) {
        int value = 0;
        int index = this.getFlatPreferences(this.optionsSelectedPreferenceList, feature);
        value = index != -1 ? this.optionsSelectedPreferenceList.get(index).getValue() : FlatPreferences.getFlatPreferences(feature.getIndex()).getDefaultValue();
        return value;
    }

    public int getOptionsFeaturInitValue(Feature feature) {
        int value = -1;
        int i = 0;
        while (i < this.initOptionsSelectedFeatureList.size()) {
            if (this.initOptionsSelectedFeatureList.get(i).getKey().equals(feature)) {
                value = this.initOptionsSelectedFeatureList.get(i).getValue();
                break;
            }
            ++i;
        }
        if (value == -1) {
            value = feature.getData().getDefaultValue();
        }
        return value;
    }

    private FeatureValueData getFeatureValueData(List<FeatureValueData> featureList, Feature feature) {
        if (featureList == null || feature == null) {
            return null;
        }
        int i = 0;
        while (i < featureList.size()) {
            if (featureList.get(i).getKey().equals(feature)) {
                return featureList.get(i);
            }
            ++i;
        }
        return null;
    }

    private int getFlatPreferences(List<FlatPreferences> featureList, FlatPreferences feature) {
        if (featureList == null || feature == null) {
            return -1;
        }
        int i = 0;
        while (i < featureList.size()) {
            if (featureList.get(i).getIndex() == feature.getIndex()) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public List<Long> getTotalOverheadRange() {
        return Collections.unmodifiableList(this.totalOverheadRange);
    }

    public int getTotalOverheadRangeCount() {
        return this.totalOverheadRange.size() + 1;
    }

    public Set<String> getSelectedPageList(String targetName) {
        HashSet<String> selectedPageList = new HashSet<String>();
        TargetData target = this.getTarget(targetName);
        if (target != null) {
            List<FlatFeature> featureList = target.getSelectedFlatFeatureList();
            int i = 0;
            while (i < featureList.size()) {
                if (featureList.get(i).getPage() != null) {
                    selectedPageList.add(featureList.get(i).getPage());
                }
                ++i;
            }
        } else {
            Logger.debug((Object)("Does not exist targetName : " + targetName));
        }
        return selectedPageList;
    }

    private void copyFeatureList(List<FeatureValueData> source, List<FeatureValueData> dest) {
        dest.clear();
        if (source.isEmpty()) {
            return;
        }
        int i = 0;
        while (i < source.size()) {
            dest.add(new FeatureValueData(source.get(i)));
            ++i;
        }
    }

    public boolean changedFeatures() {
        if (!this.initTarget.equals(this.selectedTarget)) {
            return true;
        }
        if (this.optionsSelectedFeatureList.size() != this.initOptionsSelectedFeatureList.size()) {
            return true;
        }
        int i = 0;
        while (i < this.optionsSelectedFeatureList.size()) {
            FeatureValueData selectedFeature = this.optionsSelectedFeatureList.get(i);
            FeatureValueData initFeature = this.getFeatureValueData(this.initOptionsSelectedFeatureList, selectedFeature.getKey());
            if (initFeature == null) {
                return true;
            }
            if (selectedFeature.getValue() != initFeature.getValue()) {
                return true;
            }
            ++i;
        }
        for (Map.Entry<String, TargetData> entry : this.targetListMap.entrySet()) {
            TargetData target = entry.getValue();
            if (!target.changedFeatures()) continue;
            return true;
        }
        return false;
    }

    public void applySettingData() {
        this.writeSettingFile();
        this.updateSettingData();
        this.setNewSetting(true);
    }

    private void updateSettingData() {
        this.initTarget = this.selectedTarget;
        for (Map.Entry<String, TargetData> entry : this.targetListMap.entrySet()) {
            TargetData target = entry.getValue();
            target.applySettingData();
        }
    }

    public void revertSettingData() {
        this.selectedTarget = this.initTarget;
        for (Map.Entry<String, TargetData> entry : this.targetListMap.entrySet()) {
            TargetData target = entry.getValue();
            target.revertSettingData();
        }
        this.setNewSetting(false);
    }

    public void writeAvailableChartList(String targetName, List<String> availableChartList) {
        TargetData target = this.getTarget(targetName);
        if (target != null) {
            target.setAvailableChartList(availableChartList);
        } else {
            Logger.debug((Object)("Does not exist targetName : " + targetName));
        }
        this.writeSettingFile();
    }

    public Set<Feature> getSelectedFeatureSet() {
        HashSet<Feature> selectedFeatures = new HashSet<Feature>();
        selectedFeatures.addAll(this.defaultFeatureList);
        TargetData target = this.getConnectedTarget();
        List<FeatureValueData> featureList = target.getSelectedFeatureList();
        int i = 0;
        while (i < featureList.size()) {
            selectedFeatures.add(featureList.get(i).getKey());
            ++i;
        }
        i = 0;
        while (i < this.optionsSelectedFeatureList.size()) {
            selectedFeatures.add(this.optionsSelectedFeatureList.get(i).getKey());
            ++i;
        }
        return selectedFeatures;
    }

    public Set<FlatPreferences> getSelectedPreferenceSet() {
        List<FlatFeature> featureList = this.getConnectedTarget().getSelectedFlatFeatureList();
        HashSet<FlatPreferences> selectedFeatures = new HashSet<FlatPreferences>();
        selectedFeatures.addAll(this.optionsSelectedPreferenceList);
        if (!this.isOptionsSelectedPrefereces(FlatPreferences.FUNCTION_PROFILING)) {
            selectedFeatures.add(FlatPreferences.FUNCTION_PROFILING);
        }
        if (!this.isOptionsSelectedPrefereces(FlatPreferences.APP_STARTUP)) {
            selectedFeatures.add(FlatPreferences.APP_STARTUP);
        }
        if (!this.isOptionsSelectedPrefereces(FlatPreferences.SYSTEM_ALL_PROCESSES)) {
            selectedFeatures.add(FlatPreferences.SYSTEM_ALL_PROCESSES);
        }
        if (!featureList.contains((Object)FlatFeature.PROCESS_MEMORY) && !this.isOptionsSelectedPrefereces(FlatPreferences.PROCESS_MEMORY)) {
            selectedFeatures.add(FlatPreferences.PROCESS_MEMORY);
        }
        return selectedFeatures;
    }

    public Set<FlatFeature> getSelectedFlatFeatureSet() {
        HashSet<FlatFeature> selectedFlatFeatures = new HashSet<FlatFeature>();
        TargetData target = this.getConnectedTarget();
        List<FlatFeature> featureList = target.getSelectedFlatFeatureList();
        int i = 0;
        while (i < featureList.size()) {
            selectedFlatFeatures.add(featureList.get(i));
            ++i;
        }
        Logger.debug(selectedFlatFeatures);
        return selectedFlatFeatures;
    }

    public boolean isPlatformDA() {
        return this.isPlatformDA;
    }

    public String getPlatform() {
        return null;
    }

    public boolean isNewSetting() {
        return this.isNewSetting;
    }

    public void setNewSetting(boolean isNewSetting) {
        this.isNewSetting = isNewSetting;
    }
}

