/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.setting;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.tizen.dynamicanalyzer.protocol.Protocol;
import org.tizen.dynamicanalyzer.setting.Feature;
import org.tizen.dynamicanalyzer.setting.FeatureValueData;
import org.tizen.dynamicanalyzer.setting.FlatFeature;
import org.tizen.dynamicanalyzer.setting.Template;
import org.tizen.dynamicanalyzer.util.Logger;

public class TargetData {
    private String targetName = null;
    private Protocol protocolVersion = Protocol.VERSION_UNKNOWN;
    private List<Template> availableTemplateList = new ArrayList<Template>();
    private List<Feature> availableFeatureList = new ArrayList<Feature>();
    private List<FlatFeature> availableFlatFeatureList = new ArrayList<FlatFeature>();
    private Template initTemplate = null;
    private List<FeatureValueData> initFeatureList = new ArrayList<FeatureValueData>();
    private List<FlatFeature> initFlatFeatureList = new ArrayList<FlatFeature>();
    private Template selectedTemplate = null;
    private List<FeatureValueData> selectedFeatureList = new ArrayList<FeatureValueData>();
    private List<FlatFeature> selectedFlatFeatureList = new ArrayList<FlatFeature>();
    private List<String> availableChartList = new ArrayList<String>();

    public TargetData(String targetName) {
        this.targetName = targetName;
    }

    public String getTargetName() {
        return this.targetName;
    }

    public Protocol getProtocolVersion() {
        return this.protocolVersion;
    }

    public void setAvailableChartList(List<String> availableChartList) {
        this.availableChartList.clear();
        this.availableChartList.addAll(availableChartList);
    }

    public Template getSelectedTemplate() {
        return this.selectedTemplate;
    }

    public void setSelectedTemplate(Template template) {
        if (this.initTemplate == null) {
            this.initTemplate = template;
        }
        this.selectedTemplate = template;
    }

    public List<Template> getAvailableTemplateList() {
        return Collections.unmodifiableList(this.availableTemplateList);
    }

    public List<Feature> getAvailableFeatureList() {
        return Collections.unmodifiableList(this.availableFeatureList);
    }

    public List<FlatFeature> getAvailableFlatFeatureList() {
        return Collections.unmodifiableList(this.availableFlatFeatureList);
    }

    public List<String> getAvailableChartList() {
        return Collections.unmodifiableList(this.availableChartList);
    }

    public void setSelectedFeatureList(List<FeatureValueData> selectedFeatureList) {
        this.selectedFeatureList.clear();
        this.selectedFeatureList.addAll(selectedFeatureList);
    }

    public void addSelectedFeature(String featureName) {
        FeatureValueData featureValue = new FeatureValueData(Feature.getFeature(featureName));
        this.selectedFeatureList.add(featureValue);
    }

    public void addSelectedFlatFeature(String featureName) {
        FlatFeature feature = FlatFeature.getFlatFeature(featureName);
        if (!this.selectedFlatFeatureList.contains((Object)feature)) {
            this.selectedFlatFeatureList.add(feature);
        }
    }

    public void removeSelectedFeature(String featureName) {
    }

    public void removeSelectedFlatFeature(String featureName) {
        FlatFeature feature = FlatFeature.getFlatFeature(featureName);
        if (this.selectedFlatFeatureList.contains((Object)feature)) {
            int i = 0;
            while (i < this.selectedFlatFeatureList.size()) {
                if (this.selectedFlatFeatureList.get(i).getName() == featureName) {
                    this.selectedFlatFeatureList.remove(i);
                    break;
                }
                ++i;
            }
        }
    }

    public void clearSelectedFeature() {
        this.selectedFeatureList.clear();
    }

    public List<FeatureValueData> getSelectedFeatureList() {
        return Collections.unmodifiableList(this.selectedFeatureList);
    }

    public List<FlatFeature> getSelectedFlatFeatureList() {
        return Collections.unmodifiableList(this.selectedFlatFeatureList);
    }

    public boolean isSelectedFeature(Feature feature) {
        FeatureValueData featureValue = this.getFeatureValueData(this.selectedFeatureList, feature);
        return featureValue != null;
    }

    public boolean isSelectedFlatFeature(String name) {
        int i = 0;
        while (i < this.selectedFlatFeatureList.size()) {
            if (this.selectedFlatFeatureList.get(i).getName() == name) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private FeatureValueData getFeatureValueData(List<FeatureValueData> featureList, Feature feature) {
        if (featureList == null || feature == null) {
            return null;
        }
        int i = 0;
        while (i < featureList.size()) {
            if (featureList.get(i).getKey().equals(feature)) {
                return featureList.get(i);
            }
            ++i;
        }
        return null;
    }

    public void changeSelectedFeatureList(Template template) {
        if (template.equals(this.selectedTemplate)) {
            this.selectedFeatureList.clear();
            this.selectedFeatureList.addAll(template.getData().getFeatureList());
        } else {
            Logger.debug((Object)"The template is not selected.");
        }
    }

    public int getSelectedFeatureValue(Feature feature) {
        FeatureValueData featureValue = this.getFeatureValueData(this.selectedFeatureList, feature);
        if (featureValue == null) {
            return -1;
        }
        return featureValue.getValue();
    }

    public void makeDetailInformation(String[] list) {
        if (list[1].equals("Protocol Version")) {
            this.protocolVersion = Protocol.getVersion(list[2]);
        } else if (list[1].equals("Available Template List")) {
            this.makeAvailableTemplateList(list);
        } else if (list[1].equals("Selected Template")) {
            if (list[2] != null && !list[2].isEmpty()) {
                this.setSelectedTemplate(Template.getTemplate(Integer.parseInt(list[2])));
            }
        } else if (list[1].equals("Available Feature List")) {
            this.makeAvailableFeatureList(list);
        } else if (list[1].equals("Available FlatFeature List")) {
            this.makeAvailableFlatFeatureList(list);
        } else if (list[1].equals("Selected Feature List")) {
            this.makeSelectedFeatureList(list);
        } else if (list[1].equals("Selected FlatFeature List")) {
            this.makeSelectedFlatFeatureList(list);
        } else if (list[1].equals("Available Chart List")) {
            this.makeAvailableChartList(list);
        }
    }

    private void makeAvailableTemplateList(String[] list) {
        if (list != null) {
            int i = 2;
            while (i < list.length) {
                this.availableTemplateList.add(Template.getTemplate(Integer.parseInt(list[i])));
                ++i;
            }
        }
    }

    private void makeAvailableFeatureList(String[] list) {
        if (list != null) {
            int i = 2;
            while (i < list.length) {
                this.availableFeatureList.add(Feature.getFeature(Integer.parseInt(list[i])));
                ++i;
            }
        }
    }

    private void makeAvailableFlatFeatureList(String[] list) {
        if (list != null) {
            int i = 2;
            while (i < list.length) {
                this.availableFlatFeatureList.add(FlatFeature.getFlatFeature(Integer.parseInt(list[i])));
                ++i;
            }
        }
    }

    private void makeSelectedFeatureList(String[] list) {
        int i = 2;
        while (i < list.length) {
            String[] valueList = list[i].split(":");
            FeatureValueData feature = new FeatureValueData(Feature.getFeature(Integer.parseInt(valueList[0])));
            if (valueList.length > 1) {
                feature.setValue(Integer.parseInt(valueList[1]));
            }
            this.selectedFeatureList.add(feature);
            ++i;
        }
        this.copyFeatureList(this.selectedFeatureList, this.initFeatureList);
    }

    private void makeSelectedFlatFeatureList(String[] list) {
        int i = 2;
        while (i < list.length) {
            String[] valueList = list[i].split(":");
            FlatFeature feature = FlatFeature.getFlatFeature(Integer.parseInt(valueList[0]));
            this.selectedFlatFeatureList.add(feature);
            ++i;
        }
        this.copyFlatFeatureList(this.selectedFlatFeatureList, this.initFlatFeatureList);
    }

    private void makeAvailableChartList(String[] list) {
        if (list != null) {
            int i = 2;
            while (i < list.length) {
                this.availableChartList.add(list[i]);
                ++i;
            }
        }
    }

    public void writeSelectedData(PrintWriter writer) throws IOException {
        writer.println(String.valueOf(this.targetName) + "|" + "Protocol Version" + "|" + (Object)((Object)this.protocolVersion));
        writer.println(String.valueOf(this.targetName) + "|" + "Available Template List" + "|" + this.writeAvailableTemplateListData());
        writer.println(String.valueOf(this.targetName) + "|" + "Selected Template" + "|" + this.selectedTemplate.getIndex());
        writer.println(String.valueOf(this.targetName) + "|" + "Available Feature List" + "|" + this.writeAvailableFeatureListData());
        writer.println(String.valueOf(this.targetName) + "|" + "Available FlatFeature List" + "|" + this.writeAvailableFlatFeatureListData());
        writer.println(String.valueOf(this.targetName) + "|" + "Selected Feature List" + "|" + this.writeSelectedFeatureListData());
        writer.println(String.valueOf(this.targetName) + "|" + "Selected FlatFeature List" + "|" + this.writeSelectedFlatFeatureListData());
        writer.println(String.valueOf(this.targetName) + "|" + "Available Chart List" + "|" + this.writeAvailableChartListData());
        writer.checkError();
    }

    private String writeSelectedFeatureListData() {
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < this.selectedFeatureList.size()) {
            FeatureValueData feature = this.selectedFeatureList.get(i);
            buffer.append(feature.getKey().getIndex());
            if (feature.getValue() > 0) {
                buffer.append(String.valueOf(":" + feature.getValue()));
            }
            if (i < this.selectedFeatureList.size() - 1) {
                buffer.append("|");
            }
            ++i;
        }
        return buffer.toString();
    }

    private String writeSelectedFlatFeatureListData() {
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < this.selectedFlatFeatureList.size()) {
            FlatFeature feature = this.selectedFlatFeatureList.get(i);
            buffer.append(feature.getIndex());
            if (i < this.selectedFlatFeatureList.size() - 1) {
                buffer.append("|");
            }
            ++i;
        }
        return buffer.toString();
    }

    private String writeAvailableChartListData() {
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < this.availableChartList.size()) {
            if (i < this.availableChartList.size() - 1) {
                buffer.append(String.valueOf(this.availableChartList.get(i)) + "|");
            } else {
                buffer.append(this.availableChartList.get(i));
            }
            ++i;
        }
        return buffer.toString();
    }

    private String writeAvailableTemplateListData() {
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < this.availableTemplateList.size()) {
            if (i < this.availableTemplateList.size() - 1) {
                buffer.append(String.valueOf(this.availableTemplateList.get(i).getIndex()) + "|");
            } else {
                buffer.append(this.availableTemplateList.get(i).getIndex());
            }
            ++i;
        }
        return buffer.toString();
    }

    private String writeAvailableFeatureListData() {
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < this.availableFeatureList.size()) {
            if (i < this.availableFeatureList.size() - 1) {
                buffer.append(String.valueOf(this.availableFeatureList.get(i).getIndex()) + "|");
            } else {
                buffer.append(this.availableFeatureList.get(i).getIndex());
            }
            ++i;
        }
        return buffer.toString();
    }

    private String writeAvailableFlatFeatureListData() {
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < this.availableFlatFeatureList.size()) {
            if (i < this.availableFlatFeatureList.size() - 1) {
                buffer.append(String.valueOf(this.availableFlatFeatureList.get(i).getIndex()) + "|");
            } else {
                buffer.append(this.availableFlatFeatureList.get(i).getIndex());
            }
            ++i;
        }
        return buffer.toString();
    }

    public boolean changedFeatures() {
        if (!this.initTemplate.equals(this.selectedTemplate)) {
            return true;
        }
        if (this.selectedFeatureList.size() != this.initFeatureList.size()) {
            return true;
        }
        int i = 0;
        while (i < this.selectedFeatureList.size()) {
            FeatureValueData selectedFeature = this.selectedFeatureList.get(i);
            FeatureValueData initFeature = this.getFeatureValueData(this.initFeatureList, selectedFeature.getKey());
            if (initFeature == null) {
                return true;
            }
            if (selectedFeature.getValue() != initFeature.getValue()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void applySettingData() {
        this.copyFlatFeatureList(this.selectedFlatFeatureList, this.initFlatFeatureList);
    }

    public void revertSettingData() {
        this.copyFlatFeatureList(this.initFlatFeatureList, this.selectedFlatFeatureList);
    }

    private void copyFeatureList(List<FeatureValueData> source, List<FeatureValueData> dest) {
        dest.clear();
        if (source.isEmpty()) {
            return;
        }
        int i = 0;
        while (i < source.size()) {
            dest.add(new FeatureValueData(source.get(i)));
            ++i;
        }
    }

    private void copyFlatFeatureList(List<FlatFeature> source, List<FlatFeature> dest) {
        dest.clear();
        if (source.isEmpty()) {
            return;
        }
        int i = 0;
        while (i < source.size()) {
            dest.add(source.get(i));
            ++i;
        }
    }

    public void setSelectedFlatFeatures(Set<FlatFeature> set) {
        this.selectedFlatFeatureList.clear();
        this.selectedFlatFeatureList.addAll(set);
    }
}

