/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.swap.logparser;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.tizen.dynamicanalyzer.common.Global;
import org.tizen.dynamicanalyzer.common.SymbolManager;
import org.tizen.dynamicanalyzer.communicator.DeviceInfo;
import org.tizen.dynamicanalyzer.communicator.UnsupportedProtocolException;
import org.tizen.dynamicanalyzer.control.DataThread;
import org.tizen.dynamicanalyzer.nl.InformationViewLabels;
import org.tizen.dynamicanalyzer.swap.logparser.DataManagerRegistry;
import org.tizen.dynamicanalyzer.swap.logparser.ImageProcessingThread;
import org.tizen.dynamicanalyzer.swap.logparser.LogPackage;
import org.tizen.dynamicanalyzer.swap.model.data.FileSyscallData;
import org.tizen.dynamicanalyzer.swap.model.data.LogData;
import org.tizen.dynamicanalyzer.swap.model.data.ProfileData;
import org.tizen.dynamicanalyzer.swap.model.data.ScreenShotData;
import org.tizen.dynamicanalyzer.swap.model.data.WebProfileData;
import org.tizen.dynamicanalyzer.ui.info.callstack.CallStackInserter;
import org.tizen.dynamicanalyzer.ui.info.screenshot.SocketClient;
import org.tizen.dynamicanalyzer.ui.summary.profiling.FunctionUsageProfiler;
import org.tizen.dynamicanalyzer.ui.summary.profiling.WebProfileDataMaker;
import org.tizen.dynamicanalyzer.util.Logger;

public class LogParser
extends DataThread<List<LogData>> {
    private static LogParser instance = new LogParser();
    public static List<LogData> END_OF_QUEUE = new ArrayList<LogData>();
    private Map<Integer, Deque<Long>> functionEntryStackByTidMap = new HashMap<Integer, Deque<Long>>();
    private Map<Integer, Deque<webFunctionEntryInfo>> webFunctionEntryStackByTidMap = new HashMap<Integer, Deque<webFunctionEntryInfo>>();
    private Map<Integer, Deque<Long>> fileFunctionEntryStackByTidMap = new HashMap<Integer, Deque<Long>>();
    private List<Thread> imageThreads = new ArrayList<Thread>();

    public static LogParser getInstance() {
        return instance;
    }

    @Override
    protected String getThreadName() {
        return "Log parsing thread";
    }

    @Override
    protected boolean workAfterStart() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected boolean workAfterStopNormal() {
        List<Thread> list = this.imageThreads;
        synchronized (list) {
            while (!this.imageThreads.isEmpty()) {
                try {
                    this.imageThreads.wait();
                }
                catch (InterruptedException e) {
                    Logger.exception((Throwable)e);
                    return false;
                }
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected boolean workAfterStopForced() {
        List<Thread> list = this.imageThreads;
        synchronized (list) {
            for (Thread entry : this.imageThreads) {
                entry.interrupt();
            }
            while (!this.imageThreads.isEmpty()) {
                try {
                    this.imageThreads.wait();
                }
                catch (InterruptedException e) {
                    Logger.exception((Throwable)e);
                    return false;
                }
            }
            return true;
        }
    }

    @Override
    protected void resetBeforeStart() {
        this.functionEntryStackByTidMap.clear();
        this.webFunctionEntryStackByTidMap.clear();
        this.fileFunctionEntryStackByTidMap.clear();
        this.imageThreads.clear();
    }

    @Override
    protected void clearAfterStop() {
        this.functionEntryStackByTidMap.clear();
        this.webFunctionEntryStackByTidMap.clear();
        this.fileFunctionEntryStackByTidMap.clear();
    }

    private Deque<Long> getFunctionEntryStack(int tid) {
        Deque<Long> functionEntryStack = this.functionEntryStackByTidMap.get(tid);
        if (functionEntryStack == null) {
            functionEntryStack = new ArrayDeque<Long>();
            this.functionEntryStackByTidMap.put(tid, functionEntryStack);
        }
        return functionEntryStack;
    }

    private Deque<webFunctionEntryInfo> getWebFunctionEntryStack(int tid) {
        Deque<webFunctionEntryInfo> webFunctionEntryStack = this.webFunctionEntryStackByTidMap.get(tid);
        if (webFunctionEntryStack == null) {
            webFunctionEntryStack = new ArrayDeque<webFunctionEntryInfo>();
            this.webFunctionEntryStackByTidMap.put(tid, webFunctionEntryStack);
        }
        return webFunctionEntryStack;
    }

    private Deque<Long> getFileFunctionEntryStack(int tid) {
        Deque<Long> fileFunctionEntryStack = this.fileFunctionEntryStackByTidMap.get(tid);
        if (fileFunctionEntryStack == null) {
            fileFunctionEntryStack = new ArrayDeque<Long>();
            this.fileFunctionEntryStackByTidMap.put(tid, fileFunctionEntryStack);
        }
        return fileFunctionEntryStack;
    }

    @Override
    public void run() {
        Thread curThread = Thread.currentThread();
        try {
            while (this.testThread(curThread)) {
                List loglist = (List)this.pollData();
                if (loglist == null) break;
                if (loglist == END_OF_QUEUE) {
                    break;
                }
                this.logParsing(loglist);
            }
        }
        finally {
            DataManagerRegistry.updateLog(LogPackage.END_OF_QUEUE);
            CallStackInserter.getInstance().pushData(CallStackInserter.END_OF_QUEUE);
        }
        Logger.debug((Object)"log parsing thread end!!");
    }

    private void logParsing(List<LogData> loglist) {
        int size = loglist.size();
        LogPackage logPack = new LogPackage();
        int i = 0;
        while (i < size) {
            LogData log = loglist.get(i);
            if (log != null) {
                int id = log.getMsgID();
                switch (id) {
                    case 8: 
                    case 9: {
                        boolean ret = this.processFunctionData((ProfileData)log);
                        if (!ret) break;
                        this.packLog(log, logPack);
                        break;
                    }
                    case 10: 
                    case 11: {
                        break;
                    }
                    case 21: 
                    case 22: {
                        boolean ret = this.processWebFunctionData((WebProfileData)log);
                        if (!ret) break;
                        this.packLog(log, logPack);
                        break;
                    }
                    case 12: 
                    case 13: {
                        boolean ret = this.processFileFunctionData((FileSyscallData)log);
                        if (!ret) break;
                        this.packLog(log, logPack);
                        break;
                    }
                    case 4: 
                    case 5: 
                    case 7: 
                    case 14: 
                    case 16: 
                    case 17: 
                    case 25: 
                    case 26: 
                    case 32: 
                    case 33: 
                    case 257: {
                        this.packLog(log, logPack);
                        break;
                    }
                    case 262: {
                        this.processScreenshotData((ScreenShotData)log);
                        this.packLog(log, logPack);
                        break;
                    }
                    default: {
                        this.packLog(log, logPack);
                        Global.getRuntimeCallstackManager().makeCallstackWithoutBacktrace(log);
                    }
                }
            }
            ++i;
        }
        this.updateLog(logPack);
    }

    private boolean processFunctionData(ProfileData pData) {
        int msgID = pData.getMsgID();
        Deque<Long> functionStack = this.getFunctionEntryStack(pData.getTid());
        if (msgID == 8) {
            functionStack.addLast(pData.getSeq());
        } else if (!functionStack.isEmpty()) {
            pData.setEntrySeq(functionStack.removeLast());
        } else {
            Logger.error((Object)"function exit log without entry log");
        }
        boolean bMakeCallstack = true;
        try {
            bMakeCallstack = pData.getProbeType() == 4 ? false : pData.getProbeType() != 3;
        }
        catch (UnsupportedProtocolException unsupportedProtocolException) {
            bMakeCallstack = true;
        }
        if (bMakeCallstack) {
            int apiID = SymbolManager.getFuncId(pData, pData.getPcAddr(), pData.getPid(), pData.getTime());
            if (apiID < 0) {
                return false;
            }
            String apiName = Global.getFunctionName(apiID);
            if (apiName.equals(InformationViewLabels.CALLSTACK_TABLE_UNKNOWN_FUNCTION)) {
                return false;
            }
            pData.setApiId(apiID);
            Global.getRuntimeCallstackManager().makeUserCallstack(pData, FunctionUsageProfiler.getInstance().getProfileDataMakerByPid(pData.getPid()));
        }
        return true;
    }

    private boolean processWebFunctionData(WebProfileData pData) {
        int msgID = pData.getMsgID();
        Deque<webFunctionEntryInfo> functionStack = this.getWebFunctionEntryStack(pData.getTID());
        webFunctionEntryInfo info = null;
        if (msgID == 21) {
            info = new webFunctionEntryInfo();
            info.seq = pData.getSeq();
            if (pData.getFunctionURL() == null || pData.getFunctionURL().isEmpty() || pData.getFunctionLineNumber() <= 0) {
                info.userFunction = false;
            }
            functionStack.addLast(info);
        } else if (!functionStack.isEmpty()) {
            info = functionStack.removeLast();
            if (info.userFunction) {
                pData.setEntrySeq(info.seq);
            }
        } else {
            Logger.error((Object)"web function exit log without entry log");
            return false;
        }
        if (info.userFunction) {
            WebProfileDataMaker profiler = FunctionUsageProfiler.getInstance().getWebProfileDataMakerByPid(pData.getPID());
            profiler.makeWebFunctionUsageProfileData(pData);
        }
        return info.userFunction;
    }

    private boolean processFileFunctionData(FileSyscallData pData) {
        boolean ret = true;
        int msgID = pData.getMsgID();
        Deque<Long> fileFunctionStack = this.getFileFunctionEntryStack(pData.getTid());
        if (msgID == 12) {
            fileFunctionStack.addLast(pData.getSeq());
        } else if (!fileFunctionStack.isEmpty()) {
            pData.setEntrySeq(fileFunctionStack.removeLast());
        } else {
            ret = false;
            Logger.warning((Object)"file function exit log without entry log");
        }
        return ret;
    }

    private void processScreenshotData(ScreenShotData log) {
        DeviceInfo curDev = Global.getCurrentDeviceInfo();
        if (curDev.isEmulator() && SocketClient.getInstance().isConnected()) {
            curDev.emulatorScreenshot.send();
            String remoteImgPath = curDev.emulatorScreenshot.getFilePath();
            this.processImagefromECS(remoteImgPath, log.getOrientation());
        } else {
            this.processImage(log.getImageFilePath(), log.getOrientation());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processImage(String from, int angle) {
        if (angle != 0) {
            Logger.debug((Object)("[ image rotate : " + angle + " ]"));
        }
        Thread thread = new Thread(null, new ImageProcessingThread(this, from, angle, false), "Internal Image Process Thread");
        List<Thread> list = this.imageThreads;
        synchronized (list) {
            this.imageThreads.add(thread);
        }
        thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processImagefromECS(String path, int angle) {
        if (angle != 0) {
            Logger.debug((Object)("[ image rotate : " + angle + " ]"));
        }
        Thread thread = new Thread(null, new ImageProcessingThread(this, path, angle, true), "Internal Image Process Thread");
        List<Thread> list = this.imageThreads;
        synchronized (list) {
            this.imageThreads.add(thread);
        }
        thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setImageThreadFinished(Thread finishedThread) {
        List<Thread> list = this.imageThreads;
        synchronized (list) {
            this.imageThreads.remove(finishedThread);
            this.imageThreads.notifyAll();
        }
    }

    private void updateLog(LogPackage logPack) {
        if (logPack != null && !logPack.isEmpty()) {
            DataManagerRegistry.updateLog(logPack);
        }
    }

    private void packLog(LogData logData, LogPackage logPack) {
        int msgID = logData.getMsgID();
        switch (msgID) {
            case 8: 
            case 9: {
                ProfileData fData = (ProfileData)logData;
                try {
                    if (fData.getProbeType() == 4) {
                        logPack.setLogs(2304, logData);
                        break;
                    }
                    logPack.setLogs(logData.getMsgID(), logData);
                }
                catch (UnsupportedProtocolException unsupportedProtocolException) {
                    logPack.setLogs(logData.getMsgID(), logData);
                }
                break;
            }
            case 12: 
            case 13: {
                logPack.setLogs(2304, logData);
                break;
            }
            default: {
                logPack.setLogs(logData.getMsgID(), logData);
            }
        }
    }

    private class webFunctionEntryInfo {
        long seq = -1L;
        boolean userFunction = true;

        private webFunctionEntryInfo() {
        }
    }
}

