/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.common;

import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.widgets.Display;
import org.tizen.dynamicanalyzer.common.AnalyzerManager;
import org.tizen.dynamicanalyzer.ui.toolbar.Toolbar;
import org.tizen.dynamicanalyzer.widgets.chartBoard.DAChartBoard;
import org.tizen.dynamicanalyzer.widgets.chartBoard.DAChartBoardManager;
import org.tizen.dynamicanalyzer.widgets.da.view.DAPageComposite;
import org.tizen.dynamicanalyzer.widgets.scale.DAScale;

public class TimeLineChartKeyListener
extends KeyAdapter
implements KeyListener {
    private DAChartBoard chartboard;
    private DAChartBoardManager boardMannager;
    private DAScale scale;

    public TimeLineChartKeyListener(DAChartBoard chartboard) {
        this.chartboard = chartboard;
        this.boardMannager = chartboard.getBoardManager();
        this.scale = chartboard.getScale();
    }

    public void keyPressed(KeyEvent e) {
        int zoom_val = this.scale.getSelection();
        double chartDiv = 3.0;
        double changeScroll = 120.0 / Math.pow(2.0, zoom_val);
        double visibleStart = this.boardMannager.getVisibleStartTime();
        switch (e.keyCode) {
            case 119: {
                this.scale.changeScale(true);
                zoom_val = this.scale.getSelection();
                Toolbar.INSTANCE.setScaleSelection(zoom_val);
                break;
            }
            case 115: {
                this.scale.changeScale(false);
                zoom_val = this.scale.getSelection();
                Toolbar.INSTANCE.setScaleSelection(zoom_val);
                break;
            }
            case 97: {
                this.boardMannager.startTimeChanged(visibleStart - changeScroll / chartDiv);
                break;
            }
            case 100: {
                this.boardMannager.startTimeChanged(visibleStart + changeScroll / chartDiv);
                break;
            }
            case 113: {
                this.boardMannager.startTimeChanged(this.boardMannager.getTotalStartTime());
                break;
            }
            case 101: {
                this.boardMannager.startTimeChanged(this.boardMannager.getTotalEndTime());
                break;
            }
        }
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                DAPageComposite page = AnalyzerManager.getCurrentPage();
                page.updateView();
            }
        });
    }

    public void keyReleased(KeyEvent e) {
    }
}

