/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.file;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.nebula.widgets.grid.Grid;
import org.eclipse.nebula.widgets.grid.GridColumn;
import org.eclipse.nebula.widgets.grid.GridItem;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.tizen.dynamicanalyzer.common.AnalyzerManager;
import org.tizen.dynamicanalyzer.common.DASelectionData;
import org.tizen.dynamicanalyzer.common.Global;
import org.tizen.dynamicanalyzer.database.SqlConnectionManager;
import org.tizen.dynamicanalyzer.error.ErrorCodeManager;
import org.tizen.dynamicanalyzer.model.FilterProperty;
import org.tizen.dynamicanalyzer.model.TableInput;
import org.tizen.dynamicanalyzer.swap.model.data.FileData;
import org.tizen.dynamicanalyzer.ui.file.FileApiListView;
import org.tizen.dynamicanalyzer.ui.file.FileChartView;
import org.tizen.dynamicanalyzer.ui.file.FilePage;
import org.tizen.dynamicanalyzer.ui.file.data.FileAccessorDB;
import org.tizen.dynamicanalyzer.ui.file.data.FileApiDB;
import org.tizen.dynamicanalyzer.ui.file.manager.FileDataManager;
import org.tizen.dynamicanalyzer.ui.file.model.FileAccessor;
import org.tizen.dynamicanalyzer.ui.file.model.FileEvent;
import org.tizen.dynamicanalyzer.ui.file.model.FileSelectedData;
import org.tizen.dynamicanalyzer.ui.widgets.table.DAApiListTableComposite;
import org.tizen.dynamicanalyzer.ui.widgets.table.DATableDataFormat;
import org.tizen.dynamicanalyzer.util.Logger;
import org.tizen.dynamicanalyzer.utils.AnalyzerUtil;
import org.tizen.dynamicanalyzer.utils.Formatter;
import org.tizen.dynamicanalyzer.widgets.da.view.DAViewData;

public class FileApiListTable
extends DAApiListTableComposite {
    private FileDataManager fileDataManager = FileDataManager.getInstance();

    public FileApiListTable(Composite parent, int compStyle, int tableStyle) {
        super(parent, compStyle, tableStyle);
        this.table.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                GridItem[] items = FileApiListTable.this.table.getSelection();
                if (items == null) {
                    return;
                }
                long startTime = 0L;
                long endTime = 0L;
                int i = 0;
                while (i < items.length) {
                    DATableDataFormat dataFormat = (DATableDataFormat)items[i].getData();
                    long itemTime = dataFormat.getLogData().getTime();
                    if (0L == startTime) {
                        startTime = itemTime;
                    }
                    if (startTime > itemTime) {
                        startTime = itemTime;
                    }
                    if (endTime < itemTime) {
                        endTime = itemTime;
                    }
                    ++i;
                }
                DASelectionData selData = new DASelectionData(FilePage.apilistViewID, startTime, endTime, items, (Control)FileApiListTable.this.table);
                AnalyzerManager.getCurrentPage().updateView((DAViewData)selData);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.table.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseDoubleClick(MouseEvent e) {
                GridItem[] ti = ((Grid)e.widget).getSelection();
                if (ti == null || ti.length == 0) {
                    return;
                }
                List<Object> markerData = ((DATableDataFormat)ti[0].getData()).getData();
                long markerTime = Long.parseLong((String)markerData.get(1));
                AnalyzerUtil.addMarker(markerTime);
            }
        });
    }

    @Override
    protected List<TableInput> makeTableInput() {
        List<FilterProperty> filterList;
        ArrayList<TableInput> input;
        ArrayList<Integer> removeTableIndex;
        block19: {
            FileApiListView view = (FileApiListView)AnalyzerManager.getCurrentPage().getView(FilePage.apilistViewID);
            if (view == null) {
                return null;
            }
            long rangeStartTime = view.getRangeStartTime();
            long rangeEndTime = view.getRangeEndTime();
            HashMap<String, Integer> findStartAPITableIndexHashMap = new HashMap<String, Integer>();
            HashMap<Integer, Long> findStartTimeHashMap = new HashMap<Integer, Long>();
            removeTableIndex = new ArrayList<Integer>();
            input = new ArrayList<TableInput>();
            filterList = this.getFilterPropertyList();
            FileSelectedData selectedData = this.fileDataManager.getSelectedData();
            if (selectedData == null) {
                return null;
            }
            ResultSet rs = null;
            if (!filterList.isEmpty()) {
                List<String> whereClause = this.convertFilterProperty2Query(filterList);
                rs = this.fileDataManager.getApiDB().selectAPI(selectedData.getFileId(), selectedData.getAccessorId(), selectedData.isParentChart(), whereClause);
            } else {
                rs = this.fileDataManager.getApiDB().selectAPI(selectedData.getFileId(), selectedData.getAccessorId(), selectedData.isParentChart(), null);
            }
            FileAccessor accessor = selectedData.getFileAccessor();
            boolean isParentChart = selectedData.isParentChart();
            String filePath = null;
            int pid = -1;
            int tid = -1;
            if (rs != null) {
                try {
                    try {
                        int i = -1;
                        int indexToRemove = 0;
                        int index = 0;
                        while (rs.next()) {
                            String keString;
                            ++i;
                            ++index;
                            ArrayList<String> contentText = new ArrayList<String>();
                            ArrayList<String> contentData = new ArrayList<String>();
                            Integer startLogIndex = 0;
                            long seq = rs.getLong(1);
                            long fd = rs.getLong(2);
                            int fdApiType = rs.getInt(3);
                            long time = rs.getLong(4);
                            int apiId = rs.getInt(5);
                            long errno = rs.getLong(6);
                            long fileSize = rs.getLong(7);
                            long ioSize = rs.getLong(8);
                            String returns = rs.getString(9);
                            String args = rs.getString(10);
                            if (isParentChart) {
                                filePath = rs.getString(11);
                                pid = rs.getInt(12);
                                tid = rs.getInt(13);
                            } else {
                                filePath = accessor.getFilePath();
                                pid = accessor.getPid();
                                tid = accessor.getTid();
                            }
                            FileEvent fileEvent = new FileEvent(seq, filePath, pid, tid, fd, fdApiType, apiId, time, fileSize, ioSize, args, returns, errno);
                            String apiName = Global.getFunctionName(apiId);
                            String errMsg = this.getErrorMessage(errno);
                            long startTime = 0L;
                            String startTimeStr = "";
                            String elapsedTime = "";
                            if (fdApiType == 2 || fdApiType == 4 || fdApiType == 14) {
                                keString = String.valueOf(apiName) + pid + tid + fd;
                                findStartAPITableIndexHashMap.put(keString, i);
                                findStartTimeHashMap.put(i, time);
                                contentText.add(Formatter.toTimeFormat(time));
                                contentData.add(Long.toString(time));
                                contentText.add("-");
                                contentData.add("-");
                                removeTableIndex.add(indexToRemove);
                            } else if (fdApiType == 3 || fdApiType == 5 || fdApiType == 15) {
                                --index;
                                keString = String.valueOf(apiName) + pid + tid + fd;
                                startLogIndex = (Integer)findStartAPITableIndexHashMap.get(keString);
                                String timeFormat = "";
                                if (startLogIndex == null) continue;
                                startTime = (Long)findStartTimeHashMap.get(startLogIndex);
                                startTimeStr = Formatter.toTimeFormat(startTime);
                                contentText.add(startTimeStr);
                                contentData.add(Long.toString(startTime));
                                findStartAPITableIndexHashMap.remove(keString);
                                findStartTimeHashMap.remove(startLogIndex);
                                timeFormat = Formatter.toTimeFormat(time - startTime);
                                elapsedTime = timeFormat.replace("00:", "");
                                contentText.add(elapsedTime);
                                contentData.add(Long.toString(time - startTime));
                            } else {
                                contentText.add(Formatter.toTimeFormat(time));
                                contentData.add(Long.toString(time));
                                contentText.add("00.000");
                                contentData.add("00.000");
                            }
                            contentText.add(0, Integer.toString(index));
                            contentData.add(0, Integer.toString(index));
                            contentText.add(Integer.toString(pid));
                            contentData.add(Integer.toString(pid));
                            contentText.add(Integer.toString(tid));
                            contentData.add(Integer.toString(tid));
                            contentText.add(Long.toString(fd));
                            contentData.add(Long.toString(fd));
                            contentText.add(apiName);
                            contentData.add(apiName);
                            contentText.add(args);
                            contentData.add(args);
                            contentText.add(returns);
                            contentData.add(returns);
                            contentText.add(errMsg);
                            contentData.add(errMsg);
                            DATableDataFormat tableData = new DATableDataFormat(seq);
                            tableData.setLogData(fileEvent);
                            tableData.getData().addAll(contentData);
                            TableInput tableInput = new TableInput();
                            tableInput.setText(contentText);
                            tableInput.setData(tableData);
                            if (!errMsg.contains("SUCCESS")) {
                                tableInput.setFailed(true);
                            }
                            input.add(tableInput);
                            ++indexToRemove;
                            if (time < rangeStartTime || time > rangeEndTime) continue;
                            tableInput.setInRange(true);
                        }
                    }
                    catch (SQLException e) {
                        Logger.exception((Throwable)e);
                        SqlConnectionManager.releaseResultSet(rs);
                        break block19;
                    }
                }
                catch (Throwable throwable) {
                    SqlConnectionManager.releaseResultSet(rs);
                    throw throwable;
                }
                SqlConnectionManager.releaseResultSet(rs);
            }
        }
        Collections.sort(removeTableIndex, Collections.reverseOrder());
        Iterator iterator = removeTableIndex.iterator();
        while (iterator.hasNext()) {
            int index = (Integer)iterator.next();
            input.remove(index);
        }
        this.removeTableDataByFilterProperty(input, filterList);
        return input;
    }

    private void removeTableDataByFilterProperty(List<TableInput> targetList, List<FilterProperty> filterList) {
        if (filterList.size() == 0) {
            return;
        }
        ArrayList<TableInput> removeCandidateList = new ArrayList<TableInput>();
        int i = 0;
        while (i < targetList.size()) {
            TableInput tableInput = targetList.get(i);
            boolean delete = false;
            int a = 0;
            while (a < filterList.size()) {
                FilterProperty property = filterList.get(a);
                String targetContent = tableInput.getText().get(property.getColumnIndex()).toLowerCase();
                if (!targetContent.contains(property.getKeyWord().toLowerCase())) {
                    delete = true;
                    break;
                }
                ++a;
            }
            if (delete) {
                removeCandidateList.add(tableInput);
            }
            ++i;
        }
        targetList.removeAll(removeCandidateList);
    }

    @Override
    protected String getFilteredColumnName(int index) {
        String columnName = null;
        switch (index) {
            case 3: {
                columnName = FileAccessorDB.COLUMN.PID.name;
                break;
            }
            case 4: {
                columnName = FileAccessorDB.COLUMN.TID.name;
                break;
            }
            case 5: {
                columnName = FileApiDB.COLUMN.FD.name;
                break;
            }
            case 7: {
                columnName = this.addLowerOperation(FileApiDB.COLUMN.ARGUMENT.name);
                break;
            }
            case 8: {
                columnName = FileApiDB.COLUMN.RETURN_VALUE.name;
                break;
            }
        }
        return columnName;
    }

    private String getErrorMessage(long erroNo) {
        String errMsg = ErrorCodeManager.getInatance().getErrorCode(erroNo).name();
        if (errMsg == null) {
            errMsg = "undefined error code";
        }
        return errMsg;
    }

    @Override
    protected void actionSetStartEnd(int type) {
        GridItem item = this.table.getItem(this.mousePoint);
        if (item != null) {
            FileData data = (FileData)((DATableDataFormat)item.getData()).getLogData();
            long time = data.getTime();
            double startTime = -1.0;
            double endTime = -1.0;
            if (type == 0) {
                this.rangeDataManager.setMarkerStartTime(time);
                startTime = (double)time / 1000000.0;
                endTime = (double)this.rangeDataManager.getMarkerEndTime() / 1000000.0;
            } else if (type == 1) {
                this.rangeDataManager.setMarkerEndTime(time);
                endTime = (double)time / 1000000.0;
                startTime = (double)this.rangeDataManager.getMarkerStartTime() / 1000000.0;
            }
            FileChartView chartview = (FileChartView)AnalyzerManager.getCurrentPage().getView(FilePage.chartViewID);
            if (chartview != null) {
                chartview.setRangeMarker(startTime, endTime);
            }
        }
    }

    @Override
    public boolean[] getColumnVisibility() {
        if (this.table == null) {
            return null;
        }
        GridColumn[] columns = this.table.getColumns();
        int size = columns.length;
        boolean[] columnsVisibility = new boolean[size];
        int i = 1;
        while (i < size) {
            columnsVisibility[i] = columns[i].getVisible();
            ++i;
        }
        return columnsVisibility;
    }
}

