/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.hierarchy.tree;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.FreeformLayer;
import org.eclipse.draw2d.FreeformViewport;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.MouseEvent;
import org.eclipse.draw2d.MouseListener;
import org.eclipse.draw2d.ScalableFreeformLayeredPane;
import org.eclipse.draw2d.Viewport;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.tizen.dynamicanalyzer.common.AnalyzerManager;
import org.tizen.dynamicanalyzer.common.DAResult;
import org.tizen.dynamicanalyzer.common.DASelectionData;
import org.tizen.dynamicanalyzer.common.DAState;
import org.tizen.dynamicanalyzer.communicator.DACommunicator;
import org.tizen.dynamicanalyzer.communicator.UnsupportedProtocolException;
import org.tizen.dynamicanalyzer.nl.AnalyzerLabels;
import org.tizen.dynamicanalyzer.nl.UIHierarchyPageLabels;
import org.tizen.dynamicanalyzer.resources.ColorResources;
import org.tizen.dynamicanalyzer.resources.ImageResources;
import org.tizen.dynamicanalyzer.swap.model.data.hierarchy.HierarchyUIObject;
import org.tizen.dynamicanalyzer.ui.hierarchy.HierarchyDataManager;
import org.tizen.dynamicanalyzer.ui.hierarchy.HierarchyPage;
import org.tizen.dynamicanalyzer.ui.hierarchy.HierarchyViewCommunication;
import org.tizen.dynamicanalyzer.ui.hierarchy.NodeSearchType;
import org.tizen.dynamicanalyzer.ui.hierarchy.tree.HierarchyTreeViewBottomPane;
import org.tizen.dynamicanalyzer.ui.hierarchy.tree.HierarchyTreeViewLayout;
import org.tizen.dynamicanalyzer.ui.hierarchy.tree.HierarchyTreeViewToolbar;
import org.tizen.dynamicanalyzer.ui.hierarchy.tree.figure.HierarchyTreeFigure;
import org.tizen.dynamicanalyzer.ui.hierarchy.tree.figure.HierarchyTreeNodeFigure;
import org.tizen.dynamicanalyzer.ui.hierarchy.tree.info.HierarchyTreeInfoViewLayout;
import org.tizen.dynamicanalyzer.ui.hierarchy.tree.info.HierarchyTreeNodeInfoFigure;
import org.tizen.dynamicanalyzer.ui.hierarchy.tree.tool.HierarchyZoomManager;
import org.tizen.dynamicanalyzer.util.Logger;
import org.tizen.dynamicanalyzer.util.WorkbenchUtil;
import org.tizen.dynamicanalyzer.widgets.da.base.DADialog;
import org.tizen.dynamicanalyzer.widgets.da.base.ProgressDialog;
import org.tizen.dynamicanalyzer.widgets.da.view.DAViewComposite;
import org.tizen.dynamicanalyzer.widgets.da.view.DAViewData;

public class HierarchyTreeView
extends DAViewComposite {
    private ScalableFreeformLayeredPane root;
    private FreeformLayer treeLayer;
    private FreeformLayer informationLayer;
    private FigureCanvas mainCanvas;
    private HierarchyTreeViewToolbar topToolBar;
    private HierarchyTreeViewBottomPane bottomPane;
    private HierarchyTreeFigure treeRoot = null;
    private HierarchyTreeNodeFigure selectedNode;
    private List<HierarchyTreeNodeFigure> searchedNodeList = new ArrayList<HierarchyTreeNodeFigure>();
    private ProgressDialog progressDialog;

    public HierarchyTreeView(Composite parent, int style) {
        super(parent, style, true);
        this.setLayout((Layout)new FillLayout());
        this.setTitle(UIHierarchyPageLabels.UIHIERARCHY_TREE_VIEW_TITLE);
        Composite contents = this.getContentArea();
        contents.setLayout((Layout)new FormLayout());
        this.createTopToolbar(contents);
        this.createBottomToolbar(contents);
        this.createTreeView(contents);
        HierarchyZoomManager.INSTANCE.setTreeView(this);
    }

    public void refreshTree() {
        this.treeLayer.invalidateTree();
        this.treeLayer.validate();
        this.notifyOtherViews(new HierarchyViewCommunication(HierarchyViewCommunication.HIERARCHY_ACTION.TREE_ZOOM, null));
    }

    public void clear() {
        this.treeLayer.removeAll();
        this.informationLayer.removeAll();
    }

    public void stopProgress(final boolean isSuccess) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                if (HierarchyTreeView.this.progressDialog != null) {
                    HierarchyTreeView.this.progressDialog.close();
                    HierarchyTreeView.this.progressDialog = null;
                }
                if (isSuccess) {
                    HierarchyTreeView.this.restructTree();
                } else {
                    Shell shell = WorkbenchUtil.getWorkbenchWindow().getShell();
                    DADialog dialog = new DADialog(shell, DADialog.DIALOGTYPE.ERROR, 0);
                    dialog.setIcon(ImageResources.DIALOG_ERROR_ICON);
                    dialog.setMessage(UIHierarchyPageLabels.UIHIERARCHY_DIALOG_ERROR_GET_HIERARCHY);
                    dialog.setDialog();
                    dialog.open();
                }
            }
        });
    }

    public FigureCanvas getFigureCanvas() {
        return this.mainCanvas;
    }

    public FreeformLayer getTreeLayer() {
        return this.treeLayer;
    }

    public void restructTree() {
        List<HierarchyUIObject> rootUIObjects;
        if (this.treeRoot != null && this.treeLayer.getChildren().contains((Object)this.treeRoot)) {
            this.treeLayer.remove((IFigure)this.treeRoot);
        }
        if ((rootUIObjects = HierarchyDataManager.getInstance().getRootUIObjects()).size() == 1) {
            this.treeRoot = new HierarchyTreeFigure(this.createTreeNode(rootUIObjects.get(0), false));
        } else if (rootUIObjects.size() > 1) {
            this.treeRoot = new HierarchyTreeFigure(this.createTreeNode(new HierarchyUIObject(), true));
            int i = 0;
            while (i < rootUIObjects.size()) {
                this.treeRoot.add((IFigure)new HierarchyTreeFigure(this.createTreeNode(rootUIObjects.get(i), false)));
                ++i;
            }
            Logger.info((Object)("rootObject count is " + rootUIObjects.size()));
        } else {
            return;
        }
        this.createTreeFigure(this.treeRoot);
        this.treeLayer.add((IFigure)this.treeRoot);
        this.selectedNode = null;
        this.informationLayer.removeAll();
        this.searchUIObject();
        this.notifyOtherViews(new HierarchyViewCommunication(HierarchyViewCommunication.HIERARCHY_ACTION.TREE_RESTRUCT, null));
    }

    public void startProgress() {
        Shell shell = WorkbenchUtil.getWorkbenchWindow().getShell();
        this.progressDialog = new ProgressDialog(shell, org.tizen.dynamicanalyzer.workbench.LayoutManager.getBaseComposite());
        this.progressDialog.setProgressStyle(3);
        this.progressDialog.setProgressMessage(UIHierarchyPageLabels.UIHIERARCHY_PROGRESS_MESSAGE_GET_HIERARCHY);
        this.progressDialog.setProgressInfo(AnalyzerLabels.DLG_PLEASE_WAIT);
        this.progressDialog.setCancelListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }

            public void widgetSelected(SelectionEvent arg0) {
                HierarchyTreeView.this.cancelProgress();
            }
        });
        this.progressDialog.open();
    }

    public void searchUIObject() {
        List<HierarchyUIObject> searchedList = HierarchyDataManager.getInstance().searchUIObject(NodeSearchType.getSearchType(this.bottomPane.getSearchType()), this.bottomPane.getSearchWord());
        int i = 0;
        while (i < this.searchedNodeList.size()) {
            this.searchedNodeList.get(i).setSearched(false);
            ++i;
        }
        i = 0;
        while (i < searchedList.size()) {
            HierarchyTreeNodeFigure nodeFigure = this.findTreeNodeFigure(searchedList.get(i), this.treeRoot);
            if (nodeFigure != null) {
                nodeFigure.setSearched(true);
                this.searchedNodeList.add(nodeFigure);
            } else {
                Logger.error((Object)"Model / UI object is not matched!!");
            }
            ++i;
        }
        this.notifyOtherViews(new HierarchyViewCommunication(HierarchyViewCommunication.HIERARCHY_ACTION.NODE_SEARCH, null));
    }

    private HierarchyTreeNodeFigure findTreeNodeFigure(HierarchyUIObject uiObject, HierarchyTreeFigure figure) {
        HierarchyTreeNodeFigure nodeFigure = figure.getNode();
        if (nodeFigure != null) {
            List children;
            if (nodeFigure.getUIObject().getAddress() == uiObject.getAddress()) {
                return nodeFigure;
            }
            IFigure branch = figure.getBranch();
            if (branch != null && (children = branch.getChildren()) != null) {
                int i = 0;
                while (i < children.size()) {
                    HierarchyTreeFigure child = (HierarchyTreeFigure)((Object)children.get(i));
                    nodeFigure = this.findTreeNodeFigure(uiObject, child);
                    if (nodeFigure != null) {
                        return nodeFigure;
                    }
                    ++i;
                }
            }
        }
        return null;
    }

    private void createTopToolbar(Composite parent) {
        this.topToolBar = new HierarchyTreeViewToolbar(parent, this);
        FormData data = new FormData();
        data.top = new FormAttachment(0, 0);
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        data.height = 24;
        this.topToolBar.setLayoutData(data);
        this.topToolBar.setLayout((Layout)new FormLayout());
        this.topToolBar.setBackground(ColorResources.TREEVIEW_TOP_TOOLBAR_BG);
        this.topToolBar.createToolbarComponent();
    }

    private void createBottomToolbar(Composite parent) {
        this.bottomPane = new HierarchyTreeViewBottomPane(parent, this);
        FormData data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        data.bottom = new FormAttachment(100, 0);
        data.height = 22;
        this.bottomPane.setLayoutData(data);
        this.bottomPane.setLayout((Layout)new FormLayout());
        this.bottomPane.setBackground(ColorResources.TREEVIEW_BOTTOM_TOOLBAR_BG);
        this.bottomPane.createPaneComponent();
    }

    private void createTreeView(Composite parent) {
        this.root = new ScalableFreeformLayeredPane();
        this.root.setFont(parent.getFont());
        this.treeLayer = new FreeformLayer();
        this.treeLayer.setBackgroundColor(ColorResources.TREEVIEW_BG);
        this.root.add((IFigure)this.treeLayer, (Object)"Primary");
        this.informationLayer = new FreeformLayer();
        this.root.add((IFigure)this.informationLayer, (Object)"information");
        this.informationLayer.setLayoutManager((LayoutManager)new HierarchyTreeInfoViewLayout());
        HierarchyTreeViewLayout layout = new HierarchyTreeViewLayout();
        this.treeLayer.setLayoutManager((LayoutManager)layout);
        this.treeLayer.setBorder((Border)new MarginBorder(50, 30, 50, 30));
        this.mainCanvas = new FigureCanvas(parent, 0x20000000);
        this.mainCanvas.setViewport((Viewport)new FreeformViewport());
        this.mainCanvas.setBackground(ColorResources.TREEVIEW_BG);
        this.mainCanvas.setContents((IFigure)this.root);
        FormData data = new FormData();
        data.top = new FormAttachment((Control)this.topToolBar, 0);
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        data.bottom = new FormAttachment((Control)this.bottomPane, 0);
        this.mainCanvas.setLayoutData((Object)data);
        this.mainCanvas.addListener(37, new Listener(){

            public void handleEvent(Event event) {
                if (event.stateMask == 262144) {
                    if (event.count > 0) {
                        HierarchyZoomManager.INSTANCE.zoomIn();
                        HierarchyTreeView.this.bottomPane.changeScale(true);
                    } else {
                        HierarchyZoomManager.INSTANCE.zoomOut();
                        HierarchyTreeView.this.bottomPane.changeScale(false);
                    }
                    event.doit = false;
                }
            }
        });
        this.mainCanvas.getViewport().addMouseListener((MouseListener)new MouseListener.Stub(){

            public void mousePressed(MouseEvent me) {
                HierarchyTreeView.this.informationLayer.removeAll();
                if (HierarchyTreeView.this.selectedNode != null) {
                    HierarchyTreeView.this.selectedNode.setSelected(false);
                    HierarchyTreeView.this.selectedNode = null;
                    HierarchyTreeView.this.notifyOtherViews(new HierarchyViewCommunication(HierarchyViewCommunication.HIERARCHY_ACTION.NODE_UNSELECT, null));
                }
            }
        });
    }

    private HierarchyTreeNodeFigure createTreeNode(final HierarchyUIObject uiObject, boolean hidden) {
        final HierarchyTreeNodeFigure node = new HierarchyTreeNodeFigure(uiObject, hidden);
        node.addMouseListener((MouseListener)new MouseListener.Stub(){

            public void mousePressed(MouseEvent me) {
                if (DAState.isRunning()) {
                    HierarchyUIObject uiObject2 = node.getUIObject();
                    if (uiObject2.checkNeedToRequest()) {
                        try {
                            DAResult result = DACommunicator.requestUIScreenshot(uiObject2.getAddress());
                            if (result.isSuccess()) {
                                uiObject2.setStatus(HierarchyUIObject.STATUS.OK);
                                uiObject2.setImageFile(Long.toString(uiObject2.getAddress()));
                            } else if (result.equals((Object)DAResult.ErrorCode.ERR_DOWNLOAD_FILE_FAILED)) {
                                uiObject2.setStatus(HierarchyUIObject.STATUS.ERROR);
                            } else if (result.equals((Object)DAResult.ErrorCode.ERR_UI_OBJECT_CAN_NOT_TAKE_SCREENSHOT)) {
                                uiObject2.setStatus(HierarchyUIObject.STATUS.APP_BACKGROUND);
                            } else if (result.equals((Object)DAResult.ErrorCode.ERR_UI_OBJECT_NOT_FOUND)) {
                                uiObject2.setStatus(HierarchyUIObject.STATUS.OBJECT_NOT_EXIST);
                            }
                        }
                        catch (InterruptedException e) {
                            Logger.exception((Throwable)e);
                        }
                        catch (UnsupportedProtocolException e) {
                            Logger.exception((Throwable)e);
                        }
                    }
                } else if (uiObject.getStatus() != HierarchyUIObject.STATUS.OK || uiObject.getImageFilePath() == null) {
                    uiObject.setStatus(HierarchyUIObject.STATUS.NOT_IN_TRACE);
                }
                if (HierarchyTreeView.this.selectedNode != null) {
                    HierarchyTreeView.this.selectedNode.setSelected(false);
                }
                HierarchyTreeView.this.selectedNode = node;
                HierarchyTreeView.this.selectedNode.setSelected(true);
                HierarchyTreeView.this.notifyOtherViews(new HierarchyViewCommunication(HierarchyViewCommunication.HIERARCHY_ACTION.NODE_SELECT, HierarchyTreeView.this.selectedNode.getUIObject()));
                HierarchyTreeNodeInfoFigure infoFigure = new HierarchyTreeNodeInfoFigure(node.getUIObject());
                HierarchyTreeView.this.informationLayer.removeAll();
                HierarchyTreeView.this.informationLayer.add((IFigure)infoFigure, (Object)HierarchyTreeView.this.selectedNode);
            }
        });
        return node;
    }

    private void cancelProgress() {
        try {
            DAResult result = DACommunicator.cancelRequestUIHierarchy();
            if (result.isSuccess()) {
                Logger.warning((Object)result);
            }
        }
        catch (InterruptedException e) {
            Logger.exception((Throwable)e);
        }
        catch (UnsupportedProtocolException e) {
            Logger.exception((Throwable)e);
        }
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                if (HierarchyTreeView.this.progressDialog != null) {
                    HierarchyTreeView.this.progressDialog.close();
                    HierarchyTreeView.this.progressDialog = null;
                }
            }
        });
    }

    private void createTreeFigure(HierarchyTreeFigure treeFigure) {
        HierarchyUIObject uiObject = treeFigure.getNode().getUIObject();
        Iterator<HierarchyUIObject> iter = uiObject.getChildrenIterator();
        while (iter.hasNext()) {
            HierarchyUIObject object = iter.next();
            HierarchyTreeFigure figure = new HierarchyTreeFigure(this.createTreeNode(object, false));
            treeFigure.getBranch().add((IFigure)figure);
            this.createTreeFigure(figure);
        }
    }

    private void notifyOtherViews(HierarchyViewCommunication communicationParam) {
        AnalyzerManager.getCurrentPage().updateView((DAViewData)new DASelectionData(HierarchyPage.treeViewID, communicationParam));
    }
}

