/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.hierarchy.tree;

import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.tizen.dynamicanalyzer.resources.ColorResources;
import org.tizen.dynamicanalyzer.resources.ImageResources;
import org.tizen.dynamicanalyzer.ui.hierarchy.NodeSearchType;
import org.tizen.dynamicanalyzer.ui.hierarchy.tree.HierarchyScaleRenderer;
import org.tizen.dynamicanalyzer.ui.hierarchy.tree.HierarchyTreeView;
import org.tizen.dynamicanalyzer.ui.hierarchy.tree.tool.HierarchyZoomManager;
import org.tizen.dynamicanalyzer.widgets.combo.DACustomCombo;
import org.tizen.dynamicanalyzer.widgets.combo.DACustomComboSelectionListener;
import org.tizen.dynamicanalyzer.widgets.da.base.DATextBox;
import org.tizen.dynamicanalyzer.widgets.scale.DAScale;
import org.tizen.dynamicanalyzer.widgets.scale.DAScaleDefaultRenderer;
import org.tizen.dynamicanalyzer.widgets.scale.DAScaleSelectionListener;

public class HierarchyTreeViewBottomPane
extends Composite {
    private HierarchyTreeView treeView;
    private DACustomCombo searchCombo;
    private DATextBox searchBox;
    private DAScale scale;

    public HierarchyTreeViewBottomPane(Composite parent, HierarchyTreeView treeView) {
        super(parent, 0);
        this.treeView = treeView;
    }

    public void createPaneComponent() {
        this.searchCombo = this.createSearchCombo(this);
        FormData data = new FormData();
        data.top = new FormAttachment(0, 2);
        data.left = new FormAttachment(0, 2);
        data.width = 69;
        data.height = 18;
        this.searchCombo.setLayoutData((Object)data);
        this.searchCombo.addSelectionListener(new DACustomComboSelectionListener(){

            public void selectionEvent(DACustomCombo combo) {
                HierarchyTreeViewBottomPane.this.treeView.searchUIObject();
            }
        });
        this.searchBox = new DATextBox((Composite)this, 4);
        data = new FormData();
        data.top = new FormAttachment(0, 2);
        data.left = new FormAttachment((Control)this.searchCombo, 3);
        data.width = 170;
        data.height = 15;
        this.searchBox.setLayoutData(data);
        this.searchBox.setBackground(ColorResources.VIEW_BG_COLOR);
        this.searchBox.getControl().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                HierarchyTreeViewBottomPane.this.treeView.searchUIObject();
                e.doit = false;
            }
        });
        this.scale = new DAScale((Composite)this, 22, 11, 0);
        this.scale.setThumbImage(ImageResources.SCALE_CONTROL_THUMB);
        this.scale.setRenderer((DAScaleDefaultRenderer)new HierarchyScaleRenderer());
        this.scale.addSelectionListener(new DAScaleSelectionListener(){

            public void widgetSelected() {
                int selection = HierarchyTreeViewBottomPane.this.scale.getSelection();
                HierarchyZoomManager.INSTANCE.setCurrentScaleStep(selection);
            }
        });
        this.scale.setLeftWidth(43);
        this.scale.setRightWidth(43);
        data = new FormData();
        data.top = new FormAttachment(0, 2);
        data.right = new FormAttachment(100, 0);
        data.width = 202;
        data.height = 18;
        this.scale.setLayoutData((Object)data);
    }

    public String getSearchType() {
        return this.searchCombo.getText();
    }

    public String getSearchWord() {
        return this.searchBox.getText();
    }

    public void changeScale(boolean isIncrease) {
        this.scale.changeScale(isIncrease);
    }

    private DACustomCombo createSearchCombo(Composite parent) {
        DACustomCombo searchCombo = new DACustomCombo(parent, 0);
        searchCombo.setImages(ImageResources.FILTER_BUTTON_NORMAL, ImageResources.FILTER_BUTTON_HOVER, ImageResources.FILTER_BUTTON_PUSH, ImageResources.FILTER_BUTTON_HOVER);
        searchCombo.setFontPoint(new Point(8, 1));
        searchCombo.setForeground(ColorResources.FILTER_COMBO_TEXT);
        searchCombo.add(NodeSearchType.TYPE.getTitle());
        searchCombo.add(NodeSearchType.NAME.getTitle());
        searchCombo.add(NodeSearchType.TEXT.getTitle());
        searchCombo.select(0);
        return searchCombo;
    }
}

